/*
 * Decompiled with CFR 0.152.
 */
package io.github.escposjava.print.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import io.github.escposjava.print.exceptions.QRCodeException;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.EnumMap;
import java.util.Map;

public class QRCodeGenerator {
    public BufferedImage generate(String string) throws QRCodeException {
        return this.generate(string, 150);
    }

    public BufferedImage generate(String string, int n) throws QRCodeException {
        try {
            Map<EncodeHintType, Object> map = this.a();
            BitMatrix bitMatrix = this.a(string, n, map);
            return this.a(bitMatrix);
        }
        catch (WriterException writerException) {
            throw new QRCodeException("QRCode generation error", writerException);
        }
    }

    private Map<EncodeHintType, Object> a() {
        EnumMap<EncodeHintType, Object> enumMap = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
        enumMap.put(EncodeHintType.CHARACTER_SET, (Object)"UTF-8");
        enumMap.put(EncodeHintType.MARGIN, (Object)1);
        enumMap.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.L);
        return enumMap;
    }

    private BitMatrix a(String string, int n, Map<EncodeHintType, Object> map) throws WriterException {
        QRCodeWriter qRCodeWriter = new QRCodeWriter();
        return qRCodeWriter.encode(string, BarcodeFormat.QR_CODE, n, n, map);
    }

    private BufferedImage a(BitMatrix bitMatrix) {
        BufferedImage bufferedImage = new BufferedImage(bitMatrix.getWidth(), bitMatrix.getWidth(), 1);
        bufferedImage.createGraphics();
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, bitMatrix.getWidth(), bitMatrix.getWidth());
        graphics2D.setColor(Color.BLACK);
        for (int i = 0; i < bitMatrix.getWidth(); ++i) {
            for (int j = 0; j < bitMatrix.getWidth(); ++j) {
                if (!bitMatrix.get(i, j)) continue;
                graphics2D.fillRect(i, j, 1, 1);
            }
        }
        return bufferedImage;
    }
}

