/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.VoidPaymentDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;

public class VoidPaymentAction
extends PosAction {
    public VoidPaymentAction() {
        super(Messages.getString("VoidPaymentAction.0"));
        this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
    }

    public VoidPaymentAction(DataChangeListener dataChangeListener) {
        super(Messages.getString("VoidPaymentAction.0"), dataChangeListener);
        this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
    }

    @Override
    public void execute() {
        try {
            Object object = this.getSelectedObject();
            if (object == null) {
                return;
            }
            Ticket ticket = null;
            ticket = object instanceof Ticket ? (Ticket)object : TicketService.getTicket((String)object);
            if (ticket == null) {
                return;
            }
            TicketDAO.getInstance().loadFullTicket(ticket);
            VoidPaymentDialog voidPaymentDialog = new VoidPaymentDialog(POSUtil.getFocusedWindow(), ticket);
            voidPaymentDialog.setSize(PosUIManager.getSize(800, 600));
            voidPaymentDialog.open();
            if (!ticket.isPaid().booleanValue()) {
                new SettleTicketAction(ticket).actionPerformed(null);
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }
}

