/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.WeeklyPayrollReportData;
import com.floreantpos.report.WeeklyPayrollReportModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;

public class WeeklyPayrollReportService {
    private Date a;
    private Date b;
    private User c;
    private int d;

    public WeeklyPayrollReportService() {
    }

    public WeeklyPayrollReportService(Date date, Date date2, User user, int n) {
        this.a = date;
        this.b = date2;
        this.c = user;
        this.d = n;
    }

    public JasperPrint createJasper() {
        try {
            DateUtil.validateDate(this.a, this.b);
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            Calendar calendar2 = Calendar.getInstance();
            calendar2.setTime(this.a);
            calendar.set(1, calendar2.get(1));
            calendar.set(2, calendar2.get(2));
            calendar.set(5, calendar2.get(5));
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            this.a = calendar.getTime();
            calendar.clear();
            calendar2.setTime(this.b);
            calendar.set(1, calendar2.get(1));
            calendar.set(2, calendar2.get(2));
            calendar.set(5, calendar2.get(5));
            calendar.set(10, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            this.b = calendar.getTime();
            WeeklyPayrollReportModel weeklyPayrollReportModel = new WeeklyPayrollReportModel();
            List<WeeklyPayrollReportData> list = AttendenceHistoryDAO.getInstance().findWeeklyPayroll(this.a, this.b, this.c, this.d);
            JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("WeeklyPayrollReport"));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ReportUtil.populateRestaurantProperties(hashMap);
            ReportUtil.populateReportTime(hashMap, this.a, this.b);
            ReportUtil.populateReportFooter(hashMap);
            this.a(hashMap);
            Comparator<WeeklyPayrollReportData> comparator = Comparator.comparing(WeeklyPayrollReportData::getFromDateOfWeek, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(WeeklyPayrollReportData::getUserIdSortKey, Comparator.nullsLast(Comparator.naturalOrder()));
            list.sort(comparator);
            weeklyPayrollReportModel.setRows(list);
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)weeklyPayrollReportModel));
            return jasperPrint;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
        return null;
    }

    private void a(HashMap<String, Object> hashMap) {
        hashMap.put("RTitle", Messages.getString("WeeklyPayrollReportAction.0"));
        hashMap.put("colEID", Messages.getString("EmployeeId"));
        hashMap.put("colEName", Messages.getString("EmployeeName"));
        hashMap.put("colRole", Messages.getString("colRole"));
        hashMap.put("colRHW", Messages.getString("RegularH") + "<br/>" + Messages.getString("Worked"));
        hashMap.put("colOHW", Messages.getString("OvertimeH") + "<br/>" + Messages.getString("Worked"));
        hashMap.put("colRPay", Messages.getString("Regular") + "<br/>" + Messages.getString("PAYMENT"));
        hashMap.put("colOTPay", Messages.getString("OvertimeTH") + "<br/>" + Messages.getString("PAYMENT"));
        hashMap.put("colTHWork", Messages.getString("TotalH") + "<br/>" + Messages.getString("Worked"));
        hashMap.put("colTPay", POSConstants.TOTAL + "<br/>" + Messages.getString("PAYMENT"));
        hashMap.put("colDTips", Messages.getString("declaredTips"));
        hashMap.put("colNCTips", Messages.getString("OtherTips"));
    }
}

