/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.ServiceExplorer;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class ServiceExplorerAction
extends AbstractAction {
    public ServiceExplorerAction() {
        super(Messages.getString("Service"));
    }

    public ServiceExplorerAction(String string) {
        super(string);
    }

    public ServiceExplorerAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
            ServiceExplorer serviceExplorer = null;
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            int n = jTabbedPane.indexOfTab(Messages.getString("Service"));
            if (n == -1) {
                serviceExplorer = new ServiceExplorer();
                serviceExplorer.initData();
                jTabbedPane.addTab(Messages.getString("Service"), serviceExplorer);
            } else {
                serviceExplorer = (ServiceExplorer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(serviceExplorer);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

