/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.report.TaxExemptReportView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTabbedPane;

public class TaxExemptReportAction
extends AbstractAction {
    public TaxExemptReportAction() {
        super(POSConstants.TAX_EXEMPT_REPORT);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            TaxExemptReportView taxExemptReportView = null;
            int n = jTabbedPane.indexOfTab(POSConstants.TAX_EXEMPT_REPORT);
            if (n == -1) {
                taxExemptReportView = new TaxExemptReportView();
                jTabbedPane.addTab(POSConstants.TAX_EXEMPT_REPORT, taxExemptReportView);
            } else {
                taxExemptReportView = (TaxExemptReportView)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(taxExemptReportView);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

