/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.AboutAction;
import com.floreantpos.actions.CacheDataUpdateAction;
import com.floreantpos.actions.DefaultPriceAction;
import com.floreantpos.actions.ImageGalleryAction;
import com.floreantpos.actions.PayoutReasonAction;
import com.floreantpos.actions.PluginsAction;
import com.floreantpos.actions.RecalculateTicketsAction;
import com.floreantpos.actions.SetupWizardAction;
import com.floreantpos.actions.VoidReasonAction;
import com.floreantpos.bo.actions.AttendanceHistoryAction;
import com.floreantpos.bo.actions.AttributeExplorerAction;
import com.floreantpos.bo.actions.BackofficeWindowCloseListener;
import com.floreantpos.bo.actions.BalanceUpdateTransactionHistoryAction;
import com.floreantpos.bo.actions.CategorywiseSalesReport;
import com.floreantpos.bo.actions.CookingInstructionExplorerAction;
import com.floreantpos.bo.actions.CouponExplorerAction;
import com.floreantpos.bo.actions.CourseExplorerAction;
import com.floreantpos.bo.actions.CreditCardReportAction;
import com.floreantpos.bo.actions.CronJobScheduleExplorerAction;
import com.floreantpos.bo.actions.CurrencyExplorerAction;
import com.floreantpos.bo.actions.CustomerAccountReportAction;
import com.floreantpos.bo.actions.CustomerMonitorConfigurationAction;
import com.floreantpos.bo.actions.CustomerPaymentReportAction;
import com.floreantpos.bo.actions.DashboardAction;
import com.floreantpos.bo.actions.DataResetAction;
import com.floreantpos.bo.actions.DeliverySummaryReportAction;
import com.floreantpos.bo.actions.DepartmentAction;
import com.floreantpos.bo.actions.DiscountReportAction;
import com.floreantpos.bo.actions.DrawerPullReportExplorerAction;
import com.floreantpos.bo.actions.EmployeeAttendanceAction;
import com.floreantpos.bo.actions.EndOfDaySummaryReporAction;
import com.floreantpos.bo.actions.GiftCardBrowserAction;
import com.floreantpos.bo.actions.GiftCardGenerateAction;
import com.floreantpos.bo.actions.GiftCardSummaryReportAction;
import com.floreantpos.bo.actions.GiftCardTransactionReportAction;
import com.floreantpos.bo.actions.HourlySalesReportAction;
import com.floreantpos.bo.actions.ImportFromExcelAction;
import com.floreantpos.bo.actions.ImportFromOtherPosAction;
import com.floreantpos.bo.actions.ItemExplorerAction;
import com.floreantpos.bo.actions.ItemwiseSalesReportAction;
import com.floreantpos.bo.actions.JournalReportAction;
import com.floreantpos.bo.actions.KeyStatisticsSalesReportAction;
import com.floreantpos.bo.actions.LanguageSelectionAction;
import com.floreantpos.bo.actions.MailTemplateConfigurationExplorerAction;
import com.floreantpos.bo.actions.MenuPageExplorerAction;
import com.floreantpos.bo.actions.MigrateDatabaseAction;
import com.floreantpos.bo.actions.MigrateFloreantposAction;
import com.floreantpos.bo.actions.MultiplierExplorerAction;
import com.floreantpos.bo.actions.OpenTicketSummaryReportAction;
import com.floreantpos.bo.actions.OrdersTypeExplorerAction;
import com.floreantpos.bo.actions.PaymentReceivedReportAction;
import com.floreantpos.bo.actions.PayoutReportAction;
import com.floreantpos.bo.actions.PayrollReportAction;
import com.floreantpos.bo.actions.PizzaItemExplorerAction;
import com.floreantpos.bo.actions.PriceExplorerAction;
import com.floreantpos.bo.actions.ReceiptConfigurationExplorerAction;
import com.floreantpos.bo.actions.SalesAreaExplorerAction;
import com.floreantpos.bo.actions.SalesBalanceReportAction;
import com.floreantpos.bo.actions.SalesByEmployeeReportAction;
import com.floreantpos.bo.actions.SalesDetailReportAction;
import com.floreantpos.bo.actions.SalesExceptionReportAction;
import com.floreantpos.bo.actions.SalesReportAction;
import com.floreantpos.bo.actions.SalesTaxReportAction;
import com.floreantpos.bo.actions.ServerProductivityReportAction;
import com.floreantpos.bo.actions.ServiceExplorerAction;
import com.floreantpos.bo.actions.SessionSummaryReportAction;
import com.floreantpos.bo.actions.ShiftExplorerAction;
import com.floreantpos.bo.actions.ShiftwiseSalesSummaryReportAction;
import com.floreantpos.bo.actions.ShowReleaseNoteAction;
import com.floreantpos.bo.actions.StaffBankReportAction;
import com.floreantpos.bo.actions.StoreConfigurationAction;
import com.floreantpos.bo.actions.StoreSessionExplorerAction;
import com.floreantpos.bo.actions.TaxExemptReportAction;
import com.floreantpos.bo.actions.TaxExplorerAction;
import com.floreantpos.bo.actions.TerminalConfigurationAction;
import com.floreantpos.bo.actions.TerminalExplorerAction;
import com.floreantpos.bo.actions.TicketExplorerAction;
import com.floreantpos.bo.actions.TracTipsReportAction;
import com.floreantpos.bo.actions.UserExplorerAction;
import com.floreantpos.bo.actions.UserTypeExplorerAction;
import com.floreantpos.bo.actions.VoidItemReportAction;
import com.floreantpos.bo.actions.VoidPaymentReportAction;
import com.floreantpos.bo.actions.WeeklyPayrollReportAction;
import com.floreantpos.bo.actions.WorkHourCalculationAction;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.customPayment.CustomPaymentBrowserAction;
import com.floreantpos.extension.CloudSyncPlugin;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.main.Application;
import com.floreantpos.main.Main;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ToolbarBlinkButton;
import com.floreantpos.teminaltype.TerminalTypeAction;
import com.floreantpos.ui.FooterPanel;
import com.floreantpos.ui.floorplan.ShowTableBrowserAction;
import com.floreantpos.versioning.VersionInfo;
import com.floreantpos.webservice.CloudSyncAction;
import com.jidesoft.swing.JideTabbedPane;
import com.orocube.licensemanager.OroLicense;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class BackOfficeWindow
extends JFrame {
    private static final String a = "bwy";
    private static final String b = "bwx";
    private static final String c = "bwheight";
    private static final String d = "bwwidth";
    private JMenu e;
    private static BackOfficeWindow f;
    private JMenuBar g;
    private final User h;
    private boolean i;
    private JPanel j;
    private JideTabbedPane k;
    private JComboBox l;
    private ToolbarBlinkButton m;
    private ToolbarBlinkButton n;
    private FooterPanel o;

    public BackOfficeWindow(User user) {
        this(user, false);
    }

    public BackOfficeWindow(User user, boolean bl) {
        this.h = user;
        this.i = bl;
        this.setIconImage(new ImageIcon(this.getClass().getResource("/icons/icon.png")).getImage());
        this.h();
        this.createMenus();
        this.b();
        this.f();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                BackOfficeWindow.this.close();
            }
        });
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        String string = VersionInfo.getAppName() + " " + VersionInfo.getVersion() + "- " + POSConstants.BACK_OFFICE;
        if (terminal.isMasterTerminal().booleanValue()) {
            string = string + Messages.getString("BackOfficeWindow.3");
        }
        this.setTitle(string);
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        f = this;
        this.g();
        JMenu jMenu = new JMenu(Messages.getString("BackOfficeWindow.0"));
        jMenu.add(new AboutAction());
        jMenu.add(new PluginsAction());
        jMenu.add(new ShowReleaseNoteAction());
        this.g.add(jMenu);
        this.a();
    }

    private void a() {
        this.o = new FooterPanel();
        this.o.initTimers();
        this.add((Component)this.o, "South");
        this.e();
    }

    public FooterPanel getStatusBar() {
        return this.o;
    }

    private void b() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "", "[fill][]"));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.m = new ToolbarBlinkButton(Messages.getString("CacheDataUpdateAction.0"));
        this.m.setBackground(UIManager.getColor("Control.background"));
        this.m.setOriginalBackColor(UIManager.getColor("Control.background"));
        this.m.setIcon(IconFactory.getIcon("refresh_24.png"));
        this.m.addActionListener(actionEvent -> this.d());
        this.m.setHideActionText(false);
        this.m.setBorderPainted(false);
        this.n = new ToolbarBlinkButton(Messages.getString("BackOfficeWindow.4"));
        this.n.setBackground(UIManager.getColor("Control.background"));
        this.n.setOriginalBackColor(UIManager.getColor("Control.background"));
        this.n.setAction(new CloudSyncAction(Boolean.TRUE, Messages.getString("BackOfficeWindow.5")));
        this.n.setHideActionText(false);
        this.n.setBorderPainted(false);
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout());
        JLabel jLabel = new JLabel();
        jLabel.setText(Messages.getString("PrintConfigurationView.10"));
        jPanel2.add(jLabel);
        this.l = new JComboBox<PaperSize>(PaperSize.values());
        jPanel2.add(this.l);
        this.c();
        jPanel.add((Component)this.m, "");
        CloudSyncPlugin cloudSyncPlugin = (CloudSyncPlugin)ExtensionManager.getPlugin(CloudSyncPlugin.class);
        if (cloudSyncPlugin != null && cloudSyncPlugin.hasValidLicense()) {
            jPanel.add((Component)this.n, "");
        }
        jPanel.add((Component)jPanel2, "align right");
        this.add((Component)jPanel, "North");
        this.l.addActionListener(actionEvent -> this.a(this.l.getSelectedItem()));
        jPanel2.setVisible(Application.getInstance().isDevelopmentMode());
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (this.o != null) {
            this.o.startOrStopTimer(bl);
        }
    }

    private void c() {
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        String string = terminal.getProperty("report.paper_size");
        if (StringUtils.isNotEmpty((String)string)) {
            PaperSize paperSize = PaperSize.valueOf(string);
            this.l.setSelectedItem((Object)paperSize);
        }
    }

    private void d() {
        new CacheDataUpdateAction(true, true).execute();
        this.c();
        this.e();
    }

    private void e() {
        try {
            this.o.updateView(this.h);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void a(Object object) {
        try {
            DataProvider.get().refreshCurrentTerminal();
            Terminal terminal = DataProvider.get().getCurrentTerminal();
            PaperSize paperSize = (PaperSize)((Object)object);
            terminal.addProperty("report.paper_size", paperSize.name());
            TerminalDAO.getInstance().update(terminal);
        }
        catch (Exception exception) {
            PosLog.debug(this.getClass(), exception.getMessage());
        }
    }

    private void f() {
        int n = AppConfig.getInt(d, 900);
        int n2 = AppConfig.getInt(c, 650);
        this.setSize(n, n2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n3 = dimension.width - n >> 1;
        int n4 = dimension.height - n2 >> 1;
        n3 = AppConfig.getInt(b, n3);
        n4 = AppConfig.getInt(a, n4);
        this.setLocation(n3, n4);
    }

    protected void createMenus() {
        UserType userType = this.h.getType();
        this.g = new JMenuBar();
        if (userType == null) {
            this.createAdminMenu(this.g);
            this.a(this.g);
            this.createReportMenu(this.g);
            this.createFloorMenu(this.g);
        } else {
            if (this.h.hasPermissionInAnyRole(UserPermission.PERFORM_ADMINISTRATIVE_TASK)) {
                this.createAdminMenu(this.g);
            }
            if (this.h.hasPermissionInAnyRole(UserPermission.VIEW_EXPLORERS)) {
                this.a(this.g);
            }
            if (this.h.hasPermissionInAnyRole(UserPermission.VIEW_REPORTS)) {
                this.createReportMenu(this.g);
            }
        }
        this.createFloorMenu(this.g);
        this.setJMenuBar(this.g);
    }

    private void g() {
        for (FloreantPlugin object : ExtensionManager.getPlugins()) {
            object.initBackoffice(this);
        }
        OroLicense oroLicense = Application.getInstance().getLicense();
        for (FloreantPlugin floreantPlugin : ExtensionManager.getInactivePlugins()) {
            String string = "";
            if (oroLicense == null) continue;
            string = oroLicense.getHolderEmail() == null ? "" : oroLicense.getHolderEmail();
            floreantPlugin.initAboutMenu(this, string);
        }
    }

    protected void createReportMenu(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu(POSConstants.REPORTS);
        jMenu.add(new SalesReportAction());
        jMenu.add(new ItemwiseSalesReportAction());
        jMenu.add(new CategorywiseSalesReport());
        jMenu.add(new ShiftwiseSalesSummaryReportAction());
        jMenu.add(new SalesByEmployeeReportAction());
        jMenu.add(new HourlySalesReportAction());
        jMenu.add(new SalesBalanceReportAction());
        jMenu.add(new SalesDetailReportAction());
        jMenu.add(new KeyStatisticsSalesReportAction());
        jMenu.add(new SalesExceptionReportAction());
        jMenu.add(new SalesTaxReportAction());
        jMenu.add(new JSeparator());
        jMenu.add(new EndOfDaySummaryReporAction());
        jMenu.add(new DeliverySummaryReportAction());
        jMenu.add(new OpenTicketSummaryReportAction());
        jMenu.add(new JSeparator());
        jMenu.add(new PaymentReceivedReportAction());
        jMenu.add(new CreditCardReportAction());
        jMenu.add(new CustomerPaymentReportAction());
        jMenu.add(new CustomerAccountReportAction());
        jMenu.add(new JSeparator());
        jMenu.add(new VoidItemReportAction());
        jMenu.add(new VoidPaymentReportAction());
        jMenu.add(new DiscountReportAction());
        jMenu.add(new PayoutReportAction());
        jMenu.add(new TaxExemptReportAction());
        jMenu.add(new JSeparator());
        jMenu.add(new PayrollReportAction());
        jMenu.add(new WeeklyPayrollReportAction());
        jMenu.add(new TracTipsReportAction());
        jMenu.add(new ServerProductivityReportAction());
        jMenu.add(new EmployeeAttendanceAction());
        jMenu.add(new StaffBankReportAction());
        jMenu.add(new JSeparator());
        jMenu.add(new GiftCardSummaryReportAction());
        jMenu.add(new GiftCardTransactionReportAction());
        jMenu.add(new JSeparator());
        jMenu.add(new JournalReportAction());
        jMenu.add(new SessionSummaryReportAction());
        jMenuBar.add(jMenu);
    }

    private void a(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu(POSConstants.EXPLORERS);
        jMenuBar.add(jMenu);
        jMenu.add(new MenuPageExplorerAction());
        jMenu.add(new ItemExplorerAction());
        jMenu.add(new PizzaItemExplorerAction());
        OrderServiceExtension orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
        if (orderServiceExtension != null) {
            jMenu.add(new ServiceExplorerAction());
        }
        jMenu.add(new JSeparator());
        jMenu.add(new ShiftExplorerAction());
        jMenu.add(new AttributeExplorerAction());
        jMenu.add(new MultiplierExplorerAction());
        jMenu.add(new VoidReasonAction());
        jMenu.add(new PayoutReasonAction());
        jMenu.add(new CookingInstructionExplorerAction());
        jMenu.add(new JSeparator());
        jMenu.add(new CourseExplorerAction());
        jMenu.add(new CouponExplorerAction());
        jMenu.add(new DefaultPriceAction());
        jMenu.add(new PriceExplorerAction());
        jMenu.add(new JSeparator());
        if (this.h.hasPermissionInAnyRole(UserPermission.VIEW_GIFT_CARD)) {
            jMenu.add(new GiftCardBrowserAction());
        }
        jMenu.add(new StoreSessionExplorerAction());
        jMenu.add(new TicketExplorerAction());
        jMenu.add(new DrawerPullReportExplorerAction());
        jMenu.add(new JSeparator());
        jMenu.add(new ImageGalleryAction());
        jMenu.add(new JSeparator());
        jMenu.add(new AttendanceHistoryAction());
        jMenu.add(new WorkHourCalculationAction());
        if (Application.getInstance().isDevelopmentMode()) {
            jMenu.add(new BalanceUpdateTransactionHistoryAction());
        }
        if (orderServiceExtension == null) {
            return;
        }
        orderServiceExtension.createCustomerMenu(jMenu);
    }

    protected void createAdminMenu(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu(POSConstants.ADMIN);
        jMenu.add(new DashboardAction());
        jMenu.add(new JSeparator());
        jMenu.add(new StoreConfigurationAction());
        jMenu.add(new TerminalConfigurationAction(DataProvider.get().getCurrentTerminal()));
        if (this.h.hasPermissionInAnyRole(UserPermission.PERFORM_ADMINISTRATIVE_TASK) || this.h.hasPermissionInAnyRole(UserPermission.PERFORM_MANAGER_TASK)) {
            jMenu.add(new ReceiptConfigurationExplorerAction());
        }
        jMenu.add(new MailTemplateConfigurationExplorerAction());
        jMenu.add(new CustomerMonitorConfigurationAction());
        jMenu.add(new JSeparator());
        jMenu.add(new UserExplorerAction());
        jMenu.add(new UserTypeExplorerAction());
        jMenu.add(new JSeparator());
        jMenu.add(new DepartmentAction());
        jMenu.add(new SalesAreaExplorerAction());
        jMenu.add(new TerminalExplorerAction());
        jMenu.add(new TerminalTypeAction());
        if (TerminalConfig.isMultipleOrderSupported()) {
            jMenu.add(new OrdersTypeExplorerAction());
        }
        jMenu.add(new JSeparator());
        jMenu.add(new CurrencyExplorerAction());
        jMenu.add(new TaxExplorerAction());
        jMenu.add(new CustomPaymentBrowserAction());
        jMenu.add(new JSeparator());
        jMenu.add(new CronJobScheduleExplorerAction());
        jMenu.add(new JSeparator());
        jMenu.add(new LanguageSelectionAction());
        jMenu.add(new SetupWizardAction());
        jMenu.add(new JSeparator());
        if (Application.getInstance().isDevelopmentMode()) {
            jMenu.add(new RecalculateTicketsAction());
        }
        jMenu.add(new DataResetAction());
        jMenu.add(new MigrateDatabaseAction());
        jMenu.add(new MigrateFloreantposAction());
        jMenu.add(new JSeparator());
        jMenu.add(new ImportFromExcelAction());
        jMenu.add(new ImportFromOtherPosAction());
        jMenu.add(new JSeparator());
        AbstractAction abstractAction = new AbstractAction("Restart"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Main.restart();
            }
        };
        jMenu.add(abstractAction);
        JMenuItem jMenuItem = jMenu.add(new AbstractAction(POSConstants.CLOSE){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BackOfficeWindow.this.close();
                if (BackOfficeWindow.this.i) {
                    new BackofficeWindowCloseListener(BackOfficeWindow.this).windowClosing(null);
                }
            }
        });
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
    }

    protected void createFloorMenu(JMenuBar jMenuBar) {
        this.e = new JMenu(Messages.getString("BackOfficeWindow.2"));
        this.e.add(new ShowTableBrowserAction());
        jMenuBar.add(this.e);
    }

    protected void createGiftCardMenu(JMenuBar jMenuBar) {
        JMenu jMenu = new JMenu(Messages.getString("GiftCard"));
        jMenu.add(new GiftCardGenerateAction());
        jMenu.add(new GiftCardBrowserAction());
        jMenuBar.add(jMenu);
    }

    private void h() {
        this.j = new JPanel();
        this.k = new JideTabbedPane();
        this.k.setTabShape(1);
        this.k.setShowCloseButtonOnTab(true);
        this.k.setTabInsets(new Insets(5, 5, 5, 5));
        this.getContentPane().setLayout(new BorderLayout(5, 0));
        this.setDefaultCloseOperation(3);
        this.j.setLayout(new BorderLayout(5, 0));
        this.j.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.j.add((Component)this.k, "Center");
        this.getContentPane().add((Component)this.j, "Center");
    }

    public JTabbedPane getTabbedPane() {
        return this.k;
    }

    private void i() {
        AppConfig.putInt(d, this.getWidth());
        AppConfig.putInt(c, this.getHeight());
        AppConfig.putInt(b, this.getX());
        AppConfig.putInt(a, this.getY());
    }

    public void close() {
        this.i();
        this.dispose();
    }

    public static BackOfficeWindow getInstance() {
        return f;
    }

    public JMenuBar getBackOfficeMenuBar() {
        return this.g;
    }

    public JMenu getFloorPlanMenu() {
        return this.e;
    }

    public void setFloorPlanMenu(JMenu jMenu) {
        this.e = jMenu;
    }

    @Override
    public void dispose() {
        f = null;
        super.dispose();
    }

    public User getCurrentUser() {
        return this.h;
    }

    public void blinkCacheRefreshButton() {
        this.m.setBlinking(true);
    }

    public void blinkSyncButton() {
        this.n.setBlinking(true);
    }
}

