/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ComboGroupTreeExplorer;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.ComboItemEntryDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ComboItemExplorer
extends TransparentPanel
implements ActionListener {
    private JTable a;
    private final ComboItemExplorerTableModel b;
    private MenuItem c;
    private ComboGroupTreeExplorer d;
    private JRadioButton e;
    private JRadioButton f;
    private JRadioButton g;
    private JRadioButton h;
    private JCheckBox i;

    public ComboItemExplorer() {
        this.a();
        this.b = new ComboItemExplorerTableModel();
        this.a.setModel(this.b);
    }

    private void a() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("fill"));
        jPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.a = new JTable();
        this.a.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.a.setRowHeight(30);
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.setActionCommand(POSConstants.ADD);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.setActionCommand(POSConstants.EDIT);
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.setActionCommand(POSConstants.DELETE);
        jButton3.addActionListener(this);
        this.i = new JCheckBox(Messages.getString("ComboItemExplorer.1"));
        this.i.addActionListener(actionEvent -> this.a(actionEvent));
        this.e = new JRadioButton(Messages.getString("BasePriceOnly"));
        this.e.setSelected(true);
        this.f = new JRadioButton(Messages.getString("BaseAndGroupPrice"));
        this.g = new JRadioButton(Messages.getString("SumOfAddedItemsPrice"));
        this.h = new JRadioButton(Messages.getString("HighestPrice"));
        this.e.addItemListener(itemEvent -> this.c());
        this.f.addItemListener(itemEvent -> this.d());
        this.g.addItemListener(itemEvent -> this.e());
        this.h.addItemListener(itemEvent -> this.f());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.e);
        buttonGroup.add(this.f);
        buttonGroup.add(this.g);
        buttonGroup.add(this.h);
        jPanel.add((Component)this.i, "wrap");
        JPanel jPanel2 = new JPanel(new WrapLayout(3));
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("PricingRule")));
        jPanel2.add((Component)this.e, "wrap");
        jPanel2.add((Component)this.f, "wrap");
        jPanel2.add((Component)this.g, "wrap");
        jPanel2.add((Component)this.h, "wrap");
        jPanel.add((Component)jPanel2, "gaptop 5!,wrap,growx");
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("inset 0 0 0 0"));
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        JScrollPane jScrollPane = new JScrollPane(this.a);
        jScrollPane.setPreferredSize(PosUIManager.getSize(0, 172));
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("ComboItemExplorer.5")));
        jPanel3.add((Component)jScrollPane, "grow,wrap");
        jPanel3.add((Component)transparentPanel, "grow");
        jPanel.add((Component)jPanel3, "grow,newline");
        this.d = new ComboGroupTreeExplorer();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(Messages.getString("ComboItemExplorer.12"));
        this.d.setBorder(BorderFactory.createCompoundBorder(titledBorder, new EmptyBorder(7, 7, 0, 7)));
        jPanel.add((Component)this.d, "grow, newline");
        JScrollPane jScrollPane2 = new JScrollPane(jPanel);
        jScrollPane2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add(jScrollPane2);
    }

    private void b() {
        this.c.setBasePriceForComboItem(false);
        this.c.setBaseAndGroupPriceForComboItem(false);
        this.c.setModifiablePriceForComboItem(false);
        this.c.setHighestPricedComboItem(false);
    }

    private void c() {
        this.b();
        this.c.setBasePriceForComboItem(true);
    }

    private void d() {
        this.b();
        this.c.setBaseAndGroupPriceForComboItem(true);
    }

    private void e() {
        this.b();
        this.c.setModifiablePriceForComboItem(true);
    }

    private void f() {
        this.b();
        this.c.setHighestPricedComboItem(true);
    }

    private void a(ActionEvent actionEvent) {
        JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
        this.c.setEnableComboQuantitySelection(jCheckBox.isSelected());
    }

    public void setMenuItem(MenuItem menuItem) {
        this.c = menuItem;
        this.g();
    }

    private void g() {
        if (this.c.getComboItems() != null) {
            this.b.setItems(new ArrayList<ComboItem>(this.c.getComboItems()));
        } else {
            this.b.setItems(new ArrayList<ComboItem>());
        }
        this.d.setMenuItem(this.c);
        this.i.setSelected(this.c.isEnableComboQuantitySelection());
        this.e.setSelected(this.c.isBasePriceForComboItem());
        this.f.setSelected(this.c.isBaseAndGroupPriceForComboItem());
        this.g.setSelected(this.c.isModifiablePriceForComboItem());
        this.h.setSelected(this.c.isHighestPricedComboItem());
        if (StringUtils.isEmpty((String)this.c.getId()) && this.e.isSelected()) {
            this.c.setBasePriceForComboItem(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (POSConstants.ADD.equals(string)) {
            this.h();
        } else if (POSConstants.EDIT.equals(string)) {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                BOMessageDialog.showError(Messages.getString("ComboItemExplorer.8"));
                return;
            }
            ComboItem comboItem = this.b.getComboItem(n);
            this.a(comboItem);
        } else if (POSConstants.DELETE.equals(string)) {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                BOMessageDialog.showError(POSConstants.SELECT_ITEM_TO_DELETE);
                return;
            }
            ComboItem comboItem = this.b.getComboItem(n);
            this.a(n, comboItem);
        }
    }

    private void h() {
        try {
            MenuItem menuItem;
            MenuItemSelectionDialog menuItemSelectionDialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>());
            menuItemSelectionDialog.setSelectionMode(1);
            menuItemSelectionDialog.setShowVariantParent(false);
            menuItemSelectionDialog.setShowVariant(true);
            menuItemSelectionDialog.setShowComboItem(false);
            menuItemSelectionDialog.setIncludePizzaItem(false);
            menuItemSelectionDialog.setSize(PosUIManager.getSize(600, 515));
            menuItemSelectionDialog.open();
            if (menuItemSelectionDialog.isCanceled()) {
                return;
            }
            ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
            for (ComboItem iterator2 : this.b.getItems()) {
                arrayList.add(iterator2.getMenuItem());
            }
            List<MenuItem> list = menuItemSelectionDialog.getSelectedItems();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                menuItem = (MenuItem)iterator.next();
                if (!this.c.equals(menuItem)) continue;
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CannotAddParentItem"));
                return;
            }
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                menuItem = (MenuItem)iterator2.next();
                if (arrayList == null || arrayList.contains(menuItem)) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setMenuItem(menuItem);
                comboItem.setQuantity(1.0);
                comboItem.setCost(menuItem.getCost());
                Double d = menuItem.getPrice();
                if (menuItem.isVariant().booleanValue()) {
                    d = d + menuItem.getParentMenuItem().getPrice();
                }
                comboItem.setPrice(d);
                this.b.addComboItem(comboItem);
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(ComboItem comboItem) {
        try {
            ComboItemEntryDialog comboItemEntryDialog = new ComboItemEntryDialog();
            comboItemEntryDialog.setComboItemTitle(comboItem.getName());
            comboItemEntryDialog.setQuantity(comboItem.getQuantity());
            comboItemEntryDialog.open();
            if (comboItemEntryDialog.isCanceled()) {
                return;
            }
            Double d = comboItemEntryDialog.getQuantity();
            boolean bl = MenuItemDAO.getInstance().isFractionalUnit(comboItem.getItemId());
            if (NumberUtil.isFractional(d).booleanValue() && !bl) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("FractionalQuantityNotAllowed"));
                return;
            }
            comboItem.setQuantity(d);
            this.b.fireTableDataChanged();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void a(int n, ComboItem comboItem) {
        try {
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                this.b.deleteItem(comboItem, n);
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public List<ComboItem> getSelectedComboItems() {
        return this.b.getItems();
    }

    public List<ComboGroup> getSelectedComboGroups() {
        return this.d.getGroups();
    }

    private class ComboItemExplorerTableModel
    extends AbstractTableModel {
        String[] a = new String[]{Messages.getString("ComboItemExplorer.9"), Messages.getString("ComboItemExplorer.10"), Messages.getString("ComboItemExplorer.11") + " (" + CurrencyUtil.getCurrencySymbol() + ")"};
        List<ComboItem> b = new ArrayList<ComboItem>();

        public void setItems(List<ComboItem> list) {
            if (list == null) {
                return;
            }
            this.b.addAll(list);
        }

        public List<ComboItem> getItems() {
            return this.b;
        }

        @Override
        public int getRowCount() {
            if (this.b == null) {
                return 0;
            }
            return this.b.size();
        }

        @Override
        public int getColumnCount() {
            return this.a.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.b == null) {
                return "";
            }
            ComboItem comboItem = this.b.get(n);
            if (comboItem == null) {
                return "";
            }
            switch (n2) {
                case 0: {
                    return comboItem.getName();
                }
                case 1: {
                    return NumberUtil.trimDecilamIfNotNeeded(comboItem.getQuantity());
                }
                case 2: {
                    return comboItem.getPrice() * comboItem.getQuantity();
                }
            }
            return null;
        }

        public void addComboItem(ComboItem comboItem) {
            int n = this.b.size();
            this.b.add(comboItem);
            this.fireTableRowsInserted(n, n);
        }

        public void deleteItem(ComboItem comboItem, int n) {
            Iterator<ComboItem> iterator = this.b.iterator();
            while (iterator.hasNext()) {
                ComboItem comboItem2 = iterator.next();
                if (comboItem.getMenuItem() != comboItem2.getMenuItem()) continue;
                iterator.remove();
            }
            this.fireTableRowsDeleted(n, n);
        }

        public ComboItem getComboItem(int n) {
            return this.b.get(n);
        }
    }
}

