/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.VariantAttributesSelectionDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class MenuItemVariantExplorer
extends TransparentPanel
implements ActionListener {
    private JTable a;
    private final MenuItemExplorerTableModel b;
    private MenuItem c;
    private Map<String, MenuItem> d = new HashMap<String, MenuItem>();
    private JButton e;
    private boolean f;

    public MenuItemVariantExplorer() {
        this(false);
    }

    public MenuItemVariantExplorer(boolean bl) {
        this.f = bl;
        this.a();
        this.b = new MenuItemExplorerTableModel();
        this.a.setModel(this.b);
        this.a.setRowHeight(50);
        this.a.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                if (n2 == 5) {
                    this.setHorizontalAlignment(0);
                } else if (n2 == 3) {
                    this.setHorizontalAlignment(4);
                } else if (n2 == 4) {
                    this.setHorizontalAlignment(4);
                } else {
                    this.setHorizontalAlignment(2);
                }
                return component;
            }
        });
        this.b();
        this.a.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        FixedLengthTextField fixedLengthTextField = new FixedLengthTextField();
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(fixedLengthTextField);
        defaultCellEditor.setClickCountToStart(1);
        FixedLengthTextField fixedLengthTextField2 = new FixedLengthTextField();
        DefaultCellEditor defaultCellEditor2 = new DefaultCellEditor(fixedLengthTextField2);
        defaultCellEditor2.setClickCountToStart(1);
        DoubleTextField doubleTextField = new DoubleTextField();
        doubleTextField.setAllowNegativeValue(true);
        doubleTextField.setHorizontalAlignment(4);
        DefaultCellEditor defaultCellEditor3 = new DefaultCellEditor(doubleTextField);
        defaultCellEditor3.setClickCountToStart(1);
        JCheckBox jCheckBox = new JCheckBox();
        jCheckBox.setHorizontalAlignment(0);
        DefaultCellEditor defaultCellEditor4 = new DefaultCellEditor(jCheckBox);
        defaultCellEditor4.setClickCountToStart(1);
        this.a.setDefaultEditor(this.a.getColumnClass(1), defaultCellEditor2);
        this.a.setDefaultEditor(this.a.getColumnClass(2), defaultCellEditor);
        this.a.setDefaultEditor(this.a.getColumnClass(3), defaultCellEditor3);
        this.a.setDefaultEditor(this.a.getColumnClass(4), defaultCellEditor3);
        this.a.setDefaultEditor(this.a.getColumnClass(5), defaultCellEditor4);
        if (bl) {
            TableColumnModel tableColumnModel = this.a.getColumnModel();
            this.a.removeColumn(tableColumnModel.getColumn(5));
            this.a.removeColumn(tableColumnModel.getColumn(3));
        }
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.a = new JTable(){

            @Override
            public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
                super.changeSelection(n, n2, bl, bl2);
                MenuItemVariantExplorer.this.a.editCellAt(n, n2);
                MenuItemVariantExplorer.this.a.transferFocus();
                DefaultCellEditor defaultCellEditor = (DefaultCellEditor)MenuItemVariantExplorer.this.a.getCellEditor(n, n2);
                if (n2 == 5) {
                    JCheckBox jCheckBox = (JCheckBox)defaultCellEditor.getComponent();
                    jCheckBox.requestFocus();
                } else if (n2 == 4) {
                    DoubleTextField doubleTextField = (DoubleTextField)defaultCellEditor.getComponent();
                    doubleTextField.requestFocus();
                    doubleTextField.selectAll();
                } else if (n2 == 3) {
                    DoubleTextField doubleTextField = (DoubleTextField)defaultCellEditor.getComponent();
                    doubleTextField.requestFocus();
                    doubleTextField.selectAll();
                } else if (n2 == 2) {
                    FixedLengthTextField fixedLengthTextField = (FixedLengthTextField)defaultCellEditor.getComponent();
                    fixedLengthTextField.requestFocus();
                    fixedLengthTextField.selectAll();
                } else if (n2 == 1) {
                    FixedLengthTextField fixedLengthTextField = (FixedLengthTextField)defaultCellEditor.getComponent();
                    fixedLengthTextField.setLength(255);
                    fixedLengthTextField.requestFocus();
                    fixedLengthTextField.selectAll();
                }
            }
        };
        this.a.setRowHeight(PosUIManager.getSize(40));
        this.a.setSelectionMode(0);
        JButton jButton = new JButton(Messages.getString("MenuItemVariantExplorer.2"));
        jButton.setActionCommand(POSConstants.ADD);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(POSConstants.DELETE);
        jButton2.setActionCommand(POSConstants.DELETE);
        jButton2.addActionListener(this);
        this.e = new JButton(POSConstants.RESET_COST_FROM_PARENT);
        this.e.setActionCommand(POSConstants.RESET_COST_FROM_PARENT);
        this.e.addActionListener(this);
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("inset 0 0 10 0"));
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(this.e);
        this.add((Component)new JScrollPane(this.a), "grow");
        this.add((Component)transparentPanel, "grow,newline");
    }

    public void setVisibleResetCostButton(boolean bl) {
        this.e.setVisible(bl);
    }

    private void b() {
        this.a.setAutoResizeMode(3);
        this.a(0, PosUIManager.getSize(200));
        this.a(1, PosUIManager.getSize(300));
        this.a(2, PosUIManager.getSize(180));
        this.a(3, PosUIManager.getSize(120));
        this.a(4, PosUIManager.getSize(120));
        this.a(5, PosUIManager.getSize(100));
    }

    private void a(int n, int n2) {
        TableColumn tableColumn = this.a.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
    }

    public void setParentMenuItem(MenuItem menuItem) {
        this.c = menuItem;
        this.b.setItems(menuItem.getVariants());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (POSConstants.ADD.equals(string)) {
            this.c();
        } else if (POSConstants.DELETE.equals(string)) {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                BOMessageDialog.showError(POSConstants.SELECT_ITEM_TO_DELETE);
                return;
            }
            MenuItem menuItem = this.b.getMenuItem(n);
            this.a(n, menuItem);
        } else if (POSConstants.RESET_COST_FROM_PARENT.equals(string)) {
            int n = this.b.getRowCount();
            double d = this.c.getCost();
            for (int i = 0; i < n; ++i) {
                this.b.setValueAt(d, i, 3);
                this.repaint();
            }
        }
    }

    private void c() {
        try {
            List<Comparable> list;
            MenuItemDAO.getInstance().checkIfVariantItemsCanbeDeleted(this.c, false);
            VariantAttributesSelectionDialog variantAttributesSelectionDialog = new VariantAttributesSelectionDialog(this.c.getVariants(), this.f);
            variantAttributesSelectionDialog.setSize(PosUIManager.getSize(550, 450));
            variantAttributesSelectionDialog.setParentMenuItem(this.c);
            variantAttributesSelectionDialog.open();
            if (variantAttributesSelectionDialog.isCanceled()) {
                return;
            }
            if (this.f && variantAttributesSelectionDialog.getVariants() != null && variantAttributesSelectionDialog.getVariants().size() > 0 && (list = variantAttributesSelectionDialog.getVariants().get(0).getAttributes()) != null && list.size() > 1) {
                POSMessageDialog.showError(Messages.getString("MultipleAttributeGroupIsNotAllowed"));
                this.c();
                return;
            }
            this.d.clear();
            list = variantAttributesSelectionDialog.getVariants();
            this.b.getItems().clear();
            this.b.setItems(list);
            this.b.fireTableDataChanged();
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(int n, MenuItem menuItem) {
        try {
            if (StringUtils.isNotBlank((String)menuItem.getId())) {
                MenuItemDAO.getInstance().checkIfItemCanbeDeleted(menuItem);
                if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                    this.b.deleteItem(menuItem, n);
                }
            } else {
                this.b.deleteItem(menuItem, n);
            }
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public List<MenuItem> getVariants() {
        this.a.editingStopped(null);
        return this.b.getItems();
    }

    public List<MenuItem> getActiveVariants() {
        return this.b.c;
    }

    private class MenuItemExplorerTableModel
    extends AbstractTableModel {
        String[] a = new String[]{Messages.getString("MenuItemVariantExplorer.6"), Messages.getString("MenuItemVariantExplorer.7"), Messages.getString("MenuItemVariantExplorer.8"), POSConstants.COST, Messages.getString("MenuItemVariantExplorer.9"), Messages.getString("MenuItemVariantExplorer.10")};
        List<MenuItem> b = new ArrayList<MenuItem>();
        List<MenuItem> c;

        public void setItems(List<MenuItem> list) {
            if (list == null) {
                return;
            }
            this.c = new ArrayList<MenuItem>();
            for (MenuItem menuItem : list) {
                if (menuItem.isDeleted().booleanValue()) {
                    MenuItem menuItem2 = (MenuItem)MenuItemVariantExplorer.this.d.get(menuItem.getId());
                    if (menuItem2 != null) continue;
                    MenuItemVariantExplorer.this.d.put(menuItem.getId(), menuItem);
                    continue;
                }
                this.b.add(menuItem);
                this.c.add(menuItem);
            }
        }

        public List<MenuItem> getItems() {
            if (this.b == null) {
                this.b = new ArrayList<MenuItem>();
            }
            this.b.addAll(MenuItemVariantExplorer.this.d.values());
            return this.b;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 1 || n2 == 2 || n2 == 3 || n2 == 4;
        }

        @Override
        public int getRowCount() {
            if (this.c == null) {
                return 0;
            }
            return this.c.size();
        }

        @Override
        public int getColumnCount() {
            return this.a.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 5) {
                return Boolean.class;
            }
            if (n == 3 || n == 4) {
                return Double.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.c == null) {
                return "";
            }
            MenuItem menuItem = this.c.get(n);
            if (menuItem == null) {
                return "";
            }
            switch (n2) {
                case 0: {
                    String string = "<html>";
                    List<Attribute> list = menuItem.getAttributes();
                    if (list == null) {
                        return string;
                    }
                    Iterator<Attribute> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        Attribute attribute = iterator.next();
                        string = string + attribute.getGroup().getName() + ": <font style='color:red'>" + attribute.getName() + "</font>";
                        if (!iterator.hasNext()) continue;
                        string = string + ",&nbsp;";
                    }
                    string = string + "</html>";
                    return string;
                }
                case 1: {
                    return menuItem.getTranslatedName();
                }
                case 2: {
                    return menuItem.getBarcode();
                }
                case 3: {
                    return menuItem.getCost();
                }
                case 4: {
                    return menuItem.getPrice();
                }
                case 5: {
                    return menuItem.isVisible();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n >= this.c.size()) {
                return;
            }
            MenuItem menuItem = this.c.get(n);
            if (menuItem == null) {
                return;
            }
            if (n2 == 1) {
                menuItem.setTranslatedName(String.valueOf(object));
            } else if (n2 == 2) {
                menuItem.setBarcode(String.valueOf(object));
            } else if (n2 == 3) {
                double d = 0.0;
                d = object instanceof String ? NumberUtil.round(POSUtil.parseDouble((String)object)) : (Double)object;
                menuItem.setCost(d);
            } else if (n2 == 4) {
                String string = (String)object;
                if (StringUtils.isBlank((String)string)) {
                    menuItem.setPrice(0.0);
                    return;
                }
                double d = NumberUtil.round(POSUtil.parseDouble(string));
                if (d < 0.0) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NegativePriceNotAllowed"));
                    return;
                }
                menuItem.setPrice(d);
            }
            if (n2 == 5) {
                Boolean bl = (Boolean)object;
                if (bl == null) {
                    return;
                }
                menuItem.setVisible(bl);
            }
            super.setValueAt(object, n, n2);
        }

        public void deleteItem(MenuItem menuItem, int n) {
            Iterator<MenuItem> iterator = this.c.iterator();
            while (iterator.hasNext()) {
                MenuItem menuItem2 = iterator.next();
                if (menuItem != menuItem2) continue;
                menuItem2.setDeleted(true);
                MenuItem menuItem3 = (MenuItem)MenuItemVariantExplorer.this.d.get(menuItem2.getId());
                if (menuItem3 == null) {
                    MenuItemVariantExplorer.this.d.put(menuItem2.getId(), menuItem2);
                }
                iterator.remove();
            }
            this.fireTableRowsDeleted(n, n);
        }

        public MenuItem getMenuItem(int n) {
            return this.c.get(n);
        }
    }

    public class ComboBoxEditor
    extends DefaultCellEditor
    implements TableCellEditor {
        JComboBox a;

        public ComboBoxEditor(JComboBox jComboBox) {
            super(jComboBox);
            this.a = jComboBox;
        }

        @Override
        public Object getCellEditorValue() {
            return this.a.getSelectedItem();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.a.setSelectedItem(object);
            return this.a;
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }
    }
}

