/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.ModelBrowser;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.dao.PriceRuleDAO;
import com.floreantpos.model.dao.PriceTableDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.NewPriceListForm;
import com.floreantpos.ui.model.PriceTableForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class PriceListBrowser
extends ModelBrowser<PriceTable> {
    private BeanTableModel<PriceTable> a;
    private JButton b;
    private JButton c;

    public PriceListBrowser() {
        super(new PriceTableForm(), "fill,grow", "", "grow");
        this.a();
        this.e();
    }

    private void a() {
        this.a = new BeanTableModel(PriceTable.class);
        this.a.addColumn(POSConstants.NAME, PriceTable.PROP_NAME);
        this.a.addColumn(Messages.getString("LastUpdateTime"), PriceTable.PROP_LAST_UPDATE_TIME);
        this.a.setPageSize(20);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.b(), "South");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.init(this.a);
        this.buttonPanel.removeAll();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(Messages.getString("PRICE_LISTS"));
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        this.browserPanel.add(new JScrollPane((Component)this.browserTable, 20, 30));
        this.beanPanel.setBorder(BorderFactory.createTitledBorder("Price details"));
        this.browserPanel.setBorder(new CompoundBorder(titledBorder, emptyBorder));
        jPanel.add((Component)this.browserPanel, "Center");
        jPanel2.add((Component)this.beanPanel, "Center");
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.add((Component)jPanel, "grow,w 350!");
        this.add((Component)jPanel2, "grow,span,push");
        this.d();
    }

    private JPanel b() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("", "[][]", "[][]"));
        this.b = new JButton(Messages.getString("PriceListBrowser.0"));
        this.b.addActionListener(actionEvent -> this.c());
        this.c = new JButton(Messages.getString("PriceListBrowser.1"));
        this.c.addActionListener(actionEvent -> this.delete());
        jPanel.add(this.b);
        jPanel.add(this.c);
        return jPanel;
    }

    private void c() {
        NewPriceListForm newPriceListForm = new NewPriceListForm(new PriceRule());
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog(POSUtil.getFocusedWindow(), (BeanEditor)newPriceListForm);
        beanEditorDialog.open();
        if (beanEditorDialog.isCanceled()) {
            return;
        }
        PriceTable priceTable = newPriceListForm.getPriceTable();
        this.browserTable.clearSelection();
        this.a.addRow(priceTable);
        this.browserTable.getSelectionModel().setSelectionInterval(this.a.getRowCount() - 1, this.a.getRowCount() - 1);
        this.getBeanEditor().setBean(priceTable);
        this.browserTable.revalidate();
        this.browserTable.repaint();
    }

    @Override
    public void doCancelEditing() {
        this.e();
        this.browserTable.clearSelection();
        this.browserTable.setEnabled(true);
        this.beanEditor.cancel();
    }

    private void d() {
        this.a(0);
    }

    private void a(int n) {
        try {
            this.a.setCurrentRowIndex(n);
            this.a.setRows(PriceTableDAO.getInstance().findAll());
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    @Override
    public void dataUpdated(PriceTable priceTable) {
        if (this.a.getRowCount() == 0 || this.a.getRows().indexOf(priceTable) == -1) {
            this.a.addRow(priceTable);
            this.browserTable.addRowSelectionInterval(this.a.getRowCount() - 1, this.a.getRowCount() - 1);
        }
        POSMessageDialog.showMessage(Messages.getString("BeanEditorDialog.0"));
    }

    @Override
    public void updateActionButtons() {
        this.e();
    }

    private void e() {
        this.btnSave.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.beanEditor.setFieldsEnable(true);
        this.btnEdit.setEnabled(false);
        this.btnNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnDelete.setVisible(false);
    }

    @Override
    public void refreshTable() {
        this.e();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() {
        Transaction transaction = null;
        try (Session session = null;){
            int n = this.browserTable.getSelectedRow();
            if (n < 0) {
                throw new PosException(Messages.getString("SelectToDelete"));
            }
            n = this.browserTable.convertRowIndexToModel(n);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            PriceTable priceTable = this.a.getRow(n);
            priceTable.setDeleted(true);
            PriceRule priceRule = PriceRuleDAO.getInstance().getPriceRulesByPriceTable(priceTable.getId());
            session = PriceRuleDAO.getInstance().createNewSession();
            transaction = session.beginTransaction();
            PriceTableDAO.getInstance().saveOrUpdate(priceTable, session);
            if (priceRule != null) {
                priceRule.setDeleted(true);
                PriceRuleDAO.getInstance().saveOrUpdate(priceRule, session);
            }
            transaction.commit();
            this.a.removeRow(n);
            this.browserTable.clearSelection();
            this.beanEditor.clearFields();
        }
    }
}

