/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.config.ui.DrawerConnectionView;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawerType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;

public class CashDrawerConfigurationView
extends ConfigurationView {
    private JComboBox a;
    private DrawerConnectionView b;
    private DrawerConnectionView c;

    private void a() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", ""));
        this.a = new JComboBox<CashDrawerType>(CashDrawerType.values());
        Terminal terminal = Application.getInstance().getTerminal();
        this.a.setEnabled(!terminal.isCashDrawerAssigned() && !terminal.isSecondCashDrawerAssigned());
        this.a.setToolTipText(Messages.getString("CashDrawerConfigurationView.0"));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("ins 0,hidemode 3", "[grow]"));
        this.b = new DrawerConnectionView(false, this.b());
        jPanel2.add((Component)this.b, "grow, wrap");
        this.c = new DrawerConnectionView(true, Messages.getString("CashDrawerConfigurationView.2"));
        jPanel2.add((Component)this.c, "grow, wrap");
        jPanel.add((Component)new JLabel(Messages.getString("CashDrawerConfigurationView.1")), "split 2");
        jPanel.add((Component)this.a, "wrap");
        jPanel.add((Component)jPanel2, "grow, wrap");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
        this.c();
        this.a.addItemListener(itemEvent -> this.c());
    }

    private String b() {
        CashDrawerType cashDrawerType = (CashDrawerType)((Object)this.a.getSelectedItem());
        if (cashDrawerType == CashDrawerType.SINGLE_CASH_DRAWER) {
            return Messages.getString("PeripheralConfigurationView.4");
        }
        if (cashDrawerType == CashDrawerType.DUAL_CASH_DRAWER) {
            return Messages.getString("CashDrawerConfigurationView.3");
        }
        return Messages.getString("PeripheralConfigurationView.4");
    }

    private void c() {
        CashDrawerType cashDrawerType = (CashDrawerType)((Object)this.a.getSelectedItem());
        if (cashDrawerType == CashDrawerType.NO_CASH_DRAWER) {
            this.b.setVisible(false);
            this.c.setVisible(false);
        } else if (cashDrawerType == CashDrawerType.SINGLE_CASH_DRAWER) {
            this.b.setVisible(true);
            this.c.setVisible(false);
        } else if (cashDrawerType == CashDrawerType.DUAL_CASH_DRAWER) {
            this.b.setVisible(true);
            this.c.setVisible(true);
        }
        this.b.setCaption(this.b());
    }

    @Override
    public boolean save() throws Exception {
        DataProvider.get().refreshCurrentTerminal();
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        CashDrawerType cashDrawerType = (CashDrawerType)((Object)this.a.getSelectedItem());
        if (cashDrawerType == CashDrawerType.NO_CASH_DRAWER) {
            terminal.setHasCashDrawer(false);
        } else if (cashDrawerType == CashDrawerType.SINGLE_CASH_DRAWER) {
            terminal.setHasCashDrawer(true);
            if (!this.b.save(terminal)) {
                return false;
            }
        } else if (cashDrawerType == CashDrawerType.DUAL_CASH_DRAWER) {
            terminal.setHasCashDrawer(true);
            if (!this.b.save(terminal)) {
                return false;
            }
            if (this.c != null && !this.c.save(terminal)) {
                return false;
            }
        }
        terminal.setCashDrawerType(cashDrawerType.name());
        TerminalDAO.getInstance().saveOrUpdate(terminal);
        return true;
    }

    @Override
    public void initialize() throws Exception {
        if (this.isInitialized()) {
            return;
        }
        this.a();
        this.d();
        this.b.initialize();
        if (this.c != null) {
            this.c.initialize();
        }
        this.setInitialized(true);
    }

    private void d() {
        Terminal terminal = Application.getInstance().getTerminal();
        this.a.setSelectedItem((Object)CashDrawerType.getCashDrawerType(terminal.getCashDrawerType()));
    }

    @Override
    public String getName() {
        return Messages.getString("CashDrawerConfigurationView.1");
    }
}

