/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CashRoundingRule;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.StoreUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ChargeConfigurationView
extends ConfigurationView {
    private DoubleTextField a;
    private DoubleTextField b;
    private JCheckBox c;
    private JCheckBox d;
    private JCheckBox e;
    private JComboBox f;
    private JCheckBox g;
    private Outlet h;
    private Store i;
    private JCheckBox j;
    private JCheckBox k;
    private JCheckBox l;
    private JLabel m;
    private IntegerTextField n;
    private OverflowCombobox o;
    private FixedLengthTextField p;

    public ChargeConfigurationView(Store store, Outlet outlet) {
        this.i = store;
        this.h = outlet;
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3", "[][grow][]", ""));
        JLabel jLabel = new JLabel(Messages.getString("CashConfigurationView.0"));
        this.o = new OverflowCombobox((Object[])CashRoundingRule.values());
        this.o.setMaximumSize(new Dimension(400, 30));
        jPanel.add(jLabel);
        jPanel.add((Component)this.o, "growx,wrap");
        JLabel jLabel2 = new JLabel(Messages.getString("ChargeConfigurationView.10"));
        jPanel.add((Component)jLabel2, "flowy,alignx trailing");
        this.p = new FixedLengthTextField();
        jPanel.add((Component)this.p, "growx,wrap");
        JLabel jLabel3 = new JLabel(Messages.getString("RestaurantConfigurationView.48") + ":");
        jPanel.add((Component)jLabel3, "flowy,alignx trailing");
        this.a = new DoubleTextField();
        jPanel.add((Component)this.a, "growx");
        JLabel jLabel4 = new JLabel("%");
        jPanel.add((Component)jLabel4, "wrap");
        JLabel jLabel5 = new JLabel(Messages.getString("ChargeConfigurationView.0"));
        jPanel.add((Component)jLabel5, "flowy,alignx trailing");
        this.b = new DoubleTextField();
        jPanel.add((Component)this.b, "growx");
        JLabel jLabel6 = new JLabel("%");
        jPanel.add((Component)jLabel6, "wrap");
        JLabel jLabel7 = new JLabel(Messages.getString("ChargeConfigurationView.1"));
        this.f = new OverflowCombobox();
        jPanel.add((Component)jLabel7, "alignx trailing");
        jPanel.add((Component)this.f, "grow, wrap");
        this.m = new JLabel(Messages.getString("NextTokenSequence"));
        jPanel.add((Component)this.m, "alignx trailing");
        this.n = new IntegerTextField();
        jPanel.add((Component)this.n, "growx,wrap");
        this.c = new JCheckBox(Messages.getString("ChargeConfigurationView.5"));
        jPanel.add((Component)this.c, "skip 1, wrap");
        this.d = new JCheckBox(Messages.getString("TaxConfigurationView.4"));
        jPanel.add((Component)this.d, "skip 1,wrap");
        this.d.addItemListener(itemEvent -> this.b());
        this.g = new JCheckBox(Messages.getString("ChargeConfigurationView.4"));
        this.g.setVisible(false);
        jPanel.add((Component)this.g, "skip 1,wrap");
        this.e = new JCheckBox(Messages.getString("ChargeConfigurationView.2"));
        jPanel.add((Component)this.e, "skip 1,wrap");
        this.j = new JCheckBox(Messages.getString("ChargeConfigurationView.7"));
        jPanel.add((Component)this.j, "skip 1, wrap");
        this.k = new JCheckBox(Messages.getString("ChargeConfigurationView.21"));
        jPanel.add((Component)this.k, "skip 1, wrap");
        this.l = new JCheckBox(Messages.getString("ResetTokenNo"));
        this.l.addActionListener(actionEvent -> this.c());
        jPanel.add((Component)this.l, "skip 1,wrap");
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(null);
        this.add(jScrollPane);
    }

    private void b() {
        if (this.d.isSelected()) {
            this.g.setVisible(true);
        } else {
            this.g.setVisible(false);
        }
    }

    private void c() {
        if (this.l.isSelected()) {
            this.a(true);
        } else {
            this.a(false);
        }
    }

    private void a(boolean bl) {
        this.m.setVisible(bl);
        this.n.setVisible(bl);
    }

    @Override
    public boolean save() throws Exception {
        if (!this.isInitialized()) {
            return true;
        }
        double d = 0.0;
        String string = null;
        String string2 = null;
        if (StringUtils.isEmpty(string)) {
            string = POSConstants.DOLLAR;
        }
        if (StringUtils.isEmpty(string2)) {
            string2 = "$";
        }
        d = this.a.getDoubleOrZero();
        double d2 = this.b.getDoubleOrZero();
        if (d2 > 100.0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ChargeConfigurationView.8"));
            return false;
        }
        this.i.setCurrencyName(string);
        this.i.setCurrencySymbol(string2);
        this.i.addProperty("show_subtotal.without_tax", String.valueOf(this.g.isSelected()));
        this.i.addProperty("overtime.markup", String.valueOf(d2));
        this.i.addProperty("store.allow.multiple.discount", String.valueOf(this.j.isSelected()));
        this.i.setShowVoidedItemsOnTicket(!this.k.isSelected());
        this.i.setVATNumber(this.p.getText());
        this.i.setUseDetailedReconciliation(this.c.isSelected());
        this.i.setItemPriceIncludesTax(this.d.isSelected());
        this.i.setEnableFloridaTaxRule(this.e.isSelected());
        if (this.l.isSelected()) {
            int n = this.n.getInteger();
            if (n < 1) {
                throw new PosException(Messages.getString("TokenNoGreaterOne"));
            }
            this.i.addProperty("token_no.start", String.valueOf(n));
        }
        this.i.addProperty("reset.token", String.valueOf(this.l.isSelected()));
        if (this.h != null) {
            this.h.setDefaultGratuityPercentage(d);
            TaxGroup taxGroup = (TaxGroup)this.f.getSelectedItem();
            this.h.setTaxGroup(taxGroup);
        }
        CashRoundingRule cashRoundingRule = (CashRoundingRule)((Object)this.o.getSelectedItem());
        StoreUtil.setCashRoundRule(this.i, cashRoundingRule);
        return true;
    }

    @Override
    public void initialize() throws Exception {
        ArrayList<TaxGroup> arrayList = new ArrayList<TaxGroup>();
        arrayList.add(null);
        arrayList.addAll(TaxGroupDAO.getInstance().findAll());
        this.f.setModel(new ComboBoxModel(arrayList));
        this.k.setSelected(!this.i.isShowVoidedItemsOnTicket());
        boolean bl = this.i.getBooleanProperty("reset.token", true);
        this.l.setSelected(bl);
        String string = this.i.getProperty("token_no.start");
        String string2 = string == null ? String.valueOf(1) : string;
        this.n.setText(string2);
        this.a(bl);
        this.g.setSelected(POSUtil.getBoolean(this.i.getProperty("show_subtotal.without_tax")));
        this.b.setText(String.valueOf(this.i.getOvertimeMarkup()));
        this.c.setSelected(this.i.isUseDetailedReconciliation());
        this.d.setSelected(this.i.isItemPriceIncludesTax());
        this.e.setSelected(this.i.isEnableFloridaTaxRule());
        this.j.setSelected(this.i.isAllowMulDiscount());
        this.p.setText(this.i.getVATNumber());
        if (this.h != null) {
            this.a.setText(String.valueOf(this.h.getDefaultGratuityPercentage()));
            this.f.setSelectedItem(this.h.getTaxGroup());
        }
        this.o.setSelectedItem((Object)StoreUtil.getCashRounding(this.i));
        this.setInitialized(true);
    }

    @Override
    public String getName() {
        return POSConstants.CONFIG_TAB_CHARGE;
    }
}

