/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.PrintException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.Course;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Department;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Printer;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.ReceiptParam;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.TipSuggestion;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.base.BaseCourse;
import com.floreantpos.model.base.BaseModifiableTicketItem;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.base.BaseTicketItemCookingInstruction;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.base.BaseTicketItemSeat;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.ext.CardTypeEnum;
import com.floreantpos.model.ext.ReciptPaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.qrcode.QRReceiptPlugin;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.ListModel;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.TipsSuggestionDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.NumericGlobalIdGenerator;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ReceiptUtil;
import com.floreantpos.util.ShiftUtil;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReceiptConfigurationView
extends JPanel
implements RefreshableView {
    private boolean a = false;
    private JTextPane b;
    private JTextPane c;
    private JTextPane d;
    private JTextPane e;
    private JTextPane f;
    private JList<TipSuggestion> g;
    private JList<ReceiptParam> h;
    private OrderType i;
    private ButtonGroup j;
    private boolean k;
    private OrderInfoView l = null;
    private KitchenReceiptView m = null;
    private JCheckBox n = new JCheckBox(Messages.getString("ReceiptConfigurationView.0"));
    private JComboBox o = new JComboBox();
    private JComboBox p = new JComboBox();
    private JComboBox q = new JComboBox();
    private JComboBox r = new JComboBox();
    private JComboBox s = new JComboBox();
    private JComboBox t = new JComboBox();
    private String[] u;
    private JComboBox v = new JComboBox();
    private JCheckBox w = new JCheckBox(Messages.getString("ReceiptConfigurationView.1"));
    private JCheckBox x = new JCheckBox(Messages.getString("ZeroCostModifier"));
    private JCheckBox y = new JCheckBox(Messages.getString("ReceiptConfigurationView.2"));
    private JCheckBox z = new JCheckBox(Messages.getString("ReceiptConfigurationView.3"));
    private JCheckBox A = new JCheckBox(Messages.getString("ReceiptConfigurationView.111"));
    private JCheckBox B = new JCheckBox(Messages.getString("ReceiptConfigurationView.4"));
    private JCheckBox C = new JCheckBox(Messages.getString("ReceiptConfigurationView.5"));
    private JCheckBox D = new JCheckBox(Messages.getString("ReceiptConfigurationView.6"));
    private JCheckBox E = new JCheckBox(Messages.getString("ReceiptConfigurationView.7"));
    private POSToggleButton F;
    private POSToggleButton G;
    private POSToggleButton H;
    private JComboBox<ReciptPaperSize> I;
    private JButton J;
    private JButton K;
    private JButton L;
    private JScrollPane M;
    private JPanel N;
    private JPanel O = null;
    private JComboBox P;
    private JPanel Q;
    private Store R = DataProvider.get().getStore();
    private Terminal S = DataProvider.get().getCurrentTerminal();
    private FontPropertiesPanel T;
    private FontPropertiesPanel U;
    private FontPropertiesPanel V;
    private FontPropertiesPanel W;
    private FontPropertiesPanel X;
    private FontPropertiesPanel Y;

    public ReceiptConfigurationView() {
        this(false);
    }

    public ReceiptConfigurationView(boolean bl) {
        this.k = bl;
        this.b();
    }

    public void initialize() throws Exception {
        if (this.a) {
            this.refresh();
            return;
        }
        this.a();
        this.a = true;
    }

    private void a() {
        DataProvider.get().refreshStore();
        ReceiptParam[] receiptParamArray = ReceiptParam.values();
        List<ReceiptParam> list = Arrays.asList(receiptParamArray);
        list.sort(Comparator.comparing(Enum::name));
        this.h.setModel(new ListModel<ReceiptParam>(list));
        String string = this.S.getProperty("main.recipt.paper_size", ReciptPaperSize.Eighty.name());
        String string2 = this.S.getProperty("kitchen.recipt.paper_size", ReciptPaperSize.Eighty.name());
        String string3 = this.S.getProperty("main.receipt.print_preview_system", "Standard");
        String string4 = this.S.getProperty("kitchen.receipt.print_preview_system", "Standard");
        if (!this.k) {
            ReciptPaperSize reciptPaperSize = ReciptPaperSize.fromName(string);
            this.I.setSelectedItem((Object)reciptPaperSize);
            this.P.setSelectedItem(string3);
        } else {
            ReciptPaperSize reciptPaperSize = ReciptPaperSize.fromName(string2);
            this.I.setSelectedItem((Object)reciptPaperSize);
            this.P.setSelectedItem(string4);
        }
        if (this.k) {
            this.m();
        } else {
            this.i();
        }
        this.j();
        this.l();
        this.w();
    }

    private String a(Object object) {
        String string = "#000000";
        Color color = Color.black;
        if (object != null) {
            color = ((SimpleColor)((Object)object)).a;
        }
        try {
            string = "#" + Integer.toHexString(color.getRGB()).substring(2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public boolean save(boolean bl) throws Exception {
        Object object;
        Object object2;
        boolean bl2;
        TerminalDAO.getInstance().refresh(this.S);
        StoreDAO.getInstance().refresh(this.R);
        this.b.getDocument().putProperty("__EndOfLine__", "<br>");
        this.e.getDocument().putProperty("__EndOfLine__", "<br>");
        this.f.getDocument().putProperty("__EndOfLine__", "<br>");
        this.c.getDocument().putProperty("__EndOfLine__", "<br>");
        this.d.getDocument().putProperty("__EndOfLine__", "<br>");
        String string = this.b.getText();
        String string2 = this.e.getText();
        String string3 = this.f.getText();
        String string4 = this.c.getText();
        String string5 = this.d.getText();
        if (string.replaceAll("<br>", "").isEmpty()) {
            string = "";
        }
        if (string2.replaceAll("<br>", "").isEmpty()) {
            string2 = "";
        }
        if (string3.replaceAll("<br>", "").isEmpty()) {
            string3 = "";
        }
        if (string4.replaceAll("<br>", "").isEmpty()) {
            string4 = "";
        }
        if (string5.replaceAll("<br>", "").isEmpty()) {
            string5 = "";
        }
        String string6 = "";
        boolean bl3 = bl2 = this.i != null && bl;
        if (bl2 && this.i.getId() != "generic_order") {
            string6 = this.i.getId() + ".";
        }
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < this.g.getModel().getSize(); ++i) {
            object2 = this.g.getModel().getElementAt(i);
            object = new JSONObject();
            object.put("percentage", (Object)NumberUtil.trimDecilamIfNotNeeded(((TipSuggestion)object2).getPercentage()));
            object.put("sortOrder", ((TipSuggestion)object2).getSortOrder());
            jSONArray.put(object);
        }
        Map<String, String> map = this.R.getProperties();
        object2 = (ReciptPaperSize)((Object)this.I.getSelectedItem());
        if (!this.k) {
            POSUtil.storeLongProperty(map, string6 + "ticket.header", string, 255);
            POSUtil.storeLongProperty(map, string6 + "ticket.order.info", string2, 255);
            POSUtil.storeLongProperty(map, string6 + "ticket.order.extrainfo1", string3, 255);
            POSUtil.storeLongProperty(map, string6 + "ticket.footer", string4, 255);
            POSUtil.storeLongProperty(map, string6 + "ticket.bottom", string5, 255);
            POSUtil.storeLongProperty(map, string6 + "tips_suggestion", jSONArray.toString(), 255);
            this.R.addProperty(string6 + "ticket.modifier.color", this.a(this.o.getSelectedItem()));
            this.R.addProperty(string6 + "ticket.seat.color", this.a(this.p.getSelectedItem()));
            this.R.addProperty(string6 + "ticket.instruction.color", this.a(this.v.getSelectedItem()));
            this.R.addProperty(string6 + "receipt.show_tips_suggestion", String.valueOf(this.n.isSelected()));
            this.R.addProperty(string6 + "receipt.show_tips_block", String.valueOf(this.y.isSelected()));
            this.R.addProperty(string6 + "receipt.show_tax_breakdown", String.valueOf(this.z.isSelected()));
            this.R.addProperty(string6 + "kitchen_receipt.print_cooking_instruction", String.valueOf(this.B.isSelected()));
            this.R.addProperty("showModifierPrice", String.valueOf(this.w.isSelected()));
            this.R.addProperty("suppress.zerocost.modifiers", String.valueOf(this.x.isSelected()));
            this.R.setShowQRCodeOnHeader(this.D.isSelected());
            this.R.setShowQRCodeOnFooter(this.E.isSelected());
            this.T.updateModel("ticket.header");
            this.U.updateModel("ticket.order.info");
            this.V.updateModel("ticket.order.extrainfo1");
            this.W.updateModel("ticket.footer");
            this.X.updateModel("ticket.bottom");
            this.Y.updateModel("ticket.details");
            this.S.addProperty("main.recipt.paper_size", ((Enum)object2).name());
            this.S.addProperty("main.receipt.print_preview_system", String.valueOf(this.P.getSelectedItem()));
            this.n();
        } else {
            POSUtil.storeLongProperty(map, string6 + "kitchen.header", string, 255);
            POSUtil.storeLongProperty(map, string6 + "kitchen.order.info", string2, 255);
            POSUtil.storeLongProperty(map, string6 + "kitchen.order.extrainfo1", string3, 255);
            POSUtil.storeLongProperty(map, string6 + "kitchen.footer", string4, 255);
            POSUtil.storeLongProperty(map, string6 + "kitchen.bottom", string5, 255);
            this.R.addProperty(string6 + "kitchen_ticket.modifier.color", this.a(this.o.getSelectedItem()));
            this.R.addProperty(string6 + "kitchen_ticket.seat.color", this.a(this.p.getSelectedItem()));
            this.R.addProperty(string6 + "kitchen_ticket.instruction.color", this.a(this.v.getSelectedItem()));
            this.R.addProperty("kitchen_receipt.print_translated_name", String.valueOf(this.A.isSelected()));
            this.R.setShowGuestNote(this.C.isSelected());
            this.T.updateModel("kitchen.header");
            this.U.updateModel("kitchen.order.info");
            this.V.updateModel("kitchen.order.extrainfo1");
            this.W.updateModel("kitchen.footer");
            this.X.updateModel("kitchen.bottom");
            this.Y.updateModel("kitchen.details");
            this.S.addProperty("kitchen.recipt.paper_size", ((Enum)object2).name());
            this.S.addProperty("kitchen.receipt.print_preview_system", String.valueOf(this.P.getSelectedItem()));
            this.o();
        }
        object = ReceiptParam.STORE_LOGO.getParamName();
        if (string.contains((CharSequence)object) || string3.contains((CharSequence)object) || string2.contains((CharSequence)object) || string4.contains((CharSequence)object) || string5.contains((CharSequence)object)) {
            POSUtil.storeLongProperty(map, this.k ? string6 + "kitchen.header.logo.show" : string6 + "ticket.header.logo.show", "true", 255);
        } else {
            POSUtil.storeLongProperty(map, this.k ? string6 + "kitchen.header.logo.show" : string6 + "ticket.header.logo.show", "false", 255);
        }
        TerminalDAO.getInstance().update(this.S);
        StoreDAO.getInstance().saveOrUpdate(this.R);
        DataProvider.get().refreshStore();
        OutletDAO.getInstance().refresh(DataProvider.get().getOutlet());
        DataProvider.get().refreshCurrentTerminal();
        OroMqttClient.getInstance().notifyDataUpdated(Store.class);
        return true;
    }

    private void b() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        int n = Application.getPosWindow().getSize().width / 3 + 80;
        int n2 = PosUIManager.getSize(n);
        int n3 = PosUIManager.getSize(125);
        int n4 = PosUIManager.getDefaultFontSize();
        jPanel.setLayout((LayoutManager)new MigLayout("ins 0 5 10 5 ,wrap 1,filly", "[" + n2 + "]", "[" + n3 + "][grow," + n3 + "][grow," + n3 + "][grow," + n3 + "][" + n3 + "][]"));
        this.h = new JList();
        this.h.setFocusable(false);
        this.h.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ReceiptConfigurationView.this.s();
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.h);
        jScrollPane.setBorder(BorderFactory.createTitledBorder("Params"));
        jScrollPane.setPreferredSize(PosUIManager.getSize(130, 200));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel4.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.33")));
        this.I = new JComboBox<ReciptPaperSize>(ReciptPaperSize.values());
        jPanel4.add(this.I, "grow");
        jPanel3.add((Component)jPanel4, "South");
        JPanel jPanel5 = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel5.setBorder(BorderFactory.createTitledBorder("Print preview"));
        this.P = new JComboBox();
        this.P.addItem("Standard");
        this.P.addItem("EscPOS");
        this.P.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            this.l();
        });
        jPanel5.add((Component)this.P, "grow");
        jPanel3.add((Component)jPanel5, "North");
        jPanel2.add((Component)jPanel3, "North");
        jPanel2.add((Component)jScrollPane, "Center");
        this.add((Component)jPanel2, "West");
        this.T = new FontPropertiesPanel();
        this.U = new FontPropertiesPanel();
        this.V = new FontPropertiesPanel();
        this.W = new FontPropertiesPanel();
        this.X = new FontPropertiesPanel();
        this.Y = new FontPropertiesPanel();
        this.b(false);
        this.b = new JTextPane();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setFontSize(simpleAttributeSet, n4);
        StyleConstants.setAlignment(simpleAttributeSet, 1);
        this.b.setParagraphAttributes(simpleAttributeSet, true);
        jPanel.add(this.a(Messages.getString("ReceiptConfigurationView.26"), this.T, this.b), "grow");
        this.e = new JTextPane();
        this.e.setParagraphAttributes(simpleAttributeSet, true);
        jPanel.add(this.a(Messages.getString("ReceiptConfigurationView.28"), this.U, this.e), "grow");
        this.f = new JTextPane();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        this.f.setParagraphAttributes(simpleAttributeSet, true);
        jPanel.add(this.a(Messages.getString("ReceiptConfigurationView.30"), this.V, this.f), "grow");
        this.d = new JTextPane();
        StyleConstants.setAlignment(simpleAttributeSet, 0);
        this.d.setParagraphAttributes(simpleAttributeSet, true);
        jPanel.add(this.a(Messages.getString("ReceiptConfigurationView.37"), this.W, this.d), "grow");
        this.c = new JTextPane();
        StyleConstants.setAlignment(simpleAttributeSet, 1);
        this.c.setParagraphAttributes(simpleAttributeSet, true);
        jPanel.add(this.a(Messages.getString("ReceiptConfigurationView.32"), this.X, this.c), "grow");
        this.Y.setBorder(BorderFactory.createTitledBorder(Messages.getString("PosMessage.112")));
        jPanel.add((Component)this.Y, "grow");
        jPanel.add((Component)this.c(), "grow");
        jPanel.add((Component)this.d(), "grow, gap left 50");
        jPanel.add((Component)this.f(), "grow,wrap,gap bottom 50");
        JScrollPane jScrollPane2 = new JScrollPane(jPanel);
        jScrollPane2.setBorder(null);
        jScrollPane2.getVerticalScrollBar().setUnitIncrement(25);
        this.add(jScrollPane2);
        JPanel jPanel6 = new JPanel((LayoutManager)new MigLayout("fillx,ins 3 0 3 0"));
        jPanel6.add((Component)new JSeparator(), "span,growx");
        JButton jButton = new JButton(POSConstants.RESTORE_DEFAULTS);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ReceiptConfigurationView.35"), POSConstants.CONFIRM) == 1) {
                    return;
                }
                ReceiptConfigurationView.this.g();
            }
        });
        jPanel6.add((Component)jButton, "split 2,center, gapbottom 0");
        JButton jButton2 = new JButton(POSConstants.SAVE);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ReceiptConfigurationView.this.save(true);
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ReceiptConfigurationView.36"));
                    if (ReceiptConfigurationView.this.k) {
                        ReceiptConfigurationView.this.d(false);
                    } else {
                        ReceiptConfigurationView.this.c(false);
                    }
                }
                catch (StaleStateException staleStateException) {
                    POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), ReceiptConfigurationView.this);
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        jPanel6.add(jButton2);
        if (Application.getInstance().getLicense().isDemoLicense()) {
            JPanel jPanel7 = POSUtil.doCreateDemoMessagePanel(Messages.getString("StoreConfigurationView.13"));
            jPanel6.add(jPanel7);
        }
        this.add((Component)jPanel6, "South");
    }

    private Component a(String string, JPanel jPanel, JTextPane jTextPane) {
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(jTextPane);
        jPanel2.setBorder(BorderFactory.createTitledBorder(string));
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add(jScrollPane);
        return jPanel2;
    }

    private JPanel c() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3"));
        this.n.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ReceiptConfigurationView.this.a(true);
                } else {
                    ReceiptConfigurationView.this.a(false);
                }
            }
        });
        this.D.setVisible(false);
        this.E.setVisible(false);
        jPanel.add((Component)this.D, "wrap");
        jPanel.add((Component)this.E, "wrap");
        jPanel.add((Component)this.w, "wrap");
        jPanel.add((Component)this.x, "wrap");
        jPanel.add((Component)this.y, "wrap");
        jPanel.add((Component)this.z, "wrap");
        jPanel.add((Component)this.C, "wrap");
        jPanel.add((Component)this.A, "wrap");
        jPanel.add((Component)this.B, "wrap");
        jPanel.add((Component)this.n, "wrap");
        return jPanel;
    }

    private JPanel d() {
        this.N = new JPanel((LayoutManager)new MigLayout("hidemode 3"));
        this.N.setBorder(BorderFactory.createTitledBorder(Messages.getString("TipsSuggestion")));
        this.g = new JList();
        this.M = new JScrollPane(this.g);
        this.M.setPreferredSize(PosUIManager.getSize(130, 120));
        this.J = new JButton(POSConstants.ADD_BUTTON_TEXT);
        this.J.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiptConfigurationView.this.t();
            }
        });
        this.K = new JButton(POSConstants.EDIT);
        this.K.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiptConfigurationView.this.u();
            }
        });
        this.L = new JButton(POSConstants.DELETE);
        this.L.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiptConfigurationView.this.v();
            }
        });
        this.N.add(this.M);
        this.N.add(this.J);
        this.N.add(this.K);
        this.N.add(this.L);
        this.a(false);
        return this.N;
    }

    private void a(boolean bl) {
        this.M.setVisible(bl);
        this.J.setVisible(bl);
        this.K.setVisible(bl);
        this.L.setVisible(bl);
        this.N.setVisible(bl);
    }

    private JPanel e() {
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        this.u = graphicsEnvironment.getAvailableFontFamilyNames();
        this.q.setModel(new DefaultComboBoxModel<String>(this.u));
        this.s.setModel(new DefaultComboBoxModel<String>(this.u));
        Integer[] integerArray = new Integer[]{10, 12, 14, 16, 18, 20, 22, 24};
        this.r.setModel(new DefaultComboBoxModel<Integer>(integerArray));
        this.t.setModel(new DefaultComboBoxModel<Integer>(integerArray));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("ins 2,fillx", "[]10[]", ""));
        jPanel2.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.72")));
        jPanel2.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.73")), "split 2");
        jPanel2.add(this.q);
        jPanel2.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.74")), "split 2");
        jPanel2.add(this.r);
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("ins 2,fillx", "[]10[]", ""));
        jPanel3.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.71")));
        jPanel3.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.73")), "split 2");
        jPanel3.add(this.s);
        jPanel3.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.74")), "split 2");
        jPanel3.add(this.t);
        jPanel.add((Component)jPanel2, "grow, wrap");
        jPanel.add((Component)jPanel3, "grow");
        return jPanel;
    }

    private JPanel f() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 2,fillx"));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReceiptConfigurationView.9")));
        this.o.setModel(new DefaultComboBoxModel<SimpleColor>(SimpleColor.values()));
        this.v.setModel(new DefaultComboBoxModel<SimpleColor>(SimpleColor.values()));
        this.p.setModel(new DefaultComboBoxModel<SimpleColor>(SimpleColor.values()));
        jPanel.add((Component)new JLabel(Messages.getString("ReceiptConfigurationView.10")), "split 6");
        jPanel.add((Component)this.o, "");
        jPanel.add(new JLabel(Messages.getString("ReceiptConfigurationView.13")));
        jPanel.add((Component)this.p, "");
        jPanel.add(new JLabel(Messages.getString("ReceiptConfigurationView.15")));
        jPanel.add((Component)this.v, "");
        return jPanel;
    }

    private void g() {
        try {
            if (this.k) {
                ReceiptUtil.populateDefaultKitchenReceiptProperties(this.R);
            } else {
                ReceiptUtil.populateDefaultTicketReceiptProperties(this.R);
            }
            this.h();
            this.a = false;
            this.initialize();
            this.save(false);
            if (this.k) {
                this.d(false);
            } else {
                this.c(false);
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(exception.getMessage());
        }
    }

    private void h() {
        if (this.i == null) {
            return;
        }
        String string = this.i.getId();
        try {
            StoreDAO.getInstance().refresh(this.R);
            Map<String, String> map = this.R.getProperties();
            if (!this.k) {
                POSUtil.removeLongProperty(map, string + "." + "ticket.header");
                POSUtil.removeLongProperty(map, string + "." + "ticket.order.info");
                POSUtil.removeLongProperty(map, string + "." + "ticket.footer");
                POSUtil.removeLongProperty(map, string + "." + "ticket.bottom");
                POSUtil.removeLongProperty(map, string + "." + "ticket.order.extrainfo1");
                POSUtil.removeLongProperty(map, string + "." + "ticket.order.extrainfo2");
                this.R.removeProperty(string + "." + "ticket.modifier.color");
                this.R.removeProperty(string + "." + "ticket.seat.color");
                this.R.removeProperty(string + "." + "ticket.instruction.color");
                this.R.removeProperty(string + "." + "receipt.show_tips_suggestion");
                this.R.removeProperty(string + "." + "receipt.show_tips_block");
                this.R.removeProperty(string + "." + "receipt.show_tax_breakdown");
                this.R.removeProperty(string + "." + "showModifierPrice");
                this.R.removeProperty(string + "." + "suppress.zerocost.modifiers");
                POSUtil.removeLongProperty(map, string + "." + "tips_suggestion");
                POSUtil.removeLongProperty(map, string + "." + "ticket.header.logo.show");
            } else {
                POSUtil.removeLongProperty(map, string + "." + "kitchen.header");
                POSUtil.removeLongProperty(map, string + "." + "kitchen.order.info");
                POSUtil.removeLongProperty(map, string + "." + "kitchen.footer");
                POSUtil.removeLongProperty(map, string + "." + "kitchen.order.extrainfo1");
                POSUtil.removeLongProperty(map, string + "." + "kitchen.order.extrainfo2");
                this.R.removeProperty(string + "." + "kitchen_ticket.modifier.color");
                this.R.removeProperty(string + "." + "kitchen_ticket.seat.color");
                this.R.removeProperty(string + "." + "kitchen_ticket.instruction.color");
                this.R.removeProperty(string + "." + "kitchen_receipt.print_translated_name");
                POSUtil.removeLongProperty(map, string + "." + "kitchen.bottom");
                POSUtil.removeLongProperty(map, string + "." + "kitchen.header.logo.show");
            }
            StoreDAO.getInstance().saveOrUpdate(this.R);
            Application.getInstance().refreshStore();
            if (!this.k) {
                this.n();
            } else {
                this.o();
            }
        }
        catch (Exception exception) {
            PosLog.error(ReceiptConfigurationView.class, exception.getMessage(), exception);
        }
    }

    private void i() {
        if (this.l != null && this.O != null) {
            return;
        }
        List<OrderType> list = DataProvider.get().getOrderTypes();
        String string = "w " + PosUIManager.getSize(90);
        if (list == null || list.isEmpty()) {
            this.q();
            return;
        }
        ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
        try {
            this.l = new OrderInfoView(arrayList);
            this.l.setPreferredSize(PosUIManager.getSize(500, 0));
            this.l.setBorder(new EmptyBorder(8, 0, 5, 0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.add((Component)this.l, "East");
        this.l.add(this.r(), "South");
        this.O = new JPanel((LayoutManager)new MigLayout("wrap 1,ins 5 3 5 18", "sg,fill", ""));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiptConfigurationView.this.a(actionEvent);
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        this.i = null;
        this.F = new POSToggleButton(POSConstants.ALL);
        this.F.addActionListener(actionListener);
        OrderType orderType = new OrderType("generic_order");
        this.F.putClientProperty("orderType", orderType);
        buttonGroup.add(this.F);
        this.O.add((Component)this.F, string);
        if (this.i == null) {
            this.i = orderType;
            this.F.setSelected(true);
        }
        for (OrderType orderType2 : list) {
            String string2 = ReceiptUtil.getReceiptSectionByOrderType(this.R, "ticket.header", orderType2.getId());
            POSToggleButton pOSToggleButton = new POSToggleButton("<html><center>" + orderType2.getName() + (string2 != null ? "*" : "") + "</center></html>");
            buttonGroup.add(pOSToggleButton);
            this.O.add((Component)pOSToggleButton, string);
            pOSToggleButton.putClientProperty("orderType", orderType2);
            pOSToggleButton.addActionListener(actionListener);
            if (this.i != null) continue;
            arrayList.add(this.createNewTicket(orderType2, null));
        }
        this.O.add((Component)new JSeparator(), "gaptop 20");
        this.j = new ButtonGroup();
        this.G = new POSToggleButton("<html><center>Guest Check</center></html>");
        this.G.putClientProperty("guestCheck", "cash");
        this.G.addActionListener(actionListener);
        this.j.add(this.G);
        this.O.add((Component)this.G, string);
        this.H = new POSToggleButton("<html><center>Guest Check (Credit Card)</center><html>");
        this.H.putClientProperty("guestCheck", "creditCard");
        this.H.addActionListener(actionListener);
        this.j.add(this.H);
        this.O.add((Component)this.H, string);
        JScrollPane jScrollPane = new JScrollPane(this.O, 20, 31);
        this.l.add((Component)jScrollPane, "East");
        this.c(false);
    }

    private String a(String string, String string2) {
        String string3;
        if (StringUtils.isNotEmpty((String)string)) {
            string = string + ".";
        }
        if (StringUtils.isEmpty((String)(string3 = this.R.getProperty(string + string2)))) {
            string3 = this.R.getProperty(string2);
        }
        return string3;
    }

    private void j() {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        if (this.i != null && this.i.getId() != "generic_order") {
            string6 = this.i.getId();
        }
        if (!this.k) {
            string = ReceiptUtil.getReceiptSection(this.R, "ticket.header", string6);
            string2 = ReceiptUtil.getReceiptSection(this.R, "ticket.order.info", string6);
            string3 = ReceiptUtil.getReceiptSection(this.R, "ticket.order.extrainfo1", string6);
            string4 = ReceiptUtil.getReceiptSection(this.R, "ticket.footer", string6);
            string5 = ReceiptUtil.getReceiptSection(this.R, "ticket.bottom", string6);
            this.T.updateView("ticket.header");
            this.U.updateView("ticket.order.info");
            this.V.updateView("ticket.order.extrainfo1");
            this.W.updateView("ticket.footer");
            this.X.updateView("ticket.bottom");
            this.Y.updateView("ticket.details");
            this.o.setSelectedItem((Object)SimpleColor.getColor(this.a(string6, "ticket.modifier.color")));
            this.p.setSelectedItem((Object)SimpleColor.getColor(this.a(string6, "ticket.seat.color")));
            this.v.setSelectedItem((Object)SimpleColor.getColor(this.a(string6, "ticket.instruction.color")));
            this.w.setSelected(POSUtil.getBoolean(this.R.getProperty("showModifierPrice")));
            this.x.setSelected(POSUtil.getBoolean(this.R.getProperty("suppress.zerocost.modifiers")));
            this.D.setSelected(this.R.isShowQRCodeOnHeader());
            this.E.setSelected(this.R.isShowQRCodeOnFooter());
            this.n.setSelected(ReceiptUtil.getReceiptBooleanProp(this.R, "receipt.show_tips_suggestion", string6));
            this.y.setSelected(ReceiptUtil.getReceiptBooleanProp(this.R, "receipt.show_tips_block", string6));
            this.z.setSelected(ReceiptUtil.getReceiptBooleanProp(this.R, "receipt.show_tax_breakdown", string6));
            this.B.setSelected(ReceiptUtil.getReceiptBooleanProp(this.R, "kitchen_receipt.print_cooking_instruction", string6));
        } else {
            string = ReceiptUtil.getReceiptSection(this.R, "kitchen.header", string6);
            string2 = ReceiptUtil.getReceiptSection(this.R, "kitchen.order.info", string6);
            string3 = ReceiptUtil.getReceiptSection(this.R, "kitchen.order.extrainfo1", string6);
            string4 = ReceiptUtil.getReceiptSection(this.R, "kitchen.footer", string6);
            string5 = ReceiptUtil.getReceiptSection(this.R, "kitchen.bottom", string6);
            this.T.updateView("kitchen.header");
            this.U.updateView("kitchen.order.info");
            this.V.updateView("kitchen.order.extrainfo1");
            this.W.updateView("kitchen.footer");
            this.X.updateView("kitchen.bottom");
            this.Y.updateView("kitchen.details");
            this.o.setSelectedItem((Object)SimpleColor.getColor(this.a(string6, "kitchen_ticket.modifier.color")));
            this.p.setSelectedItem((Object)SimpleColor.getColor(this.a(string6, "kitchen_ticket.seat.color")));
            this.v.setSelectedItem((Object)SimpleColor.getColor(this.a(string6, "kitchen_ticket.instruction.color")));
            boolean bl = this.R.getProperty("kitchen_receipt.print_translated_name") == null ? false : Boolean.valueOf(this.R.getProperty("kitchen_receipt.print_translated_name"));
            this.A.setSelected(bl);
            this.C.setSelected(this.R.isShowGuestNote());
        }
        this.k();
        this.w.setVisible(!this.k && this.i.getId() == "generic_order");
        this.x.setVisible(!this.k && this.i.getId() == "generic_order");
        this.z.setVisible(!this.k);
        this.B.setVisible(!this.k);
        this.n.setVisible(!this.k);
        this.y.setVisible(!this.k);
        this.C.setVisible(this.k);
        this.A.setVisible(this.k);
        string = string.replaceAll("<br>", "\n");
        string2 = string2.replaceAll("<br>", "\n");
        string3 = string3.replaceAll("<br>", "\n");
        string4 = string4.replaceAll("<br>", "\n");
        string5 = string5.replaceAll("<br>", "\n");
        this.b.setText(string);
        this.e.setText(string2);
        this.f.setText(string3);
        this.c.setText(string4);
        this.d.setText(string5);
        this.w();
    }

    private void k() {
        this.D.setVisible(false);
        this.E.setVisible(false);
        QRReceiptPlugin qRReceiptPlugin = (QRReceiptPlugin)ExtensionManager.getPlugin(QRReceiptPlugin.class);
        if (qRReceiptPlugin != null && qRReceiptPlugin.hasValidLicense()) {
            this.D.setVisible(!this.k);
            this.E.setVisible(!this.k);
        }
    }

    private void l() {
        try {
            boolean bl = this.P.getSelectedItem() != null && this.P.getSelectedItem().toString().equals("EscPOS");
            this.b(bl);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void b(boolean bl) {
        this.T.setVisible(bl);
        this.U.setVisible(bl);
        this.V.setVisible(bl);
        this.W.setVisible(bl);
        this.X.setVisible(bl);
        this.Y.setVisible(bl);
    }

    private void m() {
        try {
            this.m = new KitchenReceiptView();
            this.m.setBorder(new EmptyBorder(8, 0, 5, 0));
            this.m.setPreferredSize(PosUIManager.getSize(500, 0));
            this.add((Component)this.m, "East");
            this.m.add(this.r(), "South");
            this.p();
            this.d(false);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    private void n() {
        Component[] componentArray;
        for (Component component : componentArray = this.O.getComponents()) {
            POSToggleButton pOSToggleButton;
            OrderType orderType;
            if (!(component instanceof POSToggleButton) || (orderType = (OrderType)(pOSToggleButton = (POSToggleButton)component).getClientProperty("orderType")) == null || !StringUtils.isNotEmpty((String)orderType.getName())) continue;
            String string = ReceiptUtil.getReceiptSectionByOrderType(this.R, "ticket.header", orderType.getId());
            pOSToggleButton.setText("<html><center>" + orderType.getName() + (string != null ? "*" : "") + "</center></html>");
        }
    }

    private void o() {
        Component[] componentArray;
        for (Component component : componentArray = this.Q.getComponents()) {
            POSToggleButton pOSToggleButton;
            OrderType orderType;
            if (!(component instanceof POSToggleButton) || (orderType = (OrderType)(pOSToggleButton = (POSToggleButton)component).getClientProperty("orderType")) == null) continue;
            String string = ReceiptUtil.getReceiptSectionByOrderType(this.R, "kitchen.header", orderType.getId());
            pOSToggleButton.setText("<html><center>" + orderType.getName() + (string != null ? "*" : "") + "</center></html>");
        }
    }

    private void p() {
        List<OrderType> list = DataProvider.get().getOrderTypes();
        if (list == null || list.isEmpty()) {
            this.q();
            return;
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        this.i = null;
        this.Q = new JPanel((LayoutManager)new MigLayout("wrap 1,ins 5 3 5 18", "sg,fill", ""));
        for (OrderType orderType : list) {
            String string = ReceiptUtil.getReceiptSectionByOrderType(this.R, "kitchen.header", orderType.getId());
            POSToggleButton pOSToggleButton = new POSToggleButton("<html><center>" + orderType.getName() + (string != null ? "*" : "") + "</center></html>");
            buttonGroup.add(pOSToggleButton);
            String string2 = "w " + PosUIManager.getSize(90);
            this.Q.add((Component)pOSToggleButton, string2);
            pOSToggleButton.putClientProperty("orderType", orderType);
            pOSToggleButton.addActionListener(actionEvent -> {
                POSToggleButton pOSToggleButton = (POSToggleButton)actionEvent.getSource();
                OrderType orderType = (OrderType)pOSToggleButton.getClientProperty("orderType");
                if (orderType != null) {
                    this.i = orderType;
                }
                this.j();
                this.d(false);
            });
            if (this.i != null) continue;
            this.i = orderType;
            pOSToggleButton.setSelected(true);
        }
        JScrollPane jScrollPane = new JScrollPane(this.Q, 20, 31);
        this.m.add((Component)jScrollPane, "East");
    }

    private void q() {
        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ReceiptConfigurationView.66"));
        this.removeAll();
    }

    private Component r() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("ins 5 5 0 5"));
        JButton jButton = new JButton(Messages.getString("ReceiptConfigurationView.64"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (ReceiptConfigurationView.this.k) {
                    ReceiptConfigurationView.this.d(false);
                } else {
                    ReceiptConfigurationView.this.c(false);
                }
            }
        });
        JButton jButton2 = new JButton(Messages.getString("ReceiptConfigurationView.65"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReceiptConfigurationView.this.x();
            }
        });
        jPanel.add((Component)jButton, "gapleft 100!,split 2");
        jPanel.add(jButton2);
        return jPanel;
    }

    private void c(boolean bl) {
        try {
            block14: {
                if (bl) {
                    this.save(true);
                }
                if (this.H.isSelected() || this.G.isSelected()) {
                    String string = null;
                    if (this.G.isSelected()) {
                        string = (String)this.G.getClientProperty("guestCheck");
                    } else if (this.H.isSelected()) {
                        string = (String)this.H.getClientProperty("guestCheck");
                    }
                    ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
                    Ticket ticket = this.createNewTicket(this.i, string);
                    arrayList.add(ticket);
                    this.l.setTickets(arrayList);
                    try {
                        this.l.getReportPanel().removeAll();
                        if (string == null) {
                            this.l.createReport();
                            break block14;
                        }
                        this.l.createReport(ticket.getTransactions().iterator().next());
                    }
                    catch (Exception exception) {
                        PosLog.error(ReceiptConfigurationView.class, exception.getMessage());
                    }
                } else {
                    ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
                    Ticket ticket = this.createNewTicket(this.i, null);
                    arrayList.add(ticket);
                    this.l.setTickets(arrayList);
                    try {
                        this.l.getReportPanel().removeAll();
                        this.l.createReport();
                    }
                    catch (Exception exception) {
                        PosLog.error(ReceiptConfigurationView.class, exception.getMessage());
                    }
                }
            }
            this.l.revalidate();
            this.l.repaint();
            this.j();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void d(boolean bl) {
        try {
            if (bl) {
                this.save(true);
            }
            Ticket ticket = this.createNewTicket(this.i, null);
            try {
                this.m.getReportPanel().removeAll();
                this.m.createReport(ticket);
                this.m.revalidate();
                this.m.repaint();
            }
            catch (Exception exception) {}
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    public Ticket createNewTicket(OrderType orderType, String string) {
        Object object;
        Cloneable cloneable;
        SalesArea salesArea;
        int n = 4;
        Date date = null;
        boolean bl = false;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        Double d = 0.0;
        Customer customer = new Customer();
        customer.setFirstName("Firstname");
        customer.setLastName("Lastname");
        customer.setMobileNo("+02............");
        customer.setZipCode("565656");
        customer.setMemberId(Messages.getString("ReceiptConfigurationView.97"));
        customer.setSignatureImageId(Messages.getString("ReceiptConfigurationView.98"));
        customer.setLoyaltyPoint(100);
        if (orderType.isDelivery().booleanValue()) {
            date = new Date();
            string2 = "Customer address.....";
            string3 = Messages.getString("ReceiptConfigurationView.70");
            string4 = "Phone extension..";
            string5 = "Manager instructions..";
            bl = false;
            d = 0.0;
        }
        Application application = Application.getInstance();
        Ticket ticket = new Ticket(true);
        ticket.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        ticket.setOrderType(orderType);
        ticket.setNumberOfGuests(n);
        ticket.setNote("guest note");
        ticket.addExtraProperty("ticket.sub_order_type", POSConstants.FOR_HERE_TO_GO_BUTTON_TEXT);
        if (bl) {
            ticket.setCustomerWillPickup(true);
        } else {
            ticket.setDeliveryDate(date);
            ticket.setDeliveryAddress(string2);
            ticket.setExtraDeliveryInfo(string3);
            ticket.addProperty("PHONE_EXTENSION", string4);
            ticket.addProperty("MANAGER_INSTRUCTION", string5);
            ticket.setDeliveryCharge(d);
            ticket.setCustomerWillPickup(false);
        }
        if (customer != null) {
            ticket.setCustomer(customer);
        }
        Terminal terminal = application.getTerminal();
        ticket.setTerminal(terminal);
        Department department = terminal.getDepartment();
        if (department != null) {
            ticket.setDepartmentId(department.getId());
        }
        if ((salesArea = terminal.getSalesArea()) != null) {
            ticket.setSalesAreaId(salesArea.getId());
        }
        User user = Application.getCurrentUser();
        ticket.setOwner(user);
        ticket.setAssignedDriver(user);
        ticket.setShortId("123");
        ticket.setShift(ShiftUtil.getCurrentShift());
        if (this.i.isShowTableSelection().booleanValue()) {
            cloneable = new ArrayList();
            cloneable.add(1);
            cloneable.add(2);
            ticket.setTableNumbers((List<Integer>)((Object)cloneable));
        }
        cloneable = DateUtil.getServerTimeCalendar();
        ticket.setCreateDate(((Calendar)cloneable).getTime());
        ticket.setCreationHour(((Calendar)cloneable).get(11));
        ticket.addProperty("printCount", String.valueOf(1));
        ticket.addProperty("previewTicket", String.valueOf(Boolean.TRUE));
        ticket.setId(NumericGlobalIdGenerator.generateGlobalId());
        ticket.setTokenNo(1);
        TicketItemTax ticketItemTax = new TicketItemTax();
        ticketItemTax.setId(GlobalIdGenerator.generateGlobalId());
        ticketItemTax.setName(Messages.getString("ReceiptConfigurationView.99"));
        ticketItemTax.setRate(6.0);
        TicketItemTax ticketItemTax2 = new TicketItemTax();
        ticketItemTax2.setId(GlobalIdGenerator.generateGlobalId());
        ticketItemTax2.setName(Messages.getString("ReceiptConfigurationView.100"));
        ticketItemTax2.setRate(15.0);
        for (int i = 0; i < 5; ++i) {
            Comparable comparable;
            Comparable comparable2;
            object = new PreviewTicketItem();
            ((BaseTicketItem)object).setId(NumericGlobalIdGenerator.generateGlobalId());
            ((BaseTicketItem)object).setMenuItemId("0");
            ((BaseTicketItem)object).setName("Item " + (i + 1));
            ((BaseTicketItem)object).setQuantity((double)i + 1.0);
            ((BaseTicketItem)object).setUnitPrice(2.5);
            ((BaseTicketItem)object).setShouldPrintToKitchen(true);
            ((TicketItem)object).setTaxes(Arrays.asList(ticketItemTax, ticketItemTax2));
            if (orderType.isEnableCourse().booleanValue()) {
                comparable2 = new Course(Messages.getString("ReceiptConfigurationView.101") + (i + 1));
                ((BaseCourse)comparable2).setShortName(Messages.getString("ReceiptConfigurationView.101") + (i + 1));
                ((BaseTicketItem)object).setCourseId(Messages.getString("ReceiptConfigurationView.101") + (i + 1));
                ((BaseTicketItem)object).setCourseName(Messages.getString("ReceiptConfigurationView.101") + (i + 1));
            }
            ticket.addToticketItems((TicketItem)object);
            ((BaseTicketItem)object).setTicket(ticket);
            if (i == 1) {
                for (int j = 0; j <= 1; ++j) {
                    comparable = new TicketItemModifier();
                    ((BaseTicketItemModifier)comparable).setId(NumericGlobalIdGenerator.generateGlobalId());
                    ((BaseTicketItemModifier)comparable).setItemId("0");
                    ((BaseTicketItemModifier)comparable).setGroupId("0");
                    ((BaseTicketItemModifier)comparable).setItemQuantity(2.0);
                    ((BaseTicketItemModifier)comparable).setName("Modifier " + (j + 1));
                    ((BaseTicketItemModifier)comparable).setUnitPrice(1.5);
                    ((BaseTicketItemModifier)comparable).setShouldPrintToKitchen(true);
                    ((BaseTicketItemModifier)comparable).setTicketItem((TicketItem)object);
                    ((BaseModifiableTicketItem)object).addToticketItemModifiers((TicketItemModifier)comparable);
                }
            } else if (i == 2) {
                comparable2 = new TicketItemCookingInstruction();
                ((BaseTicketItemCookingInstruction)comparable2).setDescription("Fry (Cooking Ins.)");
                ((TicketItem)object).addCookingInstruction((TicketItemCookingInstruction)comparable2);
            }
            if (i == 2) {
                TicketItem ticketItem = new TicketItem();
                comparable = new TicketItemSeat();
                ticketItem.setName("Seat** 1");
                ticketItem.setShouldPrintToKitchen(true);
                ticketItem.setTreatAsSeat(true);
                ticketItem.setSeatNumber(1);
                ticketItem.setPrintedToKitchen(false);
                ticketItem.setShouldPrintToKitchen(true);
                ticketItem.setSeat((TicketItemSeat)comparable);
                ticketItem.setTicket(ticket);
                ((BaseTicketItemSeat)comparable).setSeatNumber(1);
                ticket.addToticketItems(ticketItem);
                continue;
            }
            if (i != 3) continue;
            TicketItem ticketItem = new TicketItem();
            comparable = new TicketItemSeat();
            ticketItem.setName("Seat** Shared");
            ticketItem.setShouldPrintToKitchen(true);
            ticketItem.setTreatAsSeat(true);
            ticketItem.setSeatNumber(null);
            ticketItem.setPrintedToKitchen(false);
            ticketItem.setShouldPrintToKitchen(true);
            ticketItem.setSeat((TicketItemSeat)comparable);
            ticketItem.setTicket(ticket);
            ((BaseTicketItemSeat)comparable).setSeatNumber(1);
            ticket.addToticketItems(ticketItem);
        }
        ticket.calculatePrice();
        PosTransaction posTransaction = null;
        object = null;
        if (string != null && string.equals("creditCard")) {
            object = PaymentType.CREDIT_CARD;
            posTransaction = ((PaymentType)((Object)object)).createTransaction();
            posTransaction.setCaptured(false);
            posTransaction.setCardMerchantGateway("Payment gateway name..");
            posTransaction.setCardReader(CardReader.MANUAL.name());
            posTransaction.setCardHolderName("Card holder name");
            posTransaction.setCardNumber("4111111111111111");
            posTransaction.setCardExpMonth("12");
            posTransaction.setCardExpYear("2020");
            posTransaction.setCardType(CardTypeEnum.VISA.name());
            posTransaction.setCardAuthCode("00000");
            posTransaction.setTransactionType(TransactionType.CREDIT.name());
            ticket.setCashier(user);
        } else {
            object = PaymentType.CASH;
            posTransaction = ((PaymentType)((Object)object)).createTransaction();
        }
        posTransaction.setLoyaltyEarnedForPurchase(5);
        posTransaction.setLoyaltyChargedAmount(3);
        posTransaction.setTenderAmount(ticket.getDueAmount());
        posTransaction.setAmount(ticket.getDueAmount());
        posTransaction.setTicket(ticket);
        ticket.addTotransactions(posTransaction);
        ticket.setVoided(false);
        ticket.setTerminal(terminal);
        ticket.setPaidAmount(NumberUtil.round(ticket.getPaidAmount() + posTransaction.getAmount()));
        ticket.calculatePrice();
        Date date2 = new Date();
        if (ticket.getDueAmount() == 0.0) {
            ticket.setPaid(true);
        } else {
            ticket.setPaid(false);
            ticket.setClosed(false);
        }
        posTransaction.setTerminal(terminal);
        posTransaction.setUser(user);
        posTransaction.setServer(user);
        posTransaction.setTransactionTime(date2);
        return ticket;
    }

    private void s() {
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        JTextComponent jTextComponent = null;
        if (!(component instanceof JTextComponent)) {
            return;
        }
        jTextComponent = (JTextComponent)component;
        ReceiptParam receiptParam = this.h.getSelectedValue();
        if (receiptParam == null) {
            return;
        }
        String string = "<" + receiptParam.getParamName() + ">$" + receiptParam.getParamName() + "</" + receiptParam.getParamName() + ">";
        jTextComponent.replaceSelection(string);
    }

    @Override
    public void refresh() {
        DataProvider.get().refreshStore();
        OutletDAO.getInstance().refresh(DataProvider.get().getOutlet());
        DataProvider.get().refreshCurrentTerminal();
        this.R = DataProvider.get().getStore();
        this.S = DataProvider.get().getCurrentTerminal();
        this.a();
    }

    private void a(ActionEvent actionEvent) {
        try {
            String string;
            POSToggleButton pOSToggleButton = (POSToggleButton)actionEvent.getSource();
            OrderType orderType = (OrderType)pOSToggleButton.getClientProperty("orderType");
            if (orderType != null) {
                this.i = orderType;
            }
            if (StringUtils.isEmpty((String)(string = (String)pOSToggleButton.getClientProperty("guestCheck")))) {
                string = null;
                this.j.clearSelection();
            }
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            Ticket ticket = this.createNewTicket(this.i, string);
            arrayList.add(ticket);
            this.j();
            this.l.setTickets(arrayList);
            this.l.getReportPanel().removeAll();
            if (string == null) {
                this.l.createReport();
            } else {
                this.l.createReport(ticket.getTransactions().iterator().next());
            }
            this.l.revalidate();
            this.l.repaint();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void t() {
        try {
            TipsSuggestionDialog tipsSuggestionDialog = new TipsSuggestionDialog(Messages.getString("AddTips"), this.a((TipSuggestion)null));
            tipsSuggestionDialog.setSize(PosUIManager.getSize(400, 250));
            tipsSuggestionDialog.open();
            if (tipsSuggestionDialog.isCanceled()) {
                return;
            }
            ArrayList<TipSuggestion> arrayList = new ArrayList<TipSuggestion>();
            for (int i = 0; i < this.g.getModel().getSize(); ++i) {
                arrayList.add(this.g.getModel().getElementAt(i));
            }
            arrayList.add(tipsSuggestionDialog.getTipSuggestion());
            Collections.sort(arrayList, (tipSuggestion, tipSuggestion2) -> tipSuggestion.getSortOrder() - tipSuggestion2.getSortOrder());
            this.a(arrayList);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private List<Double> a(TipSuggestion tipSuggestion) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < this.g.getModel().getSize(); ++i) {
            TipSuggestion tipSuggestion2 = this.g.getModel().getElementAt(i);
            if (tipSuggestion != null && tipSuggestion.getPercentage() == tipSuggestion2.getPercentage()) continue;
            arrayList.add(tipSuggestion2.getPercentage());
        }
        return arrayList;
    }

    private void u() {
        try {
            TipSuggestion tipSuggestion3 = this.g.getSelectedValue();
            if (tipSuggestion3 == null) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectTipSuggestion"));
                return;
            }
            TipsSuggestionDialog tipsSuggestionDialog = new TipsSuggestionDialog(Messages.getString("EditTips"), this.a(tipSuggestion3));
            tipsSuggestionDialog.setTipsPercentage(tipSuggestion3.getPercentage());
            tipsSuggestionDialog.setTipsSortOrder(tipSuggestion3.getSortOrder());
            tipsSuggestionDialog.setSize(PosUIManager.getSize(400, 250));
            tipsSuggestionDialog.open();
            if (tipsSuggestionDialog.isCanceled()) {
                return;
            }
            int n = this.g.getSelectedIndex();
            ArrayList<TipSuggestion> arrayList = new ArrayList<TipSuggestion>();
            for (int i = 0; i < this.g.getModel().getSize(); ++i) {
                arrayList.add(this.g.getModel().getElementAt(i));
            }
            arrayList.remove(n);
            arrayList.add(n, tipsSuggestionDialog.getTipSuggestion());
            Collections.sort(arrayList, (tipSuggestion, tipSuggestion2) -> tipSuggestion.getSortOrder() - tipSuggestion2.getSortOrder());
            this.a(arrayList);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void v() {
        try {
            int n = this.g.getSelectedIndex();
            if (n == -1) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectTipSuggestion"));
                return;
            }
            ArrayList<TipSuggestion> arrayList = new ArrayList<TipSuggestion>();
            for (int i = 0; i < this.g.getModel().getSize(); ++i) {
                arrayList.add(this.g.getModel().getElementAt(i));
            }
            arrayList.remove(n);
            this.a(arrayList);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private void a(List<TipSuggestion> list) {
        ListModel<TipSuggestion> listModel = new ListModel<TipSuggestion>(list);
        this.g.setModel(listModel);
        this.g.revalidate();
        this.g.repaint();
    }

    private void w() throws JSONException, JsonSyntaxException {
        if (this.i != null) {
            String string = ReceiptUtil.getReceiptSection(this.R, "tips_suggestion", this.i.getId());
            if (string == null) {
                string = "[{\"percentage\":25,\"sortOrder\":1},{\"percentage\":20,\"sortOrder\":2},{\"percentage\":18,\"sortOrder\":3},{\"percentage\":15,\"sortOrder\":4}]";
            }
            JSONArray jSONArray = new JSONArray(string);
            GsonBuilder gsonBuilder = new GsonBuilder();
            Gson gson = gsonBuilder.create();
            ArrayList<TipSuggestion> arrayList = new ArrayList<TipSuggestion>();
            for (int i = 0; i < jSONArray.length(); ++i) {
                Object object = jSONArray.get(i);
                if (object == null) continue;
                arrayList.add((TipSuggestion)gson.fromJson(object.toString(), TipSuggestion.class));
            }
            Collections.sort(arrayList, (tipSuggestion, tipSuggestion2) -> tipSuggestion.getSortOrder() - tipSuggestion2.getSortOrder());
            this.a(arrayList);
        }
    }

    private void x() {
        try {
            this.save(false);
            if (this.k && ReceiptPrintService.hasNoKitchenReceiptPrinters() || !this.k && ReceiptPrintService.hasNoReceiptPrinters()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NoPrinterIsConfigured"));
                return;
            }
            if (this.k) {
                this.m.print();
            } else {
                ReceiptPrintService.printTestTicket(this.l.getTickets().get(0));
            }
        }
        catch (PrintException printException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), printException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    static class PreviewTicketItem
    extends ModifiableTicketItem {
        private static final long b = 1L;

        @Override
        public List<Printer> getPrinters(OrderType orderType) {
            PrinterGroup printerGroup = this.getPrinterGroup();
            ArrayList<Printer> arrayList = new ArrayList<Printer>();
            arrayList.add(VirtualPrinter.getKdsPrinter());
            PosPrinters posPrinters = DataProvider.get().getPrinters();
            arrayList.addAll(posPrinters.getStickerPrinters());
            if (printerGroup == null) {
                arrayList.addAll(posPrinters.getKitchenPrinters());
                return arrayList;
            }
            List<String> list = printerGroup.getPrinterNames();
            List<Printer> list2 = posPrinters.getKitchenPrinters();
            for (Printer printer : list2) {
                if (!list.contains(printer.getVirtualPrinter().getName())) continue;
                arrayList.add(printer);
            }
            return arrayList;
        }
    }

    static enum SimpleColor {
        black(Color.black),
        red(Color.red);

        final Color a;

        private SimpleColor(Color color) {
            this.a = color;
        }

        public static SimpleColor getColor(String string) {
            Color color = SimpleColor.getAwtColor(string);
            if (color != null) {
                for (SimpleColor simpleColor : SimpleColor.values()) {
                    if (simpleColor.a.getRGB() != color.getRGB()) continue;
                    return simpleColor;
                }
            }
            return black;
        }

        public static Color getAwtColor(String string) {
            try {
                return Color.decode(string);
            }
            catch (Exception exception) {
                return Color.black;
            }
        }

        static String[] a() {
            List<SimpleColor> list = Arrays.asList(SimpleColor.values());
            String string = list.toString().replaceAll(" ", "");
            return string.substring(1, string.length() - 1).split(",");
        }
    }

    public class KitchenReceiptView
    extends JPanel {
        private JPanel b;
        private Ticket c;

        public KitchenReceiptView() {
            this.createUI();
        }

        public void createUI() {
            this.b = new JPanel((LayoutManager)new MigLayout("wrap 1, ax 50%", "", ""));
            PosScrollPane posScrollPane = new PosScrollPane(this.b);
            posScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            this.setLayout(new BorderLayout());
            this.add(posScrollPane);
        }

        public void createReport(Ticket ticket) throws Exception {
            this.c = ticket;
            try {
                ReceiptPrintService.getKitchenReceiptPrintPreviewService().rendererKitchenReceipt(ticket, this.b);
            }
            catch (Exception exception) {
                POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
            }
        }

        public void print() throws Exception {
            ReceiptPrintService.printToKitchen(this.c, false, false);
        }

        public JPanel getReportPanel() {
            return this.b;
        }
    }

    private class FontPropertiesPanel
    extends JPanel {
        private static final String b = "48";
        private static final String c = "01";
        public static final String FONT_TYPE_A = "Font A";
        public static final String FONT_TYPE_B = "Font B";
        private JCheckBox d;
        private JComboBox<Object> e;
        private JComboBox<String> f;
        private FixedLengthTextField g;

        public FontPropertiesPanel() {
            this.setLayout((LayoutManager)new MigLayout("center,ins 0 0 3 0"));
            this.d = new JCheckBox(Messages.getString("FontBold"));
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("");
            for (int i = 10; i <= 39; ++i) {
                arrayList.add(String.format("%02d", i));
            }
            this.e = new JComboBox<Object>(arrayList.toArray());
            this.f = new JComboBox<String>(new String[]{"", FONT_TYPE_A, FONT_TYPE_B});
            this.g = new FixedLengthTextField();
            this.g.setLength(2);
            this.add(this.d);
            this.add((Component)new JLabel(Messages.getString("FontSize")), "gapleft 10!");
            this.add(this.e, "w 50!");
            this.add(new JLabel(Messages.getString("Type")));
            this.add(this.f);
            this.add((Component)this.g, "w 50!");
            this.f.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                this.a();
            });
        }

        public void updateView(String string) {
            try {
                this.d.setSelected(ReceiptConfigurationView.this.R.getBooleanProperty(string + ".font-weight", false));
                String string2 = ReceiptConfigurationView.this.R.getProperty(string + ".font-size", "");
                if (StringUtils.isEmpty((String)string2)) {
                    this.e.setSelectedIndex(0);
                } else {
                    this.e.setSelectedItem(string2);
                }
                String string3 = ReceiptConfigurationView.this.R.getProperty(string + ".font-type", "");
                if (StringUtils.isEmpty((String)string3)) {
                    this.f.setSelectedIndex(0);
                } else {
                    this.f.setSelectedItem(this.a(string3));
                }
                this.g.setText(string3);
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }

        public void updateModel(String string) {
            try {
                ReceiptConfigurationView.this.R.addProperty(string + ".font-weight", String.valueOf(this.d.isSelected()));
                ReceiptConfigurationView.this.R.addProperty(string + ".font-size", this.e.getSelectedItem() == null ? "" : this.e.getSelectedItem().toString());
                ReceiptConfigurationView.this.R.addProperty(string + ".font-type", this.g.getText());
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }

        private void a() {
            try {
                if (this.f.getSelectedItem() == null || StringUtils.isBlank((String)this.f.getSelectedItem().toString())) {
                    this.g.setText("");
                    return;
                }
                this.g.setText(this.b());
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }

        private String b() {
            Object object = this.f.getSelectedItem();
            if (object == null) {
                return "";
            }
            switch (object.toString()) {
                case "Font B": {
                    return c;
                }
                case "Font A": {
                    return b;
                }
            }
            return "";
        }

        private String a(String string) {
            if (string == null) {
                return "";
            }
            if (b.equalsIgnoreCase(string)) {
                return FONT_TYPE_A;
            }
            if (c.equalsIgnoreCase(string)) {
                return FONT_TYPE_B;
            }
            return "";
        }
    }
}

