/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.customer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.CustomerCsvExportAction;
import com.floreantpos.actions.CustomerCsvImportAction;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.customer.CustomerHistoryDialog;
import com.floreantpos.model.ClubMemberType;
import com.floreantpos.model.Customer;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.CustomerForm;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import com.floreantpos.util.ProfileUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class CustomerExplorer
extends TransparentPanel {
    private JTable a;
    private BeanTableModel<Customer> b;
    private JButton c;
    private JButton d;
    private JLabel e;
    private JTextField f;
    private JComboBox<ClubMemberType> g;

    public CustomerExplorer() {
        this.a();
        this.updateCustomer();
    }

    public void updateCustomer() {
        String string = this.f.getText();
        ClubMemberType clubMemberType = (ClubMemberType)((Object)this.g.getSelectedItem());
        CustomerDAO.getInstance().findByPhoneOrName(string, this.b, Boolean.TRUE, Boolean.TRUE, ClubMemberType.isAffiliate(clubMemberType));
        int n = this.b.getCurrentRowIndex() + 1;
        int n2 = this.b.getNextRowIndex();
        int n3 = this.b.getNumRows();
        if (n2 > n3) {
            n2 = n3;
        }
        this.e.setText(String.format(Messages.getString("CustomerExplorer.0"), n, n2, n3));
        this.c.setEnabled(this.b.hasPrevious());
        this.d.setEnabled(this.b.hasNext());
    }

    private void a() {
        this.b = new BeanTableModel(Customer.class, 50);
        this.b.addColumn(Messages.getString("CustomerExplorer.1"), Customer.PROP_NAME);
        this.b.addColumn(Messages.getString("CustomerExplorer.6"), Customer.PROP_MEMBER_ID);
        this.b.addColumn(Messages.getString("CustomerExplorer.3"), "mobileNo");
        this.b.addColumn(Messages.getString("CustomerExplorer.5"), "email");
        this.b.addColumn(Messages.getString("CustomerExplorer.7"), "address");
        this.b.addColumn(Messages.getString("CustomerExplorer.13"), "balance", 11, BeanTableModel.DataType.MONEY);
        this.b.addColumn(Messages.getString("CustomerExplorer.17"), Customer.PROP_LOYALTY_POINT, 11, BeanTableModel.DataType.NUMBER);
        this.b.addColumn(Messages.getString("CustomerExplorer.8"), Customer.PROP_ACTIVE);
        this.a = new JTable(this.b);
        this.b.initTableRenderer(this.a);
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.a.setDefaultRenderer(Object.class, new PosTableRenderer());
        PosGuiUtil.setColumnWidth(this.a, 0, 140);
        PosGuiUtil.setColumnWidth(this.a, 1, 100);
        PosGuiUtil.setColumnWidth(this.a, 2, 140);
        PosGuiUtil.setColumnWidth(this.a, 3, 120);
        PosGuiUtil.setColumnWidth(this.a, 4, 140);
        PosGuiUtil.setColumnWidth(this.a, 5, 35);
        PosGuiUtil.setColumnWidth(this.a, 6, 100);
        PosGuiUtil.setColumnWidth(this.a, 7, 30);
        this.setLayout(new BorderLayout(5, 0));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,hidemode 3, ins 10"));
        JLabel jLabel = new JLabel(Messages.getString("NameOrEmailOrCellOrLoyalty"));
        this.f = new JTextField(20);
        this.f.addActionListener(actionEvent -> this.updateCustomer());
        JLabel jLabel2 = new JLabel(Messages.getString("CustomerExplorer.25"));
        this.g = new JComboBox<ClubMemberType>(ClubMemberType.values());
        JButton jButton = new JButton(Messages.getString("Search"));
        jButton.addActionListener(actionEvent -> this.updateCustomer());
        JButton jButton2 = new JButton(Messages.getString("CustomerExplorer.26"));
        jButton2.addActionListener(actionEvent -> {
            this.f.setText("");
            this.updateCustomer();
        });
        this.g.addActionListener(actionEvent -> this.updateCustomer());
        jPanel.add((Component)jLabel, "split 6");
        jPanel.add(this.f);
        jPanel.add(jLabel2);
        jPanel.add(this.g);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.add((Component)jPanel, "North");
        this.add((Component)new JScrollPane(this.a), "Center");
        JButton jButton3 = new JButton(POSConstants.ADD);
        jButton3.addActionListener(actionEvent -> this.c());
        JButton jButton4 = new JButton(POSConstants.EDIT);
        jButton4.addActionListener(actionEvent -> this.d());
        JButton jButton5 = new JButton(POSConstants.DELETE);
        jButton5.addActionListener(actionEvent -> this.e());
        JButton jButton6 = new JButton(Messages.getString("CustomerExplorer.2"));
        jButton6.addActionListener(actionEvent -> this.b());
        this.c = new JButton(Messages.getString("CustomerExplorer.30"));
        this.d = new JButton(Messages.getString("CustomerExplorer.31"));
        this.e = new JLabel();
        this.c.addActionListener(actionEvent -> {
            this.b.setCurrentRowIndex(this.b.getPreviousRowIndex());
            this.updateCustomer();
        });
        this.d.addActionListener(actionEvent -> {
            this.b.setCurrentRowIndex(this.b.getNextRowIndex());
            this.updateCustomer();
        });
        JButton jButton7 = new JButton(Messages.getString("CustomerExplorer.10"));
        jButton7.setAction(new CustomerCsvExportAction());
        JButton jButton8 = new JButton(Messages.getString("CustomerExplorer.20"));
        jButton8.setAction(new CustomerCsvImportAction(this));
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("fillx"));
        transparentPanel.add((Component)jButton3, "right, split 5");
        transparentPanel.add(jButton4);
        transparentPanel.add(jButton5);
        transparentPanel.add(jButton6);
        transparentPanel.add(jButton7);
        transparentPanel.add(jButton8);
        transparentPanel.add((Component)this.e, "right, split 3");
        transparentPanel.add(this.c);
        transparentPanel.add(this.d);
        this.add((Component)transparentPanel, "South");
        boolean bl = ProfileUtil.shouldDisplayClubposSfControls();
        jLabel2.setVisible(bl);
        this.g.setVisible(bl);
    }

    private void b() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CustomerExplorer.4"));
            return;
        }
        Customer customer = this.b.getRow(n);
        if (customer != null) {
            CustomerHistoryDialog customerHistoryDialog = new CustomerHistoryDialog(customer.getId(), (boolean)Boolean.FALSE);
            customerHistoryDialog.openUndecoratedFullScreen();
        }
    }

    private void c() {
        try {
            boolean bl = true;
            CustomerForm customerForm = new CustomerForm(bl);
            customerForm.enableCustomerFields(true);
            Window window = SwingUtilities.getWindowAncestor(this);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog(window, (BeanEditor)customerForm);
            beanEditorDialog.setPreferredSize(PosUIManager.getSize(920, 700));
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            Customer customer = (Customer)customerForm.getBean();
            this.b.addRow(0, customer);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void d() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("UserTypeExplorer.0"));
                return;
            }
            Customer customer = CustomerDAO.getInstance().get(this.b.getRow(n).getId());
            boolean bl = true;
            CustomerForm customerForm = new CustomerForm(bl);
            customerForm.enableCustomerFields(true);
            customerForm.setBean(customer);
            Window window = SwingUtilities.getWindowAncestor(this);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog(window, (BeanEditor)customerForm);
            beanEditorDialog.setPreferredSize(PosUIManager.getSize(920, 700));
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.a.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void e() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("UserTypeExplorer.1"));
                return;
            }
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                Customer customer = this.b.getRow(n);
                CustomerDAO customerDAO = CustomerDAO.getInstance();
                if (StringUtils.isNotBlank((String)customer.getId())) {
                    customerDAO.delete(customer.getId());
                }
                this.b.removeRow(customer);
                this.updateCustomer();
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

