/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.ui.ConfigurationSubEditor;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.main.PosWindow;
import com.floreantpos.main.update.UpdateManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.util.POSUtil;
import com.orocube.common.about.dialog.OroCommonLicenceActivationDialog;
import com.orocube.common.util.ProductInfo;
import com.orocube.common.util.TerminalUtil;
import com.orocube.licensemanager.InvalidLicenseException;
import com.orocube.licensemanager.LicenseExpiredException;
import com.orocube.licensemanager.LicenseMode;
import com.orocube.licensemanager.LicenseNotFoundException;
import com.orocube.licensemanager.LicenseUtil;
import com.orocube.licensemanager.OroLicense;
import com.orocube.licensemanager.ui.InvalidPluginDialog;
import com.orocube.licensemanager.ui.LicenseSelectionListener;
import com.orocube.licensemanager.ui.PluginsDialog;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.SwingWorker;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractFloreantPlugin
implements FloreantPlugin,
ProductInfo,
LicenseSelectionListener {
    private OroLicense a;

    @Override
    public boolean requireLicense() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initLicense() {
        String string = this.getProductName();
        String string2 = this.getProductVersion();
        String string3 = TerminalUtil.getSystemUID();
        try {
            this.a = LicenseUtil.loadAndValidate((String)this.getId(), (String)string, (String)string2, (String)string3);
        }
        catch (LicenseExpiredException licenseExpiredException) {
            this.a = licenseExpiredException.getLicense();
            this.a((InvalidLicenseException)licenseExpiredException);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception.getMessage());
        }
        finally {
            if (this.a == null) {
                this.b(string, string2);
            }
        }
    }

    private void a(InvalidLicenseException invalidLicenseException) {
        final OroLicense oroLicense = invalidLicenseException.getLicense();
        if (oroLicense == null) {
            return;
        }
        final BusyDialog busyDialog = new BusyDialog();
        busyDialog.setCaption(Messages.getString("CheckingLicenseFor") + " " + this.getDisplayName());
        SwingWorker<Void, Void> swingWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                try {
                    AbstractFloreantPlugin.this.a = OroCommonLicenceActivationDialog.loadAndValidateOnlineLicense((OroLicense)oroLicense);
                }
                catch (Exception exception) {
                    PosLog.error(this.getClass(), exception.getMessage());
                }
                return null;
            }

            @Override
            protected void done() {
                busyDialog.dispose();
            }
        };
        swingWorker.execute();
        busyDialog.open();
    }

    public static void promptToActivatePluginsIfNeeded(List<AbstractFloreantPlugin> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        if (AbstractFloreantPlugin.a(list)) {
            for (AbstractFloreantPlugin abstractFloreantPlugin : list) {
                if (abstractFloreantPlugin.getLicense() != null && abstractFloreantPlugin.getLicense().isValid() && abstractFloreantPlugin.isActivated() || abstractFloreantPlugin.getLicense() != null) continue;
                abstractFloreantPlugin.a(abstractFloreantPlugin.getProductName(), abstractFloreantPlugin.getProductVersion());
            }
        } else {
            AbstractFloreantPlugin.openPluginsActivationDialog(list, false);
        }
    }

    private static boolean a(List<AbstractFloreantPlugin> list) {
        boolean bl = true;
        for (FloreantPlugin floreantPlugin : list) {
            if (AppConfig.getBoolean(floreantPlugin.getProductName() + ".invalid.license.do_not_prompt", false)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    public static void openPluginsActivationDialog(List<AbstractFloreantPlugin> list, boolean bl) {
        Window window = POSUtil.getFocusedWindow();
        PluginsDialog pluginsDialog = new PluginsDialog(list, window, TerminalUtil.getSystemUID());
        pluginsDialog.setDoNotPromtCheckBoxValue(AbstractFloreantPlugin.a(list));
        if (bl) {
            pluginsDialog.setCancelButtonText(POSConstants.CANCEL_BUTTON_TEXT);
            pluginsDialog.setCaption("Available plugins");
        }
        pluginsDialog.setVisible(true);
        String string = ".invalid.license.do_not_prompt";
        boolean bl2 = pluginsDialog.isDoNotPromptAgain();
        for (AbstractFloreantPlugin abstractFloreantPlugin : list) {
            AppConfig.put(abstractFloreantPlugin.getProductName() + string, bl2);
            if (abstractFloreantPlugin.getLicense() != null && abstractFloreantPlugin.getLicense().isValid() && abstractFloreantPlugin.isActivated() || !bl2 || abstractFloreantPlugin.getLicense() != null) continue;
            abstractFloreantPlugin.a(abstractFloreantPlugin.getProductName(), abstractFloreantPlugin.getProductVersion());
        }
    }

    private void a(String string, String string2, String string3) {
        String string4 = string + ".activation.do_not_prompt";
        boolean bl = AppConfig.getBoolean(string4, false);
        if (bl) {
            this.a(string, string2);
        } else {
            String string5 = "License for " + string + " not found. Please select a license to activate " + string + ".";
            String string6 = "Plugin license not found";
            Window window = POSUtil.getFocusedWindow();
            InvalidPluginDialog invalidPluginDialog = new InvalidPluginDialog(this, window, string5, string6, string, string2, string3);
            invalidPluginDialog.setVisible(true);
            if (invalidPluginDialog.isCanceled() && invalidPluginDialog.isDoNotPromptAgain()) {
                AppConfig.put(string4, true);
                this.a(string, string2);
            }
        }
    }

    private void b(String string, String string2, String string3) {
        String string4 = string + ".invalid.license.do_not_prompt";
        boolean bl = AppConfig.getBoolean(string4, false);
        if (bl) {
            this.b(string, string2);
        } else {
            String string5 = "License for " + string + " is invalid. Please select a valid license to activate " + string + ".";
            String string6 = "Invalid license";
            Window window = POSUtil.getFocusedWindow();
            InvalidPluginDialog invalidPluginDialog = new InvalidPluginDialog(this, window, string5, string6, string, string2, string3);
            invalidPluginDialog.setVisible(true);
            if (invalidPluginDialog.isCanceled() && invalidPluginDialog.isDoNotPromptAgain()) {
                AppConfig.put(string4, true);
                this.b(string, string2);
            }
        }
    }

    private void a(String string, String string2) {
        if (this.isEmbedded()) {
            this.a = new OroLicense();
            this.a.setProductName(string);
            this.a.setProductVersion(string2);
            this.a.setLicenseMode(LicenseMode.UNINILIZED);
            this.a.setValid(true);
        }
    }

    private void b(String string, String string2) {
        if (this.isEmbedded()) {
            this.a = new OroLicense();
            this.a.setProductName(string);
            this.a.setProductVersion(string2);
            this.a.setLicenseMode(LicenseMode.UNINILIZED);
            this.a.setValid(false);
        }
    }

    private void a() {
        String string = this.getProductName();
        String string2 = this.getProductVersion();
        String string3 = TerminalUtil.getOldSystemUID();
        try {
            this.a = LicenseUtil.loadAndValidate((String)this.getId(), (String)string, (String)string2, (String)string3);
        }
        catch (LicenseNotFoundException licenseNotFoundException) {
            this.a(string, string2, string3);
        }
        catch (InvalidLicenseException invalidLicenseException) {
            this.b(string, string2, string3);
        }
        catch (Exception exception) {
            LogFactory.getLog(this.getClass()).error((Object)exception);
        }
    }

    public void checkForUpdate() {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        if (!this.isUpdateAvailable()) {
            POSMessageDialog.showMessage(backOfficeWindow, Messages.getString("AbstractFloreantPlugin.2"));
            return;
        }
        String string = this.getProductName();
        String string2 = this.getProductVersion();
        Integer n = this.getProductNumericVersion();
        if (n == null) {
            return;
        }
        String string3 = this.getUpdateServerURL();
        UpdateManager updateManager = new UpdateManager();
        updateManager.setParentWindow(backOfficeWindow == null ? Application.getPosWindow() : backOfficeWindow);
        updateManager.checkForPluginUpdate(string3, string, string2, n);
    }

    public boolean isUpdateAvailable() {
        String string = this.getProductName();
        String string2 = this.getProductVersion();
        Integer n = this.getProductNumericVersion();
        if (n == null) {
            return false;
        }
        String string3 = this.getUpdateServerURL();
        UpdateManager updateManager = new UpdateManager();
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        updateManager.setParentWindow(backOfficeWindow == null ? Application.getPosWindow() : backOfficeWindow);
        return updateManager.isUpdateAvailable(string3, string, string2, n);
    }

    @Override
    public abstract String getId();

    @Override
    public abstract String getProductName();

    public abstract String getProductVersion();

    public abstract Integer getProductNumericVersion();

    public abstract Component getParent();

    public abstract String getUpdateServerURL();

    @Override
    public void licenseFileSelected(File file) throws Exception {
        try {
            OroLicense oroLicense = LicenseUtil.loadAndValidate((File)file, (String)this.getId(), (String)this.getProductName(), (String)this.getProductVersion(), (String)TerminalUtil.getSystemUID());
            LicenseUtil.copyLicenseFile((File)file, (String)this.getProductName());
            this.setLicense(oroLicense);
        }
        catch (Exception exception) {
            LogFactory.getLog(this.getClass()).error((Object)exception);
            throw exception;
        }
    }

    @Override
    public boolean hasValidLicense() {
        if (this.a != null) {
            if (this.a.isDemoLicense()) {
                return this.a.isValid() && this.a.isPinVarified();
            }
            return this.a.isValid();
        }
        return false;
    }

    @Override
    public OroLicense getLicense() {
        return this.a;
    }

    @Override
    public void setLicense(OroLicense oroLicense) {
        this.a = oroLicense;
    }

    @Override
    public boolean isActivated() {
        return this.getLicense() != null && this.getLicense().getLicenseMode() != LicenseMode.UNINILIZED;
    }

    @Override
    public void initBackoffice(BackOfficeWindow backOfficeWindow) {
    }

    @Override
    public void initConfigurationView(JDialog jDialog) {
    }

    @Override
    public List<AbstractAction> getSpecialFunctionActions() {
        return null;
    }

    @Override
    public List<ConfigurationSubEditor> getSubEditors() {
        return null;
    }

    @Override
    public void initUI(PosWindow posWindow) {
    }

    @Override
    public void restartPOS(boolean bl) {
    }

    public String getDisplayName() {
        try {
            if (this.getLicense() != null && StringUtils.isNotBlank((String)this.getLicense().getDisplayName())) {
                return this.getLicense().getDisplayName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getProductName();
    }
}

