/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.extension;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.extension.AbstractFloreantPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.main.Main;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.floreantpos.webservice.CloudSyncAction;
import com.floreantpos.webservice.CloudSyncSettingAction;
import com.floreantpos.webservice.PosWebService;
import com.orocube.common.about.AboutPluginAction;
import com.orocube.common.util.ProductInfo;
import com.orocube.common.util.TerminalUtil;
import com.orocube.licensemanager.LicenseMode;
import com.orocube.licensemanager.LicenseUtil;
import com.orocube.licensemanager.OroLicense;
import com.orocube.licensemanager.ui.LicenseSelectionListener;
import java.awt.Component;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import net.xeoh.plugins.base.annotations.PluginImplementation;

@PluginImplementation
public class CloudSyncPlugin
extends AbstractFloreantPlugin
implements ProductInfo {
    private static final String a = "Cloud Sync";

    public String getDescription() {
        return Messages.getString("CloudSync.description");
    }

    @Override
    public void initLicense() {
        String string = this.getProductName();
        String string2 = this.getProductVersion();
        try {
            String string3 = TerminalUtil.getSystemUID();
            super.setLicense(LicenseUtil.loadAndValidate((String)this.getId(), (String)string, (String)string2, (String)string3));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public OroLicense getLicense() {
        String string = this.getProductName();
        String string2 = this.getProductVersion();
        OroLicense oroLicense = super.getLicense();
        if (oroLicense == null && this.isEmbedded()) {
            oroLicense = new OroLicense();
            oroLicense.setProductName(string);
            oroLicense.setProductVersion(string2);
            oroLicense.setLicenseMode(LicenseMode.UNINILIZED);
            oroLicense.setValid(false);
            super.setLicense(oroLicense);
        }
        return oroLicense;
    }

    @Override
    public void initBackoffice(BackOfficeWindow backOfficeWindow) {
        JMenuBar jMenuBar = backOfficeWindow.getBackOfficeMenuBar();
        JMenu jMenu = new JMenu(Messages.getString("CloudSyncPlugin.0"));
        String string = Application.getInstance().getLicense() == null ? "" : Application.getInstance().getLicense().getHolderEmail();
        jMenu.add(new JMenuItem(new CloudSyncAction(false)));
        JMenuItem jMenuItem = new JMenuItem(new CloudSyncSettingAction());
        jMenu.add(jMenuItem);
        jMenuItem.setVisible(PosWebService.get().isCloudConfigured());
        jMenu.add((Action)new AboutPluginAction((LicenseSelectionListener)this, this.getLicense(), (Component)POSUtil.getBackOfficeWindow(), (ProductInfo)this, string));
        jMenuBar.add(jMenu);
    }

    @Override
    public void initAboutMenu(BackOfficeWindow backOfficeWindow, String string) {
        JMenuBar jMenuBar = backOfficeWindow.getBackOfficeMenuBar();
        JMenu jMenu = new JMenu(Messages.getString("Cloud"));
        jMenu.add((Action)new AboutPluginAction((LicenseSelectionListener)this, this.getLicense(), (Component)POSUtil.getBackOfficeWindow(), (ProductInfo)this, string));
        jMenuBar.add(jMenu);
    }

    @Override
    public void initConfigurationView(JDialog jDialog) {
    }

    @Override
    public List<AbstractAction> getSpecialFunctionActions() {
        return null;
    }

    @Override
    public void restartPOS(boolean bl) {
        if (bl) {
            try {
                Main.restart();
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
    }

    @Override
    public boolean requireLicense() {
        return true;
    }

    @Override
    public String getProductName() {
        return a;
    }

    @Override
    public String getProductVersion() {
        return "1.0";
    }

    @Override
    public Integer getProductNumericVersion() {
        return 1;
    }

    @Override
    public Component getParent() {
        return POSUtil.getFocusedWindow();
    }

    public URL getChangeLogURL() {
        return null;
    }

    @Override
    public String getUpdateServerURL() {
        return null;
    }

    @Override
    public String getMinParentVersion() {
        return VersionInfo.getVersion();
    }

    @Override
    public int getMinParentNumericVersion() {
        return VersionInfo.getNumericVersion();
    }

    @Override
    public String getId() {
        return String.valueOf(a.hashCode());
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }
}

