/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.base.BaseComboItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"menuItem"})
public class ComboItem
extends BaseComboItem
implements PropertyContainer {
    private static final long serialVersionUID = 1L;
    private transient JsonObject propertiesContainer;
    private MenuItem menuItem;

    public ComboItem() {
    }

    public ComboItem(String string) {
        super(string);
    }

    @XmlTransient
    public MenuItem getMenuItem() {
        if (this.menuItem == null) {
            String string = this.getMenuItemId();
            if (StringUtils.isEmpty((String)string)) {
                return null;
            }
            this.menuItem = MenuItemDAO.getInstance().loadInitialized(string);
        }
        return this.menuItem;
    }

    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
        if (menuItem != null) {
            if (StringUtils.isBlank((String)super.getMenuItemId())) {
                this.setItemId(menuItem.getId());
            }
            this.setName(menuItem.getDisplayName());
            Double d = menuItem.getPrice();
            if (menuItem.isVariant().booleanValue() && menuItem.getParentMenuItem() != null) {
                d = d + menuItem.getParentMenuItem().getPrice();
            }
            this.setPrice(d);
        }
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        return this.propertiesContainer;
    }
}

