/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.JsonPropertyContainer;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseImageResource;
import com.floreantpos.swing.PosUIManager;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.awt.Image;
import java.beans.Transient;
import java.sql.Blob;
import javax.swing.ImageIcon;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
@JsonIgnoreProperties(ignoreUnknown=true, value={"asIcon", "image", "scaledImage", "buttonImage", "buttonBigImage", "imageIcon", "imageData"})
public class ImageResource
extends BaseImageResource
implements JsonPropertyContainer,
TimedModel {
    private static final long serialVersionUID = 1L;
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    public static final String JSON_PROP_IMAGE_FORMAT = "imageFormat";
    private transient JsonObject propertiesContainer;
    private transient ImageIcon buttonImage = null;

    public ImageResource() {
    }

    public ImageResource(String string) {
        super(string);
    }

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    @Override
    @Transient
    @Deprecated
    public Blob getImageData() {
        return super.getImageData();
    }

    @Override
    @Deprecated
    public void setImageData(Blob blob) {
        super.setImageData(blob);
    }

    public IMAGE_CATEGORY getImageCategory() {
        return IMAGE_CATEGORY.fromInt(super.getImageCategoryNum());
    }

    public void setImageCategory(IMAGE_CATEGORY iMAGE_CATEGORY) {
        super.setImageCategoryNum(iMAGE_CATEGORY.getType());
    }

    public ImageIcon getScaledImage(int n, int n2) {
        byte[] byArray = this.getImageBytes();
        if (byArray == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(byArray);
        Image image = imageIcon.getImage().getScaledInstance(n, n2, 4);
        return new ImageIcon(image);
    }

    public ImageIcon getButtonImage() {
        if (this.buttonImage != null) {
            return this.buttonImage;
        }
        byte[] byArray = this.getImageBytes();
        if (byArray == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(byArray);
        this.buttonImage = ImageResource.getScaledImageIcon(imageIcon, 40);
        return this.buttonImage;
    }

    public static ImageIcon getScaledImageIcon(ImageIcon imageIcon, int n) {
        int n2 = imageIcon.getIconHeight();
        int n3 = imageIcon.getIconWidth();
        if (n3 > n2) {
            int n4 = n;
            int n5 = n2 * n4 / n3;
            Image image = imageIcon.getImage().getScaledInstance(PosUIManager.getSize(n4), PosUIManager.getSize(n5), 4);
            return new ImageIcon(image);
        }
        int n6 = n;
        int n7 = n3 * n6 / n2;
        Image image = imageIcon.getImage().getScaledInstance(PosUIManager.getSize(n7), PosUIManager.getSize(n6), 4);
        return new ImageIcon(image);
    }

    public ImageIcon getButtonImage(int n, int n2) {
        byte[] byArray = this.getImageBytes();
        if (byArray == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(byArray);
        int n3 = imageIcon.getIconHeight();
        int n4 = imageIcon.getIconWidth();
        if (n4 > n3) {
            int n5 = n;
            int n6 = n3 * n5 / n4;
            Image image = imageIcon.getImage().getScaledInstance(n5, n6, 4);
            return new ImageIcon(image);
        }
        int n7 = n2;
        int n8 = n4 * n7 / n3;
        Image image = imageIcon.getImage().getScaledInstance(n8, n7, 4);
        return new ImageIcon(image);
    }

    public ImageIcon getImageOfHeight(int n) {
        byte[] byArray = this.getImageBytes();
        if (byArray == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(byArray);
        int n2 = imageIcon.getIconHeight();
        int n3 = imageIcon.getIconWidth();
        int n4 = n;
        int n5 = n3 * n4 / n2;
        if (n4 <= 0 || n5 <= 0) {
            return null;
        }
        Image image = imageIcon.getImage().getScaledInstance(n5, n4, 4);
        return new ImageIcon(image);
    }

    public ImageIcon getButtonBigImage() {
        byte[] byArray = this.getImageBytes();
        if (byArray == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(byArray);
        int n = imageIcon.getIconHeight();
        int n2 = imageIcon.getIconWidth();
        if (n2 > n) {
            int n3 = 200;
            int n4 = n * n3 / n2;
            Image image = imageIcon.getImage().getScaledInstance(PosUIManager.getSize(n3), PosUIManager.getSize(n4), 4);
            return new ImageIcon(image);
        }
        int n5 = 200;
        int n6 = n2 * n5 / n;
        Image image = imageIcon.getImage().getScaledInstance(PosUIManager.getSize(n6), PosUIManager.getSize(n5), 4);
        return new ImageIcon(image);
    }

    @XmlTransient
    public Image getImage() {
        byte[] byArray = this.getImageBytes();
        if (byArray == null) {
            return null;
        }
        return new ImageIcon(byArray).getImage();
    }

    public ImageIcon getImageIcon() {
        byte[] byArray = this.getImageBytes();
        if (byArray == null) {
            return null;
        }
        return new ImageIcon(byArray);
    }

    @XmlTransient
    public ImageIcon getAsIcon() {
        byte[] byArray = this.getImageBytes();
        if (byArray == null) {
            return null;
        }
        return this.getButtonImage();
    }

    @Override
    public void setProperties(String string) {
        this.propertiesContainer = null;
        super.setProperties(string);
    }

    @Override
    public void updateProperties(String string) {
        super.setProperties(string);
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = StringUtils.isBlank((String)super.getProperties()) ? new JsonObject() : (JsonObject)new Gson().fromJson(super.getProperties(), JsonObject.class);
        }
        return this.propertiesContainer;
    }

    @JsonIgnore
    @XmlTransient
    public String getImageFileName() {
        return this.getProperty("image_file_name");
    }

    public void putImageFileName(String string) {
        this.addProperty("image_file_name", string);
    }

    public static enum IMAGE_CATEGORY {
        UNLISTED(0),
        FLOORPLAN(1),
        PRODUCTS(2),
        PEOPLE(3),
        DELETED(4);

        private int type;

        private IMAGE_CATEGORY(int n2) {
            this.type = n2;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int n) {
            this.type = n;
        }

        public static IMAGE_CATEGORY fromInt(int n) {
            IMAGE_CATEGORY[] iMAGE_CATEGORYArray;
            for (IMAGE_CATEGORY iMAGE_CATEGORY : iMAGE_CATEGORYArray = IMAGE_CATEGORY.values()) {
                if (iMAGE_CATEGORY.type != n) continue;
                return iMAGE_CATEGORY;
            }
            return UNLISTED;
        }
    }
}

