/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.TimedModel;
import com.floreantpos.model.base.BaseInventoryUnit;
import com.floreantpos.model.dao.InventoryUnitGroupDAO;
import com.floreantpos.model.util.InventoryUnitConversionRule;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"uniqueId", "unitGroup"})
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement
public class InventoryUnit
extends BaseInventoryUnit
implements IUnit,
PropertyContainer,
TimedModel {
    private static final long serialVersionUID = 1L;
    public static final String PROP_CONVERSION_RULE = "conversion.rule";
    private boolean updateLastUpdateTime = true;
    private boolean updateSyncTime = false;
    private transient JsonObject propertiesContainer;
    private InventoryUnitGroup unitGroup;

    @Override
    public boolean isUpdateSyncTime() {
        return this.updateSyncTime;
    }

    @Override
    public void setUpdateSyncTime(boolean bl) {
        this.updateSyncTime = bl;
    }

    @Override
    public boolean isUpdateLastUpdateTime() {
        return this.updateLastUpdateTime;
    }

    @Override
    public void setUpdateLastUpdateTime(boolean bl) {
        this.updateLastUpdateTime = bl;
    }

    public InventoryUnit() {
    }

    public InventoryUnit(String string) {
        super(string);
    }

    public InventoryUnit(String string, String string2) {
        super(string, string2);
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    @JsonIgnore
    public String getUniqueCode() {
        return super.getCode();
    }

    @XmlTransient
    public InventoryUnitGroup getUnitGroup() {
        String string = this.getUnitGroupId();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        if (this.unitGroup != null && string.equals(this.unitGroup.getId())) {
            return this.unitGroup;
        }
        this.unitGroup = InventoryUnitGroupDAO.getInstance().get(string);
        return this.unitGroup;
    }

    public void setUnitGroup(InventoryUnitGroup inventoryUnitGroup) {
        this.unitGroup = inventoryUnitGroup;
    }

    public String getUniqueId() {
        return ("unit_" + this.getName() + "_" + this.getId()).replaceAll("\\s+", "_");
    }

    public double getBaseUnitConversionValue() {
        double d = 0.0;
        List<InventoryUnit> list = this.getUnitGroup().getUnits();
        if (list != null && list.size() > 0) {
            for (InventoryUnit inventoryUnit : list) {
                if (!inventoryUnit.isBaseUnit().booleanValue()) continue;
                d = inventoryUnit.getConversionRate();
                break;
            }
        }
        return d * this.getConversionRate();
    }

    @Override
    public String getProperties() {
        if (this.propertiesContainer != null) {
            return this.propertiesContainer.toString();
        }
        String string = super.getProperties();
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
        return string;
    }

    @Override
    public void setProperties(String string) {
        super.setProperties(string);
        this.propertiesContainer = (JsonObject)new Gson().fromJson(string, JsonObject.class);
    }

    @Override
    public JsonObject getPropertyStore() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = new JsonObject();
        }
        return this.propertiesContainer;
    }

    public InventoryUnitConversionRule getConversionRule() {
        String string = this.getProperty(PROP_CONVERSION_RULE, InventoryUnitConversionRule.DIVISION.getName());
        return InventoryUnitConversionRule.fromName(string);
    }

    @Override
    public Double getConversionRate() {
        Double d = super.getConversionRate();
        return d == 0.0 ? 1.0 : d;
    }

    @Override
    public String getDisplayName() {
        return this.getProperty("unit_display_name", "");
    }

    public void setDisplayName(String string) {
        this.addProperty("unit_display_name", string);
    }

    @Override
    public boolean hideFromSalesScreen() {
        return this.getBooleanProperty("hideFromSalesScreen", Boolean.FALSE);
    }

    public void setHideFromSalesScreen(boolean bl) {
        this.addProperty("hideFromSalesScreen", String.valueOf(bl));
    }

    public void setStockCountable(boolean bl) {
        this.addProperty("stockCountable", String.valueOf(bl));
    }

    @Override
    public boolean isStockCountable() {
        return this.getBooleanProperty("stockCountable", Boolean.TRUE);
    }
}

