/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.base.BasePriceTableItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.InventoryUnitConvertionUtil;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;

@JsonIgnoreProperties(ignoreUnknown=true, value={"menuItem", "itemName"})
public class PriceTableItem
extends BasePriceTableItem {
    private static final long serialVersionUID = 1L;
    private MenuItem menuItem;
    private String itemName;
    private double regularPrice;

    public PriceTableItem() {
    }

    public PriceTableItem(String string) {
        super(string);
    }

    @XmlTransient
    public MenuItem getMenuItem() {
        if (this.menuItem == null) {
            this.menuItem = MenuItemDAO.getInstance().get(this.getMenuItemId());
        }
        return this.menuItem;
    }

    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
    }

    @XmlTransient
    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String string) {
        this.itemName = string;
    }

    public double getRegularPrice() {
        String string = this.getUnit();
        MenuItem menuItem = this.getMenuItem();
        Double d = menuItem.getVariantPrice();
        if (StringUtils.isBlank((String)string)) {
            return d;
        }
        IUnit iUnit = DataProvider.get().getUnitByCode(string);
        if (menuItem.isAllowUnitSelection() || menuItem.isAllowUnitWiseSelection()) {
            return menuItem.getDestinationUnitPrice(menuItem, iUnit, d, menuItem.getUnitQuantity(menuItem.getUnit(), iUnit));
        }
        return InventoryUnitConvertionUtil.calculatePrice(d, iUnit, menuItem);
    }

    public void setRegularPrice(double d) {
        this.regularPrice = d;
    }
}

