/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.Course;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Printer;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.ServicePaymentType;
import com.floreantpos.model.Tax;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.User;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.model.base.BaseTicketItemModifier;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.model.util.ServiceChargeType;
import com.floreantpos.util.JsonUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.OrgJsonUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

@JsonIgnoreProperties(ignoreUnknown=true, value={"inventoryAdjusted", "menuItem", "voidItem", "comboItemsModifierExtraPrice"})
@XmlSeeAlso(value={ModifiableTicketItem.class, ComboTicketItem.class})
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.PROPERTY, property="classType")
@JsonSubTypes(value={@JsonSubTypes.Type(value=ModifiableTicketItem.class), @JsonSubTypes.Type(value=ComboTicketItem.class)})
public class TicketItem
extends BaseTicketItem
implements ITicketItem,
PropertyContainer {
    public static final String JSON_PROP_DISCOUNT_ON_SC = "discountOnSc";
    public static final String JSON_PROP_VOID_ID = "voidId";
    public static final String JSON_PROP_VOIDED_BY_USER = "voidedByUser";
    public static final String JSON_PROP_MODIIFIER_VOID_IDS = "modifierVoidIds";
    public static final String JSON_PROP_VOID_REASON = "voidReason";
    public static final String JSON_PROP_VOID_QUANTITY = "voidQuantity";
    public static final String JSON_PROP_WASTED = "wasted";
    public static final String JSON_PROP_PRINTED_TO_KITCHEN = "originalItemPrintedToKitchen";
    public static final String JSON_PROP_RETURNED = "returned";
    public static final String JSON_PROP_RETURNED_ITEM_VOIDED = "returnedVoided";
    public static final String PROPERTY_COOKING_INSTRUCTION = "COOKING_INSTRUCTION";
    private static final String JSON_PROP_GIFT_CARD_PAID_AMOUNT = "gift_card_paid_amount";
    private static final String JSON_PROP_SC_WITHOUT_MODOFIERS = "scWithoutModifiers";
    public static final String PROPERTY_TAX = "TAX";
    public static final String PROPERTY_DISCOUNT = "DISCOUNT";
    private static final long serialVersionUID = 1L;
    private transient boolean syncEdited;
    private transient com.google.gson.JsonObject propertiesContainer;
    private String classType;
    private transient MenuItem menuItem;
    private int tableRowNum;
    private Double quantityToShip;
    public static final int HALF = 0;
    public static final int FULL = 1;
    public static final int SHARED_FULL = 2;
    public static final int SHARED_CUSTOM = 3;
    private Boolean includeVoidQuantity;
    private VoidItem voidItem;
    private List<TicketItemCookingInstruction> cookingInstructions;
    private List<TicketItemTax> taxes;
    private List<TicketItemDiscount> discounts;
    private TicketItem parentTicketItem;
    private Integer sortOrder;

    public TicketItem() {
        this.setDataVersion(2);
        this.setCreateDate(StoreDAO.getServerTimestamp());
    }

    public TicketItem(String string) {
        super(string);
        this.setDataVersion(2);
        this.setCreateDate(StoreDAO.getServerTimestamp());
    }

    public TicketItem(Ticket ticket, String string, double d, double d2, TicketItemTax ticketItemTax) {
        this.setName(string);
        this.setUnitPrice(d);
        this.setQuantity(d2);
        this.addTotaxes(ticketItemTax);
        this.setTicket(ticket);
        this.setDataVersion(2);
        this.setCreateDate(StoreDAO.getServerTimestamp());
    }

    public TicketItem createNew() {
        if (this instanceof ModifiableTicketItem) {
            return new ModifiableTicketItem();
        }
        return new TicketItem();
    }

    public Boolean isHasModifiers() {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        return list != null && list.size() > 0;
    }

    public TicketItemModifier getSizeModifier() {
        return null;
    }

    public void setSizeModifier(TicketItemModifier ticketItemModifier) {
    }

    public List<TicketItemModifier> getTicketItemModifiers() {
        return null;
    }

    public void setTicketItemModifiers(List<TicketItemModifier> list) {
    }

    public void addToticketItemModifiers(TicketItemModifier ticketItemModifier) {
    }

    public TicketItem clone() {
        return (TicketItem)SerializationUtils.clone((Serializable)this);
    }

    public TicketItem cloneAsNew() {
        return this.cloneAsNew(false);
    }

    public TicketItem cloneAsNew(boolean bl) {
        Object object;
        Object object2;
        TicketItem ticketItem = (TicketItem)SerializationUtils.clone((Serializable)this);
        boolean bl2 = bl && ticketItem.isPrintedToKitchen() != false;
        ticketItem.setId(null);
        ticketItem.setCreateDate(StoreDAO.getServerTimestamp());
        ticketItem.setVersion(0L);
        ticketItem.setPaid(Boolean.FALSE);
        ticketItem.setPrintedToKitchen(bl2);
        ticketItem.setInventoryAdjustQty(0.0);
        ticketItem.setCloudSynced(false);
        ticketItem.setHasSyncError(false);
        ticketItem.setKitchenStatusValue(KitchenStatus.WAITING);
        ticketItem.setSeat(null);
        if (ticketItem.getSizeModifier() != null) {
            ticketItem.getSizeModifier().setId(null);
            ticketItem.getSizeModifier().setPrintedToKitchen(bl2);
        }
        this.cloneModifiers(this, ticketItem, bl2);
        List<TicketItemCookingInstruction> list = ticketItem.getCookingInstructions();
        if (list != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                ((TicketItemCookingInstruction)object).setPrintedToKitchen(bl2);
                ((TicketItemCookingInstruction)object).setKitchenStatusValue(KitchenStatus.WAITING);
            }
        }
        ticketItem.setComboItems(null);
        if (this.isComboItem().booleanValue() && (object2 = this.getComboItems()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                TicketItem ticketItem2 = (TicketItem)object.next();
                TicketItem ticketItem3 = (TicketItem)SerializationUtils.clone((Serializable)ticketItem2);
                ticketItem3.setId(null);
                ticketItem3.setCreateDate(StoreDAO.getServerTimestamp());
                ticketItem3.setParentTicketItem(ticketItem);
                ticketItem3.setComboItems(null);
                if (ticketItem3.getSizeModifier() != null) {
                    ticketItem3.getSizeModifier().setId(null);
                    ticketItem3.getSizeModifier().setPrintedToKitchen(bl2);
                }
                this.cloneModifiers(ticketItem2, ticketItem3, bl2);
                ticketItem.addTocomboItems(ticketItem3);
            }
        }
        return ticketItem;
    }

    private void cloneModifiers(TicketItem ticketItem, TicketItem ticketItem2, boolean bl) {
        ticketItem2.setTicketItemModifiers(null);
        List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
        if (list != null && list.size() > 0) {
            for (TicketItemModifier ticketItemModifier : list) {
                Object object;
                if (!ticketItemModifier.isInfoOnly().booleanValue()) {
                    ModifierGroup modifierGroup;
                    List<MenuModifier> list2;
                    object = ticketItemModifier.getItemId();
                    MenuModifier menuModifier = MenuModifierDAO.getInstance().get((String)object);
                    String string = ticketItemModifier.getGroupId();
                    MenuItemModifierSpec menuItemModifierSpec = MenuItemModifierSpecDAO.getInstance().get(string);
                    if (menuItemModifierSpec != null && menuItemModifierSpec.isUseModifierGroupSettings() && (list2 = (modifierGroup = menuItemModifierSpec.getModifierGroup()).getModifiers()) != null && !list2.contains(menuModifier) || menuModifier != null && menuModifier.isDeleted().booleanValue()) continue;
                }
                object = (TicketItemModifier)SerializationUtils.clone((Serializable)ticketItemModifier);
                ((BaseTicketItemModifier)object).setId(null);
                ((BaseTicketItemModifier)object).setTicketItem(ticketItem2);
                ((BaseTicketItemModifier)object).setPrintedToKitchen(bl);
                ((TicketItemModifier)object).setKitchenStatusValue(KitchenStatus.WAITING);
                ticketItem2.addToticketItemModifiers((TicketItemModifier)object);
            }
        }
    }

    public void setTaxes(List<TicketItemTax> list) {
        this.taxes = list;
        this.buildTaxes();
    }

    public List<TicketItemTax> getTaxes() {
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
            String string = super.getTaxesProperty();
            if (StringUtils.isNotEmpty((String)string)) {
                JsonReader jsonReader = Json.createReader((Reader)new StringReader(string));
                JsonArray jsonArray = jsonReader.readArray();
                jsonReader.close();
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JsonObject jsonObject = (JsonObject)jsonArray.get(i);
                    TicketItemTax ticketItemTax = new TicketItemTax();
                    ticketItemTax.setId(JsonUtil.getString(jsonObject, TicketItemTax.PROP_ID));
                    ticketItemTax.setName(JsonUtil.getString(jsonObject, TicketItemTax.PROP_NAME));
                    ticketItemTax.setRate(JsonUtil.getDouble(jsonObject, TicketItemTax.PROP_RATE));
                    ticketItemTax.setTaxAmount(JsonUtil.getDouble(jsonObject, TicketItemTax.PROP_TAX_AMOUNT));
                    this.taxes.add(ticketItemTax);
                }
            }
        }
        return this.taxes;
    }

    public void addTotaxes(TicketItemTax ticketItemTax) {
        this.taxes = this.getTaxes();
        if (this.taxes == null) {
            this.taxes = new ArrayList<TicketItemTax>();
        }
        this.taxes.add(ticketItemTax);
    }

    public void buildTaxes() {
        if (this.taxes == null || this.taxes.isEmpty()) {
            this.setTaxesProperty(null);
            return;
        }
        JSONArray jSONArray = new JSONArray();
        for (TicketItemTax ticketItemTax : this.taxes) {
            jSONArray.put((Object)ticketItemTax.toJson());
        }
        this.setTaxesProperty(jSONArray.toString());
    }

    public void setDiscounts(List<TicketItemDiscount> list) {
        this.discounts = list;
    }

    public List<TicketItemDiscount> getDiscounts() {
        if (this.discounts == null) {
            this.discounts = new ArrayList<TicketItemDiscount>();
            String string = super.getDiscountsProperty();
            if (StringUtils.isNotEmpty((String)string)) {
                JSONArray jSONArray = new JSONArray(string);
                for (int i = 0; i < jSONArray.length(); ++i) {
                    JSONObject jSONObject = jSONArray.getJSONObject(i);
                    TicketItemDiscount ticketItemDiscount = new TicketItemDiscount();
                    ticketItemDiscount.setTicketItem(this);
                    ticketItemDiscount.setDiscountId(OrgJsonUtil.getString(jSONObject, TicketItemDiscount.PROP_DISCOUNT_ID));
                    ticketItemDiscount.setName(OrgJsonUtil.getString(jSONObject, TicketItemDiscount.PROP_NAME));
                    ticketItemDiscount.setType(OrgJsonUtil.getInt(jSONObject, TicketItemDiscount.PROP_TYPE));
                    ticketItemDiscount.setAutoApply(OrgJsonUtil.getBoolean(jSONObject, TicketItemDiscount.PROP_AUTO_APPLY));
                    ticketItemDiscount.setApplyIfDivisible(OrgJsonUtil.getBoolean(jSONObject, TicketItemDiscount.PROP_APPLY_IF_DIVISIBLE));
                    ticketItemDiscount.setCouponQuantity(OrgJsonUtil.getDouble(jSONObject, TicketItemDiscount.PROP_COUPON_QUANTITY));
                    ticketItemDiscount.setMinimumAmount(OrgJsonUtil.getDouble(jSONObject, TicketItemDiscount.PROP_MINIMUM_AMOUNT));
                    ticketItemDiscount.setValue(OrgJsonUtil.getDouble(jSONObject, TicketItemDiscount.PROP_VALUE));
                    ticketItemDiscount.setAmount(OrgJsonUtil.getDouble(jSONObject, TicketItemDiscount.PROP_AMOUNT));
                    ticketItemDiscount.setAmountWithoutModifiers(OrgJsonUtil.getDouble(jSONObject, "amountWithoutModifier"));
                    ticketItemDiscount.setDataVersion(OrgJsonUtil.getInt(jSONObject, "dataVersion"));
                    ticketItemDiscount.setDiscountPercentage(OrgJsonUtil.getDouble(jSONObject, "discountPercentage"));
                    this.discounts.add(ticketItemDiscount);
                }
            }
        }
        return this.discounts;
    }

    public void addTodiscounts(TicketItemDiscount ticketItemDiscount) {
        this.discounts = this.getDiscounts();
        if (this.discounts == null) {
            this.discounts = new ArrayList<TicketItemDiscount>();
        }
        this.discounts.add(ticketItemDiscount);
        ActionHistoryDAO.addTicketItemDiscountAddedActionHistory(this.getTicket(), ticketItemDiscount);
    }

    public void buildDiscounts() {
        if (this.discounts == null || this.discounts.isEmpty()) {
            this.setDiscountsProperty(null);
            return;
        }
        JSONArray jSONArray = new JSONArray();
        for (TicketItemDiscount ticketItemDiscount : this.discounts) {
            jSONArray.put((Object)ticketItemDiscount.toJson());
        }
        this.setDiscountsProperty(jSONArray.toString());
    }

    public int getTableRowNum() {
        return this.tableRowNum;
    }

    public void setTableRowNum(int n) {
        this.tableRowNum = n;
    }

    @Override
    public boolean canAddCookingInstruction() {
        return this.isPrintedToKitchen() == false;
    }

    @Override
    public String toString() {
        return POSConstants.NAME.toLowerCase() + ": " + this.getName() + " " + POSConstants.ID.toLowerCase() + ": " + this.getId();
    }

    public void setCookingInstructions(List<TicketItemCookingInstruction> list) {
        this.cookingInstructions = list;
        this.buildCoookingInstructions();
    }

    public void addCookingInstructions(List<TicketItemCookingInstruction> list) {
        this.cookingInstructions = this.getCookingInstructions();
        if (this.cookingInstructions == null) {
            this.cookingInstructions = new ArrayList<TicketItemCookingInstruction>(2);
        }
        for (TicketItemCookingInstruction ticketItemCookingInstruction : list) {
            this.addCookingInstruction(ticketItemCookingInstruction);
        }
    }

    public void addCookingInstruction(TicketItemCookingInstruction ticketItemCookingInstruction) {
        this.cookingInstructions = this.getCookingInstructions();
        if (this.cookingInstructions == null) {
            this.cookingInstructions = new ArrayList<TicketItemCookingInstruction>();
            return;
        }
        this.cookingInstructions.add(ticketItemCookingInstruction);
        this.buildCoookingInstructions();
    }

    public void buildCoookingInstructions() {
        if (this.cookingInstructions == null || this.cookingInstructions.isEmpty()) {
            this.setCookingInstructionsProperty(null);
            return;
        }
        JSONArray jSONArray = new JSONArray();
        for (TicketItemCookingInstruction ticketItemCookingInstruction : this.cookingInstructions) {
            jSONArray.put((Object)ticketItemCookingInstruction.toJson());
        }
        this.setCookingInstructionsProperty(jSONArray.toString());
    }

    public void removeCookingInstruction(TicketItemCookingInstruction ticketItemCookingInstruction) {
        List<TicketItemCookingInstruction> list = this.getCookingInstructions();
        if (list == null || list.size() == 0) {
            return;
        }
        Iterator<TicketItemCookingInstruction> iterator = list.iterator();
        while (iterator.hasNext()) {
            TicketItemCookingInstruction ticketItemCookingInstruction2 = iterator.next();
            if (ticketItemCookingInstruction2.getTableRowNum() != ticketItemCookingInstruction.getTableRowNum()) continue;
            iterator.remove();
            this.buildCoookingInstructions();
            return;
        }
    }

    public TicketItemModifier findTicketItemModifierFor(MenuModifier menuModifier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : list) {
            String string = ticketItemModifier.getItemId();
            if (string == null || !string.equals(menuModifier.getId())) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public TicketItemModifier addTicketItemModifier(MenuModifier menuModifier, int n, OrderType orderType, Multiplier multiplier) {
        return this.addTicketItemModifier(menuModifier, n, orderType, multiplier, 1.0);
    }

    public TicketItemModifier addTicketItemModifier(MenuModifier menuModifier, int n, OrderType orderType, Multiplier multiplier, double d) {
        TicketItemModifier ticketItemModifier = new TicketItemModifier();
        ticketItemModifier.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        ticketItemModifier.setItemId(menuModifier.getId());
        ticketItemModifier.setPageItemId(menuModifier.getPageItemId());
        MenuItemModifierSpec menuItemModifierSpec = menuModifier.getMenuItemModifierSpec();
        if (menuItemModifierSpec != null) {
            ticketItemModifier.setGroupId(menuItemModifierSpec.getId());
        }
        ticketItemModifier.setItemQuantity(d);
        ticketItemModifier.setName(menuModifier.getDisplayName());
        double d2 = menuModifier.getPriceForMultiplier(multiplier);
        if (multiplier != null) {
            ticketItemModifier.setMultiplierName(multiplier.getId());
            ticketItemModifier.setName(multiplier.getTicketPrefixDisplay() + menuModifier.getDisplayName());
        }
        ticketItemModifier.setUnitPrice(d2);
        this.setModifierUnitCost(menuModifier, multiplier, d, ticketItemModifier);
        ticketItemModifier.setTaxes(menuModifier.getTaxByOrderType(orderType, this));
        ticketItemModifier.setModifierType(n);
        ticketItemModifier.setShouldPrintToKitchen(menuModifier.isShouldPrintToKitchen());
        ticketItemModifier.setTicketItem(this);
        if (StringUtils.isNotEmpty((String)menuModifier.getTranslatedName())) {
            ticketItemModifier.addProperty("translatedName", menuModifier.getTranslatedName());
        }
        this.addToticketItemModifiers(ticketItemModifier);
        return ticketItemModifier;
    }

    private void setModifierUnitCost(MenuModifier menuModifier, Multiplier multiplier, double d, TicketItemModifier ticketItemModifier) {
        double d2;
        double d3 = d2 = menuModifier.getCost().doubleValue();
        if (multiplier != null) {
            d3 = d2 * (multiplier.getRate() / 100.0);
        }
        ticketItemModifier.setUnitCost(d3);
    }

    public TicketItemModifier addTicketItemModifier(MenuModifier menuModifier, boolean bl) {
        TicketItemModifier ticketItemModifier = new TicketItemModifier();
        ticketItemModifier.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        ticketItemModifier.setItemId(menuModifier.getId());
        MenuItemModifierSpec menuItemModifierSpec = menuModifier.getMenuItemModifierSpec();
        if (menuItemModifierSpec != null) {
            ticketItemModifier.setGroupId(menuItemModifierSpec.getId());
        }
        ticketItemModifier.setItemCount(1);
        ticketItemModifier.setName(menuModifier.getDisplayName());
        if (bl) {
            ticketItemModifier.setUnitPrice(menuModifier.getExtraPrice());
            ticketItemModifier.setModifierType(3);
        } else {
            ticketItemModifier.setUnitPrice(menuModifier.getPrice());
            ticketItemModifier.setModifierType(1);
        }
        ticketItemModifier.setTaxes(menuModifier.getTaxByOrderType(ticketItemModifier.getTicketItem().getTicket().getOrderType(), this));
        ticketItemModifier.setShouldPrintToKitchen(menuModifier.isShouldPrintToKitchen());
        ticketItemModifier.setTicketItem(this);
        this.addToticketItemModifiers(ticketItemModifier);
        return ticketItemModifier;
    }

    public void updateModifiersUnitPrice(double d) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list != null) {
            for (TicketItemModifier ticketItemModifier : list) {
                if (ticketItemModifier.isInfoOnly().booleanValue()) continue;
                ticketItemModifier.setUnitPrice(ticketItemModifier.getUnitPrice() * d / 100.0);
            }
        }
    }

    public void updateModifiersUnitPriceByGroup(MenuItemModifierSpec menuItemModifierSpec) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        ArrayList<TicketItemModifier> arrayList = new ArrayList<TicketItemModifier>();
        if (list != null) {
            double d = 0.0;
            for (TicketItemModifier ticketItemModifier : list) {
                if (ticketItemModifier.isInfoOnly().booleanValue() || !ticketItemModifier.getGroupId().equals(menuItemModifierSpec.getId())) continue;
                ticketItemModifier.setMultiplierName(null);
                arrayList.add(ticketItemModifier);
                d += ticketItemModifier.getItemQuantity().doubleValue();
            }
            Double d2 = menuItemModifierSpec.getPrice((int)d);
            if (d2 != null && d > 0.0) {
                double d3 = d2;
                for (TicketItemModifier ticketItemModifier : arrayList) {
                    Double d4 = ticketItemModifier.getMultiplierPrice(d2 / (double)((int)d));
                    ticketItemModifier.setUnitPrice(d4);
                    d3 -= NumberUtil.round(d4);
                }
                TicketItemModifier ticketItemModifier = (TicketItemModifier)arrayList.get(arrayList.size() - 1);
                ticketItemModifier.setUnitPrice(ticketItemModifier.getUnitPrice() + d3);
            } else {
                this.updateTicketItemModifiersPrice(arrayList, menuItemModifierSpec);
            }
        }
    }

    public void updateTicketItemModifiersPrice(List<TicketItemModifier> list, MenuItemModifierSpec menuItemModifierSpec) {
        HashMap<String, Multiplier> hashMap = new HashMap<String, Multiplier>();
        for (TicketItemModifier ticketItemModifier : list) {
            MenuModifier menuModifier;
            String string = ticketItemModifier.getMultiplierName();
            Multiplier multiplier = null;
            if (StringUtils.isNotBlank((String)string) && (multiplier = (Multiplier)hashMap.get(string)) == null) {
                multiplier = DataProvider.get().getMultiplierById(string);
                hashMap.put(string, multiplier);
            }
            if ((menuModifier = ticketItemModifier.getMenuModifier()) == null) {
                menuModifier = MenuModifierDAO.getInstance().get(ticketItemModifier.getItemId());
            }
            if (menuModifier == null) continue;
            ticketItemModifier.setUnitPrice(menuModifier.getPriceForMultiplier(multiplier));
        }
    }

    public boolean contains(TicketItemModifier ticketItemModifier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        int n = 0;
        if (list != null) {
            for (TicketItemModifier ticketItemModifier2 : list) {
                if (ticketItemModifier2.isInfoOnly().booleanValue() || !ticketItemModifier.getName().trim().equals(ticketItemModifier2.getName().trim())) continue;
                ++n;
            }
        }
        return n > 1;
    }

    public TicketItemModifier removeTicketItemModifier(TicketItemModifier ticketItemModifier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return ticketItemModifier;
        }
        Iterator<TicketItemModifier> iterator = list.iterator();
        while (iterator.hasNext()) {
            TicketItemModifier ticketItemModifier2 = iterator.next();
            if (!ticketItemModifier2.getItemId().equals(ticketItemModifier.getItemId()) || ticketItemModifier2.getModifierType() != ticketItemModifier.getModifierType()) continue;
            iterator.remove();
            return ticketItemModifier2;
        }
        return ticketItemModifier;
    }

    public TicketItemModifier removeTicketItemModifier(int n) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return null;
        }
        TicketItemModifier ticketItemModifier = list.get(n);
        list.remove(n);
        return ticketItemModifier;
    }

    public void calculatePrice() {
        if (this.getDataVersion() == 2) {
            this.calculatePriceV2();
        } else {
            this.calculatePriceV1();
        }
    }

    private void calculatePriceV1() {
        Serializable serializable;
        if (this.isTreatAsSeat().booleanValue()) {
            return;
        }
        BigDecimal bigDecimal = NumberUtil.convertToBigDecimal(this.getUnitPrice());
        BigDecimal bigDecimal2 = NumberUtil.convertToBigDecimal(this.getQuantity());
        BigDecimal bigDecimal3 = bigDecimal.multiply(bigDecimal2);
        BigDecimal bigDecimal4 = this.calculateDiscount(bigDecimal3);
        BigDecimal bigDecimal5 = this.calculateServiceCharge(bigDecimal3.subtract(bigDecimal4));
        BigDecimal bigDecimal6 = NumberUtil.convertToBigDecimal("0");
        BigDecimal bigDecimal7 = NumberUtil.convertToBigDecimal("0");
        BigDecimal bigDecimal8 = NumberUtil.convertToBigDecimal("0");
        double d = this.getUnitCost() * this.getQuantity();
        double d2 = 0.0;
        BigDecimal bigDecimal9 = null;
        bigDecimal9 = this.isTaxOnServiceCharge() != false ? this.calculateTax(bigDecimal3.subtract(bigDecimal4).add(bigDecimal5)) : this.calculateTax(bigDecimal3.subtract(bigDecimal4));
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list != null) {
            serializable = new HashSet();
            for (TicketItemModifier comparable2 : list) {
                if (comparable2.isInfoOnly().booleanValue()) continue;
                comparable2.calculatePrice();
                if (comparable2.isShouldSectionWisePrice().booleanValue() && serializable.contains(comparable2.getItemId())) continue;
                bigDecimal6 = bigDecimal6.add(NumberUtil.convertToBigDecimal(comparable2.getSubTotalAmount()));
                bigDecimal7 = bigDecimal7.add(NumberUtil.convertToBigDecimal(comparable2.getDiscountAmount()));
                bigDecimal8 = bigDecimal8.add(NumberUtil.convertToBigDecimal(comparable2.getTaxAmount()));
                bigDecimal5 = bigDecimal5.add(NumberUtil.convertToBigDecimal(comparable2.getServiceCharge()));
                d2 += comparable2.getTotalCost().doubleValue();
                serializable.add(comparable2.getItemId());
            }
        }
        serializable = bigDecimal3.add(bigDecimal6);
        BigDecimal bigDecimal10 = this.calculateDiscount((BigDecimal)serializable);
        BigDecimal bigDecimal11 = bigDecimal9.add(bigDecimal8);
        BigDecimal bigDecimal12 = NumberUtil.convertToBigDecimal("0");
        BigDecimal bigDecimal13 = NumberUtil.convertToBigDecimal("0");
        if (this.isTaxIncluded().booleanValue()) {
            bigDecimal12 = ((BigDecimal)serializable).subtract(bigDecimal10).add(bigDecimal5);
            bigDecimal13 = bigDecimal3.subtract(bigDecimal4).add(bigDecimal5);
        } else {
            bigDecimal12 = ((BigDecimal)serializable).subtract(bigDecimal10).add(bigDecimal11).add(bigDecimal5);
            bigDecimal13 = bigDecimal3.subtract(bigDecimal4).add(bigDecimal9).add(bigDecimal5);
        }
        this.setTotalCost(d + d2);
        this.setTotalAmountWithoutModifiers(d);
        this.setSubtotalAmount(NumberUtil.round(((BigDecimal)serializable).doubleValue()));
        this.setSubtotalAmountWithoutModifiers(NumberUtil.round(bigDecimal3.doubleValue()));
        this.setDiscountAmount(NumberUtil.round(bigDecimal10.doubleValue()));
        this.setDiscountWithoutModifiers(NumberUtil.round(bigDecimal4.doubleValue()));
        this.setTaxAmount(NumberUtil.round(bigDecimal11.doubleValue()));
        this.setTaxAmountWithoutModifiers(NumberUtil.round(bigDecimal9.doubleValue()));
        this.setServiceCharge(NumberUtil.round(bigDecimal5.doubleValue()));
        this.setTotalAmount(NumberUtil.round(bigDecimal12.doubleValue()));
        this.setTotalAmountWithoutModifiers(NumberUtil.round(bigDecimal13.doubleValue()));
        this.setAdjustedUnitPrice(bigDecimal.doubleValue());
        this.setAdjustedDiscount(NumberUtil.round(bigDecimal10.doubleValue()));
        this.setAdjustedDiscountWithoutModifiers(NumberUtil.round(bigDecimal4.doubleValue()));
        this.setAdjustedSubtotal(NumberUtil.round(((BigDecimal)serializable).doubleValue()));
        this.setAdjustedSubtotalWithoutModifiers(NumberUtil.round(bigDecimal3.doubleValue()));
        this.setAdjustedTax(NumberUtil.round(bigDecimal11.doubleValue()));
        this.setAdjustedTaxWithoutModifiers(NumberUtil.round(bigDecimal9.doubleValue()));
        this.setAdjustedTotal(NumberUtil.round(bigDecimal12.doubleValue()));
        this.setAdjustedTotalWithoutModifiers(NumberUtil.round(bigDecimal13.doubleValue()));
    }

    @Deprecated
    public void calculateAdjustedPrice() {
        Serializable serializable;
        List<TicketItemModifier> list;
        BigDecimal bigDecimal;
        if (this.isTreatAsSeat().booleanValue()) {
            return;
        }
        Ticket ticket = this.getTicket();
        if (ticket == null) {
            return;
        }
        BigDecimal bigDecimal2 = NumberUtil.convertToBigDecimal(ticket.getSubtotalAmountWithVoidItems());
        BigDecimal bigDecimal3 = NumberUtil.convertToBigDecimal(ticket.getTicketDiscountAmount());
        BigDecimal bigDecimal4 = NumberUtil.convertToBigDecimal(ticket.getItemDiscountAmount());
        BigDecimal bigDecimal5 = bigDecimal2.subtract(bigDecimal4);
        BigDecimal bigDecimal6 = bigDecimal5.subtract(bigDecimal3);
        BigDecimal bigDecimal7 = bigDecimal = NumberUtil.convertToBigDecimal(this.getSubtotalAmountWithoutModifiers()).subtract(NumberUtil.convertToBigDecimal(this.getDiscountWithoutModifiers()));
        if (bigDecimal5.compareTo(BigDecimal.ZERO) != 0) {
            bigDecimal7 = bigDecimal.multiply(bigDecimal6).divide(bigDecimal5, 4, RoundingMode.HALF_UP);
        }
        BigDecimal bigDecimal8 = this.calculateServiceCharge(bigDecimal7);
        BigDecimal bigDecimal9 = this.calculateTax(bigDecimal7.add(bigDecimal8));
        BigDecimal bigDecimal10 = NumberUtil.convertToBigDecimal(this.getQuantity());
        BigDecimal bigDecimal11 = bigDecimal7.divide(bigDecimal10, 4, RoundingMode.HALF_UP);
        BigDecimal bigDecimal12 = NumberUtil.convertToBigDecimal("0");
        BigDecimal bigDecimal13 = NumberUtil.convertToBigDecimal("0");
        BigDecimal bigDecimal14 = NumberUtil.convertToBigDecimal("0");
        if (bigDecimal7.doubleValue() < 0.0) {
            bigDecimal7 = BigDecimal.ZERO;
        }
        if ((list = this.getTicketItemModifiers()) != null) {
            serializable = new HashSet();
            for (TicketItemModifier comparable2 : list) {
                if (comparable2.isInfoOnly().booleanValue()) continue;
                comparable2.calculateAdjustedPrice();
                if (!comparable2.isShouldSectionWisePrice().booleanValue() && serializable.contains(comparable2.getItemId())) continue;
                bigDecimal12 = bigDecimal12.add(NumberUtil.convertToBigDecimal(comparable2.getAdjustedSubtotal()).abs());
                bigDecimal13 = bigDecimal13.add(NumberUtil.convertToBigDecimal(comparable2.getAdjustedDiscount()).abs());
                bigDecimal14 = bigDecimal14.add(NumberUtil.convertToBigDecimal(comparable2.getAdjustedTax()).abs());
                serializable.add(comparable2.getItemId());
            }
        }
        serializable = bigDecimal7.add(bigDecimal12);
        BigDecimal bigDecimal15 = NumberUtil.convertToBigDecimal(this.getSubtotalAmountWithoutModifiers()).subtract(bigDecimal7);
        BigDecimal bigDecimal16 = bigDecimal15.add(bigDecimal13);
        BigDecimal bigDecimal17 = bigDecimal9.add(bigDecimal14);
        BigDecimal bigDecimal18 = NumberUtil.convertToBigDecimal(0.0);
        BigDecimal bigDecimal19 = NumberUtil.convertToBigDecimal(0.0);
        if (this.isTaxIncluded().booleanValue()) {
            bigDecimal18 = ((BigDecimal)serializable).add(bigDecimal8);
            bigDecimal19 = bigDecimal7.add(bigDecimal8);
        } else {
            bigDecimal18 = ((BigDecimal)serializable).add(bigDecimal17).add(bigDecimal8);
            bigDecimal19 = bigDecimal7.add(bigDecimal9).add(bigDecimal8);
        }
        this.setAdjustedUnitPrice(NumberUtil.round(bigDecimal11.doubleValue()));
        this.setAdjustedDiscount(NumberUtil.round(bigDecimal16.doubleValue()));
        this.setAdjustedDiscountWithoutModifiers(NumberUtil.round(bigDecimal15.doubleValue()));
        this.setAdjustedSubtotal(((BigDecimal)serializable).doubleValue());
        this.setAdjustedSubtotalWithoutModifiers(NumberUtil.round(bigDecimal7.doubleValue()));
        this.setServiceCharge(NumberUtil.round(bigDecimal8.doubleValue()));
        this.setAdjustedTax(NumberUtil.round(bigDecimal17.doubleValue()));
        this.setAdjustedTaxWithoutModifiers(NumberUtil.round(bigDecimal9.doubleValue()));
        this.setAdjustedTotal(NumberUtil.round(bigDecimal18.doubleValue()));
        this.setAdjustedTotalWithoutModifiers(NumberUtil.round(bigDecimal19.doubleValue()));
    }

    public void calculatePriceV2() {
        if (this.isTreatAsSeat().booleanValue()) {
            return;
        }
        Ticket ticket = this.getTicket();
        double d = this.getUnitPrice();
        double d2 = this.getQuantity();
        double d3 = NumberUtil.round(d * d2);
        double d4 = NumberUtil.round(this.calculateDiscountV2(d3));
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = this.getUnitCost() * d2;
        d5 = ticket != null && (ticket.isDiscountOnSerivceCharge() || ticket.hasRepriceDiscount()) ? NumberUtil.round(this.calculateServiceChargeV2(d3 - d4)) : NumberUtil.round(this.calculateServiceChargeV2(d3));
        d10 = this.isTaxOnServiceCharge() != false ? NumberUtil.round(this.calculateTaxV2(d3 - d4 + d5)) : NumberUtil.round(this.calculateTaxV2(d3 - d4));
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list != null) {
            for (TicketItemModifier ticketItemModifier : list) {
                ticketItemModifier.setTicketItem(this);
                if (ticketItemModifier.isInfoOnly().booleanValue()) continue;
                ticketItemModifier.calculatePriceV2();
                d6 += ticketItemModifier.getSubTotalAmount().doubleValue();
                d7 += ticketItemModifier.getDiscountAmount().doubleValue();
                d8 += ticketItemModifier.getTaxAmount().doubleValue();
                d9 += ticketItemModifier.getServiceCharge().doubleValue();
                d11 += ticketItemModifier.getTotalCost().doubleValue();
            }
        }
        double d13 = NumberUtil.round(d12 + d11);
        double d14 = NumberUtil.round(d3 + d6);
        double d15 = NumberUtil.round(d4 + d7);
        double d16 = NumberUtil.round(d10 + d8);
        double d17 = NumberUtil.round(d5 + d9);
        double d18 = 0.0;
        double d19 = 0.0;
        if (this.isTaxIncluded().booleanValue()) {
            d18 = NumberUtil.round(d14 - d15 + d17);
            d19 = NumberUtil.round(d3 - d4 + d5);
        } else {
            d18 = NumberUtil.round(d14 - d15 + d16 + d17);
            d19 = NumberUtil.round(d3 - d4 + d10 + d5);
        }
        this.setTotalCost(d13);
        this.setTotalCostWithoutModifiers(d12);
        this.setSubtotalAmount(d14);
        this.setSubtotalAmountWithoutModifiers(d3);
        this.setDiscountAmount(d15);
        this.setDiscountWithoutModifiers(d4);
        this.setTaxAmount(d16);
        this.setTaxAmountWithoutModifiers(d10);
        this.setServiceCharge(NumberUtil.round(d17));
        this.setServiceChargeWithoutModifiers(d5);
        this.setTotalAmount(d18);
        this.setTotalAmountWithoutModifiers(d19);
        this.setAdjustedUnitPrice(d);
        this.setAdjustedDiscount(NumberUtil.round(d15));
        this.setAdjustedDiscountWithoutModifiers(d4);
        this.setAdjustedSubtotal(d14);
        this.setAdjustedSubtotalWithoutModifiers(d3);
        this.setAdjustedTax(d16);
        this.setAdjustedTaxWithoutModifiers(d10);
        this.setAdjustedTotal(d18);
        this.setAdjustedTotalWithoutModifiers(d19);
        this.buildDiscounts();
    }

    public void calculateAdjustedPriceV2() {
        if (this.isTreatAsSeat().booleanValue() || !this.isTicketDiscountApplicable().booleanValue()) {
            return;
        }
        Ticket ticket = this.getTicket();
        if (ticket == null) {
            return;
        }
        double d = this.getQuantity();
        double d2 = this.calculateAdjustedUnitPrice(ticket);
        double d3 = NumberUtil.round(d2 * d);
        double d4 = NumberUtil.round(this.getSubtotalAmountWithoutModifiers() - d3);
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        d5 = ticket != null && ticket.isDiscountOnSerivceCharge() || ticket.hasRepriceDiscount() ? NumberUtil.round(this.calculateServiceChargeV2(d3)) : this.getServiceChargeWithoutModifiers();
        d6 = this.isTaxOnServiceCharge() != false ? NumberUtil.round(this.calculateTaxV2(d3 + d5)) : NumberUtil.round(this.calculateTaxV2(d3));
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list != null) {
            for (TicketItemModifier ticketItemModifier : list) {
                ticketItemModifier.setTicketItem(this);
                if (ticketItemModifier.isInfoOnly().booleanValue()) continue;
                ticketItemModifier.calculateAdjustedPriceV2();
                d8 += ticketItemModifier.getAdjustedSubtotal().doubleValue();
                d9 += ticketItemModifier.getAdjustedDiscount().doubleValue();
                d10 += ticketItemModifier.getAdjustedTax().doubleValue();
                d7 += ticketItemModifier.getServiceCharge().doubleValue();
            }
        }
        double d11 = NumberUtil.round(d3 + d8);
        double d12 = NumberUtil.round(d4 + d9);
        double d13 = NumberUtil.round(d6 + d10);
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = NumberUtil.round(d5 + d7);
        if (this.isTaxIncluded().booleanValue()) {
            d14 = NumberUtil.round(d11 + d5);
            d15 = NumberUtil.round(d3 + d5);
        } else {
            d14 = NumberUtil.round(d11 + d13 + d16);
            d15 = NumberUtil.round(d3 + d6 + d5);
        }
        this.setAdjustedUnitPrice(d2);
        this.setAdjustedDiscount(NumberUtil.round(d12));
        this.setAdjustedDiscountWithoutModifiers(d4);
        this.setServiceCharge(d16);
        this.setServiceChargeWithoutModifiers(d5);
        this.setAdjustedSubtotal(d11);
        this.setAdjustedSubtotalWithoutModifiers(d3);
        this.setAdjustedTax(d13);
        this.setAdjustedTaxWithoutModifiers(d6);
        this.setAdjustedTotal(d14);
        this.setAdjustedTotalWithoutModifiers(d15);
    }

    private double calculateAdjustedUnitPrice(Ticket ticket) {
        double d = this.getQuantity();
        double d2 = NumberUtil.round((this.getSubtotalAmountWithoutModifiers() - this.getDiscountWithoutModifiers()) / d);
        double d3 = 0.0;
        double d4 = ticket.getSubtotalAmount() - ticket.getItemDiscountAmount();
        for (TicketDiscount ticketDiscount : ticket.getDiscounts()) {
            double d5 = ticket.getDiscountPercentageRate(ticketDiscount, d4);
            d2 = d3 = d2 - d2 * d5;
            double d6 = d4 * d5;
            d4 -= d6;
        }
        if (this.getUnitPrice() == 0.0) {
            d3 = 0.0;
        }
        return NumberUtil.round(d3, 4);
    }

    @Deprecated
    public BigDecimal calculateServiceCharge(BigDecimal bigDecimal) {
        if (!this.isServiceChargeApplicable().booleanValue()) {
            return BigDecimal.ZERO;
        }
        Ticket ticket = this.getTicket();
        if (ticket == null || ticket.getOrderType() == null) {
            return new BigDecimal("0");
        }
        Double d = this.getServiceChargeRate();
        if (d == 0.0) {
            d = ticket.getOutletServiceChargeRate();
        }
        if (d == 0.0 || !ticket.isServiceChargeApplicable()) {
            return new BigDecimal("0");
        }
        BigDecimal bigDecimal2 = NumberUtil.convertToBigDecimal(d / 100.0);
        return NumberUtil.round(bigDecimal.multiply(bigDecimal2));
    }

    public double calculateServiceChargeV2(double d) {
        if (!this.isServiceChargeApplicable().booleanValue()) {
            return 0.0;
        }
        Ticket ticket = this.getTicket();
        if (ticket == null || !ticket.isServiceChargeApplicable()) {
            return 0.0;
        }
        Double d2 = this.getServiceChargeRate();
        if (d2 == 0.0) {
            d2 = ticket.getOutletServiceChargeRate();
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        double d3 = 0.0;
        ServiceChargeType serviceChargeType = ticket.getServiceChargeType();
        switch (serviceChargeType) {
            case PERCENTAGE: 
            case EMPTY: {
                d3 = d * (d2 / 100.0);
                break;
            }
            case FIXEDAMOUNT: {
                d3 = 0.0;
            }
        }
        if (d3 < 0.0 && !this.isServiceChargeRefundable().booleanValue()) {
            d3 = 0.0;
        }
        return d3;
    }

    public boolean isMergable(TicketItem ticketItem, boolean bl) {
        if (this.isTreatAsSeat().booleanValue() || ticketItem.isTreatAsSeat().booleanValue()) {
            return false;
        }
        if (this.isFractionalUnit().booleanValue() || ticketItem.isFractionalUnit().booleanValue()) {
            return false;
        }
        if (this.getQuantity() > 0.0 && ticketItem.getQuantity() < 0.0 || this.getQuantity() < 0.0 && ticketItem.getQuantity() > 0.0) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.getMenuItemId()) || StringUtils.isEmpty((String)ticketItem.getMenuItemId())) {
            return false;
        }
        if (this.hasCookingInstructions() || ticketItem.hasCookingInstructions()) {
            return false;
        }
        if (this.isReturned() || ticketItem.isReturned()) {
            return false;
        }
        if (!this.getMenuItemId().equals(ticketItem.getMenuItemId())) {
            return false;
        }
        if (!this.getUnitPrice().equals(ticketItem.getUnitPrice())) {
            return false;
        }
        if (this.isComboItem().booleanValue() || ticketItem.isComboItem().booleanValue()) {
            return false;
        }
        if (!this.getSeatNumber().equals(ticketItem.getSeatNumber())) {
            return false;
        }
        if (!this.isHasModifiers().booleanValue() && !ticketItem.isHasModifiers().booleanValue()) {
            return true;
        }
        return this.isMergableModifiers(this.getTicketItemModifiers(), ticketItem.getTicketItemModifiers(), bl);
    }

    public boolean isMergableModifiers(List<TicketItemModifier> list, List<TicketItemModifier> list2, boolean bl) {
        if (list2 == null || list == null) {
            return true;
        }
        if (list.size() != list2.size()) {
            return false;
        }
        Comparator<TicketItemModifier> comparator = new Comparator<TicketItemModifier>(){

            @Override
            public int compare(TicketItemModifier ticketItemModifier, TicketItemModifier ticketItemModifier2) {
                return ticketItemModifier.getItemId().compareTo(ticketItemModifier2.getItemId());
            }
        };
        Collections.sort(list, comparator);
        Collections.sort(list2, comparator);
        Iterator<TicketItemModifier> iterator = list.iterator();
        Iterator<TicketItemModifier> iterator2 = list2.iterator();
        while (iterator.hasNext()) {
            TicketItemModifier ticketItemModifier;
            TicketItemModifier ticketItemModifier2 = iterator.next();
            if (comparator.compare(ticketItemModifier2, ticketItemModifier = iterator2.next()) != 0) {
                return false;
            }
            if (!bl) continue;
            ticketItemModifier2.merge(ticketItemModifier);
        }
        return true;
    }

    public void doCalculateComboItemPrice() {
        this.doCalculateComboItemPrice(false);
    }

    public void doCalculateComboItemPrice(boolean bl) {
        if (!(this instanceof ComboTicketItem)) {
            return;
        }
        ComboTicketItem comboTicketItem = (ComboTicketItem)this;
        MenuItem menuItem = comboTicketItem.getMenuItem();
        if (bl) {
            menuItem.setTicketItemUnitPriceAndCost(comboTicketItem, menuItem, this.menuItem.getUnit(), this.getTicket());
            List<TicketItem> list = this.getComboItems();
            if (list != null && list.size() > 0) {
                for (TicketItem ticketItem : list) {
                    MenuItem menuItem2 = ticketItem.getMenuItem();
                    if (menuItem2 == null) continue;
                    menuItem2.setTicketItemUnitPriceAndCost(ticketItem, menuItem2, menuItem2.getUnit(), this.getTicket(), false);
                }
            }
        }
        double d = this.getComboItemsModifierExtraPrice();
        if (menuItem.isBasePriceForComboItem()) {
            comboTicketItem.setUnitPrice(comboTicketItem.getUnitPrice() + d);
            return;
        }
        double d2 = this.getComboGroupItemsModifiedPrice(comboTicketItem, menuItem);
        if (menuItem.isBaseAndGroupPriceForComboItem()) {
            comboTicketItem.setUnitPrice(comboTicketItem.getUnitPrice() + d + d2);
            return;
        }
        if (menuItem.isModifiablePriceForComboItem()) {
            comboTicketItem.setUnitPrice(comboTicketItem.getComboItemsPrice() + d + d2);
            return;
        }
        if (menuItem.isHighestPricedComboItem()) {
            double d3 = d2;
            List<TicketItem> list = comboTicketItem.getComboItems();
            if (list != null && list.size() > 0) {
                for (TicketItem ticketItem : list) {
                    double d4;
                    if (ticketItem.getGroupId() != null || !((d4 = ticketItem.getUnitPrice() * (ticketItem.getQuantity() / comboTicketItem.getQuantity())) > d3)) continue;
                    d3 = d4;
                }
            }
            comboTicketItem.setUnitPrice(d3 + d);
            return;
        }
        comboTicketItem.setUnitPrice(comboTicketItem.getUnitPrice() + d);
    }

    private double getComboGroupItemsModifiedPrice(ComboTicketItem comboTicketItem, MenuItem menuItem) {
        List<ComboGroup> list = menuItem.getComboGroups();
        if (list == null || list.isEmpty()) {
            return 0.0;
        }
        double d = 0.0;
        boolean bl = menuItem.isHighestPricedComboItem();
        for (ComboGroup comboGroup : list) {
            List<TicketItem> list2;
            List<MenuItem> list3;
            if (comboGroup == null || (list3 = comboGroup.getItems()) == null || list3.isEmpty() || (list2 = comboTicketItem.getComboItems()) == null || list2.isEmpty()) continue;
            for (MenuItem menuItem2 : list3) {
                if (menuItem2 == null || StringUtils.isEmpty((String)menuItem2.getId())) continue;
                for (TicketItem ticketItem : list2) {
                    if (ticketItem == null || StringUtils.isEmpty((String)ticketItem.getMenuItemId()) || !menuItem2.getId().equals(ticketItem.getMenuItemId()) || ticketItem.getGroupId() == null) continue;
                    Double d2 = comboGroup.getItemPrice(menuItem2.getId(), ticketItem.getUnitPrice());
                    if (d2 == null) {
                        d2 = 0.0;
                    }
                    double d3 = d2 * (ticketItem.getQuantity() / comboTicketItem.getQuantity());
                    if (bl) {
                        double d4 = ticketItem.getSubtotalAmount() - ticketItem.getSubtotalAmountWithoutModifiers();
                        if (d4 > 0.0) {
                            d3 += d4 / ticketItem.getQuantity();
                        }
                        if (!(d2 > d)) continue;
                        d = d2;
                        continue;
                    }
                    d += d3;
                }
            }
        }
        return d;
    }

    public void merge(TicketItem ticketItem) {
        if (!this.isHasModifiers().booleanValue() && !ticketItem.isHasModifiers().booleanValue()) {
            this.setQuantity(this.getQuantity() + ticketItem.getQuantity());
            return;
        }
        if (this.isMergable(ticketItem, false)) {
            this.setQuantity(this.getQuantity() + ticketItem.getQuantity());
        }
    }

    public boolean hasCookingInstructions() {
        return this.getCookingInstructions() != null && this.getCookingInstructions().size() > 0;
    }

    public BigDecimal calculateDiscount(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = NumberUtil.convertToBigDecimal(0.0);
        List<TicketItemDiscount> list = this.getDiscounts();
        if (list != null) {
            for (TicketItemDiscount ticketItemDiscount : list) {
                if (ticketItemDiscount.getType() == 2) continue;
                if (ticketItemDiscount.getType() == 1) {
                    bigDecimal2 = bigDecimal2.add(NumberUtil.convertToBigDecimal(ticketItemDiscount.calculateDiscount(bigDecimal.doubleValue() - bigDecimal2.doubleValue())));
                    continue;
                }
                if (ticketItemDiscount.getType() != 0) continue;
                double d = bigDecimal.doubleValue() == 0.0 ? 0.0 : Math.abs(ticketItemDiscount.getValue() * 100.0 / bigDecimal.doubleValue());
                TicketItemDiscount ticketItemDiscount2 = new TicketItemDiscount();
                ticketItemDiscount2.setType(1);
                ticketItemDiscount2.setMinimumAmount(ticketItemDiscount.getMinimumAmount());
                ticketItemDiscount2.setValue(d);
                ticketItemDiscount2.setTicketItem(this);
                ticketItemDiscount2.setCouponQuantity(ticketItemDiscount.getCouponQuantity());
                ticketItemDiscount2.setApplyIfDivisible(Boolean.FALSE);
                BigDecimal bigDecimal3 = NumberUtil.convertToBigDecimal(ticketItemDiscount2.calculateDiscount(bigDecimal.doubleValue()));
                bigDecimal2 = bigDecimal2.add(bigDecimal3);
                ticketItemDiscount.setAmount(bigDecimal3.doubleValue());
            }
        }
        this.buildDiscounts();
        if (bigDecimal2.compareTo(bigDecimal.abs()) > 0) {
            return bigDecimal;
        }
        return NumberUtil.round(bigDecimal2);
    }

    public double calculateDiscountV2(double d) {
        double d2 = 0.0;
        List<TicketItemDiscount> list = this.getDiscounts();
        double d3 = Math.abs(d);
        if (list != null) {
            for (TicketItemDiscount ticketItemDiscount : list) {
                if (ticketItemDiscount.getType() == 2) continue;
                if (ticketItemDiscount.getType() == 1) {
                    d2 += NumberUtil.round(ticketItemDiscount.calculateDiscount(d3 - d2));
                    continue;
                }
                if (ticketItemDiscount.getType() != 0) continue;
                Double d4 = Math.abs(d) - d2;
                double d5 = ticketItemDiscount.getValue() * ticketItemDiscount.getCouponQuantity();
                if (d < 0.0 && this.getUnitPriceWithoutModifierAfterDiscount() != null) {
                    double d6 = Math.abs(this.getUnitPriceWithoutModifierAfterDiscount() * this.getQuantity());
                    if (NumberUtil.isZero(d6)) {
                        Double d7 = ticketItemDiscount.getAmount();
                        d5 = d7 < d4 ? d7.doubleValue() : d4.doubleValue();
                    } else {
                        double d8 = Math.abs(d);
                        if (d6 < d8) {
                            TicketItem ticketItem = this.getTicket().getTicketItem(this.getVoidedItemId());
                            double d9 = d8 - d6;
                            double d10 = ticketItemDiscount.getValue() * ticketItemDiscount.getCouponQuantity() / Math.abs(ticketItem.getQuantity()) * Math.abs(this.getQuantity());
                            d5 = d9 > d10 ? d10 : d9;
                        } else {
                            d5 = 0.0;
                        }
                    }
                } else if (d5 >= d4) {
                    d5 = d4;
                }
                ticketItemDiscount.setAmount(d5);
                ticketItemDiscount.setAmountWithoutModifiers(d5);
                d2 += d5;
            }
        }
        if (d < 0.0) {
            return -1.0 * Math.abs(d2);
        }
        if (d2 > d3) {
            return d;
        }
        return d2;
    }

    public double getAmountByType(TicketItemDiscount ticketItemDiscount) {
        switch (ticketItemDiscount.getType()) {
            case 0: {
                return ticketItemDiscount.getValue();
            }
            case 1: {
                return ticketItemDiscount.getValue() * this.getUnitPrice() / 100.0;
            }
        }
        return 0.0;
    }

    @Deprecated
    private BigDecimal calculateTax(BigDecimal bigDecimal) {
        Ticket ticket = this.getTicket();
        BigDecimal bigDecimal2 = NumberUtil.convertToBigDecimal("0");
        List<TicketItemTax> list = this.getTaxes();
        if (list != null) {
            if (this.isTaxIncluded().booleanValue()) {
                BigDecimal bigDecimal3 = NumberUtil.convertToBigDecimal(0.0);
                for (TicketItemTax comparable2 : list) {
                    bigDecimal3 = bigDecimal3.add(NumberUtil.convertToBigDecimal(comparable2.getRate()).divide(NumberUtil.convertToBigDecimal("100"), 4, RoundingMode.HALF_EVEN));
                }
                if (bigDecimal3.compareTo(NumberUtil.convertToBigDecimal("0")) == 0) {
                    return bigDecimal2;
                }
                BigDecimal bigDecimal4 = bigDecimal3.add(NumberUtil.convertToBigDecimal(1.0));
                BigDecimal bigDecimal6 = bigDecimal.divide(bigDecimal4, 4, RoundingMode.HALF_EVEN);
                for (TicketItemTax ticketItemTax : list) {
                    bigDecimal3 = NumberUtil.convertToBigDecimal(ticketItemTax.getRate()).divide(NumberUtil.convertToBigDecimal("100"), 4, RoundingMode.HALF_EVEN);
                    BigDecimal bigDecimal5 = bigDecimal6.multiply(bigDecimal3);
                    ticketItemTax.setTaxAmount(bigDecimal5.doubleValue());
                    bigDecimal2 = bigDecimal2.add(bigDecimal5);
                }
            } else {
                for (TicketItemTax ticketItemTax : list) {
                    BigDecimal bigDecimal6 = NumberUtil.convertToBigDecimal(ticketItemTax.getRate()).divide(NumberUtil.convertToBigDecimal("100"), 4, RoundingMode.HALF_EVEN);
                    if (bigDecimal6.compareTo(NumberUtil.convertToBigDecimal("0")) == 0) continue;
                    BigDecimal bigDecimal7 = bigDecimal.multiply(bigDecimal6);
                    ticketItemTax.setTaxAmount(bigDecimal7.doubleValue());
                    bigDecimal2 = bigDecimal2.add(bigDecimal7);
                }
            }
        }
        if (bigDecimal2.doubleValue() < 0.0) {
            bigDecimal2 = BigDecimal.ZERO;
        }
        this.buildTaxes();
        if (ticket != null && ticket.isTaxExempt().booleanValue()) {
            this.setTaxExemptAmount(bigDecimal2.doubleValue());
            return BigDecimal.ZERO;
        }
        if (ticket != null && Boolean.valueOf(ticket.getProperty("customer.taxExempt")).booleanValue()) {
            this.setTaxExemptAmount(bigDecimal2.doubleValue());
            return BigDecimal.ZERO;
        }
        return Tax.applyFloridaTaxRule(bigDecimal, bigDecimal2);
    }

    private double calculateTaxV2(double d) {
        Ticket ticket = this.getTicket();
        double d2 = 0.0;
        List<TicketItemTax> list = this.getTaxes();
        if (list != null) {
            if (ticket != null && ticket.isTaxIncluded().booleanValue()) {
                for (TicketItemTax ticketItemTax : list) {
                    if (ticketItemTax.getRate() == 0.0) {
                        ticketItemTax.setTaxAmount(0.0);
                        continue;
                    }
                    double d3 = d / (ticketItemTax.getRate() / 100.0 + 1.0);
                    double d4 = d3 * ticketItemTax.getRate() / 100.0;
                    ticketItemTax.setTaxAmount(d4);
                    d2 += d4;
                }
            } else {
                for (TicketItemTax ticketItemTax : list) {
                    if (ticketItemTax.getRate() == 0.0) continue;
                    double d5 = d * ticketItemTax.getRate() / 100.0;
                    ticketItemTax.setTaxAmount(d5);
                    d2 += d5;
                }
            }
        }
        d2 = Tax.applyFloridaTaxRuleV2(this.getTicket(), d, d2);
        this.buildTaxes();
        this.setTaxExemptAmount(0.0);
        if (ticket != null && ticket.isTaxExempt().booleanValue()) {
            this.setTaxExemptAmount(d2);
            return 0.0;
        }
        return d2;
    }

    public double getTotalTaxRate() {
        List<TicketItemTax> list = this.getTaxes();
        if (list == null || list.isEmpty()) {
            return 0.0;
        }
        double d = 0.0;
        for (TicketItemTax ticketItemTax : list) {
            d += ticketItemTax.getRate().doubleValue();
        }
        return d;
    }

    @Override
    public String getNameDisplay() {
        return this.getNameDisplay(this.getName());
    }

    public String getNameDisplay(String string) {
        if (this.isTreatAsSeat().booleanValue()) {
            return string;
        }
        String string2 = "";
        if (this.getQuantity() < 0.0) {
            if (this.isVoided().booleanValue() && !this.isItemReturned().booleanValue()) {
                string2 = string2 + "*Voided* ";
                string2 = string2 + this.getItemQuantityDisplay(true);
            } else {
                string2 = string2 + this.getItemQuantityDisplay();
            }
        } else {
            string2 = string2 + this.getItemQuantityDisplay();
        }
        if (this.isComboItem().booleanValue()) {
            List<TicketItem> list = this.getComboItems();
            if (list != null && !list.isEmpty()) {
                string2 = string2 + string;
                string2 = string2 + "\n";
                Iterator<TicketItem> iterator = list.iterator();
                while (iterator.hasNext()) {
                    TicketItem ticketItem = iterator.next();
                    string2 = string2 + " #" + NumberUtil.trimDecilamIfNotNeeded(ticketItem.getQuantity() / this.getQuantity(), true) + " " + ticketItem.getName();
                    List<TicketItemModifier> list2 = ticketItem.getTicketItemModifiers();
                    if (iterator.hasNext() || list2 != null) {
                        string2 = string2 + "\n";
                    }
                    if (list2 == null || list2.isEmpty()) continue;
                    Iterator<TicketItemModifier> iterator2 = list2.iterator();
                    while (iterator2.hasNext()) {
                        TicketItemModifier ticketItemModifier = iterator2.next();
                        string2 = string2 + ticketItemModifier.getNameDisplay();
                        if (iterator2.hasNext()) {
                            string2 = string2 + "\n";
                            continue;
                        }
                        if (!iterator.hasNext()) continue;
                        string2 = string2 + "\n";
                    }
                }
                return string2;
            }
        } else if (this.getSizeModifier() != null) {
            string2 = string2 + this.getSizeModifier().getNameDisplay().replaceAll(" -- ", "") + " " + this.getName();
            return string2.trim();
        }
        string2 = string2 + string;
        return string2;
    }

    @Override
    public String getUnitPriceDisplay() {
        if (this.isTreatAsSeat().booleanValue()) {
            return null;
        }
        return NumberUtil.formatNumberAcceptNegative(this.getUnitPrice());
    }

    @Override
    public String getItemQuantityDisplay() {
        return this.getItemQuantityDisplay(false);
    }

    public String getItemQuantityDisplay(boolean bl) {
        if (this.isTreatAsSeat().booleanValue()) {
            return "";
        }
        String string = this.getProperty("unit_Code", "");
        String string2 = this.getProperty("unit_display_name", "");
        String string3 = "";
        string3 = string2 == null || string2.length() == 0 ? string : string2;
        if (string3 == null) {
            string3 = this.getUnitName();
        }
        Double d = bl ? Math.abs(this.getQuantity()) : this.getQuantity();
        if (!this.isFractionalUnit().booleanValue() && d == 1.0 && ("ea".equals(string3) || "Each".equals(string3))) {
            return "";
        }
        String string4 = NumberUtil.trimDecilamIfNotNeeded(d, true);
        if (string3.equals("") || "ea".equals(string3) || "pc".equals(string3)) {
            return string4 + "x ";
        }
        return string4 + string3.trim() + " ";
    }

    @Override
    public String getTaxAmountWithoutModifiersDisplay() {
        return NumberUtil.formatNumberAcceptNegative(this.getTaxAmountWithoutModifiers());
    }

    @Override
    public String getTotalAmountWithoutModifiersDisplay() {
        return NumberUtil.formatNumberAcceptNegative(this.getTotalAmountWithoutModifiers());
    }

    @Override
    public String getSubTotalAmountWithoutModifiersDisplay() {
        if (this.isTreatAsSeat().booleanValue()) {
            return null;
        }
        return NumberUtil.formatNumberAcceptNegative(this.getSubtotalAmountWithoutModifiers());
    }

    @Override
    public String getItemCode() {
        return String.valueOf(this.getMenuItemId());
    }

    public List<Printer> getPrinters(OrderType orderType) {
        PrinterGroup printerGroup = this.getPrinterGroup();
        ArrayList<Printer> arrayList = new ArrayList<Printer>();
        PosPrinters posPrinters = DataProvider.get().getPrinters();
        List<Printer> list = posPrinters.getKitchenPrinters();
        arrayList.addAll(posPrinters.getStickerPrinters());
        Printer printer = VirtualPrinter.getKdsPrinter();
        if (printerGroup == null && (list == null || list.isEmpty()) && posPrinters.isPrintToKds()) {
            arrayList.add(printer);
        }
        boolean bl = false;
        if (printerGroup == null && list != null && list.size() > 0) {
            for (Printer printer2 : list) {
                if (StringUtils.isBlank((String)printer2.getDeviceName())) {
                    if (bl) continue;
                    arrayList.add(printer);
                    bl = true;
                    continue;
                }
                arrayList.add(printer2);
            }
            return arrayList;
        }
        if (printerGroup != null) {
            List<String> list2 = printerGroup.getPrinterNames();
            for (Printer printer3 : list) {
                VirtualPrinter virtualPrinter = printer3.getVirtualPrinter();
                if (StringUtils.isBlank((String)printer3.getDeviceName()) || !list2.contains(virtualPrinter.getName())) continue;
                arrayList.add(printer3);
            }
        }
        if (arrayList.isEmpty() && posPrinters.isPrintToKds()) {
            arrayList.add(printer);
        }
        return arrayList;
    }

    @Override
    public boolean canAddDiscount() {
        return true;
    }

    @Override
    public boolean canVoid() {
        return true;
    }

    @Override
    public boolean canAddAdOn() {
        return true;
    }

    @XmlTransient
    public MenuItem getMenuItem() {
        if (this.menuItem == null) {
            String string = this.getMenuItemId();
            if (StringUtils.isEmpty((String)string)) {
                return null;
            }
            this.menuItem = MenuItemDAO.getInstance().loadInitialized(string);
        }
        return this.menuItem;
    }

    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
        String string = null;
        if (menuItem != null) {
            string = menuItem.getId();
        }
        super.setMenuItemId(string);
    }

    @Override
    public KitchenStatus getKitchenStatusValue() {
        return KitchenStatus.fromString(super.getKitchenStatus());
    }

    public void setKitchenStatusValue(KitchenStatus kitchenStatus) {
        super.setKitchenStatus(kitchenStatus.name());
    }

    public void setKitchenStatusValueWithChildren(KitchenStatus kitchenStatus) {
        Object object;
        Object object2;
        super.setKitchenStatus(kitchenStatus.name());
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (TicketItemModifier)object2.next();
                ((TicketItemModifier)object).setKitchenStatusValue(kitchenStatus);
            }
        }
        if ((object2 = this.getCookingInstructions()) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                TicketItemCookingInstruction ticketItemCookingInstruction = (TicketItemCookingInstruction)object.next();
                ticketItemCookingInstruction.setKitchenStatusValue(kitchenStatus);
            }
            this.buildCoookingInstructions();
        }
    }

    @Override
    public String getUnitName() {
        if (super.getUnitName() == null) {
            return "";
        }
        return super.getUnitName();
    }

    public Double getQuantityToShip() {
        return this.quantityToShip == null ? 0.0 : this.quantityToShip;
    }

    public void setQuantityToShip(Double d) {
        this.quantityToShip = d;
    }

    @Override
    public String getSubTotalAmountDisplay() {
        if (this.isTreatAsSeat().booleanValue()) {
            return null;
        }
        if (this.isVoided().booleanValue() && !this.isItemReturned().booleanValue()) {
            return "(" + NumberUtil.format(Math.abs(this.getSubtotalAmount())) + ")";
        }
        return NumberUtil.format(this.getSubtotalAmount());
    }

    public TicketItemModifier findTicketItemModifierFor(MenuModifier menuModifier, Multiplier multiplier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : list) {
            boolean bl;
            String string = ticketItemModifier.getItemId();
            String string2 = menuModifier.getMenuItemModifierSpec() == null ? null : menuModifier.getMenuItemModifierSpec().getId();
            String string3 = ticketItemModifier.getGroupId();
            String string4 = ticketItemModifier.getMultiplierName();
            boolean bl2 = bl = string == null || string2 == null || string3 == null;
            if (bl) {
                return null;
            }
            if (multiplier != null && !multiplier.getId().equals(string4)) {
                return null;
            }
            if (!string2.equals(string3) || !string.equals(menuModifier.getId())) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public List<TicketItemModifier> findTicketItemModifiersFor(MenuModifier menuModifier, Multiplier multiplier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        ArrayList<TicketItemModifier> arrayList = new ArrayList<TicketItemModifier>();
        if (list == null) {
            return arrayList;
        }
        for (TicketItemModifier ticketItemModifier : list) {
            String string = ticketItemModifier.getItemId();
            if (string == null || multiplier == null || !string.equals(menuModifier.getId()) || !multiplier.getId().equals(ticketItemModifier.getMultiplierName())) continue;
            arrayList.add(ticketItemModifier);
        }
        return arrayList;
    }

    public double findTicketItemModifierByMenuModifier(MenuModifier menuModifier) {
        if (menuModifier == null) {
            return 0.0;
        }
        double d = 0.0;
        List<Multiplier> list = DataProvider.get().getMultiplierList();
        if (list != null) {
            for (Multiplier multiplier : list) {
                List<TicketItemModifier> list2 = this.findTicketItemModifiersFor(menuModifier, multiplier);
                if (list2 == null || list2.isEmpty()) continue;
                for (TicketItemModifier ticketItemModifier : list2) {
                    d += ticketItemModifier.getItemQuantity().doubleValue();
                }
            }
        }
        return d;
    }

    public TicketItemModifier findTicketItemModifierFor(MenuModifier menuModifier, String string) {
        return this.findTicketItemModifierFor(menuModifier, string, null);
    }

    public TicketItemModifier findTicketItemModifierFor(MenuModifier menuModifier, String string, Multiplier multiplier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : list) {
            String string2 = ticketItemModifier.getItemId();
            if (multiplier != null && string2 != null && string2.equals(menuModifier.getId()) && string != null && string.equals(ticketItemModifier.getSectionName()) && multiplier != null && multiplier.getId().equals(ticketItemModifier.getMultiplierName())) {
                return ticketItemModifier;
            }
            if (string2 == null || !string2.equals(menuModifier.getId()) || string == null || !string.equals(ticketItemModifier.getSectionName())) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public int countModifierFromGroup(MenuItemModifierSpec menuItemModifierSpec) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return 0;
        }
        int n = 0;
        for (TicketItemModifier ticketItemModifier : list) {
            String string = ticketItemModifier.getGroupId();
            if (string == null || !string.equals(menuItemModifierSpec.getId())) continue;
            n = (int)((double)n + ticketItemModifier.getItemQuantity());
        }
        return n;
    }

    public boolean requiredModifiersAdded(MenuItemModifierSpec menuItemModifierSpec) {
        int n = menuItemModifierSpec.getMinQuantity();
        if (menuItemModifierSpec.isUseModifierGroupSettings()) {
            n = menuItemModifierSpec.getModifierGroup().getMinQuantity();
        }
        if (n == 0) {
            return true;
        }
        return this.countModifierFromGroup(menuItemModifierSpec) >= n;
    }

    public boolean deleteTicketItemModifier(TicketItemModifier ticketItemModifier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null || list.isEmpty()) {
            return false;
        }
        Iterator<TicketItemModifier> iterator = list.iterator();
        while (iterator.hasNext()) {
            TicketItemModifier ticketItemModifier2 = iterator.next();
            if (ticketItemModifier2 != ticketItemModifier) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean deleteTicketItemModifierByName(TicketItemModifier ticketItemModifier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return false;
        }
        Iterator<TicketItemModifier> iterator = list.iterator();
        while (iterator.hasNext()) {
            TicketItemModifier ticketItemModifier2 = iterator.next();
            if (!ticketItemModifier2.getName().equals(ticketItemModifier.getName())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public void setPizzaSectionMode(PIZZA_SECTION_MODE pIZZA_SECTION_MODE) {
        this.setPizzaSectionModeType(pIZZA_SECTION_MODE.getValue());
    }

    public PIZZA_SECTION_MODE getPizzaSectionMode() {
        return PIZZA_SECTION_MODE.from(this.getPizzaSectionModeType());
    }

    public TicketItemModifier findTicketItemModifierByPageItem(MenuModifier menuModifier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : list) {
            String string = ticketItemModifier.getPageItemId();
            if (string == null || !string.equals(menuModifier.getPageItemId())) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public TicketItemModifier findTicketItemComboModifierFor(MenuModifier menuModifier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return null;
        }
        for (TicketItemModifier ticketItemModifier : list) {
            String string = ticketItemModifier.getItemId();
            if (string == null || !string.equals(menuModifier.getId()) || ticketItemModifier.getModifierType() != 3) continue;
            return ticketItemModifier;
        }
        return null;
    }

    public TicketItemModifier removeTicketItemModifierByPageItem(TicketItemModifier ticketItemModifier) {
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list == null) {
            return ticketItemModifier;
        }
        Iterator<TicketItemModifier> iterator = list.iterator();
        while (iterator.hasNext()) {
            TicketItemModifier ticketItemModifier2 = iterator.next();
            String string = ticketItemModifier2.getPageItemId();
            if (string == null || !string.equals(ticketItemModifier.getPageItemId()) || ticketItemModifier2.getModifierType() != ticketItemModifier.getModifierType()) continue;
            iterator.remove();
            return ticketItemModifier2;
        }
        return ticketItemModifier;
    }

    public void removeTicketItemDiscount(TicketItemDiscount ticketItemDiscount) {
        List<TicketItemDiscount> list = this.getDiscounts();
        if (list == null) {
            return;
        }
        Iterator<TicketItemDiscount> iterator = list.iterator();
        while (iterator.hasNext()) {
            TicketItemDiscount ticketItemDiscount2 = iterator.next();
            if (ticketItemDiscount2.getTableRowNum() != ticketItemDiscount.getTableRowNum()) continue;
            iterator.remove();
            return;
        }
    }

    public boolean isInventoryAdjusted() {
        if (this.isTreatAsSeat().booleanValue()) {
            return false;
        }
        return this.getQuantity().doubleValue() == this.getInventoryAdjustQty().doubleValue();
    }

    public Boolean isIncludeVoidQuantity() {
        return this.includeVoidQuantity == null ? false : this.includeVoidQuantity;
    }

    public void setIncludeVoidQuantity(Boolean bl) {
        this.includeVoidQuantity = bl;
    }

    public void setVoidItem(VoidItem voidItem) {
        this.voidItem = voidItem;
        if (voidItem == null) {
            this.removeProperty(JSON_PROP_VOID_REASON);
            this.removeProperty(JSON_PROP_VOID_QUANTITY);
        }
    }

    @XmlTransient
    public VoidItem getVoidItem() {
        if (this.voidItem != null) {
            return this.voidItem;
        }
        String string = this.getProperty(JSON_PROP_VOID_REASON);
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        double d = POSUtil.parseDouble(this.getProperty(JSON_PROP_VOID_QUANTITY));
        if (d == 0.0) {
            return null;
        }
        this.voidItem = this.createVoidItem(string, POSUtil.getBoolean(this.getProperty(JSON_PROP_WASTED)), d);
        return this.voidItem;
    }

    public void markVoided(String string, boolean bl, double d, boolean bl2) {
        if (StringUtils.isEmpty((String)string)) {
            if (bl2) {
                throw new PosException(Messages.getString("Ticket.26"));
            }
            throw new PosException(Messages.getString("Ticket.23"));
        }
        this.setCreateDate(StoreDAO.getServerTimestamp());
        this.setVoidDate(StoreDAO.getServerTimestamp());
        double d2 = this.getQuantity();
        this.setQuantity(-1.0 * d);
        if (bl2) {
            this.setReturned(true);
        } else {
            this.setVoided(true);
        }
        List<TicketItemModifier> list = this.getTicketItemModifiers();
        if (list != null) {
            for (TicketItemModifier propertyContainer : list) {
                propertyContainer.setItemQuantity(-1.0 * propertyContainer.getItemQuantity());
            }
        }
        if (this.isComboItem().booleanValue() && this.getComboItems() != null) {
            for (TicketItem ticketItem : this.getComboItems()) {
                ticketItem.markVoided(string, bl, ticketItem.getQuantity() / d2 * d, bl2);
            }
        }
        this.setVoidProperties(string, bl, d);
    }

    public void markReturnedItemVoided(String string, boolean bl, double d) {
        this.setVoided(true);
        this.setVoidDate(StoreDAO.getServerTimestamp());
        this.setQuantity(d);
        this.setReturned(false);
        this.setVoidedItemId(this.getId());
        if (bl) {
            this.setInventoryAdjustQty(d);
        } else {
            this.setInventoryAdjustQty(0.0);
        }
        this.setPrintedToKitchen(false);
        this.setVoidProperties(string, bl, d);
        this.addProperty(JSON_PROP_RETURNED_ITEM_VOIDED, String.valueOf(true));
    }

    public void removeVoidProperties() {
        this.removeProperty(JSON_PROP_VOID_REASON);
        this.removeProperty(JSON_PROP_WASTED);
        this.removeProperty(JSON_PROP_VOID_QUANTITY);
        this.removeProperty(JSON_PROP_VOID_ID);
    }

    public void setVoidProperties(String string, boolean bl, double d) {
        this.setVoidProperties(string, bl, d, this.isPrintedToKitchen());
    }

    public void setVoidProperties(String string, boolean bl, double d, boolean bl2) {
        this.addProperty(JSON_PROP_VOID_REASON, string);
        this.addProperty(JSON_PROP_WASTED, String.valueOf(bl));
        this.addProperty(JSON_PROP_VOID_QUANTITY, String.valueOf(d));
        this.addProperty(JSON_PROP_PRINTED_TO_KITCHEN, String.valueOf(bl2));
        User user = PosAction.getAuthorizedUser() == null ? Application.getCurrentUser() : PosAction.getAuthorizedUser();
        this.addProperty(JSON_PROP_VOIDED_BY_USER, user.getId());
        this.setVoidReason(string);
        this.setItemWasted(bl);
    }

    public VoidItem createVoidItem(String string, boolean bl, double d) {
        TicketItem ticketItem = this.cloneAsNew();
        ticketItem.setQuantity(d);
        ticketItem.calculatePrice();
        VoidItem voidItem = new VoidItem();
        if (ticketItem.getTicket() != null) {
            voidItem.setTicketId(ticketItem.getTicket().getId());
        }
        voidItem.setVoidReason(string);
        voidItem.setItemId(ticketItem.getId());
        voidItem.setMenuItemId(ticketItem.getMenuItemId());
        voidItem.setMenuItemName(ticketItem.getName());
        voidItem.setUnitPrice(ticketItem.getUnitPrice());
        voidItem.setQuantity(d);
        voidItem.setItemWasted(bl);
        voidItem.setVoidDate(new Date());
        voidItem.setModifier(false);
        voidItem.setPrinterGroup(ticketItem.getPrinterGroup());
        User user = Application.getCurrentUser();
        voidItem.setVoidByUser(user);
        voidItem.setTerminal(Application.getInstance().getTerminal());
        if (user != null && user.getActiveCashDrawer() != null) {
            voidItem.setCashDrawerId(user.getActiveCashDrawer().getId());
        }
        voidItem.setTaxAmount(ticketItem.getTaxAmountWithoutModifiers());
        voidItem.setTotalPrice(ticketItem.getAdjustedTotalWithoutModifiers());
        double d2 = ticketItem.getQuantity();
        double d3 = voidItem.getQuantity();
        ArrayList<VoidItem> arrayList = new ArrayList<VoidItem>();
        if (ticketItem.isHasModifiers().booleanValue()) {
            for (TicketItemModifier ticketItemModifier : ticketItem.getTicketItemModifiers()) {
                VoidItem voidItem2 = new VoidItem();
                double d4 = ticketItemModifier.getItemQuantity() * d3 / d2;
                if (!(d4 > 0.0)) continue;
                String string2 = voidItem.getVoidReason();
                if (!StringUtils.isEmpty((String)string2)) {
                    voidItem2.setVoidReason(string2);
                }
                voidItem2.setModifierId(ticketItemModifier.getItemId());
                voidItem2.setItemId(ticketItemModifier.getId());
                voidItem2.setMenuItemName(ticketItemModifier.getNameDisplay());
                voidItem2.setUnitPrice(ticketItemModifier.getUnitPrice());
                voidItem2.setQuantity(d4);
                voidItem2.setItemWasted(voidItem.isItemWasted());
                voidItem2.setVoidDate(new Date());
                voidItem2.setModifier(true);
                voidItem2.setVoidByUser(user);
                voidItem2.setTerminal(Application.getInstance().getTerminal());
                if (user != null && user.getActiveCashDrawer() != null) {
                    voidItem2.setCashDrawerId(user.getActiveCashDrawer().getId());
                }
                voidItem2.setTaxAmount(ticketItemModifier.getTaxAmount());
                voidItem2.setTotalPrice(ticketItemModifier.getAdjustedSubtotal() + ticketItemModifier.getTaxAmount());
                voidItem2.setTicketId(voidItem.getTicketId());
                arrayList.add(voidItem2);
            }
        }
        voidItem.setVoidModifiers(arrayList);
        return voidItem;
    }

    @Override
    public boolean isSaved() {
        return this.getId() != null;
    }

    public boolean isRefundable() {
        return true;
    }

    public List<TicketItemCookingInstruction> getCookingInstructions() {
        if (this.cookingInstructions == null) {
            this.convertCookingInstructionPropertyToList();
        }
        return this.cookingInstructions;
    }

    public void convertCookingInstructionPropertyToList() {
        this.cookingInstructions = new ArrayList<TicketItemCookingInstruction>();
        String string = super.getCookingInstructionsProperty();
        if (StringUtils.isNotEmpty((String)string)) {
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(string));
            JsonArray jsonArray = jsonReader.readArray();
            jsonReader.close();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonObject jsonObject = (JsonObject)jsonArray.get(i);
                TicketItemCookingInstruction ticketItemCookingInstruction = new TicketItemCookingInstruction();
                ticketItemCookingInstruction.setDescription(JsonUtil.getString(jsonObject, TicketItemCookingInstruction.PROP_DESCRIPTION));
                ticketItemCookingInstruction.setPrintedToKitchen(JsonUtil.getBoolean(jsonObject, TicketItemCookingInstruction.PROP_PRINTED_TO_KITCHEN));
                ticketItemCookingInstruction.setSaved(JsonUtil.getBoolean(jsonObject, TicketItemCookingInstruction.PROP_SAVED));
                ticketItemCookingInstruction.setKitchenStatus(JsonUtil.getString(jsonObject, TicketItemCookingInstruction.PROP_KITCHEN_STATUS));
                ticketItemCookingInstruction.setParentItem(this);
                this.cookingInstructions.add(ticketItemCookingInstruction);
            }
        }
    }

    public PrinterGroup getPrinterGroup() {
        PrinterGroup printerGroup = DataProvider.get().getPrinterGroupById(this.getPrinterGroupId());
        if (printerGroup == null) {
            DataProvider.get().getDefaultPrinterGroup();
        }
        return printerGroup;
    }

    public void setPrinterGroup(PrinterGroup printerGroup) {
        String string = null;
        if (printerGroup != null) {
            string = printerGroup.getId();
        }
        super.setPrinterGroupId(string);
    }

    public TicketItem getParentTicketItem() {
        return this.parentTicketItem;
    }

    public void setParentTicketItem(TicketItem ticketItem) {
        this.parentTicketItem = ticketItem;
    }

    public List<TicketItem> getComboItems() {
        return null;
    }

    public void setComboItems(List<TicketItem> list) {
    }

    public void addTocomboItems(TicketItem ticketItem) {
    }

    public Integer getSortOrder() {
        if (this.sortOrder != null) {
            return this.sortOrder;
        }
        if (StringUtils.isEmpty((String)this.getCourseId())) {
            return 0;
        }
        Course course = DataProvider.get().getCourse(this.getCourseId());
        if (course != null) {
            return course.getSortOrder();
        }
        return 0;
    }

    public void setSortOrder(Integer n) {
        this.sortOrder = n;
    }

    public boolean isSyncEdited() {
        return this.syncEdited;
    }

    public void setSyncEdited(boolean bl) {
        this.syncEdited = bl;
    }

    @Override
    public void addProperty(String string, String string2) {
        this.initPropertyContainer();
        this.propertiesContainer.addProperty(string, string2);
        super.setProperties(this.propertiesContainer.toString());
    }

    @Override
    public String getProperty(String string) {
        JsonElement jsonElement;
        this.initPropertyContainer();
        if (this.propertiesContainer.has(string) && !(jsonElement = this.propertiesContainer.get(string)).isJsonNull()) {
            return jsonElement.getAsString();
        }
        return null;
    }

    @Override
    public boolean hasProperty(String string) {
        return this.getProperty(string) != null;
    }

    public boolean isPropertyValueTrue(String string) {
        String string2 = this.getProperty(string);
        return POSUtil.getBoolean(string2);
    }

    @Override
    public void removeProperty(String string) {
        this.initPropertyContainer();
        this.propertiesContainer.remove(string);
        super.setProperties(this.propertiesContainer.toString());
    }

    public void setUnitSelection(boolean bl) {
        this.addProperty("menuitem.allow_unit_selection", String.valueOf(bl));
    }

    public boolean isAllowUnitSelection() {
        String string = this.getProperty("menuitem.allow_unit_selection");
        if (StringUtils.isNotEmpty((String)string)) {
            return Boolean.parseBoolean(string);
        }
        return false;
    }

    public void setItemIsGiftCard(String string, double d) {
        this.setQuantity(1.0);
        this.setShouldPrintToKitchen(false);
        this.setInventoryItem(false);
        this.setTicketDiscountApplicable(false);
        this.setName(Messages.getString("GiftCardAddBalanceView.22"));
        this.setCategoryName(Messages.getString("GiftCard"));
        this.setGroupName(Messages.getString("GiftCard"));
        this.setUnitPrice(d);
        this.addProperty("isGiftCard", String.valueOf(true));
        this.addProperty("giftCardNo", string);
    }

    public boolean isGiftCard() {
        return Boolean.valueOf(this.getProperty("isGiftCard"));
    }

    public String getGiftCardNo() {
        return this.getProperty("giftCardNo");
    }

    public String getClassType() {
        return this.classType;
    }

    public void setClassType(String string) {
        this.classType = string;
    }

    public void setReturned(Boolean bl) {
        this.addProperty(JSON_PROP_RETURNED, String.valueOf(bl));
        super.setItemReturned(bl);
    }

    public boolean isReturned() {
        return Boolean.valueOf(this.getProperty(JSON_PROP_RETURNED));
    }

    public boolean isReturnedItemVoided() {
        return Boolean.valueOf(this.getProperty(JSON_PROP_RETURNED_ITEM_VOIDED));
    }

    public double getComboItemsPrice() {
        double d = 0.0;
        List<TicketItem> list = this.getComboItems();
        if (list != null) {
            for (TicketItem ticketItem : list) {
                if (ticketItem.getGroupId() != null) continue;
                d += ticketItem.getUnitPrice() * (ticketItem.getQuantity() / this.getQuantity());
            }
        }
        return d;
    }

    @XmlTransient
    public double getComboItemsModifierExtraPrice() {
        double d = 0.0;
        List<TicketItem> list = this.getComboItems();
        if (list != null) {
            for (TicketItem ticketItem : list) {
                ticketItem.calculatePrice();
                d += (ticketItem.getSubtotalAmount() - ticketItem.getSubtotalAmountWithoutModifiers()) / this.getQuantity();
            }
        }
        return d;
    }

    public double getGiftCardPaidAmount() {
        return POSUtil.parseDouble(this.getProperty(JSON_PROP_GIFT_CARD_PAID_AMOUNT));
    }

    public void setGiftCardPaidAmount(double d) {
        this.addProperty(JSON_PROP_GIFT_CARD_PAID_AMOUNT, String.valueOf(d));
    }

    public void setSplitted(boolean bl) {
        this.addProperty("splitted", String.valueOf(bl));
    }

    public boolean isSplitted() {
        return Boolean.valueOf(this.getProperty("splitted"));
    }

    private void initPropertyContainer() {
        if (this.propertiesContainer == null) {
            this.propertiesContainer = StringUtils.isBlank((String)super.getProperties()) ? new com.google.gson.JsonObject() : (com.google.gson.JsonObject)new Gson().fromJson(super.getProperties(), com.google.gson.JsonObject.class);
        }
    }

    public void setServiceChargeWithoutModifiers(double d) {
        this.addProperty(JSON_PROP_SC_WITHOUT_MODOFIERS, String.valueOf(d));
    }

    public double getServiceChargeWithoutModifiers() {
        return this.getDoubleProperty(JSON_PROP_SC_WITHOUT_MODOFIERS);
    }

    @Override
    public com.google.gson.JsonObject getPropertyStore() {
        this.initPropertyContainer();
        return this.propertiesContainer;
    }

    public boolean hasDiscount() {
        List<TicketItemDiscount> list = this.getDiscounts();
        return list != null && list.size() > 0;
    }

    @Override
    public Boolean isShouldPrintToKitchen() {
        if (this.getKitchenStatusValue() == KitchenStatus.BUMP) {
            return false;
        }
        return super.isShouldPrintToKitchen();
    }

    public void setCustomerRequired(boolean bl) {
        this.addProperty("service.customerRequired", String.valueOf(bl));
    }

    @XmlTransient
    @JsonIgnore
    public boolean isCustomerRequired() {
        return this.getBooleanProperty("service.customerRequired", false);
    }

    public void setPaymentType(ServicePaymentType servicePaymentType) {
        this.addProperty("service.paymentType", servicePaymentType == null ? null : servicePaymentType.name());
    }

    @XmlTransient
    @JsonIgnore
    public ServicePaymentType getPaymentType() {
        String string = this.getProperty("service.paymentType");
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        return ServicePaymentType.valueOf(string);
    }

    public void setServiceStartDate(Date date) {
        this.addProperty("service.startDate", date == null ? null : DateUtil.formatSyncTime(date));
    }

    @XmlTransient
    @JsonIgnore
    public Date getServiceStartDate() {
        String string = this.getProperty("service.startDate");
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        try {
            return DateUtil.parseSyncTime(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setServiceEndDate(Date date) {
        this.addProperty("service.endDate", date == null ? null : DateUtil.formatSyncTime(date));
    }

    @XmlTransient
    @JsonIgnore
    public Date getServiceEndDate() {
        String string = this.getProperty("service.endDate");
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        try {
            return DateUtil.parseSyncTime(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public boolean isKitchenPrintable() {
        return this.isShouldPrintToKitchen() != false && this.isPrintedToKitchen() == false && this.isItemReturned() == false && this.isTreatAsSeat() == false;
    }

    public boolean hasAmountTypeDiscount() {
        List<TicketItemDiscount> list = this.getDiscounts();
        if (list == null) {
            return false;
        }
        for (TicketItemDiscount ticketItemDiscount : list) {
            if (ticketItemDiscount.getType() != 0) continue;
            return true;
        }
        return false;
    }

    public TicketItem getOriginalItemForReturnedItem(TicketItem ticketItem) {
        String string = this.getVoidedItemId();
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        Ticket ticket = this.getTicket();
        if (ticket == null) {
            return null;
        }
        List<TicketItem> list = ticket.getTicketItems();
        for (TicketItem ticketItem2 : list) {
            if (!string.equals(ticketItem2.getId())) continue;
            return ticketItem2;
        }
        return null;
    }

    private double getTotalAmountTypeDiscount(TicketItem ticketItem) {
        if (ticketItem == null) {
            return 0.0;
        }
        List<TicketItemDiscount> list = ticketItem.getDiscounts();
        if (list == null) {
            return 0.0;
        }
        double d = 0.0;
        for (TicketItemDiscount ticketItemDiscount : list) {
            if (ticketItemDiscount.getType() != 0) continue;
            d += ticketItemDiscount.getAmountWithoutModifiers();
        }
        return d;
    }

    private double getPreviousAmountTypeDiscount(TicketItem ticketItem, String string) {
        if (ticketItem == null) {
            return 0.0;
        }
        List<TicketItemDiscount> list = ticketItem.getDiscounts();
        if (list == null) {
            return 0.0;
        }
        double d = 0.0;
        for (TicketItemDiscount ticketItemDiscount : list) {
            if (string.equals(ticketItemDiscount.getDiscountId())) {
                return d;
            }
            if (ticketItemDiscount.getType() != 0) continue;
            d += ticketItemDiscount.getValue().doubleValue();
        }
        return d;
    }

    public double getReturnableQuantity() {
        double d = this.getQuantity();
        Ticket ticket = this.getTicket();
        if (ticket == null) {
            return d;
        }
        List<TicketItem> list = ticket.getTicketItems();
        for (TicketItem ticketItem : list) {
            String string;
            if (ticketItem.isTreatAsSeat().booleanValue() || !StringUtils.isNotBlank((String)(string = ticketItem.getVoidedItemId())) || !string.equals(this.getId()) || !ticketItem.isItemReturned().booleanValue()) continue;
            d += ticketItem.getQuantity().doubleValue();
        }
        return Math.abs(d);
    }

    public void putUnitPriceWithoutModifierAfterDiscount(double d) {
        this.addProperty("uprice_wt_modifier_ad", String.valueOf(d));
    }

    @XmlTransient
    @JsonIgnore
    public Double getUnitPriceWithoutModifierAfterDiscount() {
        String string = this.getProperty("uprice_wt_modifier_ad");
        if (StringUtils.isBlank((String)string)) {
            return null;
        }
        return POSUtil.parseDouble(string);
    }

    public static enum PIZZA_SECTION_MODE {
        FULL(1),
        HALF(2),
        QUARTER(3);

        private final int value;

        private PIZZA_SECTION_MODE(int n2) {
            this.value = n2;
        }

        public int getValue() {
            return this.value;
        }

        public static PIZZA_SECTION_MODE from(int n) {
            if (n == 2) {
                return HALF;
            }
            if (n == 3) {
                return QUARTER;
            }
            return FULL;
        }

        public String toString() {
            return this.name();
        }
    }
}

