/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.dao.BaseInventoryVendorDAO;
import com.floreantpos.model.dao.InventoryVendorItemsDAO;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class InventoryVendorDAO
extends BaseInventoryVendorDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        this.updateTime(object);
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        this.updateTime(object);
        super.update(object, session);
    }

    @Override
    protected void delete(Object object, Session session) {
        if (object instanceof InventoryVendor) {
            InventoryVendor inventoryVendor = (InventoryVendor)object;
            inventoryVendor.setDeleted(Boolean.TRUE);
            super.update(inventoryVendor, session);
            InventoryVendorItemsDAO.getInstance().nullifyByInventoryVendor(inventoryVendor, session);
        } else {
            super.delete(object, session);
        }
    }

    @Override
    public List<InventoryVendor> findAll() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            List list = criteria.list();
            return list;
        }
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        this.updateTime(object);
        super.saveOrUpdate(object, session);
    }

    public void saveAll(List<InventoryVendor> list) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (InventoryVendor inventoryVendor : list) {
                session.saveOrUpdate((Object)inventoryVendor);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateInventoryVendors(List<InventoryVendor> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (InventoryVendor inventoryVendor : list) {
                InventoryVendor inventoryVendor2 = this.get(inventoryVendor.getId());
                if (inventoryVendor2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(inventoryVendor.getLastUpdateTime(), inventoryVendor2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), inventoryVendor.getName() + " already updated");
                        continue;
                    }
                    long l = inventoryVendor2.getVersion();
                    PropertyUtils.copyProperties((Object)inventoryVendor2, (Object)inventoryVendor);
                    inventoryVendor2.setVersion(l);
                    inventoryVendor2.setUpdateLastUpdateTime(bl);
                    inventoryVendor2.setUpdateSyncTime(bl2);
                    this.update(inventoryVendor2, session);
                    continue;
                }
                inventoryVendor.setUpdateLastUpdateTime(bl);
                inventoryVendor.setUpdateSyncTime(bl2);
                this.save(inventoryVendor, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<InventoryVendor> findByName(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)InventoryVendor.PROP_NAME, (Object)string).ignoreCase());
            List list = criteria.list();
            return list;
        }
    }

    public InventoryVendor findVendorByName(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)InventoryVendor.PROP_NAME, (Object)string).ignoreCase());
            List list = criteria.list();
            if (list.size() == 0) {
                InventoryVendor inventoryVendor = null;
                return inventoryVendor;
            }
            InventoryVendor inventoryVendor = (InventoryVendor)criteria.list().get(0);
            return inventoryVendor;
        }
    }

    public List<InventoryVendor> findAllEnabled() {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            this.addDeletedFilter(criteria);
            criteria.add((Criterion)Restrictions.eq((String)InventoryVendor.PROP_VISIBLE, (Object)Boolean.TRUE));
            List list = criteria.list();
            return list;
        }
    }
}

