/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.model.BalanceType;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Pagination;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.ReversalTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionSubType;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BasePosTransaction;
import com.floreantpos.model.base.BaseTicket;
import com.floreantpos.model.dao.BasePosTransactionDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.HibernateProjectionsUtil;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.CardTypeEnum;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.model.util.TransactionSummary;
import com.floreantpos.report.CustomerPaymentReportView;
import com.floreantpos.report.EndOfDayReportData;
import com.floreantpos.report.MemberAccountTransactionData;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.StoreUtil;
import com.orocube.rest.service.server.BaseDataServiceDao;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class PosTransactionDAO
extends BasePosTransactionDAO {
    @Override
    protected Serializable save(Object object, Session session) {
        PosTransaction posTransaction = (PosTransaction)object;
        if (StringUtils.isEmpty((String)posTransaction.getStoreSessionId())) {
            posTransaction.setStoreSessionId(DataProvider.get().getStoreSessionId());
        }
        if (posTransaction.getTransactionTime() == null) {
            posTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
        }
        return super.save(object, session);
    }

    @Override
    protected void update(Object object, Session session) {
        PosTransaction posTransaction = (PosTransaction)object;
        if (StringUtils.isEmpty((String)posTransaction.getStoreSessionId())) {
            posTransaction.setStoreSessionId(DataProvider.get().getStoreSessionId());
        }
        if (posTransaction.getTransactionTime() == null) {
            posTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
        }
        super.update(object, session);
    }

    @Override
    protected void saveOrUpdate(Object object, Session session) {
        PosTransaction posTransaction = (PosTransaction)object;
        if (StringUtils.isEmpty((String)posTransaction.getStoreSessionId())) {
            posTransaction.setStoreSessionId(DataProvider.get().getStoreSessionId());
        }
        if (posTransaction.getTransactionTime() == null) {
            posTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
        }
        super.saveOrUpdate(object, session);
    }

    public List<PosTransaction> findUnauthorizedTransactions() {
        return this.findUnauthorizedTransactions(null);
    }

    public List<PosTransaction> findUnauthorizedTransactions(User user) {
        List<String> list = new ArrayList<String>();
        if (user != null) {
            list = Arrays.asList(user.getId());
        }
        return this.findUnauthorizedTransactions(null, null, list);
    }

    public List<PosTransaction> findUnauthorizedTransactions(String string, Terminal terminal, List<String> list) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CAPTURED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_MARKED_CAPTURED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PosTransaction.PROP_MARKED_CAPTURED), (Criterion)Restrictions.eq((String)PosTransaction.PROP_MARKED_CAPTURED, (Object)Boolean.FALSE)));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_AUTHORIZABLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PosTransaction.PROP_VOIDED), (Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE)));
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            if (!StringUtils.isBlank((String)string)) {
                criteria.add(Restrictions.ilike((String)("ticket." + Ticket.PROP_ID), (String)string, (MatchMode)MatchMode.ANYWHERE));
            }
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            if (list != null && !list.isEmpty()) {
                criteria.add(Restrictions.in((String)PosTransaction.PROP_USER_ID, list));
            }
            List list2 = criteria.list();
            return list2;
        }
    }

    public List<PosTransaction> findCapturedTransactions(User user) {
        List<String> list = new ArrayList<String>();
        if (user != null) {
            list = Arrays.asList(user.getId());
        }
        return this.findCapturedTransactions(null, null, list);
    }

    public List<PosTransaction> findCapturedTransactions(String string, Terminal terminal, List<String> list) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(CreditCardTransaction.class);
            criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CAPTURED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.isNull((String)PosTransaction.PROP_VOIDED), (Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE)));
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            if (!StringUtils.isBlank((String)string)) {
                criteria.add(Restrictions.ilike((String)("ticket." + Ticket.PROP_ID), (String)string, (MatchMode)MatchMode.ANYWHERE));
            }
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            if (list != null && !list.isEmpty()) {
                criteria.add(Restrictions.in((String)PosTransaction.PROP_USER_ID, list));
            }
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -1);
            Date date = DateUtil.startOfDay(calendar.getTime());
            Date date2 = DateUtil.endOfDay(new Date());
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
            List list2 = criteria.list();
            return list2;
        }
    }

    public Boolean hasUnauthorizedTransactions(User user) {
        try (Session session = this.createNewSession();){
            Number number;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CAPTURED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_MARKED_CAPTURED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_AUTHORIZABLE, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)user.getId()));
            }
            Boolean bl = (number = (Number)criteria.uniqueResult()) != null && number.intValue() > 0;
            return bl;
        }
    }

    public List<? extends PosTransaction> findTransactions(Terminal terminal, Class clazz, Date date, Date date2) {
        return this.findTransactions(terminal, clazz, date, date2, true);
    }

    public List<? extends PosTransaction> findTransactions(Terminal terminal, Class clazz, Date date, Date date2, boolean bl) {
        return this.findTransactions(terminal, null, clazz, date, date2, bl);
    }

    public List<? extends PosTransaction> findTransactions(Terminal terminal, Outlet outlet, Class clazz, Date date, Date date2, boolean bl) {
        return this.findTransactions(terminal, outlet, clazz, date, date2, bl, false);
    }

    public List<? extends PosTransaction> findTransactions(Terminal terminal, Outlet outlet, Class clazz, Date date, Date date2, boolean bl, boolean bl2) {
        return this.findTransactions(terminal, outlet, clazz, date, date2, bl, bl2, false);
    }

    public List<? extends PosTransaction> findTransactions(Terminal terminal, Outlet outlet, Class clazz, Date date, Date date2, boolean bl, boolean bl2, boolean bl3) {
        return this.findTransactions(terminal, outlet, clazz, date, date2, bl, bl2, bl3, null, null);
    }

    public List<? extends PosTransaction> findTransactions(Terminal terminal, Outlet outlet, Class clazz, Date date, Date date2, boolean bl, boolean bl2, boolean bl3, PaymentType paymentType, CustomPayment customPayment) {
        return this.findTransactions(terminal, outlet, clazz, date, date2, bl, bl2, bl3, paymentType, customPayment, "");
    }

    public List<? extends PosTransaction> findTransactions(Terminal terminal, Outlet outlet, Class clazz, Date date, Date date2, boolean bl, boolean bl2, boolean bl3, PaymentType paymentType, CustomPayment customPayment, String string) {
        try (Session session = this.createNewSession();){
            Object object;
            SimpleExpression simpleExpression;
            Criteria criteria = session.createCriteria(clazz);
            if (bl) {
                criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            }
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            if (outlet != null) {
                // empty if block
            }
            if (bl3) {
                criteria.add(Restrictions.eqOrIsNull((String)PosTransaction.PROP_VOIDED, (Object)false));
            }
            if (paymentType != null) {
                if (PaymentType.CARD.equals((Object)paymentType)) {
                    simpleExpression = Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CREDIT_CARD.name());
                    object = Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.DEBIT_CARD.name());
                    criteria.add((Criterion)Restrictions.or((Criterion)simpleExpression, (Criterion)object));
                } else if (PaymentType.CUSTOM_PAYMENT.equals((Object)paymentType)) {
                    criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CUSTOM_PAYMENT.name()));
                } else if (PaymentType.MEMBER_ACCOUNT.equals((Object)paymentType)) {
                    criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.MEMBER_ACCOUNT.name()));
                }
            }
            if (customPayment != null) {
                simpleExpression = Restrictions.eq((String)PosTransaction.PROP_CUSTOM_PAYMENT_ID, (Object)customPayment.getId());
                object = Restrictions.eq((String)PosTransaction.PROP_CUSTOM_PAYMENT_NAME, (Object)customPayment.getName());
                criteria.add((Criterion)Restrictions.or((Criterion)simpleExpression, (Criterion)object));
            }
            if (date != null && date2 != null) {
                criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
            }
            if (StringUtils.isNotEmpty((String)string)) {
                simpleExpression = Restrictions.disjunction();
                simpleExpression.add(Restrictions.ilike((String)PosTransaction.PROP_CARD_AUTH_CODE, (String)string, (MatchMode)MatchMode.ANYWHERE));
                simpleExpression.add(Restrictions.ilike((String)PosTransaction.PROP_CUSTOM_PAYMENT_REF, (String)string, (MatchMode)MatchMode.ANYWHERE));
                criteria.add((Criterion)simpleExpression);
            }
            simpleExpression = Projections.projectionList();
            if (bl2) {
                simpleExpression.add((Projection)Projections.property((String)PosTransaction.PROP_ID), PosTransaction.PROP_ID);
            }
            simpleExpression.add((Projection)Projections.property((String)PosTransaction.PROP_TICKET), PosTransaction.PROP_TICKET);
            simpleExpression.add((Projection)Projections.property((String)PosTransaction.PROP_PAYMENT_TYPE_STRING), PosTransaction.PROP_PAYMENT_TYPE_STRING);
            simpleExpression.add((Projection)Projections.property((String)PosTransaction.PROP_CARD_TYPE), PosTransaction.PROP_CARD_TYPE);
            simpleExpression.add((Projection)Projections.property((String)PosTransaction.PROP_CARD_READER), PosTransaction.PROP_CARD_READER);
            simpleExpression.add((Projection)Projections.property((String)PosTransaction.PROP_TRANSACTION_TIME), PosTransaction.PROP_TRANSACTION_TIME);
            simpleExpression.add((Projection)Projections.property((String)PosTransaction.PROP_USER_ID), PosTransaction.PROP_USER_ID);
            simpleExpression.add((Projection)Projections.property((String)PosTransaction.PROP_CARD_AUTH_CODE), PosTransaction.PROP_CARD_AUTH_CODE);
            simpleExpression.add((Projection)Projections.property((String)PosTransaction.PROP_TIPS_AMOUNT), PosTransaction.PROP_TIPS_AMOUNT);
            simpleExpression.add((Projection)Projections.property((String)PosTransaction.PROP_AMOUNT), PosTransaction.PROP_AMOUNT);
            simpleExpression.add((Projection)Projections.property((String)PosTransaction.PROP_TERMINAL_ID), PosTransaction.PROP_TERMINAL_ID);
            simpleExpression.add((Projection)Projections.property((String)PosTransaction.PROP_TRANSACTION_TYPE), PosTransaction.PROP_TRANSACTION_TYPE);
            simpleExpression.add((Projection)Projections.property((String)PosTransaction.PROP_CUSTOM_PAYMENT_NAME), PosTransaction.PROP_CUSTOM_PAYMENT_NAME);
            simpleExpression.add((Projection)Projections.property((String)CustomerAccountTransaction.PROP_CUSTOMER_ID), CustomerAccountTransaction.PROP_CUSTOMER_ID);
            simpleExpression.add((Projection)Projections.property((String)PosTransaction.PROP_CUSTOM_PAYMENT_REF), PosTransaction.PROP_CUSTOM_PAYMENT_REF);
            simpleExpression.add((Projection)Projections.property((String)PosTransaction.PROP_CUSTOM_PAYMENT_FIELD_NAME), PosTransaction.PROP_CUSTOM_PAYMENT_FIELD_NAME);
            simpleExpression.add((Projection)Projections.property((String)PosTransaction.PROP_EXTRA_PROPERTIES), PosTransaction.PROP_EXTRA_PROPERTIES);
            criteria.setProjection((Projection)simpleExpression);
            criteria.setResultTransformer(Transformers.aliasToBean((Class)clazz));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_TRANSACTION_TIME));
            Object object2 = object = criteria.list();
            return object2;
        }
    }

    public List<PosTransaction> findReceived(Terminal terminal, Date date, Date date2) {
        try (Session session = this.createNewSession();){
            List list;
            Criteria criteria = session.createCriteria(PosTransaction.class);
            criteria.createAlias(PosTransaction.PROP_TICKET, "t");
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria.add(Restrictions.eqOrIsNull((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_VOIDED), (Object)Boolean.FALSE));
            List list2 = list = criteria.list();
            return list2;
        }
    }

    public TransactionSummary getTransactionSummary(Terminal terminal, Class clazz, Date date, Date date2) {
        TransactionSummary transactionSummary = new TransactionSummary();
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(clazz);
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_DRAWER_RESETTED, (Object)Boolean.FALSE));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            if (date != null && date2 != null) {
                criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
                criteria.add((Criterion)Restrictions.le((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            }
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.count((String)PosTransaction.PROP_ID));
            projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
            projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
            criteria.setProjection((Projection)projectionList);
            List list = criteria.list();
            if (list == null || list.size() == 0) {
                TransactionSummary transactionSummary2 = transactionSummary;
                return transactionSummary2;
            }
            Object[] objectArray = (Object[])list.get(0);
            int n = 0;
            transactionSummary.setCount(HibernateProjectionsUtil.getInt(objectArray, n++));
            transactionSummary.setAmount(HibernateProjectionsUtil.getDouble(objectArray, n++));
            transactionSummary.setTipsAmount(HibernateProjectionsUtil.getDouble(objectArray, n++));
            TransactionSummary transactionSummary3 = transactionSummary;
            return transactionSummary3;
        }
    }

    public List<PosTransaction> getStoreSessionTransactions(StoreSession storeSession) {
        try (Session session = this.createNewSession();){
            List<String> list = CashDrawerDAO.getInstance().getCashDrawerIds(storeSession);
            if (list == null || list.isEmpty()) {
                List<PosTransaction> list2 = null;
                return list2;
            }
            Criteria criteria = session.createCriteria(this.getReferenceClass(), "t");
            criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
            criteria.add((Criterion)Restrictions.eq((String)"ticket.closed", (Object)true));
            criteria.add((Criterion)Restrictions.eq((String)"ticket.voided", (Object)false));
            criteria.add(Restrictions.in((String)PosTransaction.PROP_CASH_DRAWER_ID, list));
            List list3 = criteria.list();
            return list3;
        }
    }

    public void saveReversalTransaction(Ticket ticket, PosTransaction posTransaction, ReversalTransaction reversalTransaction) {
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            this.delete(posTransaction, session);
            this.saveOrUpdate(reversalTransaction, session);
            TicketDAO.getInstance().update(ticket, session);
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                PosLog.error(PosTransactionService.class, exception2);
            }
            throw exception;
        }
    }

    public List<PosTransaction> findPayments(Date date, Date date2, User user) {
        return this.findPayments(date, date2, user, false);
    }

    public List<PosTransaction> findPayments(Date date, Date date2, User user, boolean bl) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            List list;
            criteria = session.createCriteria(PosTransaction.class);
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)bl));
            if (bl) {
                criteria.add(Restrictions.between((String)PosTransaction.PROP_VOID_DATE, (Object)date, (Object)date2));
            } else {
                criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
            }
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            this.addMultiUserFilter(user, criteria);
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_PAYMENT_TYPE_STRING), PosTransaction.PROP_PAYMENT_TYPE_STRING);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_CUSTOM_PAYMENT_NAME), PosTransaction.PROP_CUSTOM_PAYMENT_NAME);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_USER_ID), PosTransaction.PROP_USER_ID);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_ID), PosTransaction.PROP_ID);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_TRANSACTION_TIME), PosTransaction.PROP_TRANSACTION_TIME);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_AMOUNT), PosTransaction.PROP_AMOUNT);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_TICKET), PosTransaction.PROP_TICKET);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_TRANSACTION_TYPE), PosTransaction.PROP_TRANSACTION_TYPE);
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_VOID_DATE), PosTransaction.PROP_VOID_DATE);
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(PosTransaction.class));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_USER_ID));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_PAYMENT_TYPE_STRING));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_TRANSACTION_TIME));
            List list2 = list = criteria.list();
            return list2;
        }
    }

    public List<PosTransaction> getCloudStoreSessionTransactions(StoreSession storeSession) {
        try (Session session = this.createNewSession();){
            List<String> list = CashDrawerDAO.getInstance().getCashDrawerIds(storeSession);
            if (list == null || list.isEmpty()) {
                List<PosTransaction> list2 = null;
                return list2;
            }
            Criteria criteria = session.createCriteria(this.getReferenceClass(), "t");
            criteria.add(Restrictions.in((String)PosTransaction.PROP_CASH_DRAWER_ID, list));
            List list3 = criteria.list();
            return list3;
        }
    }

    private void addMultiUserFilter(User user, Criteria criteria) {
        if (user != null) {
            PosLog.info(this.getClass(), Messages.getString("PosTransactionDAO.5") + user.getFullName() + Messages.getString("PosTransactionDAO.6") + user.getId());
            Disjunction disjunction = Restrictions.disjunction();
            disjunction.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)(user == null ? null : user.getId())));
            List<User> list = user.getLinkedUser();
            if (list != null) {
                for (User user2 : list) {
                    if (user2.getId().equals(user.getId())) continue;
                    PosLog.info(this.getClass(), Messages.getString("PosTransactionDAO.7") + user2.getFullName() + Messages.getString("PosTransactionDAO.8") + user2.getId());
                    disjunction.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)user2.getId()));
                }
            }
            criteria.add((Criterion)disjunction);
        }
    }

    public List<CustomerPaymentReportView.CustomerAccountTransactionItem> findCustomerAccountTransactions(Date date, Date date2, String string) {
        try (Session session = this.createNewSession();){
            String string2 = "select t.%s, t.%s, t.%s, t.%s, t.%s, t.%s, t.%s, t.%s, t.%s, c.%s from PosTransaction as t, Customer as c where t.%s=c.%s and t.%s between :fromDate and :toDate and t.%s=false and t.%s is not null";
            string2 = String.format(string2, PosTransaction.PROP_ID, PosTransaction.PROP_TICKET, PosTransaction.PROP_TRANSACTION_TIME, PosTransaction.PROP_TIPS_AMOUNT, PosTransaction.PROP_AMOUNT, PosTransaction.PROP_CUSTOMER_ID, PosTransaction.PROP_TRANSACTION_TYPE, PosTransaction.PROP_PAYMENT_TYPE_STRING, PosTransaction.PROP_CUSTOM_PAYMENT_NAME, Customer.PROP_NAME, PosTransaction.PROP_CUSTOMER_ID, Customer.PROP_ID, PosTransaction.PROP_TRANSACTION_TIME, PosTransaction.PROP_VOIDED, PosTransaction.PROP_TICKET);
            if (StringUtils.isNotBlank((String)string)) {
                string2 = string2 + " and ( LOWER(c.name) like '%" + string.toLowerCase() + "%'";
                string2 = string2 + " or ";
                string2 = string2 + " LOWER(c." + Customer.PROP_EMAIL + ") like '%" + string.toLowerCase() + "%' )";
            }
            Query query = session.createQuery(string2);
            query.setTimestamp("fromDate", DateUtil.toUTC(date));
            query.setTimestamp("toDate", DateUtil.toUTC(date2));
            List list = query.list();
            ArrayList<CustomerPaymentReportView.CustomerAccountTransactionItem> arrayList = new ArrayList<CustomerPaymentReportView.CustomerAccountTransactionItem>();
            for (Object[] objectArray : list) {
                CustomerPaymentReportView.CustomerAccountTransactionItem customerAccountTransactionItem = new CustomerPaymentReportView.CustomerAccountTransactionItem();
                customerAccountTransactionItem.setTransactionNo(String.valueOf(objectArray[0]));
                Ticket ticket = (Ticket)objectArray[1];
                customerAccountTransactionItem.setTicketNo(ticket.getId());
                customerAccountTransactionItem.setDate((Date)objectArray[2]);
                customerAccountTransactionItem.setTips((double)((Double)objectArray[3]));
                customerAccountTransactionItem.setTotalAmount((double)((Double)objectArray[4]));
                customerAccountTransactionItem.setCustomerId(String.valueOf(objectArray[5]));
                customerAccountTransactionItem.setTransactionType(String.valueOf(objectArray[6]));
                customerAccountTransactionItem.setPaymentTypeName(String.valueOf(objectArray[7]));
                customerAccountTransactionItem.setCustomPaymentName(String.valueOf(objectArray[8]));
                customerAccountTransactionItem.setCustomerName(String.valueOf(objectArray[9]));
                arrayList.add(customerAccountTransactionItem);
            }
            ArrayList<CustomerPaymentReportView.CustomerAccountTransactionItem> arrayList2 = arrayList;
            return arrayList2;
        }
    }

    public List<MemberAccountTransactionData> findMemberAccountTransactions(Date date, Date date2, String string, Boolean bl) {
        try (Session session = this.createNewSession();){
            Object object;
            String string2;
            String string3 = "select t.%s, t.%s, t.%s, t.%s, t.%s, t.%s, t.%s, t.%s, t.%s, c.%s, c.%s from PosTransaction as t, Customer as c where t.%s=c.%s and t.%s between :fromDate and :toDate and t.%s=false and t.%s is not null";
            string3 = String.format(string3, PosTransaction.PROP_ID, PosTransaction.PROP_TICKET, PosTransaction.PROP_TRANSACTION_TIME, PosTransaction.PROP_TIPS_AMOUNT, PosTransaction.PROP_AMOUNT, PosTransaction.PROP_CUSTOMER_ID, PosTransaction.PROP_TRANSACTION_TYPE, PosTransaction.PROP_PAYMENT_TYPE_STRING, PosTransaction.PROP_CUSTOM_PAYMENT_NAME, Customer.PROP_NAME, Customer.PROP_MEMBER_ID, PosTransaction.PROP_CUSTOMER_ID, Customer.PROP_ID, PosTransaction.PROP_TRANSACTION_TIME, PosTransaction.PROP_VOIDED, PosTransaction.PROP_TICKET);
            if (StringUtils.isNotBlank((String)string)) {
                string3 = string3 + " and ( LOWER(c.name) like '%" + string.toLowerCase() + "%'";
                string3 = string3 + " or ";
                string3 = string3 + " LOWER(c." + Customer.PROP_EMAIL + ") like '%" + string.toLowerCase() + "%' )";
            }
            if (bl != null && StringUtils.isNotBlank((String)(string2 = DataProvider.get().getStore().getProperty("cust.salesforce.this_club_code", "")))) {
                object = "select " + Customer.PROP_ID + " from Customer ";
                object = (String)object + " where " + Customer.PROP_MEMBER_ID + " like '" + string2 + "%'";
                string3 = bl != false ? string3 + " and t." + PosTransaction.PROP_CUSTOMER_ID + " in (" + (String)object + ")" : string3 + " and t." + PosTransaction.PROP_CUSTOMER_ID + " not in (" + (String)object + ")";
            }
            string3 = string3 + " order by c." + Customer.PROP_NAME;
            string2 = session.createQuery(string3);
            string2.setTimestamp("fromDate", DateUtil.toUTC(date));
            string2.setTimestamp("toDate", DateUtil.toUTC(date2));
            object = string2.list();
            ArrayList<MemberAccountTransactionData> arrayList = new ArrayList<MemberAccountTransactionData>();
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                Object[] objectArray = (Object[])object2.next();
                MemberAccountTransactionData memberAccountTransactionData = new MemberAccountTransactionData();
                memberAccountTransactionData.setTransactionNo(String.valueOf(objectArray[0]));
                Ticket ticket = (Ticket)objectArray[1];
                memberAccountTransactionData.setTicketNo(ticket.getId());
                memberAccountTransactionData.setDate((Date)objectArray[2]);
                memberAccountTransactionData.setTips((double)((Double)objectArray[3]));
                memberAccountTransactionData.setTotalAmount((double)((Double)objectArray[4]));
                memberAccountTransactionData.setTransactionType(String.valueOf(objectArray[6]));
                memberAccountTransactionData.setPaymentTypeName(String.valueOf(objectArray[7]));
                memberAccountTransactionData.setCustomPaymentName(String.valueOf(objectArray[8]));
                memberAccountTransactionData.setCustomerName(String.valueOf(objectArray[9]));
                Object object3 = objectArray[10];
                memberAccountTransactionData.setMemberId(object3 == null ? "" : String.valueOf(object3));
                arrayList.add(memberAccountTransactionData);
            }
            object2 = arrayList;
            return object2;
        }
    }

    public List<PosTransaction> findTransactionsForCashDrawer(String string, boolean bl) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass(), "t");
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CASH_DRAWER_ID, (Object)string));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)bl));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_PAYMENT_TYPE_STRING));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_TRANSACTION_TIME));
            List list = criteria.list();
            return list;
        }
    }

    public List<PosTransaction> findTransactionsForServer(String string, String string2) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)string2));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)string));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)false));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_PAYMENT_TYPE_STRING));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_TRANSACTION_TIME));
            List list = criteria.list();
            return list;
        }
    }

    public List<String> getDistinctCardMmerchantGateway(String string, Integer n) {
        List list = null;
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)string));
            }
            if (n != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TERMINAL_ID, (Object)n));
            }
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, -3);
            criteria.add((Criterion)Restrictions.gt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)calendar.getTime()));
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_CARD_MERCHANT_GATEWAY));
            criteria.setProjection(Projections.distinct((Projection)Projections.property((String)PosTransaction.PROP_CARD_MERCHANT_GATEWAY)));
            list = criteria.list();
        }
        return list;
    }

    public List<PosTransaction> findTransactionsForSession(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_STORE_SESSION_ID, (Object)string));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)false));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_PAYMENT_TYPE_STRING));
            criteria.addOrder(Order.asc((String)PosTransaction.PROP_TRANSACTION_TIME));
            List list = criteria.list();
            return list;
        }
    }

    @Deprecated
    public String findLastTxPaymentTypeName(Ticket ticket) {
        if (StringUtils.isEmpty((String)ticket.getId())) {
            return null;
        }
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)false));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TICKET, (Object)ticket));
            criteria.addOrder(Order.desc((String)PosTransaction.PROP_TRANSACTION_TIME));
            criteria.setMaxResults(1);
            criteria.setProjection((Projection)Projections.property((String)PosTransaction.PROP_PAYMENT_TYPE_STRING));
            String string = (String)criteria.uniqueResult();
            if (StringUtils.isNotEmpty((String)string)) {
                String string2 = PaymentType.valueOf(string).getDisplayString();
                return string2;
            }
            String string3 = null;
            return string3;
        }
    }

    public List<PosTransaction> getTransactionsByOutlet(Date date, Date date2, Outlet outlet, Pagination pagination) {
        Criteria criteria = null;
        try (Session session = this.createNewSession();){
            Object object;
            criteria = session.createCriteria(this.getReferenceClass());
            if (pagination != null) {
                criteria.setFirstResult(pagination.getCurrentRowIndex());
                criteria.setMaxResults(pagination.getPageSize());
            }
            this.updateCriteria(criteria, date, date2, outlet);
            List list = criteria.list();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            this.updateCriteria(criteria, date, date2, outlet);
            if (pagination != null) {
                object = (Number)criteria.uniqueResult();
                pagination.setNumRows(((Number)object).intValue());
            }
            pagination.setRows(list);
            object = list;
            return object;
        }
    }

    private void updateCriteria(Criteria criteria, Date date, Date date2, Outlet outlet) {
        if (date != null && date2 != null) {
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
        }
        if (outlet != null) {
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_OUTLET_ID, (Object)outlet.getId()));
        }
    }

    public void savePosTransaction(PosTransaction posTransaction, List<PosTransaction> list, Session session) {
        if (list == null || list.size() == 0) {
            return;
        }
        PosTransaction posTransaction2 = null;
        int n = list.indexOf(posTransaction);
        if (n != -1) {
            posTransaction2 = list.get(n);
            if (posTransaction2 == null) {
                this.save(posTransaction, session);
            } else {
                posTransaction.setVersion(posTransaction2.getVersion());
            }
        } else {
            this.save(posTransaction, session);
        }
    }

    public void saveOrUpdatePosTransactions(List<PosTransaction> list) throws Exception {
        this.saveOrUpdatePosTransactions(list, false, true);
    }

    public void saveOrUpdatePosTransactions(List<PosTransaction> list, boolean bl, boolean bl2) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        try (Session session = this.createNewSession();){
            transaction = session.beginTransaction();
            for (PosTransaction posTransaction : list) {
                PosTransaction posTransaction2 = this.get(posTransaction.getId());
                if (posTransaction2 != null) {
                    if (!BaseDataServiceDao.get().shouldSave(posTransaction.getLastUpdateTime(), posTransaction2.getLastUpdateTime())) {
                        PosLog.info(this.getClass(), posTransaction.getId() + " already updated");
                        continue;
                    }
                    String string = posTransaction2.getId();
                    long l = posTransaction2.getVersion();
                    PropertyUtils.copyProperties((Object)posTransaction2, (Object)posTransaction);
                    posTransaction2.setId(string);
                    posTransaction2.setVersion(l);
                    posTransaction2.setUpdateLastUpdateTime(bl);
                    posTransaction2.setUpdateSyncTime(bl2);
                    this.update(posTransaction2, session);
                    continue;
                }
                posTransaction.setUpdateLastUpdateTime(bl);
                posTransaction.setUpdateSyncTime(bl2);
                this.save(posTransaction, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            PosLog.error(this.getClass(), exception);
            throw exception;
        }
    }

    public void savePosTransactions(List<PosTransaction> list) throws Exception {
        if (list == null) {
            return;
        }
        for (PosTransaction posTransaction : list) {
            Transaction transaction = null;
            try (Session session = null;){
                session = this.createNewSession();
                transaction = session.beginTransaction();
                PaymentType paymentType = posTransaction.getPaymentType();
                PosTransaction posTransaction2 = this.get(posTransaction.getId());
                if (posTransaction2 == null) {
                    posTransaction2 = paymentType.createTransaction();
                    PropertyUtils.copyProperties((Object)posTransaction2, (Object)posTransaction);
                    if (StringUtils.isEmpty((String)posTransaction2.getStoreSessionId())) {
                        posTransaction2.setStoreSessionId(StoreUtil.getCurrentStoreSession().getId());
                    }
                    this.save(posTransaction2, session);
                }
                transaction.commit();
            }
        }
    }

    public double findTransactionsAmountByDate(Date date) {
        double d = 0.0;
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(PosTransaction.class);
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)DateUtil.startOfDay(date), (Object)DateUtil.endOfDay(date)));
            criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
            Object object = criteria.uniqueResult();
            if (object != null && object instanceof Number) {
                d = ((Number)object).doubleValue();
            }
            criteria = session.createCriteria(RefundTransaction.class);
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)DateUtil.startOfDay(date), (Object)DateUtil.endOfDay(date)));
            criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
            object = criteria.uniqueResult();
            if (object != null && object instanceof Number) {
                d -= ((Number)object).doubleValue();
            }
            PosLog.info(this.getReferenceClass(), Messages.getString("PosTransactionDAO.0") + date + Messages.getString("PosTransactionDAO.14") + d);
            double d2 = NumberUtil.round(d);
            return d2;
        }
    }

    private Double findTransactionsAmountByHour(Session session, Integer n, PaymentType paymentType) {
        try {
            Calendar calendar = Calendar.getInstance();
            Date date = calendar.getTime();
            calendar.add(10, -(n == null ? 24 : n));
            Date date2 = calendar.getTime();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            Criteria criteria2 = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria2.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
            if (paymentType != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)paymentType.name()));
                criteria2.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)paymentType.name()));
            }
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2, (Object)date));
            criteria2.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2, (Object)date));
            criteria.add(Restrictions.eqOrIsNull((String)PosTransaction.PROP_VOIDED, (Object)false));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT));
            criteria.setProjection((Projection)projectionList);
            criteria2.setProjection((Projection)projectionList);
            Number number = (Number)criteria.uniqueResult();
            Number number2 = (Number)criteria2.uniqueResult();
            if (number == null) {
                number = 0.0;
            }
            if (number2 == null) {
                number2 = 0.0;
            }
            return number.doubleValue() - number2.doubleValue();
        }
        catch (Exception exception) {
            PosLog.error(this.getReferenceClass(), exception);
            return 0.0;
        }
    }

    public Double findTotalTransactionsAmountByHour(Session session, Integer n) {
        return this.findTransactionsAmountByHour(session, n, null);
    }

    public Double findCashTransactionsAmountByHour(Session session, Integer n) {
        return this.findTransactionsAmountByHour(session, n, PaymentType.CASH);
    }

    public Double findCreditCardTransactionsAmountByHour(Session session, Integer n) {
        return this.findTransactionsAmountByHour(session, n, PaymentType.CREDIT_CARD);
    }

    public Map<Date, Double> findTransactionsAmntGroupByDate(Date date, Date date2) {
        try (Session session = this.createNewSession();){
            Map<Date, Double> map = this.findTransactionsAmntGroupByDate(date, date2, session);
            return map;
        }
    }

    public Map<Date, Double> findTransactionsAmntGroupByDate(Date date, Date date2, Session session) {
        try {
            Double d;
            Date date3;
            Criteria criteria = session.createCriteria(PosTransaction.class);
            Criteria criteria2 = session.createCriteria(PosTransaction.class);
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria2.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.DEBIT.name()));
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)DateUtil.startOfDay(date), (Object)DateUtil.endOfDay(date2)));
            criteria2.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)DateUtil.startOfDay(date), (Object)DateUtil.endOfDay(date2)));
            criteria.add(Restrictions.eqOrIsNull((String)PosTransaction.PROP_VOIDED, (Object)false));
            ProjectionList projectionList = Projections.projectionList();
            Projection projection = Projections.sqlGroupProjection((String)"date(transaction_time) as transaction_time, sum(amount) as amount", (String)"date(transaction_time)", (String[])new String[]{"transaction_time", "amount"}, (Type[])new Type[]{StandardBasicTypes.DATE, StandardBasicTypes.DOUBLE});
            projectionList.add(projection);
            criteria.setProjection((Projection)projectionList);
            criteria2.setProjection((Projection)projectionList);
            List list = criteria.list();
            List list2 = criteria2.list();
            TreeMap<Date, Double> treeMap = new TreeMap<Date, Double>(new Comparator<Date>(){

                @Override
                public int compare(Date date, Date date2) {
                    return date.compareTo(date2);
                }
            });
            if (list != null) {
                for (Object[] objectArray : list) {
                    if (objectArray == null || objectArray[0] == null || objectArray[1] == null) continue;
                    date3 = (Date)objectArray[0];
                    d = (Double)objectArray[1];
                    treeMap.put(date3, d);
                }
            }
            if (list2 != null) {
                for (Object[] objectArray : list2) {
                    if (objectArray == null || objectArray[0] == null || objectArray[1] == null) continue;
                    date3 = (Date)objectArray[0];
                    d = (Double)treeMap.get(date3);
                    if (d == null) {
                        d = 0.0;
                    }
                    d = d - (Double)objectArray[1];
                    treeMap.put(date3, d);
                }
            }
            return treeMap;
        }
        catch (Exception exception) {
            PosLog.error(this.getReferenceClass(), exception);
            return null;
        }
    }

    public Map<PaymentType, PosTransaction> findAmountByPaymentTypes(Session session, Date date, Date date2, Integer n) {
        HashMap<PaymentType, PosTransaction> hashMap = new HashMap<PaymentType, PosTransaction>();
        try {
            Criteria criteria = session.createCriteria(PosTransaction.class);
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TRANSACTION_TYPE, (Object)TransactionType.CREDIT.name()));
            criteria.add(Restrictions.eqOrIsNull((String)PosTransaction.PROP_VOIDED, (Object)false));
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.groupProperty((String)PosTransaction.PROP_PAYMENT_TYPE_STRING), PosTransaction.PROP_PAYMENT_TYPE_STRING);
            projectionList.add((Projection)Projections.sum((String)PosTransaction.PROP_AMOUNT), PosTransaction.PROP_AMOUNT);
            criteria.setProjection((Projection)projectionList);
            criteria.setMaxResults(n == null ? 10 : n);
            criteria.addOrder(Order.desc((String)PosTransaction.PROP_AMOUNT));
            criteria.setResultTransformer(Transformers.aliasToBean(PosTransaction.class));
            List list = criteria.list();
            if (list != null) {
                list.forEach(posTransaction -> hashMap.put(posTransaction.getPaymentType(), (PosTransaction)posTransaction));
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getReferenceClass(), exception);
        }
        return hashMap;
    }

    public static Disjunction createMasterCardSearchCriteria() {
        SimpleExpression simpleExpression = Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.MASTER_CARD.name()).ignoreCase();
        SimpleExpression simpleExpression2 = Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.MASTER_CARD.name().replaceAll("_", "")).ignoreCase();
        SimpleExpression simpleExpression3 = Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.MASTER_CARD.name().replaceAll("_", " ")).ignoreCase();
        return Restrictions.or((Criterion[])new Criterion[]{simpleExpression, simpleExpression2, simpleExpression3});
    }

    public static void createOthersCardSearchCriteria(Criteria criteria) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(CardTypeEnum.VISA.name());
        arrayList.add(CardTypeEnum.MASTER_CARD.name());
        arrayList.add(CardTypeEnum.MASTER_CARD.name().replaceAll("_", ""));
        arrayList.add(CardTypeEnum.MASTER_CARD.name().replaceAll("_", " "));
        arrayList.add(CardTypeEnum.AMERICAN_EXPRESS.name());
        arrayList.add(CardTypeEnum.AMERICAN_EXPRESS.name().replaceAll("_", ""));
        arrayList.add(CardTypeEnum.AMERICAN_EXPRESS.name().replaceAll("_", " "));
        arrayList.add(CardTypeEnum.DISCOVER.name());
        for (String string : arrayList) {
            criteria.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_CARD_TYPE, (Object)string).ignoreCase());
        }
    }

    public static Disjunction createAmexOrAmericanExpCardSearchCriteria() {
        SimpleExpression simpleExpression = Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.AMERICAN_EXPRESS.name()).ignoreCase();
        SimpleExpression simpleExpression2 = Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.AMERICAN_EXPRESS.name().replaceAll("_", "")).ignoreCase();
        SimpleExpression simpleExpression3 = Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)CardTypeEnum.AMERICAN_EXPRESS.name().replaceAll("_", " ")).ignoreCase();
        SimpleExpression simpleExpression4 = Restrictions.eq((String)PosTransaction.PROP_CARD_TYPE, (Object)"AMEX").ignoreCase();
        return Restrictions.or((Criterion[])new Criterion[]{simpleExpression, simpleExpression2, simpleExpression3, simpleExpression4});
    }

    @Deprecated
    public List<EndOfDayReportData> findEndOfDayReportData(Date date, Date date2, List<OrderType> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, EndOfDayReportData> hashMap2 = new HashMap<String, EndOfDayReportData>();
        List<String> list2 = POSUtil.getStringIds(list, OrderType.class);
        ArrayList<EndOfDayReportData> arrayList = new ArrayList<EndOfDayReportData>();
        try (Session session = this.createNewSession();){
            Object object;
            ArrayList<EndOfDayReportData> arrayList22;
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add(Restrictions.between((String)Ticket.PROP_CREATE_DATE, (Object)date, (Object)date2));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
            if (list != null && !list.isEmpty()) {
                criteria.add(Restrictions.in((String)Ticket.PROP_ORDER_TYPE_ID, list2));
            }
            criteria.addOrder(Order.asc((String)Ticket.PROP_CREATE_DATE));
            List list3 = criteria.list();
            for (ArrayList<EndOfDayReportData> arrayList22 : list3) {
                object = this.createEndOfDateReportData(hashMap, (Ticket)((Object)arrayList22));
                arrayList.add((EndOfDayReportData)object);
                hashMap2.put(((BaseTicket)((Object)arrayList22)).getId(), (EndOfDayReportData)object);
            }
            criteria = session.createCriteria(PosTransaction.class);
            criteria.createAlias("ticket", "t");
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
            criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_VOIDED), (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
            if (list != null && !list.isEmpty()) {
                criteria.add(Restrictions.in((String)("t." + Ticket.PROP_ORDER_TYPE_ID), list2));
            }
            List list4 = criteria.list();
            arrayList22 = list4.iterator();
            while (arrayList22.hasNext()) {
                object = (PosTransaction)arrayList22.next();
                String string = ((PosTransaction)object).getTicketId();
                EndOfDayReportData endOfDayReportData = (EndOfDayReportData)hashMap2.get(string);
                if (endOfDayReportData == null) {
                    Ticket ticket = TicketDAO.getInstance().get(string);
                    if (ticket == null) continue;
                    endOfDayReportData = this.createEndOfDateReportData(hashMap, ticket);
                    endOfDayReportData.setTotalTicketAmount(0.0);
                    endOfDayReportData.setGrossSelesAmount(0.0);
                    endOfDayReportData.setTaxAmount(0.0);
                    endOfDayReportData.setServiceCharge(0.0);
                    endOfDayReportData.setGratuityAmount(0.0);
                    endOfDayReportData.setDiscount(0.0);
                    arrayList.add(endOfDayReportData);
                    hashMap2.put(ticket.getId(), endOfDayReportData);
                }
                if (object instanceof RefundTransaction) {
                    endOfDayReportData.setTaxReceived(((BasePosTransaction)object).getTaxAmount() + endOfDayReportData.getTaxReceived());
                    endOfDayReportData.setTotalReceived(-1.0 * ((BasePosTransaction)object).getAmount() + endOfDayReportData.getTotalReceived());
                    endOfDayReportData.setRefundPaymentCredit(((BasePosTransaction)object).getAmount() + endOfDayReportData.getRefundPaymentCredit());
                    continue;
                }
                ((BasePosTransaction)object).setTransactionTime(endOfDayReportData.getTicketCreateDate());
                if (object instanceof PayOutTransaction || object instanceof CashDropTransaction) continue;
                if (((PosTransaction)object).getPaymentType() == PaymentType.CASH) {
                    endOfDayReportData.setTaxReceived(((BasePosTransaction)object).getTaxAmount() + endOfDayReportData.getTaxReceived());
                    endOfDayReportData.setTotalReceived(((BasePosTransaction)object).getAmount() + endOfDayReportData.getTotalReceived());
                    endOfDayReportData.setCashPaymentCredit(((BasePosTransaction)object).getAmount() + endOfDayReportData.getCashPaymentCredit());
                    continue;
                }
                if (((PosTransaction)object).getPaymentType() == PaymentType.CREDIT_CARD) {
                    endOfDayReportData.setTaxReceived(((BasePosTransaction)object).getTaxAmount() + endOfDayReportData.getTaxReceived());
                    endOfDayReportData.setTotalReceived(((BasePosTransaction)object).getAmount() + endOfDayReportData.getTotalReceived());
                    endOfDayReportData.setCreditCardPaymentCredit(((BasePosTransaction)object).getAmount() + endOfDayReportData.getCreditCardPaymentCredit());
                    continue;
                }
                if (((PosTransaction)object).getPaymentType() == PaymentType.MEMBER_ACCOUNT) {
                    endOfDayReportData.setTaxReceived(((BasePosTransaction)object).getTaxAmount() + endOfDayReportData.getTaxReceived());
                    endOfDayReportData.setTotalReceived(((BasePosTransaction)object).getAmount() + endOfDayReportData.getTotalReceived());
                    endOfDayReportData.setMemberChargeCredit(((BasePosTransaction)object).getAmount() + endOfDayReportData.getMemberChargeCredit());
                    continue;
                }
                endOfDayReportData.setTaxReceived(((BasePosTransaction)object).getTaxAmount() + endOfDayReportData.getTaxReceived());
                endOfDayReportData.setTotalReceived(((BasePosTransaction)object).getAmount() + endOfDayReportData.getTotalReceived());
                endOfDayReportData.setOthersPaymentCredit(((BasePosTransaction)object).getAmount() + endOfDayReportData.getOthersPaymentCredit());
            }
            Collections.sort(arrayList, new Comparator<EndOfDayReportData>(){

                @Override
                public int compare(EndOfDayReportData endOfDayReportData, EndOfDayReportData endOfDayReportData2) {
                    return endOfDayReportData.getEmployeeId().compareTo(endOfDayReportData2.getEmployeeId());
                }
            });
            arrayList22 = arrayList;
            return arrayList22;
        }
    }

    @Deprecated
    public List<EndOfDayReportData> findTicketsGroupedByEmployee(Date date, Date date2, List<OrderType> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            for (OrderType serializable2 : list) {
                arrayList.add(serializable2.getId());
            }
        }
        Throwable throwable = null;
        try (Session session = this.createNewSession();){
            Object object;
            Object object22;
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add(Restrictions.between((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date, (Object)date2));
            criteria.createAlias("ticket", "t");
            if (list != null) {
                criteria.add(Restrictions.in((String)("t." + Ticket.PROP_ORDER_TYPE_ID), arrayList));
            }
            ProjectionList projectionList = Projections.projectionList();
            projectionList.add((Projection)Projections.property((String)("t." + Ticket.PROP_OWNER_ID)), "employeeId");
            projectionList.add((Projection)Projections.property((String)("t." + Ticket.PROP_CUSTOMER_ID)), "customerId");
            projectionList.add((Projection)Projections.property((String)("t." + Ticket.PROP_ID)), "ticketId");
            projectionList.add((Projection)Projections.property((String)("t." + Ticket.PROP_SUBTOTAL_AMOUNT)), "netAmount");
            projectionList.add((Projection)Projections.property((String)("t." + Ticket.PROP_TAX_AMOUNT)), "taxAmount");
            projectionList.add((Projection)Projections.property((String)("t." + Ticket.PROP_SERVICE_CHARGE)), "serviceCharge");
            projectionList.add((Projection)Projections.property((String)("t." + Ticket.PROP_DISCOUNT_AMOUNT)), "discount");
            projectionList.add((Projection)Projections.property((String)("t." + Ticket.PROP_TOTAL_AMOUNT)), "totalTicketAmount");
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_AMOUNT), "totalTransactionAmount");
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_PAYMENT_TYPE_STRING), "paymentType");
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_TRANSACTION_TYPE), "transactionType");
            projectionList.add((Projection)Projections.property((String)PosTransaction.PROP_TIPS_AMOUNT), "gratuityAmount");
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(EndOfDayReportData.class));
            List list2 = criteria.list();
            if (list2 != null && list2.size() > 0) {
                for (Object object22 : list2) {
                    if (((EndOfDayReportData)object22).getPaymentType().equalsIgnoreCase(PaymentType.CASH.name())) {
                        object = ((EndOfDayReportData)object22).getTotalTransactionAmount();
                        if (((EndOfDayReportData)object22).getTransactionType().equalsIgnoreCase(TransactionType.DEBIT.name())) {
                            ((EndOfDayReportData)object22).setRefundPaymentCredit(-1.0 * (Double)object);
                            continue;
                        }
                        ((EndOfDayReportData)object22).setCashPaymentCredit((Double)object);
                        continue;
                    }
                    if (((EndOfDayReportData)object22).getPaymentType().equalsIgnoreCase(PaymentType.CREDIT_CARD.name())) {
                        object = ((EndOfDayReportData)object22).getTotalTransactionAmount();
                        if (((EndOfDayReportData)object22).getTransactionType().equalsIgnoreCase(TransactionType.DEBIT.name())) {
                            ((EndOfDayReportData)object22).setRefundPaymentCredit(-1.0 * (Double)object);
                            continue;
                        }
                        ((EndOfDayReportData)object22).setCreditCardPaymentCredit((Double)object);
                        continue;
                    }
                    if (((EndOfDayReportData)object22).getPaymentType().equalsIgnoreCase(PaymentType.MEMBER_ACCOUNT.name())) {
                        object = ((EndOfDayReportData)object22).getTotalTransactionAmount();
                        if (((EndOfDayReportData)object22).getTransactionType().equalsIgnoreCase(TransactionType.DEBIT.name())) {
                            ((EndOfDayReportData)object22).setRefundPaymentCredit(-1.0 * (Double)object);
                            continue;
                        }
                        ((EndOfDayReportData)object22).setMemberChargeCredit((Double)object);
                        continue;
                    }
                    object = ((EndOfDayReportData)object22).getTotalTransactionAmount();
                    if (((EndOfDayReportData)object22).getTransactionType().equalsIgnoreCase(TransactionType.DEBIT.name())) {
                        ((EndOfDayReportData)object22).setRefundPaymentCredit(-1.0 * (Double)object);
                        continue;
                    }
                    ((EndOfDayReportData)object22).setOthersPaymentCredit((Double)object);
                }
            }
            ArrayList arrayList2 = new ArrayList();
            object22 = new HashMap();
            object = list2.iterator();
            while (object.hasNext()) {
                EndOfDayReportData endOfDayReportData = (EndOfDayReportData)object.next();
                EndOfDayReportData endOfDayReportData2 = (EndOfDayReportData)object22.get(endOfDayReportData.getTicketId());
                if (endOfDayReportData2 == null) {
                    Comparable comparable;
                    if (endOfDayReportData.getEmployeeId() != null) {
                        comparable = UserDAO.getInstance().get(endOfDayReportData.getEmployeeId());
                        endOfDayReportData.setEmployeeName(comparable == null ? "" : ((User)comparable).getFullName());
                    }
                    if (endOfDayReportData.getCustomerId() != null) {
                        comparable = CustomerDAO.getInstance().get(endOfDayReportData.getCustomerId());
                        endOfDayReportData.setCustomerName(comparable == null ? "" : ((Customer)comparable).getName());
                    }
                    object22.put(endOfDayReportData.getTicketId(), endOfDayReportData);
                    continue;
                }
                endOfDayReportData2.setCashPaymentCredit(endOfDayReportData.getCashPaymentCredit() + endOfDayReportData2.getCashPaymentCredit());
                endOfDayReportData2.setRefundPaymentCredit(endOfDayReportData.getRefundPaymentCredit() + endOfDayReportData2.getRefundPaymentCredit());
                endOfDayReportData2.setCreditCardPaymentCredit(endOfDayReportData.getCreditCardPaymentCredit() + endOfDayReportData2.getCreditCardPaymentCredit());
                endOfDayReportData2.setMemberChargeCredit(endOfDayReportData.getMemberChargeCredit() + endOfDayReportData2.getMemberChargeCredit());
                endOfDayReportData2.setOthersPaymentCredit(endOfDayReportData.getOthersPaymentCredit() + endOfDayReportData2.getOthersPaymentCredit());
                object.remove();
            }
            arrayList2.addAll(object22.values());
            object = arrayList2;
            return object;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
    }

    public static CashDrawer populateCashDrawerReportSummary(List<CashDrawer> list) {
        CashDrawer cashDrawer = new CashDrawer();
        if (list != null) {
            for (CashDrawer cashDrawer2 : list) {
                cashDrawer.setBeginCash(cashDrawer.getBeginCash() + cashDrawer2.getBeginCash());
            }
        }
        return cashDrawer;
    }

    private EndOfDayReportData createEndOfDateReportData(Map<String, String> map, Ticket ticket) {
        Customer customer;
        EndOfDayReportData endOfDayReportData = new EndOfDayReportData();
        endOfDayReportData.setEmployeeId(ticket.getOwnerId());
        endOfDayReportData.setTicketId(ticket.getId());
        endOfDayReportData.setTicketCreateDate(ticket.getCreateDate());
        endOfDayReportData.setGrossSelesAmount(ticket.getSubtotalAmount());
        endOfDayReportData.setTaxAmount(ticket.getTaxAmount());
        endOfDayReportData.setServiceCharge(ticket.getServiceCharge());
        endOfDayReportData.setDiscount(ticket.getDiscountAmount());
        endOfDayReportData.setTotalTicketAmount(ticket.getTotalAmount());
        endOfDayReportData.setGratuityAmount(ticket.getGratuityAmount());
        String string = ticket.getCustomerId();
        String string2 = "";
        if (StringUtils.isNotEmpty((String)string) && (string2 = map.get(string)) == null && (customer = CustomerDAO.getInstance().get(string)) != null) {
            map.put(string, customer.getMemberId());
            string2 = customer.getMemberId();
            endOfDayReportData.setCustomerName(customer.getName());
        }
        endOfDayReportData.setCustomerId(string);
        endOfDayReportData.setMemberId(string2);
        return endOfDayReportData;
    }

    public List<RefundTransaction> findRefundTransactions(Terminal terminal, Date date, Date date2) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(RefundTransaction.class);
            criteria.createAlias(PosTransaction.PROP_TICKET, "t");
            criteria.add(Restrictions.isNotNull((String)PosTransaction.PROP_TICKET));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            criteria.add((Criterion)Restrictions.ge((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date));
            criteria.add((Criterion)Restrictions.lt((String)PosTransaction.PROP_TRANSACTION_TIME, (Object)date2));
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)("t." + Ticket.PROP_VOIDED), (Object)Boolean.FALSE));
            List list = criteria.list();
            return list;
        }
    }

    public double getTipsAmount(String string) {
        try (Session session = this.createNewSession();){
            double d = this.getTipsAmount(string, session);
            return d;
        }
    }

    public double getTipsAmount(String string, Session session) {
        Criteria criteria = session.createCriteria(PosTransaction.class);
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_TICKET, (Object)new Ticket(string)));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        return POSUtil.getDoubleAmount(criteria.uniqueResult());
    }

    public double calculateTipsByUser(Date date, Date date2, User user, Boolean bl) {
        try (Session session = this.createNewSession();){
            double d = this.calculateTipsByUser(session, date, date2, user, bl);
            return d;
        }
    }

    public double calculateTipsByUser(Session session, Date date, Date date2, User user, Boolean bl) {
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.createAlias(Ticket.PROP_GRATUITY, "g");
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
        if (user != null) {
            criteria.add((Criterion)Restrictions.eq((String)("g." + Gratuity.PROP_OWNER_ID), (Object)user.getId()));
        }
        criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
        criteria.add((Criterion)Restrictions.lt((String)Ticket.PROP_CREATE_DATE, (Object)date2));
        criteria.setProjection(Projections.distinct((Projection)Projections.property((String)Ticket.PROP_ID)));
        List list = criteria.list();
        if (list.isEmpty()) {
            return 0.0;
        }
        Criteria criteria2 = session.createCriteria(PosTransaction.class);
        criteria2.createAlias(PosTransaction.PROP_TICKET, "t");
        criteria2.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        if (bl != null) {
            if (bl.booleanValue()) {
                criteria2.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
            } else {
                criteria2.add((Criterion)Restrictions.ne((String)PosTransaction.PROP_PAYMENT_TYPE_STRING, (Object)PaymentType.CASH.name()));
            }
        }
        criteria2.add(Restrictions.in((String)("t." + Ticket.PROP_ID), (Collection)list));
        criteria2.setProjection((Projection)Projections.sum((String)PosTransaction.PROP_TIPS_AMOUNT));
        criteria2.list();
        return POSUtil.getDoubleAmount(criteria2.uniqueResult());
    }

    public List<BalanceUpdateTransaction> findMemberAccountTransactionsV2(List<String> list, Date date, Date date2, boolean bl) {
        try (Session session = this.createNewSession();){
            Object object;
            Criteria criteria = session.createCriteria(BalanceUpdateTransaction.class);
            criteria.add((Criterion)Restrictions.eq((String)BalanceUpdateTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)BalanceUpdateTransaction.PROP_BALANCE_TYPE_STRING, (Object)BalanceType.CUSTOMER.name()));
            if (bl) {
                object = Restrictions.eq((String)BalanceUpdateTransaction.PROP_TRANSACTION_SUB_TYPE, (Object)TransactionSubType.SALES.name());
                SimpleExpression simpleExpression = Restrictions.eq((String)BalanceUpdateTransaction.PROP_TRANSACTION_SUB_TYPE, (Object)TransactionSubType.VOIDED_SALES.name());
                criteria.add((Criterion)Restrictions.or((Criterion)object, (Criterion)simpleExpression));
            }
            criteria.add(Restrictions.between((String)BalanceUpdateTransaction.PROP_TRANSACTION_TIME, (Object)DateUtil.startOfDay(date), (Object)DateUtil.endOfDay(date2)));
            if (!list.isEmpty()) {
                criteria.add(Restrictions.in((String)BalanceUpdateTransaction.PROP_ACCOUNT_NUMBER, list));
            }
            criteria.addOrder(Order.asc((String)BalanceUpdateTransaction.PROP_ACCOUNT_NUMBER));
            criteria.addOrder(Order.asc((String)BalanceUpdateTransaction.PROP_TRANSACTION_TIME));
            object = criteria.list();
            return object;
        }
    }

    public boolean isExistsCardTransactionId(String string) {
        try (Session session = this.createNewSession();){
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_CARD_TRANSACTION_ID, (Object)string));
            Number number = (Number)criteria.uniqueResult();
            boolean bl = number != null && number.intValue() > 0;
            return bl;
        }
    }
}

