/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.print;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CategoryBreakOut;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.DrawerPullVoidEntry;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.ReceiptParam;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.base.BaseKitchenTicketItem;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.print.AwtReceiptPrinter;
import com.floreantpos.print.ITextPrinter;
import com.floreantpos.print.PrinterType;
import com.floreantpos.print.ReceiptPrintServiceProvider;
import com.floreantpos.report.AbstractReportDataSource;
import com.floreantpos.report.KitchenTicketDataSource;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.TicketDataSource;
import com.floreantpos.report.TicketPrintProperties;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import io.github.escposjava.PrinterService;
import io.github.escposjava.print.Commands;
import io.github.escposjava.print.NetworkPrinter;
import io.github.escposjava.print.SerialPortPrinter;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;

public class EscPosPrintService
extends ReceiptPrintServiceProvider {
    public static final int COL_RIGHT_FIELD_LENGTH = 13;
    public int totalCharLength;
    public int colLeftFieldLength;

    @Override
    public void printTicket(Ticket ticket, HashMap hashMap, String string) throws Exception {
        this.a(string, (Map<String, Object>)hashMap, ticket, new TicketDataSource(ticket, false));
    }

    @Override
    public void printTransaction(Ticket ticket, HashMap hashMap, PosTransaction posTransaction, String string) throws Exception {
        this.a(string, (Map<String, Object>)hashMap, ticket, posTransaction, new TicketDataSource(ticket, false));
    }

    @Override
    public void printVoidTicket(Ticket ticket, HashMap hashMap, String string) throws Exception {
        this.a(string, (Map<String, Object>)hashMap, ticket, new TicketDataSource(ticket, false));
    }

    @Override
    public void printKitchenTicket(KitchenTicket kitchenTicket, HashMap hashMap, Ticket ticket, String string, String string2) throws Exception {
        this.a(string2, (Map<String, Object>)hashMap, ticket, new KitchenTicketDataSource(kitchenTicket));
    }

    @Override
    public void printVoidKitchenTicket(KitchenTicket kitchenTicket, HashMap hashMap, String string, String string2) throws Exception {
        this.a(string2, (Map<String, Object>)hashMap, null, new KitchenTicketDataSource(kitchenTicket));
    }

    @Override
    public void rendererTicketReceipt(Ticket ticket, JPanel jPanel) throws Exception {
        TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(null, false, true, true);
        HashMap<String, Object> hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, null, false, false, true);
        ReportUtil.populateDemoLicenseMessage(hashMap);
        ITextPrinter iTextPrinter = ITextPrinter.create();
        iTextPrinter.createReport(null, hashMap, new TicketDataSource(ticket));
        iTextPrinter.rendererReport(jPanel);
    }

    @Override
    public void rendererPosTransactionReceipt(PosTransaction posTransaction, JPanel jPanel) throws Exception {
        try {
            Object object;
            Ticket ticket = posTransaction.getTicket();
            TicketPrintProperties ticketPrintProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.3"), true, true, true);
            ticketPrintProperties.setPrintCookingInstructions(false);
            HashMap<String, Object> hashMap = ReceiptPrintService.populateTicketProperties(ticket, ticketPrintProperties, posTransaction, false, false, true);
            hashMap.put("IS_IGNORE_PAGINATION", true);
            if (posTransaction != null && posTransaction.isCard()) {
                object = CardReader.fromString(posTransaction.getCardReader());
                if (object == CardReader.EXTERNAL_TERMINAL) {
                    return;
                }
                hashMap.put("copyType", Messages.getString("ReceiptPrintService.5"));
            }
            object = ITextPrinter.create();
            object.createReport(null, posTransaction, hashMap, new TicketDataSource(ticket));
            object.rendererReport(jPanel);
        }
        catch (Exception exception) {
            ReceiptPrintService.getLogger().error((Object)POSConstants.PRINT_ERROR, (Throwable)exception);
        }
    }

    @Override
    public void rendererKitchenReceipt(Ticket ticket, JPanel jPanel) throws Exception {
        block0: {
            List<KitchenTicket> list = KitchenTicket.fromTicket(ticket, false);
            Iterator<KitchenTicket> iterator = list.iterator();
            if (!iterator.hasNext()) break block0;
            KitchenTicket kitchenTicket = iterator.next();
            kitchenTicket.setParentTicket(ticket);
            HashMap hashMap = ReceiptPrintService.populateKitchenTicketProperties(kitchenTicket, "", "", true, true);
            ITextPrinter iTextPrinter = ITextPrinter.create();
            iTextPrinter.createReport(null, hashMap, new KitchenTicketDataSource(kitchenTicket));
            iTextPrinter.rendererReport(jPanel);
        }
    }

    private void a(String string, Map<String, Object> map, Ticket ticket, AbstractReportDataSource abstractReportDataSource) throws Exception {
        this.a(string, map, ticket, null, abstractReportDataSource);
    }

    private void a(String string, Map<String, Object> map, Ticket ticket, PosTransaction posTransaction, AbstractReportDataSource abstractReportDataSource) throws Exception {
        Object object6;
        Object object2;
        ReportUtil.populateDemoLicenseMessage(map);
        this.a(map);
        PrinterService printerService = this.createPrintService(string, map);
        Object object3 = map.get("beep_after_print_to_kitchen_is_done ");
        if (object3 != null && Boolean.valueOf(object3.toString()).booleanValue()) {
            printerService.beep();
        }
        if ((object2 = map.get("headerLine1.font-weight")) == null || StringUtils.isBlank((String)object2.toString())) {
            this.addBoldText(printerService, map, "headerLine1", Commands.TXT_ALIGN_CT);
        } else {
            this.addText(printerService, map, "headerLine1", Commands.TXT_ALIGN_CT);
        }
        this.addText(printerService, map, "ticketHeader", Commands.TXT_ALIGN_CT);
        this.a(printerService);
        this.addText(printerService, map, "additionalOrderInfo", Commands.TXT_ALIGN_LT);
        if (abstractReportDataSource instanceof KitchenTicketDataSource) {
            this.c(printerService);
        } else {
            this.b(printerService);
        }
        Store store = DataProvider.get().getStore();
        List list = abstractReportDataSource.getRows();
        if (list != null) {
            AbstractReportDataSource abstractReportDataSource2;
            this.b(map, printerService, "orderDetails");
            if (abstractReportDataSource instanceof TicketDataSource) {
                this.a(printerService, map, "orderDetails", (byte[])null);
                abstractReportDataSource2 = (TicketDataSource)abstractReportDataSource;
                for (Object object4 : list) {
                    if (StringUtils.isEmpty((String)object4.getNameDisplay())) continue;
                    this.a(printerService, ((TicketDataSource)abstractReportDataSource2).getColorCode(store, (ITicketItem)object4));
                    Object object5 = object6 = this.getText(object4.getNameDisplay(), "left", this.colLeftFieldLength);
                    String string2 = object4.getSubTotalAmountDisplay();
                    if (StringUtils.isNotEmpty((String)string2)) {
                        int n;
                        if (object4 instanceof ComboTicketItem && (n = ((String)object6).indexOf("\n")) != -1) {
                            printerService.printRight(this.a(this.getText(((String)object6).substring(0, n), "left", this.colLeftFieldLength), this.colLeftFieldLength, string2));
                            this.a(printerService);
                            String[] stringArray = ((String)object6).substring(n).split("\n");
                            if (stringArray.length <= 0) continue;
                            for (String string3 : stringArray) {
                                if (StringUtils.isBlank((String)string3)) continue;
                                printerService.printRight(this.a(this.getText(string3, "left", this.colLeftFieldLength), this.colLeftFieldLength, " "));
                                this.a(printerService);
                            }
                            continue;
                        }
                        object5 = ((String)object6).length() > this.colLeftFieldLength ? this.a((String)object6, this.colLeftFieldLength, string2) : (String)object5 + this.getText(string2, "right", 13);
                    } else {
                        object5 = (String)object5 + this.getText(" ", "right", 13);
                    }
                    printerService.printRight((String)object5);
                    this.a(printerService);
                }
            } else if (abstractReportDataSource instanceof KitchenTicketDataSource) {
                abstractReportDataSource2 = (KitchenTicketDataSource)abstractReportDataSource;
                int n = 0;
                for (Object object6 : list) {
                    if (StringUtils.isEmpty((String)((KitchenTicketItem)object6).getMenuItemNameDisplay())) continue;
                    if (!((BaseKitchenTicketItem)object6).isModifierItem().booleanValue() && !((BaseKitchenTicketItem)object6).isCookingInstruction().booleanValue() && n > 0) {
                        printerService.write(Commands.TXT_NORMAL);
                        this.c(printerService);
                    }
                    this.a(printerService, map, "orderDetails", new byte[]{27, 33, 22});
                    this.a(printerService, ((KitchenTicketDataSource)abstractReportDataSource2).getColorCode((KitchenTicketItem)object6, ((BaseKitchenTicketItem)object6).getKitchenTicket().getOrderTypeId()));
                    printerService.printLeft(((KitchenTicketItem)object6).getMenuItemNameDisplay());
                    printerService.lineBreak();
                    ++n;
                }
                printerService.write(Commands.TXT_NORMAL);
                this.c(printerService);
            }
        }
        printerService.setTextColor(Commands.COLOR_BLACK);
        printerService.setTextNormal();
        printerService.write(Commands.TXT_NORMAL);
        if (abstractReportDataSource instanceof TicketDataSource) {
            boolean bl;
            this.b(printerService);
            this.b(map, printerService, "orderDetails");
            this.a(printerService, map, "orderDetails", (byte[])null);
            this.a(printerService, map, "totalText", "grandSubtotal", false);
            this.a(printerService, map, "discountText", "discountAmount");
            boolean bl2 = Boolean.parseBoolean(String.valueOf(map.get("isShowTaxBreakdown")));
            if (!bl2) {
                this.a(printerService, map, "taxText", "taxAmount");
            } else {
                this.a(ticket, printerService);
            }
            this.a(printerService, map, POSConstants.LABEL_ROUNDING, "roundingAmount", true);
            this.a(printerService, map, "serviceChargeText", "serviceCharge");
            this.a(printerService, map, "deliveryChargeText", "deliveryCharge");
            this.a(printerService, map, "feeAmountText", "feeAmount");
            printerService.setTextNormal();
            printerService.write(Commands.TXT_NORMAL);
            this.b(printerService);
            this.b(map, printerService, "orderDetails");
            this.a(printerService, map, "orderDetails", (byte[])null);
            this.a(printerService, map, "netAmountText", "netAmount", false);
            if (map.get("tipAmount") != null) {
                this.a(printerService, map, "tipsText", "tipAmount");
                printerService.setTextNormal();
                printerService.write(Commands.TXT_NORMAL);
                this.b(printerService);
                this.b(map, printerService, "orderDetails");
                this.a(printerService, map, "orderDetails", (byte[])null);
                this.a(printerService, map, "grandNetAmountText", "grandNetAmount");
            }
            this.a(printerService);
            this.a(ticket, posTransaction, printerService);
            if (map.get("dueAmount") != null) {
                this.a(printerService, map, "dueAmountText", "dueAmount", false);
            }
            boolean bl3 = ReceiptPrintService.isEnabledMulticurrency(ticket);
            if (posTransaction != null && posTransaction.getChangeAmount() > 0.0 && !bl3) {
                this.a(printerService, map, "changeAmountText", "changeAmount");
            }
            if (map.get("showTips") != null && posTransaction != null) {
                this.a(printerService);
                this.addText(printerService, map, "showTips", Commands.TXT_ALIGN_CT);
            }
            if (bl3) {
                boolean bl4;
                boolean bl5 = bl4 = posTransaction != null && posTransaction instanceof RefundTransaction && map.get("refundAmount") != null;
                if (!bl4 && (object6 = ReceiptPrintService.buildAllMultiCurrency(map, ticket, posTransaction, true)) != null) {
                    map.put("additionalProperties", ((StringBuilder)object6).toString());
                }
            }
            this.addText(printerService, map, "additionalProperties", Commands.TXT_ALIGN_RT);
            boolean bl6 = Boolean.parseBoolean(String.valueOf(map.get("cardPayment")));
            boolean bl7 = bl = bl6 && Boolean.parseBoolean(String.valueOf(map.get("showTipsBlock")));
            if (bl && posTransaction != null) {
                this.b(printerService, this.getText(Messages.getString("EscPosPrintService.4"), "left", this.colLeftFieldLength));
                this.b(printerService, this.getText(Messages.getString("EscPosPrintService.5"), "left", this.colLeftFieldLength));
                this.b(printerService, this.getText(Messages.getString("EscPosPrintService.6"), "left", this.colLeftFieldLength));
            }
            if (bl6) {
                this.addText(printerService, map, "approvalCode", Commands.TXT_ALIGN_LT);
            }
            this.addText(printerService, map, "bottomMessage", Commands.TXT_ALIGN_LT);
            this.a(printerService);
            this.addText(printerService, map, "copyType", Commands.TXT_ALIGN_CT);
            this.addText(printerService, map, "footerMessage", Commands.TXT_ALIGN_CT);
        } else {
            this.addText(printerService, map, "printerName", Commands.TXT_ALIGN_LT);
            this.addText(printerService, map, "bottomMessage", Commands.TXT_ALIGN_LT);
            this.addText(printerService, map, "footerMessage", Commands.TXT_ALIGN_CT);
        }
        printerService.lineBreak(3);
        this.close(printerService);
    }

    public PrinterService createPrintService(String string, Map<String, Object> map) {
        String string2 = EscPosPrintService.valueOf(map.get("printerType"));
        PrinterService printerService = null;
        printerService = string2.equals(PrinterType.NETWORK.getName()) ? new PrinterService(EscPosPrintService.getNetworkPrinter(map)) : (string2.equals(PrinterType.SERIAL.getName()) ? new PrinterService(new SerialPortPrinter(String.valueOf(map.get("serialPort")))) : new PrinterService(new AwtReceiptPrinter(string)));
        printerService.open();
        printerService.init();
        return printerService;
    }

    public static NetworkPrinter getNetworkPrinter(Map map) {
        String string = EscPosPrintService.valueOf(map.get("ipAddress"));
        int n = POSUtil.parseInteger(String.valueOf(map.get("ipPort")));
        return new NetworkPrinter(string, n);
    }

    public void close(PrinterService printerService) throws Exception {
        printerService.cutFull();
        printerService.close();
    }

    private void a(PrinterService printerService, String string) {
        if (StringUtils.isEmpty((String)string)) {
            printerService.setTextColor(Commands.COLOR_BLACK);
            return;
        }
        if (string.equalsIgnoreCase("#ff0000")) {
            printerService.setTextColor(Commands.COLOR_RED);
        } else {
            printerService.setTextColor(Commands.COLOR_BLACK);
        }
    }

    private String a(String string, int n, String string2) {
        String string3 = "\n";
        if (string.length() == 0) {
            return "";
        }
        if (string.length() <= n) {
            return string + this.getText(string2, "right", 13);
        }
        String[] stringArray = string.split(" ");
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (String string4 : stringArray) {
            if (stringBuilder2.length() + 1 + string4.length() <= n) {
                stringBuilder2.append(string4).append(" ");
                continue;
            }
            stringBuilder.append(this.getText(stringBuilder2.toString(), "left", this.colLeftFieldLength) + this.getText(string2, "right", 13)).append(string3);
            stringBuilder2 = new StringBuilder();
            stringBuilder2.append(string4).append(" ");
            string2 = " ";
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder.append(this.getText(stringBuilder2.toString(), "left", this.colLeftFieldLength) + this.getText(string2, "right", 13));
        }
        return stringBuilder.toString();
    }

    private void a(Map<String, Object> map) {
        this.totalCharLength = POSUtil.getInteger(map.get("textLength"));
        if (this.totalCharLength <= 0) {
            this.totalCharLength = 42;
        }
        this.colLeftFieldLength = this.totalCharLength - 13;
    }

    private void a(PrinterService printerService) {
        printerService.lineBreak();
    }

    private void a(Map<String, Object> map, PrinterService printerService) {
        Image image = (Image)map.get("storeLogoIcon");
        if (image != null) {
            try {
                printerService.printImage(POSUtil.convertBlackAndWhiteImage(image));
            }
            catch (Exception exception) {
                PosLog.error(ReceiptPrintService.class, exception);
            }
        }
    }

    private void a(Map<String, Object> map, PrinterService printerService, String string) {
        BufferedImage bufferedImage = (BufferedImage)map.get(string);
        if (bufferedImage != null) {
            try {
                int n = 300;
                int n2 = bufferedImage.getType() == 0 ? 2 : bufferedImage.getType();
                BufferedImage bufferedImage2 = POSUtil.resizeImage(bufferedImage, n, n, n2);
                printerService.printImage(bufferedImage2);
            }
            catch (Exception exception) {
                PosLog.error(ReceiptPrintService.class, exception);
            }
        }
    }

    private void b(Map<String, Object> map, PrinterService printerService) {
        Object object = map.get(ReceiptParam.BARCODE.getParamName());
        if (object != null) {
            try {
                printerService.printBarcode(object.toString(), "CODE128", 255, 2, "OFF", "A");
            }
            catch (Exception exception) {
                PosLog.error(ReceiptPrintService.class, exception);
            }
        }
    }

    private void a(PrinterService printerService, Map<String, Object> map, String string, String string2) {
        this.a(printerService, map, string, string2, true);
    }

    private void a(PrinterService printerService, Map<String, Object> map, String string, String string2, boolean bl) {
        Object object = map.get(string2);
        if (bl && (object == null || object.equals("null") || object.equals("0.00"))) {
            return;
        }
        String string3 = String.valueOf(map.get(string));
        String string4 = (String)map.get(string2);
        if (string3.contains("<br>")) {
            String[] stringArray = string3.split("<br>");
            String[] stringArray2 = string4.split("<br>");
            for (int i = 0; i < stringArray.length; ++i) {
                String string5 = this.getText(stringArray[i], "left", this.colLeftFieldLength);
                String string6 = this.getText(stringArray2[i], "right", 13);
                printerService.printRight(string5 + string6);
                this.a(printerService);
            }
        } else {
            String string7 = this.getText(string3, "left", this.colLeftFieldLength);
            String string8 = this.getText(string4, "right", 13);
            printerService.printRight(string7 + string8);
            this.a(printerService);
        }
    }

    public String getText(String string, String string2, int n) {
        if (string == null) {
            string = "";
        }
        if (string2.equals("center")) {
            int n2 = (n - string.length()) / 2;
            for (int i = 1; i <= n2; ++i) {
                string = " " + string + " ";
            }
            return string;
        }
        if (string2.equals("right")) {
            int n3 = n - string.length();
            for (int i = 1; i <= n3; ++i) {
                string = " " + string;
            }
            return string;
        }
        if (string2.equals("left")) {
            int n4 = n - string.length();
            for (int i = 1; i <= n4; ++i) {
                string = string + " ";
            }
            return string;
        }
        return null;
    }

    private void b(PrinterService printerService) {
        String string = "";
        for (int i = 0; i < this.totalCharLength; ++i) {
            string = string + "-";
        }
        printerService.printLn(Commands.TXT_ALIGN_RT, string);
    }

    private void c(PrinterService printerService) {
        String string = "";
        for (int i = 0; i < this.totalCharLength; ++i) {
            string = string + "-";
        }
        printerService.printLn(Commands.TXT_ALIGN_LT, string);
    }

    public void addBoldText(PrinterService printerService, Map<String, Object> map, String string, byte[] byArray) {
        printerService.setTextTypeBold();
        this.addText(printerService, map, string, byArray, true);
        printerService.setTextTypeNormal();
        printerService.write(Commands.TXT_NORMAL);
        this.a(printerService);
    }

    public void addText(PrinterService printerService, Map<String, Object> map, String string, byte[] byArray) {
        boolean bl = POSUtil.getBoolean(map.getOrDefault(string + ".font-weight", "false").toString());
        this.a(printerService, map, string, (byte[])null);
        this.addText(printerService, map, string, byArray, bl);
        printerService.setTextTypeNormal();
        printerService.write(Commands.TXT_NORMAL);
        printerService.setTextFontA();
    }

    private void a(PrinterService printerService, Map<String, Object> map, String string, byte[] byArray) {
        try {
            byte[] byArray2;
            String string2;
            Object object;
            String string3;
            if (map == null || string == null) {
                return;
            }
            Object object2 = map.getOrDefault(string + ".font-size", "");
            String string4 = string3 = object2 == null ? null : object2.toString();
            if (StringUtils.isNotBlank((String)string3)) {
                object = this.a("1b21" + string3);
                if (object != null) {
                    printerService.write((byte[])object);
                }
            } else if (byArray != null) {
                printerService.write(byArray);
            }
            object = map.getOrDefault(string + ".font-type", "");
            String string5 = string2 = object == null ? null : object.toString();
            if (StringUtils.isNotBlank((String)string2) && (byArray2 = this.a("1b4d" + string2)) != null) {
                printerService.write(byArray2);
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private void b(Map<String, Object> map, PrinterService printerService, String string) {
        try {
            Object object = map.get(string + ".font-weight");
            if (object != null && StringUtils.isNotBlank((String)object.toString())) {
                boolean bl = POSUtil.getBoolean(object.toString());
                if (bl) {
                    printerService.setTextTypeBold();
                } else {
                    printerService.setTextTypeNormal();
                }
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    public void addText(PrinterService printerService, Map<String, Object> map, String string, byte[] byArray, boolean bl) {
        String[] stringArray;
        String string2 = String.valueOf(map.get(string));
        if (StringUtils.isEmpty((String)string2) || string2.equals("null")) {
            if (map.containsKey("qrImageIcon")) {
                this.a(printerService, map, string);
            }
            return;
        }
        if (string2.contains("<strike>")) {
            string2 = string2.replaceAll("<div><span><strike>", Messages.getString("EscPosPrintService.25"));
        }
        if ((stringArray = string2.split("<br>")).length > 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                if (StringUtils.isEmpty((String)string3)) {
                    printerService.print("\n");
                    continue;
                }
                if (string3.contains("<storeLogo")) {
                    this.a(map, printerService);
                    continue;
                }
                if (string3.contains("<barcode>")) {
                    this.a(printerService, byArray, bl, string3, false);
                    this.b(map, printerService);
                    continue;
                }
                this.a(printerService, byArray, bl, string3);
            }
        }
        if (map.containsKey("qrImageIcon")) {
            this.a(printerService, map, string);
        }
    }

    private void a(PrinterService printerService, Map<String, Object> map, String string) {
        try {
            boolean bl;
            if (string.equals("ticketHeader") && (bl = ((Boolean)map.get("showQRImageIconOnTop")).booleanValue())) {
                printerService.print("\n");
                this.a(map, printerService, "qrImageIcon");
            }
            if (string.equals("bottomMessage") && (bl = ((Boolean)map.get("showQRImageIconOnFooter")).booleanValue())) {
                printerService.print("\n");
                this.a(map, printerService, "qrImageIcon");
            }
        }
        catch (Exception exception) {
            PosLog.error(ReceiptPrintService.class, exception);
        }
    }

    private void a(PrinterService printerService, byte[] byArray, boolean bl, String string) {
        this.a(printerService, byArray, bl, string, true);
    }

    private void a(PrinterService printerService, byte[] byArray, boolean bl, String string, boolean bl2) {
        String string2;
        if (string.contains("<b>") || bl) {
            printerService.setTextTypeBold();
        }
        if (StringUtils.isBlank((String)(string2 = string.replaceAll("<.*?>", "").replaceAll("</", "").replaceAll("&nbsp;", " ")))) {
            return;
        }
        if (bl2) {
            printerService.printLn(byArray, string2);
        } else {
            printerService.print(byArray, string2);
        }
        if (string.contains("</b>")) {
            printerService.setTextTypeNormal();
        }
    }

    private byte[] a(String string) {
        try {
            if (StringUtils.isBlank((String)string)) {
                return null;
            }
            return Hex.decodeHex((char[])string.toCharArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void b(PrinterService printerService, String string) {
        this.a(printerService);
        printerService.setTextTypeUnderline();
        printerService.printLn(Commands.TXT_ALIGN_RT, string);
        printerService.setTextTypeNormal();
        this.a(printerService);
    }

    public void addLine(Document document, int n) throws DocumentException {
        for (int i = 0; i < n; ++i) {
            document.add((Element)new Paragraph(" "));
        }
    }

    @Override
    public void testPrinter(HashMap<String, Object> hashMap, String string) throws Exception {
        PrinterService printerService = this.createPrintService(string, hashMap);
        this.addBoldText(printerService, hashMap, "title", Commands.TXT_ALIGN_CT);
        this.addText(printerService, hashMap, "data", Commands.TXT_ALIGN_LT);
        this.close(printerService);
    }

    public static String valueOf(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    private void a(Ticket ticket, PosTransaction posTransaction, PrinterService printerService) {
        List<ReceiptPrintService.TransactionDataRow> list = ReceiptPrintService.buildPayments(posTransaction, ticket);
        if (list == null || list.isEmpty()) {
            return;
        }
        for (ReceiptPrintService.TransactionDataRow transactionDataRow : list) {
            String string;
            String string2 = NumberUtil.formatNumberAcceptNegative(transactionDataRow.getAmount());
            String string3 = string = this.getText(transactionDataRow.getPaymentType(), "left", this.colLeftFieldLength);
            if (string.length() > this.colLeftFieldLength) {
                string3 = this.a(string, this.colLeftFieldLength, string2);
            } else {
                String string4 = this.getText(string2, "right", 13);
                string3 = string3 + string4;
            }
            printerService.printRight(string3);
            this.a(printerService);
        }
    }

    private void a(Ticket ticket, PrinterService printerService) {
        Map<String, Double> map = ReceiptPrintService.populateTaxBreakdownMap(ticket);
        if (map == null || map.isEmpty()) {
            return;
        }
        String string = CurrencyUtil.getCurrencySymbol();
        Boolean bl = ticket.isTaxIncluded();
        String string2 = "(" + POSConstants.RECEIPT_REPORT_TAX_LABEL + ") ";
        for (Map.Entry<String, Double> entry : map.entrySet()) {
            String string3 = NumberUtil.formatNumber(entry.getValue());
            String string4 = entry.getKey();
            string4 = string4 + string;
            if (bl.booleanValue()) {
                string4 = string4 + Messages.getString("ReceiptPrintService.18");
            }
            String string5 = this.getText(string2 + string4, "left", this.colLeftFieldLength);
            String string6 = this.getText(string3, "right", 13);
            printerService.printRight(string5 + string6);
            this.a(printerService);
        }
    }

    @Override
    public void printServerSummaryReport(CashDrawer cashDrawer, HashMap hashMap, String string) throws Exception {
        this.a(hashMap);
        PrinterService printerService = this.createPrintService(string, hashMap);
        this.addText(printerService, hashMap, "headerLine1", Commands.TXT_ALIGN_CT, true);
        this.addText(printerService, hashMap, "SSReportTitle", Commands.TXT_ALIGN_CT, true);
        this.addText(printerService, hashMap, "user", Commands.TXT_ALIGN_CT);
        this.addText(printerService, hashMap, "date", Commands.TXT_ALIGN_CT);
        this.a(printerService);
        this.addText(printerService, hashMap, "salesBalance", Commands.TXT_ALIGN_CT, true);
        printerService.setTextTypeNormal();
        this.b(printerService);
        String string2 = this.getText(hashMap.get("rowGrossSales").toString(), "left", this.colLeftFieldLength);
        String string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getGrossSales()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        Store store = DataProvider.get().getStore();
        if (POSUtil.getBoolean(store.getProperty("show_category_breakout.in_server_Summary")) && cashDrawer.getCategoryBreakOut().size() > 0) {
            this.a(printerService, cashDrawer, hashMap);
        }
        string2 = this.getText(hashMap.get("rowDiscount").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getTotalDiscountSales()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowReturn").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getReturnAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.b(printerService);
        string2 = this.getText(hashMap.get("rowNetSales").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getNetSales()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowSC").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getServiceCharge()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowSalesTax").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getSalesTax()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowDC").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getDeliveryCharge()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowTips").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getGratuity()), "right", 13);
        printerService.printRight(string2 + string3);
        if (cashDrawer.getFeeAmount() > 0.0) {
            this.a(printerService);
            string2 = this.getText(hashMap.get("rowFee").toString(), "left", this.colLeftFieldLength);
            string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getFeeAmount()), "right", 13);
            printerService.printRight(string2 + string3);
        }
        this.b(printerService);
        string2 = this.getText(hashMap.get("rowTotal").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getTotalRevenue()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowCReceipts").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCashReceiptAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowCCards").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCreditCardReceiptAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowDCards").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getDebitCardReceiptAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowMPayments").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCustomerPaymentAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowCPayments").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCustomPaymentAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        if (cashDrawer.getPromotionAmount() > 0.0) {
            string2 = this.getText("-PROMOTION", "left", this.colLeftFieldLength);
            string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getPromotionAmount()), "right", 13);
            printerService.printRight(string2 + string3);
            this.a(printerService);
        }
        string2 = this.getText(hashMap.get("rowGCert").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getGiftCertChangeAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowRefundPlus").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getRefundAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowTolerance").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getToleranceAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.b(printerService);
        string2 = this.getText(hashMap.get("rowReceiptDiff").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getReceiptDifferential()), "right", 13);
        printerService.printRight(string2 + string3);
        printerService.lineBreak(2);
        string2 = this.getText(hashMap.get("rowCashTips").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCashTips()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowChargedTips").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getChargedTips()), "right", 13);
        printerService.printRight(string2 + string3);
        printerService.lineBreak(2);
        printerService.printLn(Commands.TXT_ALIGN_CT, "-----------");
        this.close(printerService);
    }

    private void a(PrinterService printerService, CashDrawer cashDrawer, HashMap hashMap) {
        this.addText(printerService, hashMap, "TitleCatBreakOut", Commands.TXT_ALIGN_CT, true);
        printerService.setTextTypeNormal();
        this.a(printerService, this.totalCharLength - 4, Commands.TXT_ALIGN_CT);
        for (CategoryBreakOut categoryBreakOut : cashDrawer.getCategoryBreakOut()) {
            String string = categoryBreakOut.getCategoryName();
            if (string == null) {
                string = "Others";
            }
            String string2 = this.getText("  " + string, "left", this.colLeftFieldLength);
            String string3 = this.getText(NumberUtil.formatNumber(categoryBreakOut.getBreakOutAmt()) + "  ", "right", 13);
            printerService.printRight(string2 + string3);
            this.a(printerService);
        }
        this.a(printerService, this.totalCharLength - 4, Commands.TXT_ALIGN_CT);
    }

    private void a(PrinterService printerService, int n, byte[] byArray) {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "-";
        }
        printerService.printLn(byArray, string);
    }

    @Override
    public void showServerSummaryReport(CashDrawer cashDrawer, HashMap hashMap, JPanel jPanel) throws Exception {
        jPanel.removeAll();
        ITextPrinter iTextPrinter = ITextPrinter.create();
        iTextPrinter.createServerSummaryReport(cashDrawer, hashMap);
        iTextPrinter.rendererReport(jPanel);
        jPanel.revalidate();
        jPanel.repaint();
    }

    @Override
    public void printCashDrawerReport(CashDrawer cashDrawer, HashMap hashMap, String string) throws Exception {
        boolean bl;
        this.a(hashMap);
        PrinterService printerService = this.createPrintService(string, hashMap);
        this.addText(printerService, hashMap, "headerLine1", Commands.TXT_ALIGN_CT, true);
        this.addText(printerService, hashMap, "reportTitle", Commands.TXT_ALIGN_CT, true);
        this.addText(printerService, hashMap, "user", Commands.TXT_ALIGN_CT);
        this.addText(printerService, hashMap, "startTime", Commands.TXT_ALIGN_CT);
        this.addText(printerService, hashMap, "date", Commands.TXT_ALIGN_CT);
        this.a(printerService);
        this.addText(printerService, hashMap, "salesBalance", Commands.TXT_ALIGN_CT, true);
        printerService.setTextTypeNormal();
        this.b(printerService);
        String string2 = this.getText(hashMap.get("rowGrossReceipts").toString(), "left", this.colLeftFieldLength);
        String string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getGrossReceipts()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowCReceipts").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCashReceiptAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowCCards").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCreditCardReceiptAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowDCards").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getDebitCardReceiptAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowMPayments").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCustomerPaymentAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowCPayments").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCustomPaymentAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        if (cashDrawer.getPromotionAmount() > 0.0) {
            string2 = this.getText("-PROMOTION", "left", this.colLeftFieldLength);
            string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getPromotionAmount()), "right", 13);
            printerService.printRight(string2 + string3);
            this.a(printerService);
        }
        string2 = this.getText(hashMap.get("rowGReturns").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getGiftCertReturnAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowGCChange").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getGiftCertChangeAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowRefundPlus").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getRefundAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.b(printerService);
        string2 = this.getText(hashMap.get("rowReceiptDiff").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getReceiptDifferential()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowCashTips").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCashTips()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowChargedTips").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getChargedTips()), "right", 13);
        printerService.printRight(string2 + string3);
        boolean bl2 = bl = cashDrawer.getDrawerType() == DrawerType.STAFF_BANK;
        if (bl) {
            this.b(printerService);
            string2 = this.getText(hashMap.get("rowTotalTips").toString(), "left", this.colLeftFieldLength);
            string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getTotalTips()), "right", 13);
            printerService.printRight(string2 + string3);
            this.a(printerService);
        } else {
            this.a(printerService);
            string2 = this.getText(hashMap.get("rowTipsPaid").toString(), "left", this.colLeftFieldLength);
            string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getTipsPaid()), "right", 13);
            printerService.printRight(string2 + string3);
            this.b(printerService);
            string2 = this.getText(hashMap.get("rowTipsDiff").toString(), "left", this.colLeftFieldLength);
            string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getTipsDifferential()), "right", 13);
            printerService.printRight(string2 + string3);
            this.a(printerService);
        }
        this.a(printerService);
        this.addText(printerService, hashMap, "cashBalance", Commands.TXT_ALIGN_CT, true);
        printerService.setTextTypeNormal();
        this.b(printerService);
        string2 = this.getText(hashMap.get("rowCash").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCashReceiptAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowTipsPaid").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getTipsPaid()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        if (bl && cashDrawer.getTipsPaidByOtherTerminal() > 0.0) {
            string2 = this.getText(hashMap.get("rowTipsPaidByOtherTerminal").toString(), "left", this.colLeftFieldLength);
            string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getTipsPaidByOtherTerminal()), "right", 13);
            printerService.printRight(string2 + string3);
            this.a(printerService);
        }
        string2 = this.getText(hashMap.get("rowPayOut").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getPayOutAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowRefundMinus").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCashBack()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowBeginCash").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getBeginCash()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowCashIn").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCashInAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowDBleed").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getDrawerBleedAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.b(printerService);
        string2 = this.getText(hashMap.get("rowDAcc").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getDrawerAccountable()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowDTips").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getDeclaredTips()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowCToDipo").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCashToDeposit()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        if (bl) {
            this.a(printerService);
            this.a(printerService);
            string2 = this.getText(hashMap.get("rowCashDueOrOwedToServer").toString(), "left", this.colLeftFieldLength);
            string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getDrawerAccountable()), "right", 13);
            printerService.printRight(string2 + string3);
            this.a(printerService);
        }
        if (cashDrawer.getCashBreakdownList().size() > 0) {
            this.b(printerService, cashDrawer, hashMap);
        }
        this.close(printerService);
    }

    private void b(PrinterService printerService, CashDrawer cashDrawer, HashMap hashMap) {
        this.a(printerService);
        this.addText(printerService, hashMap, "rowCBreakD", Commands.TXT_ALIGN_CT, true);
        printerService.setTextTypeNormal();
        printerService.printRight(this.getText(hashMap.get("rowCSRAmount").toString(), "right", 13));
        this.a(printerService);
        this.b(printerService);
        for (CashBreakdown cashBreakdown : cashDrawer.getCashBreakdownList()) {
            String string = this.getText(cashBreakdown.getCurrencyName(), "left", this.colLeftFieldLength);
            String string2 = this.getText(NumberUtil.formatNumber(cashBreakdown.getBalance()), "right", 13);
            printerService.printRight(string + string2);
            this.a(printerService);
        }
        this.b(printerService);
    }

    private void c(PrinterService printerService, CashDrawer cashDrawer, HashMap hashMap) {
        this.a(printerService);
        this.addText(printerService, hashMap, "rowVRExceptions", Commands.TXT_ALIGN_CT, true);
        this.addText(printerService, hashMap, "rowVRTax", Commands.TXT_ALIGN_CT, true);
        printerService.setTextTypeNormal();
        this.b(printerService);
        printerService.printRight(this.getText(hashMap.get("rowVRAmount").toString(), "right", 13));
        this.a(printerService);
        double d = 0.0;
        for (DrawerPullVoidEntry object2 : cashDrawer.getVoidEntries()) {
            String string = this.getText(object2.getReason(), "left", this.colLeftFieldLength);
            String string2 = this.getText(NumberUtil.formatNumber(object2.getAmount()), "right", 13);
            printerService.printRight(string + string2);
            this.a(printerService);
            d += object2.getAmount().doubleValue();
        }
        this.b(printerService);
        String string = this.getText(hashMap.get("rowVRTotal").toString(), "right", this.colLeftFieldLength);
        String string3 = this.getText(NumberUtil.formatNumber(d), "right", 13);
        printerService.printRight((String)string + string3);
    }

    @Override
    public void showCashDrawerReport(CashDrawer cashDrawer, HashMap hashMap, JPanel jPanel) throws Exception {
        jPanel.removeAll();
        ITextPrinter iTextPrinter = ITextPrinter.create();
        iTextPrinter.createCashDrawerReport(cashDrawer, hashMap);
        iTextPrinter.rendererReport(jPanel);
        jPanel.revalidate();
        jPanel.repaint();
    }

    @Override
    public void printStoreSessionSummaryReport(CashDrawer cashDrawer, HashMap hashMap, String string) throws Exception {
        this.a(hashMap);
        PrinterService printerService = this.createPrintService(string, hashMap);
        this.addText(printerService, hashMap, "headerLine1", Commands.TXT_ALIGN_CT, true);
        this.addText(printerService, hashMap, "reportTitle", Commands.TXT_ALIGN_CT, true);
        printerService.setTextTypeNormal();
        this.addText(printerService, hashMap, "user", Commands.TXT_ALIGN_CT);
        this.addText(printerService, hashMap, "startTime", Commands.TXT_ALIGN_CT);
        this.addText(printerService, hashMap, "reportUser", Commands.TXT_ALIGN_CT);
        this.addText(printerService, hashMap, "date", Commands.TXT_ALIGN_CT);
        this.a(printerService);
        this.addText(printerService, hashMap, "salesBalance", Commands.TXT_ALIGN_CT, true);
        printerService.setTextTypeNormal();
        this.b(printerService);
        String string2 = this.getText(hashMap.get("rowNetSales").toString(), "left", this.colLeftFieldLength);
        String string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getNetSales()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowDiscount").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getTotalDiscountAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowSalesTax").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getSalesTax()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowSC").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getServiceCharge()), "right", 13);
        printerService.printRight(string2 + string3);
        this.b(printerService);
        string2 = this.getText(hashMap.get("rowTotal").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getTotalRevenue()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowTips").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCashTips() + cashDrawer.getChargedTips()), "right", 13);
        printerService.printRight(string2 + string3);
        this.b(printerService);
        string2 = this.getText(hashMap.get("rowGReceivable").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getGrossReceipts()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowCReceipts").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCashReceiptAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowCCards").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCreditCardReceiptAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowDCards").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getDebitCardReceiptAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowMPayments").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCustomerPaymentAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowCPayments").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCustomPaymentAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        if (cashDrawer.getPromotionAmount() > 0.0) {
            string2 = this.getText("-PROMOTION", "left", this.colLeftFieldLength);
            string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getPromotionAmount()), "right", 13);
            printerService.printRight(string2 + string3);
            this.a(printerService);
        }
        string2 = this.getText(hashMap.get("rowGCert").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getGiftCertChangeAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowRefundPlus").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getRefundAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowTolerance").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getToleranceAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.b(printerService);
        string2 = this.getText(hashMap.get("rowReceiptDiff").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getReceiptDifferential()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowCashTips").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCashTips()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowChargedTips").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getChargedTips()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowTipsPaid").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getTipsPaid()), "right", 13);
        printerService.printRight(string2 + string3);
        this.b(printerService);
        string2 = this.getText(hashMap.get("rowTipsDiff").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getTipsDifferential()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        this.a(printerService);
        this.addText(printerService, hashMap, "cashBalance", Commands.TXT_ALIGN_CT, true);
        printerService.setTextTypeNormal();
        this.b(printerService);
        string2 = this.getText(hashMap.get("rowCash").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCashReceiptAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowTipsPaid").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getTipsPaid()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowPayOut").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getPayOutAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowRefundMinus").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCashBack()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowBeginCash").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getBeginCash()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowCashIn").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getCashInAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowDBleed").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getDrawerBleedAmount()), "right", 13);
        printerService.printRight(string2 + string3);
        this.b(printerService);
        string2 = this.getText(hashMap.get("rowDAcc").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getDrawerAccountable()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        string2 = this.getText(hashMap.get("rowDTips").toString(), "left", this.colLeftFieldLength);
        string3 = this.getText(NumberUtil.formatNumber(cashDrawer.getDeclaredTips()), "right", 13);
        printerService.printRight(string2 + string3);
        this.a(printerService);
        if (cashDrawer.getCashBreakdownList().size() > 0) {
            this.b(printerService, cashDrawer, hashMap);
        }
        if (cashDrawer.getVoidEntries() != null && cashDrawer.getVoidEntries().size() > 0) {
            this.c(printerService, cashDrawer, hashMap);
        }
        this.close(printerService);
    }

    @Override
    public void showStoreSessionSummaryReport(CashDrawer cashDrawer, HashMap hashMap, JPanel jPanel) throws Exception {
        jPanel.removeAll();
        ITextPrinter iTextPrinter = ITextPrinter.create();
        iTextPrinter.createStoreSessionSummaryReport(cashDrawer, hashMap);
        iTextPrinter.rendererReport(jPanel);
        jPanel.revalidate();
        jPanel.repaint();
    }
}

