/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.EndOfDayReportData;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.model.EndOfDaySummaryReportModel;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.MultiSelectionOverflowCombobox;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class EndOfDaySummaryReportView
extends TransparentPanel {
    private JButton a;
    private JXDatePicker b;
    private JXDatePicker c;
    private JPanel d;
    private JPanel e;
    private MultiSelectComboBox<OrderType> f;

    public EndOfDaySummaryReportView() {
        this.setLayout(new BorderLayout());
        this.b();
    }

    private void a() {
        try {
            Date date = this.b.getDate();
            Date date2 = this.c.getDate();
            DateUtil.validateDate(date, date2);
            date = DateUtil.startOfDay(this.b.getDate());
            date2 = DateUtil.startOfNextDay(this.c.getDate());
            PosLog.debug(this.getClass(), String.format("End of day report, start: %s end: %s", date, date2));
            List<OrderType> list = this.f.getSelectedItems();
            List<EndOfDayReportData> list2 = TicketItemDAO.getInstance().findEndOfDayReportData(date, date2, list);
            PosLog.debug(this.getClass(), String.format("Found %s tickets", list2.size()));
            JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("end_of_day_summary_report"));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            ReportUtil.populateRestaurantProperties(hashMap);
            ReportUtil.populateReportTime(hashMap, date, date2);
            ReportUtil.populateReportFooter(hashMap);
            this.a(hashMap, list);
            EndOfDaySummaryReportModel endOfDaySummaryReportModel = new EndOfDaySummaryReportModel();
            endOfDaySummaryReportModel.setRows(list2);
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)endOfDaySummaryReportModel));
            JRViewer jRViewer = new JRViewer(jasperPrint);
            this.d.removeAll();
            this.d.add((Component)jRViewer);
            this.d.revalidate();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(HashMap<String, Object> hashMap, List<OrderType> list) {
        String string = POSUtil.createOrderTypeIdString(list);
        hashMap.put("reportTitle", Messages.getString("EndOfDaySummaryReport"));
        hashMap.put("currency", ReportUtil.reportLabelWithBoldTag(POSConstants.CURRENCY) + " " + CurrencyUtil.getCurrencyName() + CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("orderType", ReportUtil.reportLabelWithBoldTag(Messages.getString("colOrderType") + ": ") + string);
        hashMap.put("colSubtotal", POSConstants.SUBTOTAL);
        hashMap.put("colMName", Messages.getString("MEMBER"));
        hashMap.put("colTID", POSConstants.TICKET_ID);
        hashMap.put("colTAmount", Messages.getString("EndOfDaySummaryReportView.2"));
        hashMap.put("colSC", POSConstants.S_C);
        hashMap.put("colTips", Messages.getString("GRATUITY"));
        hashMap.put("colTax", POSConstants.TAX);
        hashMap.put("colTotal", POSConstants.TOTAL);
        hashMap.put("colGrossSales", POSConstants.TOTAL);
        hashMap.put("colMCharge", Messages.getString("MEMBER") + "<br/>" + Messages.getString("CHARGE"));
        hashMap.put("colCCard", Messages.getString("colCredit") + "<br/>" + Messages.getString("CARD"));
        hashMap.put("colCPayment", Messages.getString("CashPayment"));
        hashMap.put("colOthersPymt", Messages.getString("OthersPayment"));
        hashMap.put("colDiscount", POSConstants.DISCOUNT);
        hashMap.put("colRefund", Messages.getString("EndOfDaySummaryReportView.1"));
        hashMap.put("colTaxReceived", Messages.getString("EndOfDaySummaryReportView.3"));
        hashMap.put("colTotalReceived", POSConstants.TOTAL + " " + Messages.getString("EndOfDaySummaryReportView.4"));
        hashMap.put("colReturnAmount", POSConstants.RETURN);
        hashMap.put("colNetSalesAmount", POSConstants.NET_SALES);
    }

    private void b() {
        this.b = UiUtil.getDeafultDate();
        this.b.setDate(new Date());
        this.c = UiUtil.getDeafultDate();
        this.c.setDate(new Date());
        this.a = new JButton();
        this.a.setText(POSConstants.GO);
        this.a.addActionListener(actionEvent -> this.a());
        this.f = new MultiSelectionOverflowCombobox<OrderType>();
        this.f.setItems(OrderTypeDAO.getInstance().findAll());
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add(new JLabel(Messages.getString("TerminalTypeForm.1") + ":"));
        jPanel.add(this.f);
        jPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.b.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.b);
        jPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.c.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.c);
        jPanel.add((Component)this.a, "width 60!");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.d = new JPanel(new BorderLayout());
        jPanel2.add(this.d);
        this.add(jPanel2);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.e;
    }
}

