/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.Ticket;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.List;

public class TaxExemptReport {
    private List<TaxExemptData> a = new ArrayList<TaxExemptData>();

    public void addTaxExemptTicket(Ticket ticket) {
        TaxExemptData taxExemptData = new TaxExemptData();
        taxExemptData.setTicketId(ticket.getId());
        taxExemptData.setCustomerName(ticket.getCustomerNameByProperty());
        taxExemptData.setTotalAmount(ticket.getTotalAmountWithTips());
        taxExemptData.setCreateDate(ticket.getCreateDateFormatted());
        taxExemptData.setTaxAmount(ticket.getTaxAmountFromProperty());
        this.a.add(taxExemptData);
    }

    public TaxExemptTableModel getTaxExemptTableModel() {
        TaxExemptTableModel taxExemptTableModel = new TaxExemptTableModel();
        taxExemptTableModel.setRows(this.a);
        return taxExemptTableModel;
    }

    public class TaxExemptData {
        private String b;
        private String c;
        private double d;
        private String e;
        private double f;

        public String getTicketId() {
            return this.b;
        }

        public void setTicketId(String string) {
            this.b = string;
        }

        public String getCustomerName() {
            return this.c;
        }

        public void setCustomerName(String string) {
            this.c = string;
        }

        public double getTotalAmount() {
            return this.d;
        }

        public void setTotalAmount(double d) {
            this.d = d;
        }

        public String getCreateDate() {
            return this.e;
        }

        public void setCreateDate(String string) {
            this.e = string;
        }

        public double getTaxAmount() {
            return this.f;
        }

        public void setTaxAmount(double d) {
            this.f = d;
        }
    }

    public class TaxExemptTableModel
    extends ListTableModel {
        public TaxExemptTableModel() {
            this.setColumnNames(new String[]{"ticketId", "customerName", "totalAmount", "createDate", "taxAmount"});
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TaxExemptData taxExemptData = (TaxExemptData)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return taxExemptData.getTicketId();
                }
                case 1: {
                    return taxExemptData.getCustomerName();
                }
                case 2: {
                    return NumberUtil.getCurrencyFormatWithoutCurrencySymbol(taxExemptData.getTotalAmount());
                }
                case 3: {
                    return taxExemptData.getCreateDate();
                }
                case 4: {
                    return NumberUtil.getCurrencyFormatWithoutCurrencySymbol(taxExemptData.getTaxAmount());
                }
            }
            return null;
        }
    }
}

