/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.config.ui.MultiroleUserComboRenderer;
import com.floreantpos.model.DeclaredTips;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.TracTipsReportModel;
import com.floreantpos.services.report.SalesReportUtil;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.jdesktop.swingx.JXDatePicker;

public class TracTipsReportView
extends TransparentPanel {
    private JButton a;
    private JXDatePicker b;
    private JXDatePicker c;
    private JPanel d;
    private JComboBox e;
    private Session f;

    public TracTipsReportView() {
        this.setLayout(new BorderLayout());
        this.b();
    }

    private void a() {
        try {
            HashMap<String, Object> hashMap;
            Object object2;
            JasperReport jasperReport;
            GenericDAO genericDAO = new GenericDAO();
            Date date = this.b.getDate();
            Date date2 = this.c.getDate();
            DateUtil.validateDate(date, date2);
            date = DateUtil.startOfDay(this.b.getDate());
            date2 = DateUtil.endOfDay(this.c.getDate());
            User user = null;
            if (this.e.getSelectedItem() instanceof User) {
                user = (User)this.e.getSelectedItem();
            }
            this.f = genericDAO.createNewSession();
            ArrayList<HashMap<String, Object>> arrayList = new ArrayList<HashMap<String, Object>>();
            ArrayList<User> arrayList2 = new ArrayList<User>();
            if (user == null) {
                jasperReport = (ComboBoxModel)this.e.getModel();
                List object22 = jasperReport.getDataList();
                for (Object object2 : object22) {
                    if (!(object2 instanceof User)) continue;
                    arrayList2.add((User)object2);
                }
            } else {
                arrayList2.add(user);
            }
            for (User user2 : arrayList2) {
                hashMap = new TracTipsReportData();
                ((TracTipsReportData)((Object)hashMap)).setEmployeeID(user2.getId());
                ((TracTipsReportData)((Object)hashMap)).setEmployeeName(user2.getFullName());
                ((TracTipsReportData)((Object)hashMap)).setEmployeeRole(user2.getTypeName());
                this.a((TracTipsReportData)((Object)hashMap), this.f, date, date2, user2);
                this.b((TracTipsReportData)((Object)hashMap), this.f, date, date2, user2);
                ((TracTipsReportData)((Object)hashMap)).setNetTips(((TracTipsReportData)((Object)hashMap)).getCardOrOtherTips() + ((TracTipsReportData)((Object)hashMap)).getTracCashTips() + ((TracTipsReportData)((Object)hashMap)).getDeclareTips());
                arrayList.add(hashMap);
            }
            if (arrayList.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("TracTipsReportView.0"));
                return;
            }
            jasperReport = arrayList.iterator();
            while (jasperReport.hasNext()) {
                TracTipsReportData tracTipsReportData = (TracTipsReportData)jasperReport.next();
                if (!tracTipsReportData.isPaymentZero()) continue;
                jasperReport.remove();
            }
            jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("track_tips_report"));
            String string = user == null ? POSConstants.ALL : user.getFullName();
            hashMap = new HashMap<String, Object>();
            ReportUtil.populateRestaurantProperties(hashMap);
            ReportUtil.populateReportHeader(hashMap, null, date, date2, string);
            ReportUtil.populateReportFooter(hashMap);
            this.a(hashMap);
            hashMap.put("reportTitle", Messages.getString("TracTipsReportView.2"));
            object2 = new TracTipsReportModel();
            ((ListTableModel)object2).setRows(arrayList);
            JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JRTableModelDataSource((TableModel)object2));
            JRViewer jRViewer = new JRViewer(jasperPrint);
            this.d.removeAll();
            this.d.add((Component)jRViewer);
            this.d.revalidate();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(TracTipsReportData tracTipsReportData, Session session, Date date, Date date2, User user) {
        SalesReportUtil salesReportUtil = new SalesReportUtil(date, date2, user);
        salesReportUtil.setIncludeAllRole(Boolean.FALSE);
        double d = salesReportUtil.calculateGrossSalesWithOutIncludedTax(session) - salesReportUtil.calculateDiscountAmount(session) - salesReportUtil.calculateReturnAmountWithOutIncludedTax(session);
        tracTipsReportData.setNetSales(d);
        PosTransactionDAO posTransactionDAO = PosTransactionDAO.getInstance();
        tracTipsReportData.setTracCashTips(posTransactionDAO.calculateTipsByUser(session, date, date2, user, Boolean.TRUE));
        tracTipsReportData.setCardOrOtherTips(posTransactionDAO.calculateTipsByUser(session, date, date2, user, Boolean.FALSE));
    }

    private void a(HashMap<String, Object> hashMap) {
        hashMap.put("colId", POSConstants.ID);
        hashMap.put("colName", POSConstants.NAME);
        hashMap.put("colEmployeeRole", Messages.getString("colRole"));
        hashMap.put("colGSales", Messages.getString("NET_SALES"));
        hashMap.put("colCCSalesT", Messages.getString("CCSales") + "<br/>" + Messages.getString("WithOutTips"));
        hashMap.put("colCCTips", Messages.getString("CCSales") + "<br/>" + Messages.getString("GRATUITY").toLowerCase());
        hashMap.put("colTCSWT", Messages.getString("TracCash") + "<br/>" + Messages.getString("WithOutTips"));
        hashMap.put("colTCT", POSConstants.CASH + " " + Messages.getString("GRATUITY").toLowerCase());
        hashMap.put("colTDTips", Messages.getString("Declared") + " " + Messages.getString("GRATUITY").toLowerCase());
        hashMap.put("colNTips", Messages.getString("SRNTips"));
    }

    private void b() {
        this.b = UiUtil.getCurrentMonthStart();
        this.c = UiUtil.getCurrentMonthEnd();
        this.a = new JButton();
        this.a.setText(POSConstants.GO);
        this.a.addActionListener(actionEvent -> this.a());
        this.e = new JComboBox();
        List<User> list = UserDAO.getInstance().findAll();
        Vector<Object> vector = new Vector<Object>();
        vector.add(POSConstants.ALL);
        vector.addAll(list);
        this.e.setModel(new ComboBoxModel(vector));
        this.e.setRenderer(new MultiroleUserComboRenderer());
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        jPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.b.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.b);
        jPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.c.setFormats(new String[]{"dd MMM yy"});
        jPanel.add((Component)this.c);
        jPanel.add(new JLabel(POSConstants.EMPLOYEE + ":"));
        jPanel.add(this.e);
        jPanel.add((Component)this.a, "width 60!");
        this.add((Component)jPanel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 10, 10, 10));
        jPanel2.add((Component)new JSeparator(), "North");
        this.d = new JPanel(new BorderLayout());
        jPanel2.add(this.d);
        this.add(jPanel2);
    }

    private boolean a(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(PosTransaction.class);
        criteria.createAlias(PosTransaction.PROP_TICKET, "ticket");
        criteria.add((Criterion)Restrictions.ge((String)("ticket." + Ticket.PROP_CREATE_DATE), (Object)date));
        criteria.add((Criterion)Restrictions.le((String)("ticket." + Ticket.PROP_CREATE_DATE), (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_USER_ID, (Object)(user == null ? null : user.getId())));
        criteria.add((Criterion)Restrictions.eq((String)PosTransaction.PROP_VOIDED, (Object)Boolean.FALSE));
        criteria.setProjection(Projections.rowCount());
        Number number = (Number)criteria.uniqueResult();
        if (number != null) {
            return number.intValue() > 0;
        }
        return false;
    }

    private boolean b(Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(DeclaredTips.class);
        criteria.add(Restrictions.between((String)DeclaredTips.PROP_DECLARED_TIME, (Object)date, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)DeclaredTips.PROP_OWNER_ID, (Object)user.getId()));
        criteria.setProjection(Projections.rowCount());
        Number number = (Number)criteria.uniqueResult();
        if (number != null) {
            return number.intValue() > 0;
        }
        return false;
    }

    private void b(TracTipsReportData tracTipsReportData, Session session, Date date, Date date2, User user) {
        Criteria criteria = session.createCriteria(DeclaredTips.class);
        criteria.add(Restrictions.between((String)DeclaredTips.PROP_DECLARED_TIME, (Object)date, (Object)date2));
        criteria.add((Criterion)Restrictions.eq((String)DeclaredTips.PROP_OWNER_ID, (Object)user.getId()));
        criteria.setProjection((Projection)Projections.sum((String)DeclaredTips.PROP_AMOUNT));
        Double d = (Double)criteria.uniqueResult();
        if (d != null) {
            tracTipsReportData.setDeclareTips(d);
        }
    }

    public static class TracTipsReportData {
        private String a;
        private String b;
        private String c;
        private double d;
        private double e;
        private double f;
        private double g;
        private double h;
        private double i;
        private double j;
        private double k;
        private double l;
        private double m;

        public String getEmployeeID() {
            return this.a;
        }

        public boolean isPaymentZero() {
            return NumberUtil.isZero(this.d) && NumberUtil.isZero(this.m) && NumberUtil.isZero(this.i) && NumberUtil.isZero(this.f);
        }

        public void setEmployeeID(String string) {
            this.a = string;
        }

        public String getEmployeeName() {
            return this.b;
        }

        public void setEmployeeName(String string) {
            this.b = string;
        }

        public double getNetSales() {
            return this.d;
        }

        public void setNetSales(double d) {
            this.d = d;
        }

        public double getCardOrOtherTips() {
            return this.f;
        }

        public void setCardOrOtherTips(double d) {
            this.f = d;
        }

        public double getTracCreditCardTipsRate() {
            return this.g;
        }

        public void setTracCreditCardTipsRate(double d) {
            this.g = d;
        }

        public double getTracCashTips() {
            return this.i;
        }

        public void setTracCashTips(double d) {
            this.i = d;
        }

        public double getTracCashTipsRate() {
            return this.j;
        }

        public void setTracCashTipsRate(double d) {
            this.j = d;
        }

        public double getTipsPaid() {
            return this.k;
        }

        public void setTipsPaid(double d) {
            this.k = d;
        }

        public double getNetTips() {
            return this.l;
        }

        public void setNetTips(double d) {
            this.l = d;
        }

        public double getCardOrOtherAmountWithoutTips() {
            return this.e;
        }

        public void setCardOrOtherAmountWithoutTips(double d) {
            this.e = d;
        }

        public double getTracCashSalesWithoutTips() {
            return this.h;
        }

        public void setTracCashSalesWithoutTips(double d) {
            this.h = d;
        }

        public double getDeclareTips() {
            return this.m;
        }

        public void setDeclareTips(double d) {
            this.m = d;
        }

        public String getEmployeeRole() {
            return this.c;
        }

        public void setEmployeeRole(String string) {
            this.c = string;
        }
    }
}

