/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.service;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.CashInTransaction;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PayoutReason;
import com.floreantpos.model.PayoutRecepient;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.User;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.model.util.TransactionUtil;
import com.floreantpos.report.CashDrawerTransactionReportModel;
import com.floreantpos.report.PaymentDetailDataReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.util.CurrencyUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import org.apache.commons.lang3.text.WordUtils;

public class DetailsReportService {
    private static List<PosTransaction> a;
    private static List<PaymentDetailDataReportModel.PaymentDetailData> b;
    private static List<PaymentDetailDataReportModel.PaymentDetailData> c;
    private static List<PaymentDetailDataReportModel.PaymentDetailData> d;
    private static List<PaymentDetailDataReportModel.PaymentDetailData> e;

    public static JasperPrint buildStoreSessionDetailsTransationReport(StoreSession storeSession, CashDrawer cashDrawer, List<PosTransaction> list) throws JRException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("receiptType", Messages.getString("StoreSessionSummaryReportDialog.4"));
        Date date = storeSession != null ? storeSession.getCloseTime() : new Date();
        String string = ReportUtil.reportLabelWithBoldTag(Messages.getString("FROM")) + DateUtil.formatReportDateWithTime(cashDrawer.getStartTime());
        String string2 = ReportUtil.reportLabelWithBoldTag(Messages.getString("TO")) + DateUtil.formatReportDateWithTime(date != null ? date : new Date());
        hashMap.put("fromDate", string);
        hashMap.put("toDate", string2);
        return DetailsReportService.a(hashMap, list);
    }

    public static JasperPrint buildServerSummaryDetailTransationReport(StoreSession storeSession, User user, List<PosTransaction> list) throws JRException {
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("receiptType", Messages.getString("ServerSummaryReportDialog.13"));
        if (user != null) {
            object = user.getFullName();
            hashMap.put("serverName", ReportUtil.reportLabelWithBoldTag(Messages.getString("ServerSummaryReportDialog.16")) + (String)object);
        }
        object = storeSession != null ? storeSession.getCloseTime() : new Date();
        String string = ReportUtil.reportLabelWithBoldTag(Messages.getString("FROM")) + DateUtil.formatReportDateWithTime(storeSession.getOpenTime());
        String string2 = ReportUtil.reportLabelWithBoldTag(Messages.getString("TO")) + DateUtil.formatReportDateWithTime((Date)(object != null ? object : new Date()));
        hashMap.put("fromDate", string);
        hashMap.put("toDate", string2);
        return DetailsReportService.a(hashMap, list, false);
    }

    public static JasperPrint buildCashDrawerSummaryDetailTransationReport(List<PosTransaction> list, CashDrawer cashDrawer) throws JRException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("receiptType", cashDrawer.getType().intValue() == DrawerType.DRAWER.getTypeNumber() ? Messages.getString("CashDrawerReportDialog.13") : Messages.getString("CashDrawerReportDialog.14"));
        if (cashDrawer.getAssignedUser() != null) {
            hashMap.put("serverName", ReportUtil.reportLabelWithBoldTag(Messages.getString("CashDrawerReportDialog.17")) + cashDrawer.getAssignedUser());
        }
        String string = ReportUtil.reportLabelWithBoldTag(Messages.getString("FROM")) + DateUtil.formatReportDateWithTime(cashDrawer.getStartTime());
        hashMap.put("fromDate", string);
        Date date = cashDrawer.getReportTime();
        String string2 = ReportUtil.reportLabelWithBoldTag(Messages.getString("TO")) + DateUtil.formatReportDateWithTime(date != null ? date : new Date());
        hashMap.put("toDate", string2);
        return DetailsReportService.a(hashMap, list);
    }

    private static JasperPrint a(HashMap<String, Object> hashMap, List<PosTransaction> list) throws JRException {
        return DetailsReportService.a(hashMap, list, Boolean.TRUE);
    }

    private static JasperPrint a(HashMap<String, Object> hashMap, List<PosTransaction> list, boolean bl) throws JRException {
        JasperReport jasperReport;
        a = new ArrayList<PosTransaction>();
        b = new ArrayList<PaymentDetailDataReportModel.PaymentDetailData>();
        c = new ArrayList<PaymentDetailDataReportModel.PaymentDetailData>();
        d = new ArrayList<PaymentDetailDataReportModel.PaymentDetailData>();
        e = new ArrayList<PaymentDetailDataReportModel.PaymentDetailData>();
        TransactionUtil.clearCustomerData();
        for (PosTransaction serializable2 : list) {
            DetailsReportService.addPaymentDetailsData(serializable2);
        }
        CashDrawerTransactionReportModel cashDrawerTransactionReportModel = new CashDrawerTransactionReportModel();
        cashDrawerTransactionReportModel.setItems(a);
        PaymentDetailDataReportModel paymentDetailDataReportModel = new PaymentDetailDataReportModel();
        paymentDetailDataReportModel.setItems(b);
        PaymentDetailDataReportModel paymentDetailDataReportModel2 = new PaymentDetailDataReportModel();
        paymentDetailDataReportModel2.setItems(d);
        PaymentDetailDataReportModel paymentDetailDataReportModel3 = new PaymentDetailDataReportModel();
        paymentDetailDataReportModel3.setItems(e);
        PaymentDetailDataReportModel paymentDetailDataReportModel4 = new PaymentDetailDataReportModel();
        paymentDetailDataReportModel4.setItems(c);
        ReportUtil.populateRestaurantProperties(hashMap, true);
        hashMap.put("currency", ReportUtil.reportLabelWithBoldTag(POSConstants.CURRENCY) + " " + CurrencyUtil.getCurrencyName() + CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("reportTime", ReportUtil.reportLabelWithBoldTag(Messages.getString("DetailsReportService.0")) + DateUtil.formatReportDateWithTime(new Date()));
        hashMap.put("status", a == null || a.isEmpty() ? Messages.getString("NoTransactionFound") : null);
        hashMap.put("paymentType", Messages.getString("DetailsReportService.1"));
        hashMap.put("refundTitle", Messages.getString("REFUND"));
        hashMap.put("cashInTitle", Messages.getString("CASH_IN"));
        hashMap.put("payOutTitle", Messages.getString("PAAY_OUT"));
        hashMap.put("drawerBleedTitle", Messages.getString("DRAWER_BLEED"));
        hashMap.put("lblTime", POSConstants.TIME);
        hashMap.put("lblPaymentType", Messages.getString("PAYMENT_TYPE"));
        hashMap.put("lblTicketId", POSConstants.TICKET_ID);
        hashMap.put("lblCustomer", POSConstants.CUSTOMER);
        hashMap.put("lblUser", POSConstants.USER);
        hashMap.put("lblTotal", POSConstants.AMOUNT + CurrencyUtil.getCurrencySymbolWithBracket());
        hashMap.put("lblReason", Messages.getString("REASON"));
        hashMap.put("lblRecipient", Messages.getString("RECIPIENT"));
        hashMap.put("SRTotal", POSConstants.TOTAL + ":");
        hashMap.put("SRGrandTotal", POSConstants.GRAND_TOTAL);
        if (a.size() > 0) {
            jasperReport = ReportUtil.getReport("server_details_sub_report_1");
            hashMap.put("allOtherPaymentDatasource", new JRTableModelDataSource((TableModel)cashDrawerTransactionReportModel));
            hashMap.put("allOtherPaymentReport", jasperReport);
        }
        if (b.size() > 0) {
            jasperReport = ReportUtil.getReport("server_details_sub_report_2");
            hashMap.put("refundPaymentDatasource", new JRTableModelDataSource((TableModel)paymentDetailDataReportModel));
            hashMap.put("refundPaymentReport", jasperReport);
        }
        if (bl) {
            if (d.size() > 0) {
                jasperReport = ReportUtil.getReport("server_details_sub_report_3");
                hashMap.put("cashInPaymentDatasource", new JRTableModelDataSource((TableModel)paymentDetailDataReportModel2));
                hashMap.put("cashInPaymentReport", jasperReport);
            }
            if (e.size() > 0) {
                jasperReport = ReportUtil.getReport("server_details_sub_report_4");
                hashMap.put("payOutPaymentDatasource", new JRTableModelDataSource((TableModel)paymentDetailDataReportModel3));
                hashMap.put("payOutPaymentReport", jasperReport);
            }
            if (c.size() > 0) {
                jasperReport = ReportUtil.getReport("server_details_sub_report_5");
                hashMap.put("cashDropPaymentDatasource", new JRTableModelDataSource((TableModel)paymentDetailDataReportModel4));
                hashMap.put("cashDropPaymentReport", jasperReport);
            }
        }
        jasperReport = ReportUtil.getReport("server_details_master_report");
        return JasperFillManager.fillReport((JasperReport)jasperReport, hashMap, (JRDataSource)new JREmptyDataSource());
    }

    public static void addPaymentDetailsData(PosTransaction posTransaction) {
        String string;
        String string2 = string = posTransaction.getUser() == null ? "" : posTransaction.getUser().getFullName();
        if (posTransaction instanceof RefundTransaction) {
            PaymentDetailDataReportModel.PaymentDetailData paymentDetailData = new PaymentDetailDataReportModel.PaymentDetailData();
            paymentDetailData.setTime(DateUtil.formatDateWithTimeAndSec(posTransaction.getTransactionTime()));
            PaymentType paymentType = posTransaction.getPaymentType();
            String string3 = null;
            string3 = paymentType == PaymentType.CUSTOM_PAYMENT ? posTransaction.getCustomPaymentName() : WordUtils.capitalizeFully((String)paymentType.getDisplayString());
            paymentDetailData.setPaymentTypeName(string3);
            paymentDetailData.setTicketId(posTransaction.getTicketId());
            paymentDetailData.setCustomerName(TransactionUtil.getCustomerName(posTransaction));
            paymentDetailData.setAmount(posTransaction.getAmount());
            b.add(paymentDetailData);
        } else if (posTransaction instanceof CashInTransaction) {
            PaymentDetailDataReportModel.PaymentDetailData paymentDetailData = new PaymentDetailDataReportModel.PaymentDetailData();
            paymentDetailData.setTime(DateUtil.formatDateWithTimeAndSec(posTransaction.getTransactionTime()));
            paymentDetailData.setUserName(string);
            paymentDetailData.setAmount(posTransaction.getAmount());
            d.add(paymentDetailData);
        } else if (posTransaction instanceof PayOutTransaction) {
            PaymentDetailDataReportModel.PaymentDetailData paymentDetailData = new PaymentDetailDataReportModel.PaymentDetailData();
            paymentDetailData.setTime(DateUtil.formatDateWithTimeAndSec(posTransaction.getTransactionTime()));
            PayoutReason payoutReason = ((PayOutTransaction)posTransaction).getReason();
            paymentDetailData.setReason(payoutReason == null ? "" : payoutReason.getReason());
            PayoutRecepient payoutRecepient = ((PayOutTransaction)posTransaction).getRecepient();
            paymentDetailData.setRecipient(payoutRecepient == null ? "" : payoutRecepient.getName());
            paymentDetailData.setUserName(string);
            paymentDetailData.setAmount(posTransaction.getAmount());
            e.add(paymentDetailData);
        } else if (posTransaction instanceof CashDropTransaction) {
            PaymentDetailDataReportModel.PaymentDetailData paymentDetailData = new PaymentDetailDataReportModel.PaymentDetailData();
            paymentDetailData.setTime(DateUtil.formatDateWithTimeAndSec(posTransaction.getTransactionTime()));
            paymentDetailData.setUserName(string);
            paymentDetailData.setAmount(posTransaction.getAmount());
            c.add(paymentDetailData);
        } else {
            a.add(posTransaction);
        }
    }
}

