/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.config.CardConfig;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.BalanceType;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.DebitCardTransaction;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TransactionSubType;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BaseCustomer;
import com.floreantpos.model.base.BaseTerminal;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.BalanceUpdateTransactionDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.services.PostPaymentProcessor;
import com.floreantpos.services.ServiceProcessor;
import com.floreantpos.ui.dialog.MultiCurrencyTenderDialog;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.util.CashRoundingRule;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.StoreUtil;
import com.floreantpos.webservice.CloudDataUploader;
import com.orocube.common.util.TicketStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.json.JSONArray;
import org.json.JSONObject;

public class PosTransactionService {
    private static PosTransactionService a = new PosTransactionService();

    public void settleTicket(Ticket ticket, PosTransaction posTransaction, User user) throws Exception {
        this.settleTicket(ticket, posTransaction, user, null, null);
    }

    public void settleTicket(Ticket ticket, PosTransaction posTransaction, User user, PostPaymentProcessor postPaymentProcessor, List<MultiCurrencyTenderDialog.PaymentByCurrency> list) throws Exception {
        if (user == null) {
            user = Application.getCurrentUser();
        }
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        Transaction transaction = null;
        try (Session session = null;){
            session = TerminalDAO.getInstance().createNewSession();
            Date date = StoreDAO.getServerTimestamp();
            transaction = session.beginTransaction();
            this.b(ticket, posTransaction, session);
            CashDrawer cashDrawer = user.getActiveCashDrawer();
            PosTransactionService.adjustMulticurrencyBalance(session, terminal, cashDrawer, list, posTransaction);
            posTransaction.setTransactionType(TransactionType.CREDIT.name());
            posTransaction.setPaymentType(posTransaction.getPaymentType());
            posTransaction.setTerminal(terminal);
            posTransaction.setUser(user);
            posTransaction.setServer(ticket.getOwner());
            posTransaction.setCashDrawer(cashDrawer);
            posTransaction.setTransactionTime(date);
            posTransaction.setCustomerId(ticket.getCustomerId());
            posTransaction.setCustomerName(ticket.getCustomerName());
            posTransaction.setStoreSessionId(DataProvider.get().getStoreSessionId());
            ticket.setCashier(user);
            if (posTransaction.getAmount() > 0.0) {
                ticket.addTotransactions(posTransaction);
            }
            ticket.setVoided(false);
            ticket.setTerminal(terminal);
            ticket.setPaidAmount(NumberUtil.round(ticket.getPaidAmount() + posTransaction.getAmount()));
            ticket.setShouldUpdateStock(true);
            ticket.calculatePrice();
            if (NumberUtil.isZero(ticket.getDueAmount())) {
                ticket.setPaid(true);
                PosTransactionService.closeTicketIfApplicable(ticket, date);
            } else {
                ticket.setPaid(false);
                ticket.setClosed(false);
            }
            if (ticket.getOrderType() != null && ticket.getOrderType().isBarTab().booleanValue()) {
                ticket.removeProperty("payment_method");
                ticket.removeProperty("card_name");
                ticket.removeProperty("card_transaction_id");
                ticket.removeProperty("card_tracks");
                ticket.removeProperty("card_reader");
                ticket.removeProperty("advance_payment");
                ticket.removeProperty("card_number");
                ticket.removeProperty("card_exp_year");
                ticket.removeProperty("card_exp_month");
                ticket.removeProperty("card_auth_code");
            }
            this.a(ticket, posTransaction, session);
            this.c(ticket, posTransaction);
            PosTransactionService.markItemsAsPaid(ticket);
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            if (postPaymentProcessor != null) {
                postPaymentProcessor.paymentDone(posTransaction, session);
            }
            transaction.commit();
            this.a(ticket, posTransaction);
            CloudDataUploader.get().uploadTicketIfOnlineOrder(ticket);
        }
    }

    public void settleBarTabTicket(Ticket ticket, PosTransaction posTransaction, boolean bl, User user) throws Exception {
        Application application = Application.getInstance();
        Terminal terminal = application.refreshAndGetTerminal();
        Transaction transaction = null;
        GenericDAO genericDAO = new GenericDAO();
        try (Session session = genericDAO.createNewSession();){
            Date date = StoreDAO.getServerTimestamp();
            transaction = session.beginTransaction();
            ticket.setVoided(false);
            ticket.setTerminal(terminal);
            ticket.setPaidAmount(NumberUtil.round(ticket.getPaidAmount() + posTransaction.getAmount()));
            ticket.calculatePrice();
            if (bl) {
                ticket.setPaid(true);
                PosTransactionService.closeTicketIfApplicable(ticket, date);
            } else {
                ticket.setPaid(false);
                ticket.setClosed(false);
            }
            posTransaction.setTransactionType(TransactionType.CREDIT.name());
            posTransaction.setPaymentType(posTransaction.getPaymentType());
            posTransaction.setTerminal(terminal);
            posTransaction.setUser(user);
            posTransaction.setServer(ticket.getOwner());
            posTransaction.setCashDrawer(user.getActiveCashDrawer());
            posTransaction.setTransactionTime(date);
            posTransaction.setStoreSessionId(DataProvider.get().getStoreSessionId());
            ticket.setCashier(user);
            ticket.addTotransactions(posTransaction);
            ticket.setShouldUpdateStock(true);
            PosTransactionService.markItemsAsPaid(ticket);
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            this.b(ticket, posTransaction, session);
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        this.a(ticket, posTransaction);
    }

    public void voidTicket(Ticket ticket, User user) throws Exception {
        Terminal terminal = Application.getInstance().getTerminal();
        ticket.setVoidedBy(user);
        ticket.setTerminal(terminal);
        ticket.calculatePrice();
        TicketDAO.getInstance().voidTicket(ticket);
        try {
            ReceiptPrintService.printVoidTicket(ticket);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PosTransaction refundTicket(Ticket ticket, PosTransaction posTransaction, double d, User user, PaymentType paymentType, Map<String, String> map) throws Exception {
        if (map == null) {
            map = new HashMap<String, String>();
        }
        RefundTransaction refundTransaction = this.createRefundTransaction(ticket, posTransaction, d, paymentType, map);
        refundTransaction.setUser(user);
        refundTransaction.setServer(ticket.getOwner());
        if (NumberUtil.isZero(ticket.getDueAmount())) {
            ticket.setClosed(true);
            ticket.setClosingDate(StoreDAO.getServerTimestamp());
        }
        Transaction transaction = null;
        try (Session session = TicketDAO.getInstance().createNewSession();){
            Object object;
            transaction = session.beginTransaction();
            ticket.setShouldUpdateStock(true);
            PosTransactionService.markItemsAsPaid(ticket);
            this.b(ticket, refundTransaction, session);
            BalanceType balanceType = null;
            Object object2 = null;
            Double d2 = null;
            if (paymentType == PaymentType.GIFT_CERTIFICATE) {
                object = map.get(PosTransaction.PROP_GIFT_CERT_NUMBER);
                if (StringUtils.isBlank((String)object)) {
                    throw new PosException(Messages.getString("GiftCardCannotBeEmpty"));
                }
                GiftCardPaymentPlugin giftCardPaymentPlugin = GiftCardConfig.getPaymentGateway();
                GiftCardProcessor giftCardProcessor = giftCardPaymentPlugin.getProcessor();
                GiftCard giftCard = giftCardProcessor.getCard((String)object);
                if (giftCard == null) {
                    throw new PosException(Messages.getString("PosTransactionService.7"));
                }
                d2 = giftCard.getBalance();
                giftCardProcessor.refund(giftCard.getCardNumber(), d, session);
                balanceType = BalanceType.GIFT_CARD;
                object2 = object;
            } else if (paymentType == PaymentType.MEMBER_ACCOUNT) {
                object = ticket.getCustomer();
                if (object == null) {
                    throw new PosException(Messages.getString("PosTransactionService.1"));
                }
                d2 = ((BaseCustomer)object).getBalance();
                refundTransaction.setCustomerBalanceBefore(d2);
                ((BaseCustomer)object).setBalance(d2 + d);
                refundTransaction.setCustomerBalanceAfter(((BaseCustomer)object).getBalance());
                refundTransaction.setRefunded(true);
                CustomerDAO.getInstance().saveOrUpdate(ticket.getCustomer(), session);
                balanceType = BalanceType.CUSTOMER;
                object2 = ((BaseCustomer)object).getId();
            } else if ((paymentType == PaymentType.CREDIT_CARD || paymentType == PaymentType.DEBIT_CARD) && StringUtils.isNotBlank((String)(object = posTransaction.getCardMerchantGateway())) && CardReader.fromString(posTransaction.getCardReader()) != CardReader.EXTERNAL_TERMINAL) {
                double d3 = posTransaction.getAmount();
                PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGatewayByName((String)object);
                if (paymentGatewayPlugin == null) {
                    throw new PosException(String.format(Messages.getString("card_payment_gateway_is_not_configured"), object));
                }
                CardProcessor cardProcessor = paymentGatewayPlugin.getProcessor();
                try {
                    posTransaction.setAmount(d);
                    cardProcessor.refundTransaction(posTransaction, d);
                }
                catch (PosException posException) {
                    throw posException;
                }
                catch (Exception exception) {
                    throw new PosException(exception.getMessage(), exception);
                }
                finally {
                    posTransaction.setAmount(d3);
                }
            }
            if (posTransaction != null) {
                this.a(posTransaction, d, refundTransaction);
            }
            ticket.addTotransactions(refundTransaction);
            ticket.setRefunded(true);
            ticket.setCashier(user);
            ticket.calculateRefundAmount();
            ticket.setPaidAmount(NumberUtil.round(ticket.getPaidAmount() - refundTransaction.getAmount()));
            ticket.calculatePrice();
            ticket.closeIfApplicable();
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            if (d > 0.0) {
                this.deductCustomerLoyaltyPoint(ticket.getCustomer(), d, refundTransaction, session);
            }
            if ((object = DataProvider.get().getCurrentTerminal()) != null && ((BaseTerminal)object).isEnableMultiCurrency().booleanValue()) {
                PosTransactionService.adjustMulticurrencyBalance(session, (Terminal)object, user.getActiveCashDrawer(), null, refundTransaction);
            }
            if (balanceType != null) {
                BalanceUpdateTransactionDAO.getInstance().saveBalanceUpdateTrans(balanceType, ticket, refundTransaction, TransactionType.CREDIT, (String)object2, d, d2, TransactionSubType.REFUNDED, session);
            }
            transaction.commit();
        }
        return refundTransaction;
    }

    private void a(PosTransaction posTransaction, double d, RefundTransaction refundTransaction) {
        String string = posTransaction.getProperty("REFUNDED_AMOUNT");
        double d2 = 0.0;
        if (StringUtils.isNotEmpty((String)string)) {
            try {
                d2 = NumberUtil.parseDouble(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        refundTransaction.addProperty("REFUNDED_AMOUNT", String.valueOf(d + d2));
        if (posTransaction.getTipsAmount() > 0.0) {
            double d3;
            double d4;
            double d5;
            String string2 = posTransaction.getProperty("REFUNDED_TIPS_AMOUNT");
            double d6 = 0.0;
            if (StringUtils.isNotEmpty((String)string)) {
                try {
                    d6 = NumberUtil.parseDouble(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((d5 = (d4 = d2 + d) - (d3 = posTransaction.getAmount() - posTransaction.getTipsAmount()) - d6) > 0.0) {
                posTransaction.setTipsAmount(d5);
                refundTransaction.addProperty("REFUNDED_TIPS_AMOUNT", String.valueOf(d5 + d6));
            }
        }
    }

    public static void adjustMulticurrencyBalance(Session session, Terminal terminal, CashDrawer cashDrawer, List<MultiCurrencyTenderDialog.PaymentByCurrency> list, PosTransaction posTransaction) {
        if (cashDrawer == null) {
            return;
        }
        if (posTransaction.getPaymentType() != PaymentType.CASH) {
            return;
        }
        if (terminal.isEnableMultiCurrency().booleanValue()) {
            Object object;
            CashDrawerDAO.getInstance().refresh(cashDrawer, session);
            Ticket ticket = posTransaction.getTicket();
            if (list == null) {
                if (posTransaction.isVoided().booleanValue()) {
                    list = new ArrayList<MultiCurrencyTenderDialog.PaymentByCurrency>();
                    object = posTransaction.getProperty("paymentCurrencies");
                    if (StringUtils.isNotBlank((String)object)) {
                        List<MultiCurrencyTenderDialog.PaymentByCurrency> list2 = CurrencyUtil.createPaymentByCurrencies((String)object);
                        for (MultiCurrencyTenderDialog.PaymentByCurrency paymentByCurrency : list2) {
                            if (!(paymentByCurrency.tenderedAmount > 0.0)) continue;
                            double d = paymentByCurrency.tenderedAmount - paymentByCurrency.cashBackAmount;
                            paymentByCurrency.tenderedAmount = -1.0 * d;
                            paymentByCurrency.cashBackAmount = 0.0;
                            list.add(paymentByCurrency);
                        }
                    } else {
                        List<Currency> list3 = CurrencyUtil.getAllCurrency();
                        if (list3 != null && list3.size() > 0) {
                            for (Currency currency : list3) {
                                MultiCurrencyTenderDialog.PaymentByCurrency paymentByCurrency = new MultiCurrencyTenderDialog.PaymentByCurrency();
                                paymentByCurrency.currency = currency;
                                String string = currency.getId() + "_CASH_BACK";
                                String string2 = currency.getId() + "_TENDERED";
                                double d = POSUtil.parseDouble(posTransaction.getProperty(string2));
                                if (!(d > 0.0)) continue;
                                double d2 = POSUtil.parseDouble(posTransaction.getProperty(string));
                                double d3 = d - d2;
                                paymentByCurrency.tenderedAmount = -1.0 * d3;
                                list.add(paymentByCurrency);
                            }
                        }
                    }
                } else {
                    object = new MultiCurrencyTenderDialog.PaymentByCurrency();
                    object.currency = CurrencyUtil.getMainCurrency();
                    object.tenderedAmount = posTransaction.getTenderAmount();
                    if (posTransaction instanceof RefundTransaction || posTransaction instanceof PayOutTransaction || posTransaction instanceof CashDropTransaction) {
                        object.tenderedAmount = -1.0 * posTransaction.getAmount();
                    } else {
                        Double d = ticket.getDueAmount();
                        double d4 = object.cashBackAmount = d > object.tenderedAmount ? 0.0 : object.tenderedAmount - d;
                        if (Math.abs(object.cashBackAmount) < ticket.getToleranceFactor()) {
                            object.cashBackAmount = 0.0;
                        }
                    }
                    list = Arrays.asList(object);
                }
            }
            object = new JSONArray();
            list.forEach(arg_0 -> PosTransactionService.a(cashDrawer, posTransaction, (JSONArray)object, arg_0));
            posTransaction.addProperty("paymentCurrencies", object.toString());
            session.saveOrUpdate((Object)cashDrawer);
            if (ticket != null) {
                ticket.addProperty("enableMultiCurrency", String.valueOf(Boolean.TRUE));
            }
        }
    }

    private void a(Ticket ticket, PosTransaction posTransaction) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(POSConstants.CHECK + "#: " + ticket.getId());
        stringBuilder.append(", Total: " + NumberUtil.formatNumber(ticket.getTotalAmountWithTips()));
        stringBuilder.append(", Transaction amount: " + NumberUtil.formatNumber(posTransaction.getAmount()));
        stringBuilder.append(", Transaction type: " + posTransaction.buildPaymentTypeDisplayName());
        stringBuilder.append(", Server: " + ticket.getOwnerId() + "/" + ticket.getOwnerName());
        stringBuilder.append(", Cash drawer Id: " + posTransaction.getCashDrawerId());
        ActionHistoryDAO.saveHistory(PosAction.getAuthorizedUser(), ticket, posTransaction, "Settle ticket", stringBuilder.toString());
    }

    private void a(Ticket ticket, PosTransaction posTransaction, Session session) {
        Store store = DataProvider.get().getStore();
        Boolean bl = Boolean.valueOf(store.getProperty("loyalty.enabled"));
        if (!bl.booleanValue()) {
            return;
        }
        Customer customer = ticket.getCustomer();
        if (customer == null) {
            return;
        }
        customer = CustomerDAO.getInstance().get(customer.getId(), session);
        this.a(ticket, customer, posTransaction, session);
        this.a(ticket, posTransaction, store, customer, session);
        ticket.updateCustomer(customer);
    }

    private void a(Ticket ticket, Customer customer, PosTransaction posTransaction, Session session) {
        if (ticket == null) {
            throw new PosException(Messages.getString("PosTransactionService.0"));
        }
        if (ticket.getDiscounts() == null) {
            return;
        }
        ArrayList arrayList = new ArrayList();
        ticket.getDiscounts().forEach(ticketDiscount -> {
            if (!ticketDiscount.isLoyaltyCharged()) {
                arrayList.add(ticketDiscount);
            }
        });
        if (arrayList.isEmpty()) {
            return;
        }
        if (customer == null) {
            throw new PosException(Messages.getString("PosTransactionService.3"));
        }
        int n = 0;
        int n2 = customer.getLoyaltyPoint();
        for (TicketDiscount ticketDiscount2 : arrayList) {
            int n3 = ticketDiscount2.getLoyaltyPoint();
            customer.setLoyaltyPoint(n2 - n3);
            ticketDiscount2.setLoyaltyCharged(Boolean.TRUE);
            n += n3;
        }
        posTransaction.setLoyaltyChargedAmount(n);
        ticket.buildDiscounts();
        if (n > 0) {
            BalanceUpdateTransactionDAO.getInstance().saveBalanceUpdateTrans(BalanceType.LOYALTY, ticket, posTransaction, TransactionType.DEBIT, customer.getId(), Double.valueOf(n), Double.valueOf(n2), null, session);
        }
    }

    private void a(Ticket ticket, PosTransaction posTransaction, Store store, Customer customer, Session session) {
        int n;
        if (ticket == null) {
            throw new PosException(Messages.getString("PosTransactionService.0"));
        }
        if (posTransaction == null) {
            throw new PosException(Messages.getString("PosTransactionService.5"));
        }
        if (store == null) {
            throw new PosException(Messages.getString("PosTransactionService.6"));
        }
        if (customer == null) {
            return;
        }
        Integer n2 = customer.getLoyaltyPoint();
        Integer n3 = customer.getLoyaltyPoint();
        int n4 = 0;
        try {
            if (!ticket.isLoyaltyAdded()) {
                n = Integer.parseInt(store.getProperty("loyalty.pointForVisit"));
                if (n > 0) {
                    n4 = n;
                    ticket.setLoyaltyEarnedForVisit(n);
                }
                ticket.setLoyaltyAdded(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        n3 = n3 + n4;
        n = 0;
        try {
            int n5 = Integer.parseInt(store.getProperty("loyalty.pointForPuchases"));
            if (n5 > 0) {
                n = (int)(posTransaction.getAmount() / (double)n5);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        n3 = n3 + n;
        posTransaction.setLoyaltyEarnedForPurchase(n);
        customer.setLoyaltyPoint(n3);
        ticket.setCustomerTotalLoyaltyPoint(n3);
        CustomerDAO.getInstance().update(customer, session);
        BalanceUpdateTransactionDAO.getInstance().saveBalanceUpdateTrans(BalanceType.LOYALTY, ticket, posTransaction, TransactionType.CREDIT, customer.getId(), Double.valueOf(n4 + n), (double)n2, null, session);
    }

    public void deductCustomerLoyaltyPoint(Customer customer, double d, PosTransaction posTransaction, Session session) {
        if (customer == null || d <= 0.0) {
            return;
        }
        Store store = DataProvider.get().getStore();
        Boolean bl = Boolean.valueOf(store.getProperty("loyalty.enabled"));
        Boolean bl2 = Boolean.valueOf(store.getProperty("loyalty.deductPointOnRefund"));
        if (!bl.booleanValue() || !bl2.booleanValue()) {
            return;
        }
        Integer n = customer.getLoyaltyPoint();
        Integer n2 = customer.getLoyaltyPoint();
        Integer n3 = 0;
        try {
            int n4 = Integer.parseInt(store.getProperty("loyalty.pointForPuchases"));
            if (n4 > 0) {
                n3 = (int)Math.ceil(d / (double)n4);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        n2 = n2 - n3;
        posTransaction.addExtraProperty("loyalty.deducted", String.valueOf(n3));
        customer.setLoyaltyPoint(n2 > 0 ? n2 : 0);
        CustomerDAO.getInstance().update(customer, session);
        BalanceUpdateTransactionDAO.getInstance().saveBalanceUpdateTrans(BalanceType.LOYALTY, posTransaction.getTicket(), posTransaction, TransactionType.DEBIT, customer.getId(), (double)n3, (double)n, null, session);
    }

    private void b(Ticket ticket, PosTransaction posTransaction) {
        double d = 0.0;
        Currency currency = CurrencyUtil.getMainCurrency();
        if (currency != null) {
            d = currency.getTolerance();
        }
        posTransaction.setToleranceAmount(ticket.getToleranceAmount());
        double d2 = NumberUtil.round(posTransaction.getTenderAmount() - posTransaction.getAmount());
        if (d2 == 0.0) {
            return;
        }
        Store store = DataProvider.get().getStore();
        double d3 = store.isAllowPenyRounding() ? (double)Math.round(d2 * 100.0 / 5.0) * 5.0 / 100.0 : d2;
        double d4 = d2 - d3;
        if (Math.abs(d3) <= d) {
            posTransaction.setToleranceAmount(d2);
            posTransaction.setChangeAmount(0.0);
        } else {
            posTransaction.setToleranceAmount(d4);
            posTransaction.setChangeAmount(d3);
        }
        posTransaction.setAmount(posTransaction.getAmount() + posTransaction.getToleranceAmount());
    }

    public static void closeTicketIfApplicable(Ticket ticket, Date date) {
        OrderType orderType = ticket.getOrderType();
        if (orderType != null && (orderType.isCloseOnPaid().booleanValue() || orderType.isBarTab().booleanValue())) {
            ticket.setClosed(true);
            ticket.setClosingDate(date);
            TicketStatus ticketStatus = ticket.getTicketStatus();
            if (ticketStatus != TicketStatus.DeliveryFailed) {
                ticket.setTicketStatus(TicketStatus.Completed);
            }
        }
    }

    private void c(Ticket ticket, PosTransaction posTransaction) {
        double d = ticket.getGratuityAmount();
        if (d <= 0.0) {
            return;
        }
        double d2 = 0.0;
        Set<PosTransaction> set = ticket.getTransactions();
        if (set != null && set.size() > 0) {
            for (PosTransaction posTransaction2 : set) {
                if (posTransaction2 instanceof RefundTransaction || posTransaction2.isVoided().booleanValue()) continue;
                d2 += posTransaction2.getTipsAmount().doubleValue();
            }
        }
        double d3 = d - d2;
        double d4 = d3 + ticket.getPaidAmount() - ticket.getTotalAmountWithTips();
        if (d3 > 0.0) {
            if (ticket.getDueAmount() == 0.0) {
                posTransaction.setTipsAmount(d3);
            } else if (d4 > 0.0) {
                Double d5 = posTransaction.getAmount();
                if (d4 > d5) {
                    posTransaction.setTipsAmount(d5);
                } else {
                    posTransaction.setTipsAmount(d4);
                }
            }
        }
    }

    public RefundTransaction createRefundTransaction(Ticket ticket, PosTransaction posTransaction, double d, PaymentType paymentType, Map<String, String> map) {
        CashRoundingRule cashRoundingRule;
        double d2;
        if (posTransaction != null && d > (d2 = posTransaction.getRefundableAmount().doubleValue())) {
            throw new PosException(Messages.getString("RefundDialog.36") + " " + d2);
        }
        RefundTransaction refundTransaction = new RefundTransaction();
        if (map != null) {
            refundTransaction.setCustomPaymentFieldName(map.get(PosTransaction.PROP_CUSTOM_PAYMENT_FIELD_NAME));
            refundTransaction.setCustomPaymentId(map.get(PosTransaction.PROP_CUSTOM_PAYMENT_ID));
            refundTransaction.setCustomPaymentName(map.get(PosTransaction.PROP_CUSTOM_PAYMENT_NAME));
            refundTransaction.setCustomPaymentRef(map.get(PosTransaction.PROP_CUSTOM_PAYMENT_REF));
            refundTransaction.setGiftCertNumber(map.get(PosTransaction.PROP_GIFT_CERT_NUMBER));
        }
        refundTransaction.setPaymentType(paymentType);
        Double d3 = ticket.getDueAmount();
        Store store = DataProvider.get().getStore();
        if (paymentType == PaymentType.CASH && (cashRoundingRule = StoreUtil.getCashRounding(store)) != CashRoundingRule._NOROUNDING) {
            double d4 = CashRoundingRule.round(cashRoundingRule, d3);
            ticket.setRoundedAmount(NumberUtil.round(ticket.getRoundedAmount() - (d3 - d4)));
            ticket.calculatePrice();
            double d5 = NumberUtil.round(d4 - d3);
            refundTransaction.setRoundedAmount(d5);
            d -= d5;
        }
        refundTransaction.setTenderAmount(d);
        refundTransaction.setAmount(d);
        refundTransaction.setTicket(ticket);
        refundTransaction.setCustomerId(ticket.getCustomerId());
        refundTransaction.setCustomerName(ticket.getCustomerName());
        refundTransaction.setTerminal(DataProvider.get().getCurrentTerminal());
        refundTransaction.setTransactionType(TransactionType.DEBIT.name());
        refundTransaction.setCashDrawer(Application.getCurrentUser().getActiveCashDrawer());
        refundTransaction.setOutletId(DataProvider.get().getCurrentOutletId());
        refundTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
        refundTransaction.setStoreSessionId(DataProvider.get().getStoreSessionId());
        if (posTransaction == null) {
            return refundTransaction;
        }
        refundTransaction.setCardExpMonth(posTransaction.getCardExpMonth());
        refundTransaction.setCardHolderName(posTransaction.getCardHolderName());
        refundTransaction.setCardAuthCode(posTransaction.getCardAuthCode());
        refundTransaction.setCardMerchantGateway(posTransaction.getCardMerchantGateway());
        refundTransaction.setCardNumber(posTransaction.getCardNumber());
        refundTransaction.setCardTrack(posTransaction.getCardTrack());
        refundTransaction.setCardTransactionId(posTransaction.getCardTransactionId());
        refundTransaction.setCardReader(posTransaction.getCardReader());
        refundTransaction.setCardType(posTransaction.getCardType());
        refundTransaction.addProperty("REFUNDED_TRANSACTION_ID", posTransaction.getId());
        return refundTransaction;
    }

    public static void markItemsAsPaid(Ticket ticket) {
        List<TicketItem> list = ticket.getTicketItems();
        for (TicketItem ticketItem : list) {
            ticketItem.setPaid(true);
        }
    }

    private void a(Ticket ticket, Session session) {
        if (StringUtils.isBlank((String)ticket.getId())) {
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
        }
    }

    private void b(Ticket ticket, PosTransaction posTransaction, Session session) {
        boolean bl = Boolean.FALSE;
        List<TicketItem> list = ticket.getTicketItems();
        for (TicketItem ticketItem : list) {
            double d;
            Object object;
            if (ticketItem.isService().booleanValue() && !ticketItem.getBooleanProperty("processed", false).booleanValue()) {
                if (StringUtils.isBlank((String)posTransaction.getId())) {
                    PosTransactionDAO.getInstance().save(posTransaction, session);
                }
                this.a(ticket, session);
                object = new ServiceProcessor();
                ((ServiceProcessor)object).prcocess(ticketItem, ticket, posTransaction, session);
                ticketItem.addProperty("processed", String.valueOf(Boolean.TRUE));
                continue;
            }
            if (!ticketItem.isGiftCard() || posTransaction instanceof RefundTransaction) continue;
            object = ticketItem.getGiftCardNo();
            GiftCard giftCard = GiftCardDAO.getInstance().findByCardNumber(session, (String)object);
            if (giftCard == null) {
                if (posTransaction instanceof CreditCardTransaction || posTransaction instanceof DebitCardTransaction) {
                    PosLog.error(PosTransactionService.class, String.format(Messages.getString("PosTransactionService.8"), object, posTransaction.getCardNumber()));
                    return;
                }
                throw new PosException(String.format(Messages.getString("GiftCardNoNotFound"), object));
            }
            double d2 = ticketItem.getUnitPrice();
            if (d2 == (d = ticketItem.getGiftCardPaidAmount())) {
                return;
            }
            this.a(ticket, session);
            bl = Boolean.TRUE;
            ticketItem.setGiftCardPaidAmount(d2);
            posTransaction.setGiftCertNumber((String)object);
            posTransaction.setGiftCertFaceValue(d2);
            posTransaction.addGiftCardBalanceAddInfo(ticketItem.getId(), (String)object, d2);
            Double d3 = giftCard.getBalance();
            giftCard.setBalance(d3 + d2);
            GiftCardDAO.getInstance().saveOrUpdate(giftCard, session);
            BalanceUpdateTransactionDAO.getInstance().saveBalanceUpdateTrans(BalanceType.GIFT_CARD, ticket, posTransaction, TransactionType.CREDIT, (String)object, d2, d3, TransactionSubType.BALANCE_ADDED, session);
        }
        if (bl) {
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
        }
    }

    public static PosTransactionService getInstance() {
        return a;
    }

    public static void sortTransactionsByDateDesc(List<PosTransaction> list) {
        Collections.sort(list, new Comparator<PosTransaction>(){

            @Override
            public int compare(PosTransaction posTransaction, PosTransaction posTransaction2) {
                if (posTransaction.getTransactionTime() == null) {
                    return -1;
                }
                if (posTransaction2.getTransactionTime() == null) {
                    return 1;
                }
                return posTransaction2.getTransactionTime().compareTo(posTransaction.getTransactionTime());
            }
        });
    }

    private static /* synthetic */ void a(CashDrawer cashDrawer, PosTransaction posTransaction, JSONArray jSONArray, MultiCurrencyTenderDialog.PaymentByCurrency paymentByCurrency) {
        Currency currency = paymentByCurrency.currency;
        CashBreakdown cashBreakdown = cashDrawer.getCurrencyBalance(currency);
        double d = paymentByCurrency.tenderedAmount - paymentByCurrency.cashBackAmount;
        if (cashBreakdown != null) {
            cashBreakdown.setBalance(cashBreakdown.getBalance() + d);
        }
        if (!posTransaction.isVoided().booleanValue()) {
            double d2 = paymentByCurrency.tenderedAmount - paymentByCurrency.cashBackAmount;
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("currency.id", (Object)currency.getId());
            jSONObject.put("currency.name", (Object)currency.getName());
            jSONObject.put("currency.code", (Object)currency.getCode());
            jSONObject.put("currency.symbol", (Object)currency.getSymbol());
            jSONObject.put("currency.rate", (Object)currency.getExchangeRate());
            jSONObject.put("currency.tendered", (Object)NumberUtil.format(paymentByCurrency.tenderedAmount));
            jSONObject.put("currency.change", (Object)NumberUtil.format(paymentByCurrency.cashBackAmount));
            jSONObject.put("currency.paidAmount", (Object)NumberUtil.format(d2));
            jSONArray.put((Object)jSONObject);
        }
    }
}

