/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.BalanceType;
import com.floreantpos.model.BalanceUpdateTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.ServiceType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TransactionSubType;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.dao.BalanceUpdateTransactionDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.services.MembershipService;
import com.floreantpos.ui.dialog.MembershipDataInputDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

public class ServiceProcessor {
    public void prcocess(TicketItem ticketItem, Ticket ticket, PosTransaction posTransaction, Session session) {
        ServiceType serviceType = ServiceType.valueOf(ticketItem.getServiceType());
        switch (serviceType) {
            case MEMBERSHIP: {
                MembershipService membershipService = new MembershipService();
                membershipService.process(ticketItem, ticket, session);
                break;
            }
            case ADD_CUSTOMER_BALANCE: {
                String string = ticket.getCustomerId();
                if (StringUtils.isBlank((String)string)) {
                    throw new PosException(Messages.getString("CustomerIsNotSelectedForTicket"));
                }
                Customer customer = CustomerDAO.getInstance().get(string, session);
                Double d = ticketItem.getUnitPrice();
                BalanceUpdateTransaction balanceUpdateTransaction = new BalanceUpdateTransaction();
                balanceUpdateTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
                balanceUpdateTransaction.setAccountNumber(string);
                balanceUpdateTransaction.setAmount(d);
                balanceUpdateTransaction.setBalanceBefore(customer.getBalance());
                balanceUpdateTransaction.setBalanceType(BalanceType.CUSTOMER);
                balanceUpdateTransaction.setDescription(TransactionSubType.BALANCE_ADDED.name());
                balanceUpdateTransaction.setTransactionSubType(TransactionSubType.BALANCE_ADDED.name());
                balanceUpdateTransaction.setTransactionType(TransactionType.CREDIT.name());
                balanceUpdateTransaction.setTicketId(ticket.getId());
                balanceUpdateTransaction.setTransactionId(posTransaction.getId());
                balanceUpdateTransaction.setPaymentType(posTransaction.getPaymentType());
                customer.setBalance(customer.getBalance() + d);
                CustomerDAO.getInstance().update(customer, session);
                BalanceUpdateTransactionDAO.getInstance().save(balanceUpdateTransaction);
                break;
            }
        }
    }

    public static boolean captureServiceInput(Ticket ticket, TicketItem ticketItem, MenuItem menuItem) {
        ServiceType serviceType = ServiceType.valueOf(menuItem.getServiceType());
        switch (serviceType) {
            case MEMBERSHIP: {
                MembershipDataInputDialog membershipDataInputDialog = new MembershipDataInputDialog(ticket, menuItem);
                membershipDataInputDialog.pack();
                membershipDataInputDialog.setOkButtonText(POSConstants.ADD_BUTTON_TEXT);
                membershipDataInputDialog.open();
                if (membershipDataInputDialog.isCanceled()) {
                    return false;
                }
                ticketItem.setServiceStartDate(membershipDataInputDialog.getServiceStartTime());
                ticketItem.setServiceEndDate(membershipDataInputDialog.getServiceEndTime());
                List<Attribute> list = menuItem.getAttributes();
                if (list != null && list.size() > 0) {
                    Attribute attribute = list.get(0);
                    ticketItem.addProperty("attribute_id", attribute.getId());
                    ticketItem.addProperty("attribute_name", attribute.getName());
                }
                return true;
            }
            case ADD_CUSTOMER_BALANCE: {
                Double d = NumberSelectionDialog2.takeDoubleInput("Enter amount", true);
                if (d == null) {
                    return false;
                }
                ticketItem.setDiscountApplicable(false);
                ticketItem.setQuantity(1.0);
                ticketItem.setUnitPrice(d);
                return true;
            }
        }
        return false;
    }
}

