/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.Customer;
import com.floreantpos.model.PropertyContainer;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.base.BaseTicketItem;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class SplitTicketService {
    public static final String SPLIT_TYPE = "SPLIT_TYPE";
    public static final int SPLIT_EQUALLY = 0;
    public static final int SPLIT_BY_SEAT = 1;
    public static final int SPLIT_MANUALLY = 2;
    public static final int maxSplitQuantity = 100;

    public static List<Ticket> doEquallySplit(Ticket ticket, int n) throws Exception {
        PropertyContainer propertyContainer;
        int n2;
        double d = ticket.getTotalAmount();
        double d2 = d / (double)n;
        double d3 = NumberUtil.round(d2);
        double d4 = d3 * (double)n - d2 * (double)n;
        int n3 = (int)Math.abs(NumberUtil.round(d4) * 100.0);
        ArrayList<TicketItem> arrayList = new ArrayList<TicketItem>(ticket.getTicketItems());
        ArrayList<Ticket> arrayList2 = new ArrayList<Ticket>();
        ticket.getTicketItems().clear();
        arrayList2.add(ticket);
        for (n2 = 1; n2 < n; ++n2) {
            propertyContainer = SplitTicketService.a(ticket, n);
            arrayList2.add((Ticket)propertyContainer);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            propertyContainer = (TicketItem)arrayList.get(n2);
            if (((BaseTicketItem)((Object)propertyContainer)).isVoided().booleanValue() || ((BaseTicketItem)((Object)propertyContainer)).isItemReturned().booleanValue() || ((BaseTicketItem)((Object)propertyContainer)).isService().booleanValue()) {
                Ticket ticket2 = (Ticket)arrayList2.get(0);
                ((BaseTicketItem)((Object)propertyContainer)).setTicket(ticket2);
                ticket2.addToticketItems((TicketItem)propertyContainer);
                continue;
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                Ticket ticket3 = (Ticket)arrayList2.get(i);
                double d5 = d3;
                if (i < n3) {
                    if (d3 > d2) {
                        d5 -= 0.01;
                    } else if (d3 < d2) {
                        d5 += 0.01;
                    }
                }
                TicketItem ticketItem = SplitTicketService.a(ticket3, (TicketItem)propertyContainer, d, d5, n);
                ticketItem.setTicket(ticket3);
                ticket3.addToticketItems(ticketItem);
                ticket3.setSplitOrder(i + 1);
                ticket3.addProperty("split", String.valueOf(Boolean.TRUE));
                ticket3.addProperty(SPLIT_TYPE, String.valueOf(0));
                ticket3.addProperty("split_ticket_id", ticket.getId());
            }
        }
        for (n2 = 0; n2 < arrayList2.size(); ++n2) {
            propertyContainer = (Ticket)arrayList2.get(n2);
            ((Ticket)propertyContainer).calculatePrice();
        }
        return arrayList2;
    }

    private static TicketItem a(Ticket ticket, TicketItem ticketItem, double d, double d2, int n) throws Exception {
        List<Comparable> list;
        TicketItem ticketItem2 = ticketItem.cloneAsNew(true);
        ticketItem2.setSplitted(true);
        if (ticket.getId() != null) {
            ticketItem2.setCreateDate(ticketItem.getCreateDate());
        }
        ticketItem.setTicket(ticket);
        TicketItemSeat ticketItemSeat = ticketItem.getSeat();
        if (ticketItemSeat != null) {
            ticketItemSeat.setId(null);
            ticketItem2.setSeat(ticketItemSeat);
        }
        ticketItem2.setQuantity(d2 * ticketItem.getQuantity() / d);
        if (ticketItem.isInventoryAdjusted()) {
            ticketItem2.setInventoryAdjustQty(ticketItem2.getQuantity());
        }
        if (ticketItem2.isComboItem().booleanValue() && (list = ticketItem2.getComboItems()) != null) {
            for (TicketItem ticketItem3 : list) {
                ticketItem3.setQuantity(ticketItem3.getQuantity() / (double)n);
            }
        }
        if (ticketItem2.getQuantity() % 1.0 != 0.0) {
            ticketItem2.setFractionalUnit(true);
        }
        list = ticketItem2.getDiscounts();
        ticketItem2.calculatePrice();
        SplitTicketService.b(list, n);
        return ticketItem2;
    }

    public static List<Ticket> doSplitBySeatNumber(Ticket ticket) throws Exception {
        int n;
        ArrayList<TicketItem> arrayList = new ArrayList<TicketItem>(ticket.getTicketItems());
        ArrayList<TicketItem> arrayList2 = new ArrayList<TicketItem>();
        HashMap<String, Customer> hashMap = new HashMap<String, Customer>();
        HashMap<String, List<TicketItem>> hashMap2 = new HashMap<String, List<TicketItem>>();
        SplitTicketService.a(arrayList, arrayList2, hashMap, hashMap2);
        if (hashMap2.size() > 100) {
            throw new PosException(String.format(Messages.getString("SplitTicketService.16"), 100));
        }
        if (hashMap2.size() <= 1) {
            return null;
        }
        int n2 = 0;
        if (hashMap2.keySet().size() > 1) {
            n2 = hashMap2.keySet().size();
        }
        ArrayList<Ticket> arrayList3 = new ArrayList<Ticket>();
        ticket.getTicketItems().clear();
        arrayList3.add(ticket);
        for (n = 1; n < n2; ++n) {
            Iterator iterator = SplitTicketService.a(ticket, n2);
            arrayList3.add((Ticket)((Object)iterator));
        }
        n = 0;
        for (String object2 : hashMap2.keySet()) {
            Ticket ticket2 = (Ticket)arrayList3.get(n++);
            List list = (List)hashMap2.get(object2);
            if (list == null) continue;
            for (TicketItem ticketItem : list) {
                ticketItem.setTicket(ticket2);
                ticket2.addToticketItems(ticketItem);
            }
        }
        n = 0;
        for (Ticket ticket3 : arrayList3) {
            for (TicketItem ticketItem : arrayList2) {
                TicketItem ticketItem2 = SplitTicketService.a(ticket3, ticketItem, n, n2);
                ticketItem2.setTicket(ticket3);
                ticket3.addToticketItems(ticketItem2);
            }
            ++n;
            ticket3.calculatePrice();
        }
        return arrayList3;
    }

    private static void a(List<TicketItem> list, List<TicketItem> list2, Map<String, Customer> map, Map<String, List<TicketItem>> map2) {
        for (TicketItem ticketItem : list) {
            String string;
            if (ticketItem.isTreatAsSeat().booleanValue()) continue;
            TicketItem ticketItem2 = ticketItem.cloneAsNew(true);
            TicketItemSeat ticketItemSeat = ticketItem.getSeat();
            Integer n = ticketItem.getSeatNumber();
            Object object = ticketItemSeat == null ? (n == null || n == 0 ? null : n.toString()) : (string = ticketItemSeat.getSeatId());
            if (StringUtils.isBlank((String)string)) {
                list2.add(ticketItem2);
                continue;
            }
            List<TicketItem> list3 = map2.get(string);
            if (list3 == null) {
                list3 = new ArrayList<TicketItem>();
                list3.add(ticketItem2);
                if (ticketItemSeat != null) {
                    map.put(string, ticketItemSeat.getMember());
                }
                map2.put(string, list3);
                continue;
            }
            list3.add(ticketItem2);
        }
    }

    private static List<TicketDiscount> a(List<TicketDiscount> list, int n) throws Exception {
        ArrayList<TicketDiscount> arrayList = new ArrayList<TicketDiscount>();
        if (list != null && !list.isEmpty()) {
            for (TicketDiscount ticketDiscount : list) {
                TicketDiscount ticketDiscount2 = new TicketDiscount();
                PropertyUtils.copyProperties((Object)ticketDiscount2, (Object)ticketDiscount);
                ticketDiscount2.setId(null);
                if (ticketDiscount.getType() != 1) {
                    ticketDiscount2.setCouponQuantity(ticketDiscount.getCouponQuantity() / (double)n);
                }
                arrayList.add(ticketDiscount2);
            }
        }
        return arrayList;
    }

    private static Ticket a(Ticket ticket, int n) throws Exception {
        Ticket ticket2 = new Ticket(true);
        BeanUtils.copyProperties((Object)ticket, (Object)ticket2, (String[])new String[]{"customer"});
        ticket2.setProperties(null);
        ticket2.setTransactions(null);
        ticket2.setId(null);
        ticket2.setTokenNo(null);
        ticket2.setShortId(null);
        ticket2.setTicketItems(null);
        ticket2.setCreateDate(null);
        ticket2.setLastUpdateTime(null);
        ticket2.setLastSyncTime(null);
        ticket2.setGratuity(null);
        ticket2.setCloudSynced(false);
        ticket2.setDiscounts(SplitTicketService.a(ticket.getDiscounts(), n));
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List<Integer> list = ticket.getTableNumbers();
        if (list != null) {
            arrayList.addAll(list);
        }
        ticket2.setTableNumbers(arrayList);
        Optional<Customer> optional = Optional.ofNullable(ticket.getCustomer());
        optional.ifPresent(customer -> ticket2.setCustomer((Customer)customer));
        return ticket2;
    }

    private static void b(List<TicketItemDiscount> list, int n) throws Exception {
        if (list != null && !list.isEmpty()) {
            for (TicketItemDiscount ticketItemDiscount : list) {
                if (ticketItemDiscount.getType() != 1) {
                    ticketItemDiscount.setCouponQuantity(ticketItemDiscount.getCouponQuantity() / (double)n);
                }
                ticketItemDiscount.calculateDiscount(ticketItemDiscount.getTicketItem().getSubtotalAmount());
            }
        }
    }

    private static TicketItem a(Ticket ticket, TicketItem ticketItem, int n, int n2) throws Exception {
        double d;
        TicketItem ticketItem2 = ticketItem.cloneAsNew(true);
        ticketItem2.setSplitted(true);
        if (ticket.getId() != null) {
            ticketItem2.setCreateDate(ticketItem.getCreateDate());
        }
        ticketItem.setTicket(ticket);
        TicketItemSeat ticketItemSeat = ticketItem.getSeat();
        if (ticketItemSeat != null) {
            ticketItemSeat.setId(null);
            ticketItem2.setSeat(ticketItemSeat);
        }
        if ((d = ticketItem.getQuantity() / (double)n2) % 1.0 == 0.0) {
            ticketItem2.setQuantity(d);
        } else {
            double d2 = ticketItem.getSubtotalAmount() / ticketItem.getQuantity();
            double d3 = d2 * d * (double)n2;
            double d4 = NumberUtil.round(d2 * d) * (double)n2;
            double d5 = d4 - d3;
            int n3 = (int)Math.abs(NumberUtil.round(d5) * 100.0);
            ticketItem2.setQuantity(d);
            double d6 = ticketItem2.getUnitPrice() * ticketItem2.getQuantity();
            if (n < n3) {
                ticketItem2.setQuantity(d3 * d / d4);
                double d7 = ticketItem2.getUnitPrice() * ticketItem2.getQuantity();
                if (NumberUtil.round(d6) == NumberUtil.round(d7)) {
                    if (d4 < d3) {
                        ticketItem2.setQuantity((d7 + Math.abs(d5)) * ticketItem2.getQuantity() / d7);
                    } else {
                        ticketItem2.setQuantity((d7 - Math.abs(d5)) * ticketItem2.getQuantity() / d7);
                    }
                }
            } else {
                ticketItem2.setQuantity(d);
            }
            ticketItem2.setFractionalUnit(true);
        }
        List<TicketItemDiscount> list = ticketItem2.getDiscounts();
        ticketItem2.calculatePrice();
        SplitTicketService.b(list, n2);
        return ticketItem2;
    }

    public static void splitAndDistributeItem(TicketItem ticketItem, Ticket ticket, List<Ticket> list) throws Exception {
        int n = ticket.getTicketItems().indexOf(ticketItem);
        list.add(0, ticket);
        int n2 = list.size();
        for (int i = 0; i < list.size(); ++i) {
            Ticket ticket2 = list.get(i);
            TicketItem ticketItem2 = SplitTicketService.a(ticket2, ticketItem, i, n2);
            ticketItem2.setTicket(ticket2);
            if (ticket2 == ticket) {
                ticket.getTicketItems().set(n, ticketItem2);
            } else {
                ticket2.addToticketItems(ticketItem2);
            }
            ticket2.calculatePrice();
        }
    }
}

