/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import java.awt.Color;
import org.apache.commons.lang.StringUtils;

public class BarTabButton
extends PosButton {
    private User a;
    private Ticket b;

    public BarTabButton(Ticket ticket) {
        this.b = ticket;
        if (ticket.getId() != null) {
            this.setText(ticket.getId() + "");
        }
        this.update();
    }

    public String getId() {
        return this.b.getId();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BarTabButton)) {
            return false;
        }
        BarTabButton barTabButton = (BarTabButton)object;
        return this.b.equals(barTabButton.b);
    }

    public int hashCode() {
        return this.b.hashCode();
    }

    @Override
    public String toString() {
        return this.b.toString();
    }

    public void update() {
        this.setEnabled(true);
        this.setBackground(Color.white);
        this.setForeground(Color.black);
    }

    public void setUser(User user) {
        if (user != null) {
            this.a = user;
        }
    }

    public User getUser() {
        return this.a;
    }

    public boolean hasUserAccess() {
        String string;
        if (this.a == null) {
            return false;
        }
        User user = Application.getCurrentUser();
        String string2 = user.getId();
        if (string2 == (string = this.a.getId())) {
            return true;
        }
        if (user.hasPermission(UserPermission.PERFORM_MANAGER_TASK) || user.hasPermission(UserPermission.PERFORM_ADMINISTRATIVE_TASK)) {
            return true;
        }
        String string3 = PasswordEntryDialog.show(Application.getPosWindow(), Messages.getString("PosAction.0"));
        if (StringUtils.isEmpty((String)string3)) {
            return false;
        }
        User user2 = UserDAO.getInstance().findUserBySecretKey(string3);
        if (!user2.hasPermission(UserPermission.PERFORM_MANAGER_TASK)) {
            POSMessageDialog.showError(Application.getPosWindow(), UserPermission.PERFORM_MANAGER_TASK.getName() + ": " + Messages.getString("PosAction.2"));
            return false;
        }
        if (!user2.hasPermission(UserPermission.PERFORM_ADMINISTRATIVE_TASK)) {
            POSMessageDialog.showError(Application.getPosWindow(), UserPermission.PERFORM_ADMINISTRATIVE_TASK.getName() + ": " + Messages.getString("PosAction.2"));
            return false;
        }
        return true;
    }

    public void setTicket(Ticket ticket) {
        this.b = ticket;
    }

    public Ticket getTicket() {
        return this.b;
    }
}

