/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Discount;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class TicketItemDiscountSelectionDialog
extends OkCancelOptionDialog
implements TicketEditListener,
ActionListener {
    private ScrollableFlowPanel a;
    private HashMap<String, DiscountButton> b = new HashMap();
    private JPanel c;
    private JTextField d;
    private TicketViewerTable e;
    private Ticket f;
    private List<TicketItemDiscountMapping> g;

    public TicketItemDiscountSelectionDialog(Ticket ticket) {
        super(POSUtil.getFocusedWindow(), Messages.getString("DiscountSelectionDialog.0"));
        this.f = ticket;
        this.g = new ArrayList<TicketItemDiscountMapping>();
        this.a();
    }

    private void a() {
        this.setOkButtonText(POSConstants.SAVE);
        this.getContentPanel().setBorder(new EmptyBorder(5, 5, 0, 5));
        this.b();
        this.getContentPanel().add((Component)this.c, "North");
        this.a = new ScrollableFlowPanel(1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(null, Messages.getString("TicketItemDiscountSelectionDialog.1"), 2, 0);
        PosScrollPane posScrollPane = new PosScrollPane(this.a, 20, 31);
        posScrollPane.setBorder(new CompoundBorder(new EmptyBorder(5, 0, 0, 8), titledBorder));
        this.e = new TicketViewerTable(this.f);
        this.e.addTicketUpdateListener(this);
        this.e.setSelectionMode(2);
        this.e.setVisibleDeleteButton(0);
        PosScrollPane posScrollPane2 = new PosScrollPane(this.e);
        posScrollPane2.setPreferredSize(PosUIManager.getSize(350, 0));
        posScrollPane2.setBorder(new CompoundBorder(new EmptyBorder(12, 10, 2, 0), BorderFactory.createTitledBorder("")));
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.add((Component)posScrollPane2, "West");
        jPanel.add((Component)posScrollPane, "Center");
        this.getContentPanel().add((Component)jPanel, "Center");
        PosButton posButton = new PosButton(Messages.getString("TicketItemDiscountSelectionDialog.2"));
        posButton.addActionListener(actionEvent -> this.c());
        this.getButtonPanel().add((Component)posButton, 0);
        this.d();
        this.setSize(1024, 720);
    }

    private void b() {
        this.c = new JPanel(new BorderLayout(5, 5));
        this.c.setBorder(new EmptyBorder(0, 10, 0, 10));
        PosButton posButton = new PosButton(IconFactory.getIcon("/ui_icons/", "search.png"));
        posButton.setPreferredSize(new Dimension(60, 40));
        JLabel jLabel = new JLabel(Messages.getString("DiscountSelectionDialog.4"));
        this.d = new JTextField();
        this.d.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                TicketItemDiscountSelectionDialog.this.d.setText(Messages.getString("DiscountSelectionDialog.5"));
                TicketItemDiscountSelectionDialog.this.d.setForeground(Color.gray);
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                TicketItemDiscountSelectionDialog.this.d.setForeground(Color.black);
                TicketItemDiscountSelectionDialog.this.d.setText("");
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (StringUtils.isBlank((String)TicketItemDiscountSelectionDialog.this.d.getText())) {
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DiscountSelectionDialog.8"));
                        return;
                    }
                    if (!TicketItemDiscountSelectionDialog.this.a(TicketItemDiscountSelectionDialog.this.d.getText())) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DiscountSelectionDialog.11"));
                    }
                    TicketItemDiscountSelectionDialog.this.d.setText("");
                }
                catch (PosException posException) {
                    POSMessageDialog.showError(posException.getMessage());
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = GlobalInputDialog.showInputDialog(Messages.getString("DiscountSelectionDialog.10"), Messages.getString("DiscountSelectionDialog.8"), TicketItemDiscountSelectionDialog.this.d.getText(), Messages.getString("DiscountSelectionDialog.8"));
                    if (StringUtils.isBlank((String)string)) {
                        return;
                    }
                    TicketItemDiscountSelectionDialog.this.d.requestFocus();
                    if (!TicketItemDiscountSelectionDialog.this.a(string)) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DiscountSelectionDialog.11"));
                    }
                }
                catch (PosException posException) {
                    POSMessageDialog.showError(posException.getMessage());
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        this.c.add((Component)jLabel, "West");
        this.c.add(this.d);
        this.c.add((Component)posButton, "East");
    }

    private void c() {
        if (this.f.hasSeat()) {
            return;
        }
        String string = Messages.getString("TicketItemDiscountSelectionDialog.0");
        int n = POSMessageDialog.showYesNoQuestionDialog(string);
        if (n != 0) {
            return;
        }
        this.f.consolidateTicketItems();
        this.e.updateView();
    }

    private boolean a(String string) {
        Discount discount = DiscountDAO.getInstance().getDiscountByBarcode(string, 0);
        if (discount == null) {
            return false;
        }
        DiscountButton discountButton = this.b.get(discount.getId());
        discountButton.setSelected(true);
        try {
            Thread.sleep(30L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.a(discountButton);
        discountButton.setSelected(false);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.d();
    }

    private void d() {
        this.b.clear();
        this.a.getContentPane().removeAll();
        List<Discount> list = DiscountDAO.getInstance().getValidItemCoupons();
        for (Discount discount : list) {
            DiscountButton discountButton = new DiscountButton(discount);
            this.a.add(discountButton);
            this.b.put(discount.getId(), discountButton);
        }
        this.a.repaint();
        this.a.revalidate();
    }

    @Override
    public void doOk() {
        this.g.clear();
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void doCancel() {
        this.e();
        this.b.clear();
        this.setCanceled(true);
        this.dispose();
    }

    /*
     * WARNING - void declaration
     */
    private void a(DiscountButton discountButton) {
        void var7_11;
        List<TicketItemDiscount> list;
        int n;
        boolean bl;
        int[] nArray = this.e.getSelectedRows();
        Discount discount = discountButton.getDiscount();
        DiscountDAO.getInstance().validateCouponConditions(discount, this.f.getCustomerId());
        ArrayList<TicketItem> arrayList = new ArrayList<TicketItem>();
        Store store = DataProvider.get().getStore();
        boolean bl2 = bl = discountButton.getDiscount().getType() == 2;
        if (bl) {
            this.a(discount);
            return;
        }
        if (nArray.length == 0) {
            String object = Messages.getString("TicketItemDiscountSelectionDialog.19");
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), object, POSConstants.CONFIRM) != 0) {
                return;
            }
            for (n = 0; n < this.e.getRowCount(); ++n) {
                TicketItem ticketItem;
                ITicketItem iTicketItem = this.e.get(n);
                if (!(iTicketItem instanceof TicketItem) || !(ticketItem = (TicketItem)iTicketItem).isDiscountApplicable().booleanValue() || ticketItem.isTreatAsSeat().booleanValue() || ticketItem.isVoided().booleanValue() || ticketItem.isGiftCard() || ticketItem.getQuantity() < discount.getMinimumBuy() || ticketItem.hasDiscount() && !store.isAllowMulDiscount()) continue;
                arrayList.add((TicketItem)iTicketItem);
            }
        } else {
            for (int n2 : nArray) {
                TicketItem ticketItem;
                list = this.e.get(n2);
                if (!(list instanceof TicketItem) || (ticketItem = (TicketItem)((Object)list)).isTreatAsSeat().booleanValue()) continue;
                if (!ticketItem.isDiscountApplicable().booleanValue()) {
                    POSMessageDialog.showError(Messages.getString("TicketItemDiscountSelectionDialog.9"));
                    return;
                }
                if (ticketItem.isVoided().booleanValue()) {
                    POSMessageDialog.showError(Messages.getString("TicketItemDiscountSelectionDialog.3"));
                    return;
                }
                if (ticketItem.isGiftCard()) {
                    POSMessageDialog.showError(Messages.getString("TicketItemDiscountSelectionDialog.8"));
                    return;
                }
                if (ticketItem.getQuantity() < discount.getMinimumBuy()) {
                    POSMessageDialog.showError(Messages.getString("TicketItemDiscountSelectionDialog.4") + discount.getMinimumBuy().intValue());
                    return;
                }
                if (ticketItem.hasDiscount() && !store.isAllowMulDiscount()) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TicketItemDiscountSelectionDialog.20"));
                    return;
                }
                if (ticketItem.getTicket().isItemReturned(ticketItem)) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TicketItemDiscountSelectionDialog.10"));
                    return;
                }
                arrayList.add(ticketItem);
            }
        }
        if (arrayList.size() == 0) {
            return;
        }
        boolean bl3 = false;
        n = 0;
        for (TicketItem ticketItem : arrayList) {
            boolean bl4;
            TicketItemDiscount ticketItemDiscount2;
            list = ticketItem.getDiscounts();
            if (list == null) {
                list = new ArrayList();
            }
            boolean bl5 = false;
            if (discount.getMenuItems() != null && !discount.getMenuItems().isEmpty() && !DiscountDAO.getInstance().isApplicable(ticketItem.getMenuItemId(), discount.getId())) {
                ++var7_11;
                continue;
            }
            for (TicketItemDiscount ticketItemDiscount2 : list) {
                if (discount.getMaximumOff() != 0.0 && ticketItemDiscount2.getCouponQuantity() + 1.0 > discount.getMaximumOff()) {
                    bl5 = true;
                    ++var7_11;
                    n = 1;
                    break;
                }
                if (!ticketItemDiscount2.getDiscountId().equals(discount.getId())) continue;
                ticketItemDiscount2.setCouponQuantity(ticketItemDiscount2.getCouponQuantity() + 1.0);
                bl5 = true;
                this.a(ticketItem, ticketItemDiscount2);
                break;
            }
            if (bl5) continue;
            boolean bl6 = bl4 = discount.getType() == 0;
            if (bl4 && discount.isModifiable().booleanValue()) {
                this.a(discount, ticketItem);
                continue;
            }
            ticketItemDiscount2 = MenuItem.convertToTicketItemDiscount(discount, ticketItem);
            ticketItem.addTodiscounts(ticketItemDiscount2);
            this.a(ticketItem, ticketItemDiscount2);
        }
        if (var7_11 != false) {
            if (n != 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), var7_11 > true ? Messages.getString("TicketItemDiscountSelectionDialog.22") : Messages.getString("TicketItemDiscountSelectionDialog.5"));
            } else {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), var7_11 > true ? Messages.getString("TicketItemDiscountSelectionDialog.23") : Messages.getString("TicketItemDiscountSelectionDialog.7"));
            }
        }
        this.f.calculatePrice();
        this.e.updateView();
    }

    private void a(TicketItem ticketItem, TicketItemDiscount ticketItemDiscount) {
        block4: {
            try {
                TicketItemDiscountMapping ticketItemDiscountMapping = new TicketItemDiscountMapping(ticketItem, ticketItemDiscount, 1.0);
                if (this.g.contains(ticketItemDiscountMapping)) {
                    for (TicketItemDiscountMapping ticketItemDiscountMapping2 : this.g) {
                        if (!ticketItemDiscountMapping2.equals(ticketItemDiscountMapping)) continue;
                        ticketItemDiscountMapping2.setQuantity(ticketItemDiscountMapping2.getQuantity() + 1.0);
                        break block4;
                    }
                    break block4;
                }
                this.g.add(ticketItemDiscountMapping);
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
    }

    private void b(TicketItem ticketItem, TicketItemDiscount ticketItemDiscount) {
        block4: {
            try {
                TicketItemDiscountMapping ticketItemDiscountMapping = new TicketItemDiscountMapping(ticketItem, ticketItemDiscount, -ticketItemDiscount.getCouponQuantity().doubleValue());
                if (this.g.contains(ticketItemDiscountMapping)) {
                    for (TicketItemDiscountMapping ticketItemDiscountMapping2 : this.g) {
                        if (!ticketItemDiscountMapping2.equals(ticketItemDiscountMapping)) continue;
                        ticketItemDiscountMapping2.setQuantity(ticketItemDiscountMapping2.getQuantity() + ticketItemDiscountMapping.getQuantity());
                        break block4;
                    }
                    break block4;
                }
                this.g.add(ticketItemDiscountMapping);
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
    }

    private void e() {
        if (this.g.isEmpty()) {
            return;
        }
        Iterator<TicketItemDiscountMapping> iterator = this.g.iterator();
        while (iterator.hasNext()) {
            TicketItemDiscountMapping ticketItemDiscountMapping = iterator.next();
            while (ticketItemDiscountMapping.getQuantity() != 0.0) {
                TicketItem ticketItem = ticketItemDiscountMapping.getTicketItem();
                TicketItemDiscount ticketItemDiscount = ticketItemDiscountMapping.getDiscount();
                if (ticketItemDiscountMapping.getQuantity() > 0.0) {
                    Iterator<TicketItemDiscount> iterator2 = ticketItem.getDiscounts().iterator();
                    while (iterator2.hasNext()) {
                        TicketItemDiscount ticketItemDiscount2 = iterator2.next();
                        if (!ticketItemDiscount2.getName().equals(ticketItemDiscount.getName())) continue;
                        ticketItemDiscount2.setCouponQuantity(ticketItemDiscount2.getCouponQuantity() - ticketItemDiscountMapping.getQuantity());
                        ticketItemDiscountMapping.setQuantity(0.0);
                        if (ticketItemDiscount2.getCouponQuantity() != 0.0) continue;
                        iterator2.remove();
                    }
                    continue;
                }
                ticketItemDiscount.setCouponQuantity(-ticketItemDiscountMapping.getQuantity().doubleValue());
                ticketItem.addTodiscounts(ticketItemDiscount);
                ticketItemDiscountMapping.setQuantity(0.0);
            }
            iterator.remove();
        }
        this.f.calculatePrice();
        this.e.updateView();
    }

    private void a(Discount discount) {
        int[] nArray = this.e.getSelectedRows();
        if (nArray.length != 1) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TicketItemDiscountSelectionDialog.16"));
            return;
        }
        TicketItem ticketItem = (TicketItem)this.e.get(nArray[0]);
        TicketItemDiscount ticketItemDiscount = null;
        List<TicketItemDiscount> list = ticketItem.getDiscounts();
        if (list != null) {
            for (TicketItemDiscount ticketItemDiscount2 : list) {
                if (!ticketItemDiscount2.getDiscountId().equals(discount.getId())) continue;
                ticketItemDiscount = ticketItemDiscount2;
                break;
            }
        }
        double d = ticketItem.getSubtotalAmount() - ticketItem.calculateDiscount(NumberUtil.convertToBigDecimal(ticketItem.getSubtotalAmount())).doubleValue();
        double d2 = NumberSelectionDialog2.takeDoubleInput(Messages.getString("TicketItemDiscountSelectionDialog.17"), d, true);
        if (d2 == -1.0) {
            return;
        }
        ticketItem.setUnitPrice(d2);
        ticketItem.calculatePrice();
        if (ticketItemDiscount == null) {
            ticketItemDiscount = MenuItem.convertToTicketItemDiscount(discount, ticketItem);
            ticketItem.addTodiscounts(ticketItemDiscount);
        }
        ticketItemDiscount.setValue(d2);
        ticketItemDiscount.setAmount(d2);
        ticketItem.calculateDiscount(NumberUtil.convertToBigDecimal(ticketItem.getSubtotalAmount()));
        this.e.updateView();
    }

    private void a(Discount discount, TicketItem ticketItem) {
        double d = NumberSelectionDialog2.takeDoubleInput(Messages.getString("TicketItemDiscountSelectionDialog.6"), false, false, ticketItem.getSubtotalAmount());
        if (d == -1.0) {
            return;
        }
        TicketItemDiscount ticketItemDiscount = MenuItem.convertToTicketItemDiscount(discount, ticketItem);
        ticketItem.addTodiscounts(ticketItemDiscount);
        ticketItemDiscount.setValue(d);
        ticketItemDiscount.setAmount(d);
        this.a(ticketItem, ticketItemDiscount);
    }

    @Override
    public void itemAdded(Ticket ticket, ITicketItem iTicketItem) {
    }

    @Override
    public void itemRemoved(ITicketItem iTicketItem) {
        if (iTicketItem instanceof TicketItemDiscount) {
            TicketItemDiscount ticketItemDiscount = (TicketItemDiscount)iTicketItem;
            this.b(ticketItemDiscount.getTicketItem(), ticketItemDiscount);
        }
        this.f.calculatePrice();
        this.e.updateView();
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        super.windowClosed(windowEvent);
        this.e.removeTicketUpdateListener(this);
    }

    private class TicketItemDiscountMapping {
        private TicketItem b;
        private TicketItemDiscount c;
        private Double d;

        public TicketItemDiscountMapping(TicketItem ticketItem, TicketItemDiscount ticketItemDiscount, Double d) {
            this.b = ticketItem;
            this.c = ticketItemDiscount;
            this.d = d;
        }

        public Double getQuantity() {
            return this.d;
        }

        public void setQuantity(Double d) {
            this.d = d;
        }

        public TicketItem getTicketItem() {
            return this.b;
        }

        public TicketItemDiscount getDiscount() {
            return this.c;
        }

        public int hashCode() {
            int n = 31;
            int n2 = 1;
            n2 = 31 * n2 + this.a().hashCode();
            n2 = 31 * n2 + (this.c == null ? 0 : this.c.hashCode());
            n2 = 31 * n2 + (this.b == null ? 0 : this.b.hashCode());
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            TicketItemDiscountMapping ticketItemDiscountMapping = (TicketItemDiscountMapping)object;
            if (!this.a().equals(ticketItemDiscountMapping.a())) {
                return false;
            }
            if (this.c == null ? ticketItemDiscountMapping.c != null : !this.c.equals(ticketItemDiscountMapping.c)) {
                return false;
            }
            return !(this.b == null ? ticketItemDiscountMapping.b != null : !this.b.equals(ticketItemDiscountMapping.b));
        }

        private TicketItemDiscountSelectionDialog a() {
            return TicketItemDiscountSelectionDialog.this;
        }
    }

    private class DiscountButton
    extends JPanel
    implements ActionListener {
        private Discount b;
        private PosButton c;

        DiscountButton(Discount discount) {
            this.b = discount;
            this.setLayout((LayoutManager)new MigLayout("hidemode 3, fill", "", "[grow][]"));
            JLabel jLabel = new JLabel();
            jLabel.setOpaque(false);
            jLabel.setHorizontalAlignment(0);
            jLabel.setMinimumSize(PosUIManager.getSize(120, 80));
            jLabel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            jLabel.setText("<html><body><center><strong>" + discount.getName() + "</strong></center></body></html>");
            this.setBackground(Color.WHITE);
            this.setForeground(Color.BLACK);
            this.add((Component)jLabel, "grow,span,wrap,w 200!, h 160!");
            this.c = new PosButton(POSConstants.APPLY);
            this.c.addActionListener(this);
            this.add((Component)this.c, "center");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                TicketItemDiscountSelectionDialog.this.a(this);
            }
            catch (PosException posException) {
                POSMessageDialog.showError(posException.getMessage());
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
            }
        }

        public Discount getDiscount() {
            return this.b;
        }

        public void setSelected(Boolean bl) {
            this.c.setSelected(bl);
            if (bl.booleanValue()) {
                this.c.setText(Messages.getString("TicketItemDiscountSelectionDialog.13"));
                this.c.setBackground(Color.PINK);
            } else {
                this.c.setText(POSConstants.APPLY);
                this.c.setBackground(UIManager.getColor("control"));
            }
        }
    }
}

