/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.forms;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Customer;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.AddressUtil;
import com.floreantpos.util.POSUtil;
import com.jidesoft.swing.AutoCompletionComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.EmailValidator;

public class QuickCustomerForm
extends BeanEditor<Customer> {
    private FixedLengthTextField a;
    private FixedLengthTextField b;
    private FixedLengthTextField c;
    private FixedLengthTextField d;
    private QwertyKeyPad e;
    private AddressUtil f;
    private AutoCompletionComboBox g;
    private AutoCompletionComboBox h;
    private AutoCompletionComboBox i;
    public boolean isKeypad;
    private FixedLengthTextField j;
    private FixedLengthTextField k;

    public QuickCustomerForm() {
        this.f = new AddressUtil();
        this.a();
    }

    public QuickCustomerForm(Customer customer) {
        this.isKeypad = true;
        this.f = new AddressUtil();
        this.a();
        this.setBean(customer);
    }

    public QuickCustomerForm(boolean bl) {
        this.isKeypad = bl;
        this.f = new AddressUtil();
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout(10, 10));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setOpaque(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("insets 10 10 10 10, fill", "[][fill,grow]", ""));
        jPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("QuickCustomerForm.2")));
        JLabel jLabel = new JLabel(Messages.getString("CustomerForm.18"));
        this.a = new FixedLengthTextField(220);
        this.a.setColumns(60);
        JLabel jLabel2 = new JLabel(Messages.getString("CustomerForm.21"));
        this.b = new FixedLengthTextField();
        this.b.setColumns(30);
        this.b.setLength(10);
        JLabel jLabel3 = new JLabel(Messages.getString("CustomerForm.56"));
        this.g = new AutoCompletionComboBox();
        this.g.setStrict(false);
        this.g.setModel(new DefaultComboBoxModel<Object>(this.f.getCountryNames().toArray()));
        JLabel jLabel4 = new JLabel(Messages.getString("QuickCustomerForm.0"));
        this.h = new AutoCompletionComboBox();
        this.h.setStrict(false);
        JLabel jLabel5 = new JLabel(Messages.getString("QuickCustomerForm.3"));
        this.i = new AutoCompletionComboBox();
        this.i.setStrict(false);
        JLabel jLabel6 = new JLabel(Messages.getString("QuickCustomerForm.4"));
        this.d = new FixedLengthTextField(30);
        JLabel jLabel7 = new JLabel(Messages.getString("QuickCustomerForm.5"));
        this.j = new FixedLengthTextField(30);
        JLabel jLabel8 = new JLabel(Messages.getString("QuickCustomerForm.6"));
        this.k = new FixedLengthTextField(30);
        JLabel jLabel9 = new JLabel(Messages.getString("NAME"));
        this.c = new FixedLengthTextField();
        this.c.setLength(120);
        jPanel.add((Component)jLabel6, "alignx right");
        jPanel.add((Component)this.d, "wrap");
        jPanel.add((Component)jLabel9, "alignx right");
        jPanel.add((Component)this.c, "wrap");
        jPanel.add((Component)jLabel7, "right");
        jPanel.add((Component)this.j, "wrap");
        jPanel.add((Component)jLabel8, "right");
        jPanel.add((Component)this.k, "wrap");
        jPanel.add((Component)jLabel, "right");
        jPanel.add((Component)this.a, "wrap");
        jPanel.add((Component)jLabel3, "right");
        jPanel.add((Component)this.g, "wrap");
        jPanel.add((Component)jLabel4, "right");
        jPanel.add((Component)this.h, "wrap");
        jPanel.add((Component)jLabel5, "right");
        jPanel.add((Component)this.i, "wrap");
        jPanel.add((Component)jLabel2, "right");
        jPanel.add((Component)this.b, "wrap");
        this.e = new QwertyKeyPad();
        this.add((Component)jPanel, "Center");
        if (this.isKeypad) {
            this.add((Component)((Object)this.e), "South");
        }
        this.enableCustomerFields(false);
        this.callOrderController();
        this.g.addActionListener(actionEvent -> this.b());
        this.h.addActionListener(actionEvent -> this.c());
    }

    public void callOrderController() {
        Vector<FixedLengthTextField> vector = new Vector<FixedLengthTextField>();
        vector.add(this.d);
        vector.add(this.c);
        vector.add(this.j);
        vector.add(this.k);
        vector.add((FixedLengthTextField)this.g);
        vector.add((FixedLengthTextField)this.h);
        vector.add((FixedLengthTextField)this.i);
        vector.add(this.b);
        vector.add(this.a);
    }

    public void enableCustomerFields(boolean bl) {
        this.c.setEnabled(bl);
        this.j.setEnabled(bl);
        this.k.setEnabled(bl);
        this.a.setEnabled(bl);
        this.g.setEnabled(bl);
        this.h.setEnabled(bl);
        this.i.setEnabled(bl);
        this.b.setEnabled(bl);
        this.d.setEnabled(bl);
    }

    @Override
    public void setFieldsEnable(boolean bl) {
        this.c.setEnabled(bl);
        this.j.setEnabled(bl);
        this.k.setEnabled(bl);
        this.a.setEnabled(bl);
        this.g.setEnabled(bl);
        this.h.setEnabled(bl);
        this.i.setEnabled(bl);
        this.b.setEnabled(bl);
        this.d.setEnabled(bl);
    }

    public void setFieldsEditable(boolean bl) {
        this.c.setEditable(bl);
        this.j.setEditable(bl);
        this.k.setEditable(bl);
        this.a.setEditable(bl);
        this.g.setEnabled(bl);
        this.h.setEnabled(bl);
        this.i.setEnabled(bl);
        this.b.setEditable(bl);
        this.d.setEditable(bl);
    }

    @Override
    public void createNew() {
        this.setBean(new Customer());
        this.c.setText("");
        this.j.setText("");
        this.k.setText("");
        this.a.setText("");
        this.b.setText("");
        this.d.setText("");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Customer customer = (Customer)this.getBean();
            CustomerDAO.getInstance().saveOrUpdate(customer);
            this.updateView();
            return true;
        }
        catch (Exception exception) {
            BOMessageDialog.showError(this, Messages.getString("CustomerForm.47"));
            return false;
        }
    }

    @Override
    protected void updateView() {
        Customer customer = (Customer)this.getBean();
        if (customer == null) {
            return;
        }
        this.c.setText(customer.getName());
        this.j.setText(customer.getEmail());
        this.k.setText(customer.getEmail2());
        this.g.setSelectedItem((Object)customer.getCountry());
        this.h.setSelectedItem((Object)customer.getState());
        this.i.setSelectedItem((Object)customer.getCity());
        this.d.setText(customer.getMobileNo());
        this.b.setText(customer.getZipCode());
        this.a.setText(customer.getAddress());
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        String string;
        Customer customer = (Customer)this.getBean();
        if (customer == null) {
            customer = new Customer();
            this.setBean(customer, false);
        }
        String string2 = this.d.getText();
        String string3 = this.c.getText();
        if (StringUtils.isBlank((String)string3)) {
            POSMessageDialog.showError(this, Messages.getString("QuickCustomerForm.1"));
            return false;
        }
        if (StringUtils.isNotBlank((String)string2) && !POSUtil.validatePhoneNo(string2)) {
            POSMessageDialog.showError(this, Messages.getString("QuickCustomerForm.10"));
            return false;
        }
        String[] stringArray = (string3 = string3.trim()).split(" ");
        String string4 = stringArray.length > 0 ? stringArray[0] : "";
        String string5 = stringArray.length > 0 ? string3.substring(string4.length(), string3.length()).trim() : "";
        String string6 = this.j.getText();
        String string7 = this.k.getText();
        String string8 = this.g.getSelectedItem() == null ? "" : this.g.getSelectedItem().toString();
        String string9 = this.h.getSelectedItem() == null ? "" : this.h.getSelectedItem().toString();
        String string10 = string = this.i.getSelectedItem() == null ? "" : this.i.getSelectedItem().toString();
        if (StringUtils.isNotEmpty((String)string6) && !this.a(string6)) {
            return false;
        }
        if (StringUtils.isNotEmpty((String)string7) && !this.a(string7)) {
            return false;
        }
        customer.setName(string3);
        customer.setFirstName(string4);
        customer.setLastName(string5);
        customer.setEmail(string6);
        customer.setEmail2(string7);
        customer.setAddress(this.a.getText());
        customer.setCountry(string8);
        customer.setState(string9);
        customer.setCity(string);
        customer.setZipCode(this.b.getText());
        customer.setMobileNo(string2.trim());
        return true;
    }

    private boolean a(String string) {
        boolean bl = EmailValidator.getInstance().isValid(string);
        if (!bl) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("QuickCustomerForm.8"));
            return false;
        }
        return bl;
    }

    @Override
    public boolean delete() {
        try {
            Customer customer = (Customer)this.getBean();
            if (customer == null) {
                return false;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Are you sure to delete selected table?", "Confirm");
            if (n != 0) {
                return false;
            }
            CustomerDAO.getInstance().delete(customer);
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        return Messages.getString("CustomerForm.54");
    }

    public void setPhoneNo(String string) {
        this.d.setText(string);
    }

    private void b() {
        try {
            this.h.setEnabled(true);
            this.i.setEnabled(false);
            String string = (String)this.g.getSelectedItem();
            List<String> list = this.f.getStateNames(string);
            this.h.removeAllItems();
            this.i.removeAllItems();
            this.h.addItem(null);
            for (String string2 : list) {
                this.h.addItem((Object)string2);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    private void c() {
        try {
            this.i.setEnabled(true);
            String string = (String)this.g.getSelectedItem();
            String string2 = (String)this.h.getSelectedItem();
            List<String> list = this.f.getCityNames(string, string2);
            this.i.removeAllItems();
            this.i.addItem(null);
            for (String string3 : list) {
                this.i.addItem((Object)string3);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    public static class MyOwnFocusTraversalPolicy
    extends FocusTraversalPolicy {
        Vector<Component> a;

        public MyOwnFocusTraversalPolicy(Vector<Component> vector) {
            this.a = new Vector(vector.size());
            this.a.addAll(vector);
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            int n = (this.a.indexOf(component) + 1) % this.a.size();
            return this.a.get(n);
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            int n = this.a.indexOf(component) - 1;
            if (n < 0) {
                n = this.a.size() - 1;
            }
            return this.a.get(n);
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return this.a.get(0);
        }

        @Override
        public Component getLastComponent(Container container) {
            return this.a.lastElement();
        }

        @Override
        public Component getFirstComponent(Container container) {
            return this.a.get(0);
        }
    }
}

