/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.inv;

import com.floreantpos.Messages;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class InventoryItemEntryDialog
extends OkCancelOptionDialog {
    private Component a;
    private JLabel b;
    private JComboBox c;
    private JLabel d;
    private DoubleTextField e;
    private DoubleTextField f;
    private JButton g;
    private POSTextField h;
    private JComboBox<IUnit> i;
    private JLabel j;
    private InventoryTransaction k;
    private MenuItem l;

    public InventoryItemEntryDialog() {
        this((InventoryTransaction)null);
    }

    public InventoryItemEntryDialog(InventoryTransaction inventoryTransaction) {
        this.k = inventoryTransaction;
        this.d();
        this.a();
        this.updateView();
    }

    private void a() {
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        this.i.setModel(comboBoxModel);
        this.c();
    }

    private void b() {
        if (this.l == null) {
            return;
        }
        IUnit iUnit = (IUnit)this.i.getSelectedItem();
        if (iUnit != null) {
            this.e.setText(NumberUtil.formatNumber(this.l.getCost(iUnit)));
        }
    }

    private void c() {
        if (this.l == null) {
            return;
        }
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.i.getModel();
        comboBoxModel.removeAllElements();
        comboBoxModel.setDataList(this.l.getStockCountableUnits());
    }

    private void d() {
        this.setTitle(VersionInfo.getAppName());
        this.setCaption(Messages.getString("InventoryItemEntryDialog.0"));
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "[][grow][]", ""));
        this.j = new JLabel(Messages.getString("InventoryItemEntryDialog.4"));
        jPanel.add((Component)this.j, "cell 0 2,alignx trailing");
        this.h = new POSTextField();
        jPanel.add((Component)this.h, "cell 1 2,growx");
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InventoryItemEntryDialog.this.e();
            }
        });
        this.g = new JButton(Messages.getString("Search"));
        jPanel.add((Component)this.g, "cell 2 2,growx");
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InventoryItemEntryDialog.this.e();
            }
        });
        this.b = new JLabel(Messages.getString("InventoryItemEntryDialog.9"));
        jPanel.add((Component)this.b, "cell 0 4, alignx trailing");
        this.b.setVisible(false);
        this.c = new JComboBox();
        jPanel.add((Component)this.c, "cell 1 4");
        this.c.setVisible(false);
        JLabel jLabel = new JLabel(Messages.getString("InventoryItemEntryDialog.12"));
        jPanel.add((Component)jLabel, "cell 0 7,alignx trailing");
        this.i = new JComboBox();
        this.i.setMinimumSize(PosUIManager.getSize(100, 0));
        jPanel.add(this.i, "cell 1 7");
        this.d = new JLabel(Messages.getString("InventoryItemEntryDialog.15") + " (" + CurrencyUtil.getCurrencySymbol() + ")");
        jPanel.add((Component)this.d, "cell 0 8,alignx trailing");
        this.e = new DoubleTextField();
        jPanel.add((Component)this.e, "cell 1 8,growx");
        this.a = new JLabel(Messages.getString("InventoryItemEntryDialog.20"));
        jPanel.add(this.a, "cell 0 9,alignx trailing");
        this.f = new DoubleTextField();
        jPanel.add((Component)this.f, "cell 1 9,growx");
        this.getContentPanel().add(jPanel);
        this.i.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = itemEvent.getStateChange();
                if (n == 1) {
                    InventoryItemEntryDialog.this.b();
                }
            }
        });
    }

    private void e() {
        MenuItemSelectionDialog menuItemSelectionDialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>(), true);
        menuItemSelectionDialog.setSelectionMode(0);
        menuItemSelectionDialog.setSize(PosUIManager.getSize(600, 515));
        menuItemSelectionDialog.doSearch(this.h.getText());
        menuItemSelectionDialog.open();
        if (menuItemSelectionDialog.isCanceled()) {
            return;
        }
        this.l = menuItemSelectionDialog.getSelectedRowData();
        if (this.l != null) {
            this.h.setText(this.l.getName());
            this.a(this.l.isVariant() != false ? this.l.getParentMenuItem() : this.l);
        }
        if (this.l != null) {
            this.f.setText(NumberUtil.format6DigitNumber(this.l.getReplenishLevel() == 0.0 ? 1.0 : this.l.getReplenishLevel()));
            this.e.setText(NumberUtil.formatNumber(this.l.getCost()));
        }
    }

    private void a(MenuItem menuItem) {
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.i.getModel();
        if (menuItem != null) {
            MenuItemDAO.getInstance().initialize(menuItem);
            comboBoxModel.setDataList(menuItem.getStockCountableUnits());
            InventoryUnit inventoryUnit = menuItem.getStockCountableUnit();
            if (inventoryUnit != null) {
                for (IUnit iUnit : comboBoxModel.getDataList()) {
                    if (!iUnit.getUniqueCode().equals(inventoryUnit.getUniqueCode())) continue;
                    this.i.setSelectedItem(iUnit);
                }
            } else if (comboBoxModel.getSize() > 0) {
                this.i.setSelectedIndex(0);
            }
        }
        this.b();
    }

    public void updateView() {
        InventoryTransaction inventoryTransaction = this.getInventoryTransaction();
        if (inventoryTransaction == null) {
            return;
        }
        this.l = inventoryTransaction.getMenuItem();
        if (this.l == null) {
            return;
        }
        this.a(this.l.isVariant() != false ? this.l.getParentMenuItem() : this.l);
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.i.getModel();
        if (inventoryTransaction.getUnit() != null) {
            for (IUnit iUnit : comboBoxModel.getDataList()) {
                if (iUnit.getUniqueCode() == null || !iUnit.getUniqueCode().equals(inventoryTransaction.getUnit())) continue;
                this.i.setSelectedItem(iUnit);
            }
        } else if (comboBoxModel.getSize() > 0) {
            this.i.setSelectedIndex(0);
        }
        this.h.setText(this.l.getName());
        this.f.setText(NumberUtil.format6DigitNumber(inventoryTransaction.getQuantity()));
        this.e.setText(NumberUtil.formatNumber(inventoryTransaction.getUnitCost()));
    }

    @Override
    public void doOk() {
        if (this.l == null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("InventoryItemEntryDialog.23"));
            return;
        }
        IUnit iUnit = (IUnit)this.i.getSelectedItem();
        if (iUnit == null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("InventoryItemEntryDialog.24"));
            return;
        }
        double d = this.f.getDoubleOrZero();
        if (d <= 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("InventoryItemEntryDialog.25"));
            return;
        }
        double d2 = this.e.getDoubleOrZero();
        if (d2 < 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MenuItemForm.11"));
            return;
        }
        double d3 = d2 * d;
        this.k.setMenuItem(this.l);
        this.k.setUnit(iUnit.getUniqueCode());
        this.k.setQuantity(d);
        this.k.setUnitCost(d2);
        this.k.setTotal(d3);
        this.k.setOutletId(DataProvider.get().getCurrentOutletId());
        this.setCanceled(false);
        this.dispose();
    }

    public InventoryTransaction getInventoryTransaction() {
        return this.k;
    }

    public void setInventoryTransaction(InventoryTransaction inventoryTransaction) {
        this.k = inventoryTransaction;
    }
}

