/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.DuplicateDataException;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.Department;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PriceTableItem;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.PriceRuleDAO;
import com.floreantpos.model.dao.PriceShiftDAO;
import com.floreantpos.model.dao.PriceTableItemDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.model.util.InventoryUnitConvertionUtil;
import com.floreantpos.model.util.MenuSearchCriteria;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuItemSelectionView;
import com.floreantpos.ui.model.MenuSearcher;
import com.floreantpos.ui.model.PriceShiftForm;
import com.floreantpos.ui.model.PriceTableItemSelectionView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class PriceTableForm
extends BeanEditor<PriceTable>
implements MenuSearcher {
    private PriceTableItemSelectionView a;
    private FixedLengthTextField b = new FixedLengthTextField();
    private FixedLengthTextField c = new FixedLengthTextField();
    private JComboBox d = new JComboBox();
    private JComboBox e = new JComboBox();
    private JComboBox f = new JComboBox();
    private JComboBox g = new JComboBox();
    private JComboBox h = new JComboBox();
    private JCheckBox i = new JCheckBox(Messages.getString("ACTIVE"));
    private JCheckBox j = new JCheckBox("Customer is member");
    private PriceRule k;

    public PriceTableForm() {
        this.a();
    }

    public PriceTableForm(PriceTable priceTable) {
        this.setBean(priceTable);
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][]"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new MigLayout("ins 0", "[][]", "[][]"));
        this.b.setLength(30);
        jPanel.add(new JLabel(Messages.getString("NAME")));
        jPanel.add((Component)this.b, "growx,wrap");
        this.c.setLength(255);
        jPanel.add((Component)new JLabel(Messages.getString("PriceTableForm.6")), "growx,aligny top");
        jPanel.add((Component)this.c, "growx,wrap");
        jPanel.add((Component)this.i, "skip 1,wrap");
        JButton jButton = new JButton("...");
        jButton.addActionListener(actionEvent -> this.c());
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("fillx"));
        Border border = BorderFactory.createEtchedBorder(1);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "Apply when");
        titledBorder.setTitleJustification(1);
        jPanel3.setBorder(titledBorder);
        jPanel3.add((Component)new JLabel(Messages.getString("PriceRuleForm.13")), "right");
        jPanel3.add((Component)this.d, " growx,spanx,pushx,wrap");
        jPanel3.add((Component)new JLabel(Messages.getString("PriceRuleForm.15")), "right");
        jPanel3.add((Component)this.e, "grow,wrap");
        jPanel3.add((Component)new JLabel(Messages.getString("PriceRuleForm.17")), "right");
        jPanel3.add((Component)this.f, "grow,wrap");
        jPanel3.add((Component)new JLabel(Messages.getString("PriceRuleForm.19")), "right");
        jPanel3.add((Component)this.g, "grow,wrap");
        jPanel3.add((Component)new JLabel(Messages.getString("PriceRuleForm.21")), "right");
        jPanel3.add((Component)this.h, "grow,split 2");
        jPanel3.add((Component)jButton, "wrap");
        jPanel3.add((Component)this.j, "skip 1");
        jPanel2.add((Component)jPanel, "grow");
        jPanel2.add((Component)jPanel3, "growx,spanx,pushx");
        this.add((Component)jPanel2, "North");
        this.a = new PriceTableItemSelectionView(this);
        this.b();
        this.a.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Messages.getString("PriceTableForm.0"), 1, 2));
        this.add((Component)this.a, "Center");
        this.setFieldsEnable(false);
    }

    private void b() {
        PriceTable priceTable = (PriceTable)this.getBean();
        this.a.setPriceTable(priceTable);
    }

    private void c() {
        try {
            PriceShiftForm priceShiftForm = new PriceShiftForm();
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog(POSUtil.getFocusedWindow(), (BeanEditor)priceShiftForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            PriceShift priceShift = (PriceShift)priceShiftForm.getBean();
            this.h.addItem(priceShift);
            this.h.setSelectedItem(priceShift);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            PriceTable priceTable = (PriceTable)this.getBean();
            if (StringUtils.isNotBlank((String)priceTable.getId())) {
                this.k = PriceRuleDAO.getInstance().getPriceRulesByPriceTable(priceTable.getId());
            }
            if (this.k == null) {
                this.k = new PriceRule();
            }
            this.k.setOutlet(DataProvider.get().getOutlet());
            this.k.setActive(this.i.isSelected());
            boolean bl = this.j.isSelected();
            if (bl) {
                this.k.setCustomerIsMember(bl);
            } else {
                this.k.setCustomerIsMember(null);
            }
            this.k.setDepartment((Department)this.a(this.d.getSelectedItem()));
            this.k.setSalesArea((SalesArea)this.a(this.e.getSelectedItem()));
            this.k.setCustomerGroup((CustomerGroup)this.a(this.g.getSelectedItem()));
            this.k.setPriceShift((PriceShift)this.a(this.h.getSelectedItem()));
            this.k.setOrderType((OrderType)this.a(this.f.getSelectedItem()));
            List<PriceTableItem> list = this.a.getSelectedMenuItemList();
            PriceRuleDAO.getInstance().saveOrUpdate(priceTable, this.k, list);
            POSMessageDialog.showMessage(Messages.getString("BeanEditorDialog.0"));
            return true;
        }
        catch (DuplicateDataException duplicateDataException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), duplicateDataException.getMessage());
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (IllegalModelStateException illegalModelStateException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), illegalModelStateException.getMessage());
        }
        return false;
    }

    @Override
    protected void updateView() {
        PriceTable priceTable = (PriceTable)this.getBean();
        this.b.setText(priceTable.getName());
        this.c.setText(priceTable.getDescription());
        this.d();
        if (priceTable.getId() == null) {
            this.i.setSelected(true);
            this.j.setSelected(false);
            if (this.a != null) {
                this.a.initData();
            }
            return;
        }
        this.k = PriceRuleDAO.getInstance().getPriceRulesByPriceTable(priceTable.getId());
        if (this.k != null) {
            String string = Messages.getString("PriceRuleForm.28");
            this.d.setSelectedItem(this.k.getDepartment() == null ? string : this.k.getDepartment());
            this.e.setSelectedItem(this.k.getSalesArea() == null ? string : this.k.getSalesArea());
            this.f.setSelectedItem(this.k.getOrderType() == null ? string : this.k.getOrderType());
            this.g.setSelectedItem(this.k.getCustomerGroup() == null ? string : this.k.getCustomerGroup());
            this.h.setSelectedItem(this.k.getPriceShift() == null ? string : this.k.getPriceShift());
            this.i.setSelected(this.k.isActive());
            this.j.setSelected(this.k.isCustomerIsMember() == null ? false : this.k.isCustomerIsMember());
        }
        this.b();
        this.setFieldsEnable(true);
    }

    private void d() {
        this.d.setModel(this.a(DepartmentDAO.getInstance().findAll()));
        this.e.setModel(this.a(SalesAreaDAO.getInstance().findAll()));
        this.f.setModel(this.a(OrderTypeDAO.getInstance().findAll()));
        this.g.setModel(this.a(CustomerGroupDAO.getInstance().findAll()));
        this.h.setModel(this.a(PriceShiftDAO.getInstance().findAll()));
    }

    private ComboBoxModel a(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(Messages.getString("PriceRuleForm.1"));
        arrayList.addAll(list);
        return new ComboBoxModel(arrayList);
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        PriceTable priceTable = (PriceTable)this.getBean();
        String string = this.b.getText();
        if (StringUtils.isBlank((String)string)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PriceTableForm.28"));
            return false;
        }
        string = string.trim();
        GenericDAO.getInstance().checkIdOrNameExists(priceTable.getId(), string, PriceTable.class);
        boolean bl = false;
        if ((Department)this.a(this.d.getSelectedItem()) != null) {
            bl = true;
        } else if ((SalesArea)this.a(this.e.getSelectedItem()) != null) {
            bl = true;
        } else if ((CustomerGroup)this.a(this.g.getSelectedItem()) != null) {
            bl = true;
        } else if ((PriceShift)this.a(this.h.getSelectedItem()) != null) {
            bl = true;
        } else if ((OrderType)this.a(this.f.getSelectedItem()) != null) {
            bl = true;
        } else if (this.j.isSelected()) {
            bl = true;
        }
        if (!bl) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("NewPriceRuleForm.3"));
            return false;
        }
        priceTable.setName(string);
        priceTable.setDescription(this.c.getText());
        priceTable.setLastUpdateTime(new Date());
        priceTable.setLastUpdatedBy(Application.getCurrentUser().getId());
        priceTable.setOutletId(DataProvider.get().getCurrentOutletId());
        return true;
    }

    private Object a(Object object) {
        if (object instanceof String) {
            return null;
        }
        return object;
    }

    @Override
    public String getDisplayText() {
        if (((PriceTable)this.getBean()).getId() == null) {
            return Messages.getString("PriceTableForm.30");
        }
        return Messages.getString("PriceTableForm.31");
    }

    public void setEditable(boolean bl) {
        this.c.setEditable(bl);
        this.b.setEditable(bl);
    }

    @Override
    public void createNew() {
        try {
            PriceTable priceTable = (PriceTable)this.getBean();
            MenuItemSelectionDialog menuItemSelectionDialog = new MenuItemSelectionDialog(this);
            menuItemSelectionDialog.setSelectionMode(1);
            menuItemSelectionDialog.setShowVariantParent(true);
            menuItemSelectionDialog.setShowVariant(false);
            menuItemSelectionDialog.setShowComboItem(true);
            menuItemSelectionDialog.setIncludePizzaItem(true);
            menuItemSelectionDialog.setSize(PosUIManager.getSize(600, 515));
            menuItemSelectionDialog.open();
            if (menuItemSelectionDialog.isCanceled()) {
                return;
            }
            List<PriceTableItem> list = this.convertToPriceTableItem(menuItemSelectionDialog.getSelectedItems());
            PriceTableItemSelectionView.PriceTableItemTableModel priceTableItemTableModel = this.a.getTableModel();
            PriceTableItemDAO.getInstance().saveOrUpdateItems(priceTable, list);
            ArrayList arrayList = new ArrayList();
            arrayList.clear();
            List list2 = priceTableItemTableModel.getRows();
            arrayList.addAll(list2);
            arrayList.addAll(list);
            priceTableItemTableModel.setRows(arrayList);
            priceTableItemTableModel.fireTableDataChanged();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    public List<PriceTableItem> convertToPriceTableItem(List<MenuItem> list) {
        ArrayList<PriceTableItem> arrayList = new ArrayList<PriceTableItem>();
        for (MenuItem menuItem : list) {
            if (menuItem.isAllowUnitSelection() || menuItem.isAllowUnitWiseSelection()) {
                List<IUnit> list2;
                MenuItemDAO.getInstance().initializeUnits(menuItem);
                if (menuItem.isVariant().booleanValue() && menuItem.getParentMenuItem() != null) {
                    MenuItemDAO.getInstance().initializeUnits(menuItem.getParentMenuItem());
                }
                if ((list2 = menuItem.getUnits()) != null && list2.size() > 0) {
                    for (IUnit iUnit : list2) {
                        if (!(iUnit instanceof InventoryUnit)) continue;
                        InventoryUnit inventoryUnit = (InventoryUnit)iUnit;
                        arrayList.add(this.a(menuItem, inventoryUnit));
                    }
                    continue;
                }
            }
            arrayList.add(this.a(menuItem, menuItem.getUnit() == null ? null : menuItem.getUnit()));
        }
        return arrayList;
    }

    private PriceTableItem a(MenuItem menuItem, InventoryUnit inventoryUnit) {
        PriceTableItem priceTableItem = new PriceTableItem();
        priceTableItem.setMenuItem(menuItem);
        priceTableItem.setMenuItemId(menuItem.getId());
        priceTableItem.setItemName(menuItem.getName());
        priceTableItem.setItemBarcode(menuItem.getBarcode());
        priceTableItem.setUnit(inventoryUnit == null ? null : inventoryUnit.getCode());
        Double d = menuItem.getVariantPrice();
        double d2 = 0.0;
        d2 = menuItem.isAllowUnitSelection() || menuItem.isAllowUnitWiseSelection() ? menuItem.getDestinationUnitPrice(menuItem, inventoryUnit, d, menuItem.getUnitQuantity(menuItem.getUnit(), inventoryUnit)) : InventoryUnitConvertionUtil.calculatePrice(d, inventoryUnit, menuItem);
        priceTableItem.setRegularPrice(d2);
        priceTableItem.setPrice(menuItem.isVariant() != false ? menuItem.getPrice() : d2);
        return priceTableItem;
    }

    @Override
    public boolean delete() {
        try {
            return this.a.delete();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    public void cancel() {
        this.updateView();
    }

    @Override
    public void clearFields() {
        String string = Messages.getString("PriceRuleForm.28");
        this.d.setSelectedItem(string);
        this.e.setSelectedItem(string);
        this.f.setSelectedItem(string);
        this.g.setSelectedItem(string);
        this.h.setSelectedItem(string);
        this.i.setSelected(false);
        this.j.setSelected(false);
        this.b.setText("");
        this.c.setText("");
        this.a.setPriceTable(null);
    }

    @Override
    public void search(MenuItemSelectionView.MenuItemTableModel menuItemTableModel, MenuSearchCriteria menuSearchCriteria) {
        menuSearchCriteria.setShowVariant(false);
        menuSearchCriteria.setIncludeVariantParent(true);
        MenuItemDAO.getInstance().loadMenuItems((PriceTable)this.getBean(), menuItemTableModel, menuSearchCriteria);
    }
}

