/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.setup.pages;

import com.floreantpos.Messages;
import com.floreantpos.config.ui.AddPrinterView;
import com.floreantpos.main.Application;
import com.floreantpos.model.Printer;
import com.floreantpos.model.TerminalPrinters;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.dao.TerminalPrintersDAO;
import com.floreantpos.model.dao.VirtualPrinterDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.setup.PosWizardPage;
import com.github.cjwizard.WizardSettings;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;

public class PrintConfigPage
extends PosWizardPage {
    private AddPrinterView a;
    private VirtualPrinter b;

    public PrintConfigPage() {
        super(Messages.getString("PrintConfigPage.0"), Messages.getString("PrintConfigPage.1"));
    }

    @Override
    public void initialize() throws Exception {
        this.setLayout((LayoutManager)new MigLayout());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>");
        stringBuffer.append(Messages.getString("PrintConfigPage.3"));
        stringBuffer.append("</html>");
        this.add(new JLabel(stringBuffer.toString()), "span, growx");
        this.a = new AddPrinterView();
        this.add(this.a);
        this.b = VirtualPrinterDAO.getInstance().findAReceiptPrinter();
        if (this.b != null) {
            TerminalPrinters terminalPrinters = TerminalPrintersDAO.getInstance().findPrinters(this.b);
            if (terminalPrinters != null) {
                Printer printer = new Printer();
                printer.setVirtualPrinter(this.b);
                printer.setDeviceName(terminalPrinters.getPrinterName());
                printer.setPrinterType(terminalPrinters.getProperty("printerType"));
                printer.setIpAddress(terminalPrinters.getProperty("ipAddress"));
                printer.setIpPort(terminalPrinters.getProperty("ipPort"));
                printer.setPrintSystem(terminalPrinters.getProperty("receipt.printer_type", "Standard"));
                this.a.setPrinter(printer, terminalPrinters);
            }
        } else {
            this.a.setDefaultPrinterName("Receipt printer");
            this.a.selectOroposPDFPrinter();
        }
    }

    public boolean onNext(WizardSettings wizardSettings) {
        if (!this.a.updateModel(false)) {
            POSMessageDialog.showError(Messages.getString("PrintConfigPage.6"));
            return false;
        }
        Printer printer = this.a.getPrinter();
        printer.setDefaultPrinter(true);
        VirtualPrinter virtualPrinter = printer.getVirtualPrinter();
        virtualPrinter.setType(1);
        VirtualPrinterDAO.getInstance().saveOrUpdate(virtualPrinter);
        TerminalPrinters terminalPrinters = this.a.getTerminalPrinter();
        terminalPrinters.setTerminal(Application.getInstance().getTerminal());
        terminalPrinters.setPrinterName(printer.getDeviceName());
        terminalPrinters.setVirtualPrinter(printer.getVirtualPrinter());
        TerminalPrintersDAO.getInstance().saveOrUpdate(terminalPrinters);
        return true;
    }

    @Override
    public void finish() throws Exception {
    }
}

