/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class QuickMenuPanel
extends JPanel {
    private JCheckBox a;
    private JList<MenuItem> b;
    private PosButton c;
    private OrderType d;

    public QuickMenuPanel(OrderType orderType) {
        this.d = orderType;
    }

    public void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("ins 5, fill", "", "[][grow][]"));
        this.a = new JCheckBox(Messages.getString("QuickMenuPanel.3"));
        this.b = new JList();
        this.b.setModel(new DefaultListModel());
        this.c = new PosButton(Messages.getString("QuickMenuPanel.4"));
        JScrollPane jScrollPane = new JScrollPane(this.b);
        jScrollPane.setBorder(new TitledBorder(Messages.getString("QuickMenuPanel.5")));
        this.add((Component)this.a, "wrap");
        this.add((Component)jScrollPane, "grow, wrap");
        this.add((Component)this.c, "wrap");
        this.a.addChangeListener(changeEvent -> this.a());
        this.c.addActionListener(actionEvent -> this.b());
        this.c();
    }

    private void a() {
        if (this.a.isSelected()) {
            this.b.setEnabled(true);
            this.c.setEnabled(true);
        } else {
            this.b.setEnabled(false);
            this.c.setEnabled(false);
        }
    }

    private void b() {
        try {
            List<MenuItem> list = new ArrayList<MenuItem>();
            DefaultListModel defaultListModel = (DefaultListModel)this.b.getModel();
            for (int i = 0; i < defaultListModel.getSize(); ++i) {
                list.add((MenuItem)defaultListModel.getElementAt(i));
            }
            MenuItemSelectionDialog menuItemSelectionDialog = new MenuItemSelectionDialog(list);
            menuItemSelectionDialog.setSelectionMode(1);
            menuItemSelectionDialog.setShowVariantParent(false);
            menuItemSelectionDialog.setShowVariant(true);
            menuItemSelectionDialog.setIncludePizzaItem(Boolean.FALSE);
            menuItemSelectionDialog.setSize(PosUIManager.getSize(600, 515));
            menuItemSelectionDialog.open();
            if (menuItemSelectionDialog.isCanceled()) {
                return;
            }
            defaultListModel.removeAllElements();
            list = menuItemSelectionDialog.getSelectedItems();
            Collections.sort(list, new Comparator<MenuItem>(){

                @Override
                public int compare(MenuItem menuItem, MenuItem menuItem2) {
                    return menuItem.getName().compareToIgnoreCase(menuItem2.getName());
                }
            });
            for (MenuItem menuItem : list) {
                defaultListModel.addElement(menuItem);
            }
            this.b.setModel(defaultListModel);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public String getMenuIds() {
        StringBuffer stringBuffer = new StringBuffer();
        DefaultListModel defaultListModel = (DefaultListModel)this.b.getModel();
        for (int i = 0; i < defaultListModel.getSize(); ++i) {
            stringBuffer.append(((MenuItem)defaultListModel.getElementAt(i)).getId());
            if (i == defaultListModel.getSize() - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public boolean isQucikMenuEnable() {
        return this.a.isSelected();
    }

    private void c() {
        if (this.d == null) {
            return;
        }
        if (this.d.isQuickMenuEnable()) {
            this.a.setSelected(true);
            this.b.setEnabled(true);
            this.c.setEnabled(true);
        } else {
            this.a.setSelected(false);
            this.b.setEnabled(false);
            this.c.setEnabled(false);
        }
        DefaultListModel defaultListModel = (DefaultListModel)this.b.getModel();
        List<String> list = this.d.getQuickMenuIds();
        if (list == null || list.isEmpty()) {
            return;
        }
        defaultListModel.removeAllElements();
        List<MenuItem> list2 = MenuItemDAO.getInstance().getMenuItemByIDs(list);
        for (MenuItem menuItem : list2) {
            defaultListModel.addElement(menuItem);
        }
    }
}

