/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order.modifier;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.SelectionView;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionDialog;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionListener;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class ModifierView
extends SelectionView {
    private Vector<ModifierSelectionListener> a = new Vector();
    private ModifierSelectionModel b;
    private MenuItemModifierSpec c;
    private PosButton d = new PosButton(POSConstants.CLEAR);
    private PosButton e = new PosButton();
    private PosButton f = new PosButton(POSConstants.CANCEL);
    private Multiplier g;
    private MultiplierButton h;
    private ButtonGroup i;
    private TitledBorder j;

    public ModifierView(ModifierSelectionModel modifierSelectionModel) {
        super(POSConstants.MODIFIERS, new FlowLayout(), PosUIManager.getSize(120), PosUIManager.getSize(80));
        this.b = modifierSelectionModel;
        this.j = new TitledBorder(null, Messages.getString("PizzaModifierView.0"), 2, 2);
        this.selectionButtonsPanel.setBorder(this.j);
        this.dataModel = new PaginatedListModel();
        this.actionButtonPanel.add((Component)this.btnPrev, "grow,split 2,span");
        this.actionButtonPanel.add((Component)this.btnNext, "grow");
        this.a();
        this.b();
    }

    private void a() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx,center, gap 0, ins 0"));
        LineBorder lineBorder = new LineBorder(Color.lightGray, 1, true);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(new EmptyBorder(5, 0, 5, 0), lineBorder);
        jPanel.setBorder(compoundBorder);
        jPanel.setOpaque(true);
        List<Multiplier> list = DataProvider.get().getMultiplierList();
        this.i = new ButtonGroup();
        if (list != null) {
            for (Multiplier multiplier : list) {
                MultiplierButton multiplierButton = new MultiplierButton(multiplier);
                if (multiplier.isDefaultMultiplier().booleanValue()) {
                    this.g = multiplier;
                    this.h = multiplierButton;
                    multiplierButton.setSelected(true);
                }
                jPanel.add((Component)multiplierButton, "grow");
                this.i.add(multiplierButton);
            }
        }
        this.actionButtonPanel.add((Component)jPanel, "newline,span");
    }

    private void b() {
        this.actionButtonPanel.add((Component)this.d, "newline,grow");
        this.actionButtonPanel.add((Component)this.e, "grow");
        this.actionButtonPanel.add((Component)this.f, "grow");
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (ModifierSelectionListener modifierSelectionListener : ModifierView.this.a) {
                    modifierSelectionListener.finishModifierSelection();
                }
            }
        };
        this.e.setAction(abstractAction);
        this.e.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), POSConstants.DONE);
        this.e.getActionMap().put(POSConstants.DONE, abstractAction);
        this.e.setText(Messages.getString("ModifierView.0"));
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                for (ModifierSelectionListener modifierSelectionListener : ModifierView.this.a) {
                    modifierSelectionListener.clearModifiers(ModifierView.this.c);
                }
            }
        });
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ModifierView.this.a(true);
            }
        });
    }

    private void a(boolean bl) {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof POSDialog) {
            ((POSDialog)window).setCanceled(bl);
            window.dispose();
        }
    }

    public void setModifierGroup(MenuItemModifierSpec menuItemModifierSpec) {
        try {
            this.c = menuItemModifierSpec;
            ModifierGroup modifierGroup = null;
            if (menuItemModifierSpec == null) {
                return;
            }
            this.dataModel.setPageSize(1);
            this.dataModel.setCurrentRowIndex(0);
            if (menuItemModifierSpec.isUseModifierGroupSettings()) {
                modifierGroup = menuItemModifierSpec.getModifierGroup();
                ModifierGroupDAO.getInstance().initialize(modifierGroup);
                this.dataModel.setNumRows(modifierGroup.getModifierPages().size());
                this.dataModel.setData(new ArrayList<MenuItemModifierPage>(modifierGroup.getModifierPages()));
            } else {
                this.dataModel.setNumRows(menuItemModifierSpec.getModifierPages().size());
                this.dataModel.setData(new ArrayList<MenuItemModifierPage>(menuItemModifierSpec.getModifierPages()));
            }
            this.a(modifierGroup);
            this.c();
            this.setDataModel(this.dataModel);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, posException);
        }
    }

    private void c() {
        if (this.i.getButtonCount() < 1) {
            return;
        }
        boolean bl = !this.c.isEnableGroupPricing();
        Enumeration<AbstractButton> enumeration = this.i.getElements();
        while (enumeration.hasMoreElements()) {
            MultiplierButton multiplierButton = (MultiplierButton)enumeration.nextElement();
            multiplierButton.setEnabled(bl);
            Multiplier multiplier = multiplierButton.getMultiplier();
            if (!bl) {
                if (!multiplier.getTicketPrefix().equals("Regular")) continue;
                this.g = multiplier;
                this.h = multiplierButton;
                multiplierButton.setSelected(true);
                continue;
            }
            if (!multiplier.isDefaultMultiplier().booleanValue()) continue;
            this.g = multiplier;
            this.h = multiplierButton;
            multiplierButton.setSelected(true);
        }
    }

    @Override
    public void setDataModel(PaginatedListModel paginatedListModel) {
        this.populateItems();
        super.setDataModel(paginatedListModel);
        this.updateButton();
    }

    @Override
    protected void renderItems() {
        this.updateView();
    }

    protected void populateItems() {
        this.reset();
        if (this.dataModel.getSize() == 0) {
            return;
        }
        MenuItemModifierPage menuItemModifierPage = (MenuItemModifierPage)this.dataModel.getElementAt(this.dataModel.getCurrentRowIndex());
        this.setButtonSize(new Dimension(menuItemModifierPage.getButtonWidth(), menuItemModifierPage.getButtonHeight()));
        Integer n = menuItemModifierPage.getCols();
        MigLayout migLayout = new MigLayout("center,wrap " + n);
        if (menuItemModifierPage.isFlixibleButtonSize().booleanValue()) {
            migLayout.setLayoutConstraints((Object)"fill");
            migLayout.setColumnConstraints((Object)"fill,grow");
            migLayout.setRowConstraints((Object)"fill,grow");
        }
        this.selectionButtonsPanel.setLayout((LayoutManager)migLayout);
        for (int i = 0; i < menuItemModifierPage.getRows(); ++i) {
            for (int j = 0; j < menuItemModifierPage.getCols(); ++j) {
                MenuItemModifierPageItem menuItemModifierPageItem;
                String string = String.format("cell %s %s", j, i);
                if (!menuItemModifierPage.isFlixibleButtonSize().booleanValue()) {
                    string = string + String.format(", w %s!, h %s!", menuItemModifierPage.getButtonWidth(), menuItemModifierPage.getButtonHeight());
                }
                if ((menuItemModifierPageItem = menuItemModifierPage.getItemForCell(j, i)) == null) {
                    this.selectionButtonsPanel.add((Component)new JLabel(), string);
                    continue;
                }
                AbstractButton abstractButton = this.createItemButton(menuItemModifierPageItem);
                if (abstractButton == null) continue;
                this.selectionButtonsPanel.add((Component)abstractButton, string);
            }
        }
        this.revalidate();
        this.repaint();
        this.btnNext.setVisible(this.dataModel.hasNext());
        this.btnPrev.setVisible(this.dataModel.hasPrevious());
    }

    private void a(ModifierGroup modifierGroup) {
        int n;
        int n2;
        String string;
        if (this.c.isUseModifierGroupSettings() && modifierGroup != null) {
            string = modifierGroup.getName();
            n2 = modifierGroup.getMinQuantity();
            n = modifierGroup.getMaxQuantity();
        } else {
            string = this.c.getName();
            n2 = this.c.getMinQuantity();
            n = this.c.getMaxQuantity();
        }
        String string2 = this.c.getInstruction() == null ? "" : this.c.getInstruction();
        this.selectionButtonsPanel.setBorder(null);
        String string3 = " (" + Messages.getString("ModifierView.1") + ":" + n2 + Messages.getString("ModifierView.3") + n + ")";
        TitledBorder titledBorder = new TitledBorder(null, string + string3, 2, 2);
        this.setBorder(titledBorder);
        this.lblGroupDescripton.setText("<html><div style='text-align: justify; padding:0px 5px;'>" + string2 + "</div></html>");
    }

    @Override
    protected AbstractButton createItemButton(Object object) {
        MenuItemModifierPageItem menuItemModifierPageItem = (MenuItemModifierPageItem)object;
        ModifierButton modifierButton = new ModifierButton(menuItemModifierPageItem);
        return modifierButton;
    }

    public void addModifierSelectionListener(ModifierSelectionListener modifierSelectionListener) {
        this.a.add(modifierSelectionListener);
    }

    public void removeModifierSelectionListener(ModifierSelectionListener modifierSelectionListener) {
        this.a.remove(modifierSelectionListener);
    }

    public void updateView() {
        Component[] componentArray = this.selectionButtonsPanel.getComponents();
        if (componentArray == null || componentArray.length == 0) {
            return;
        }
        TicketItem ticketItem = this.b.getTicketItem();
        HashMap<String, TicketItemModifier> hashMap = new HashMap<String, TicketItemModifier>();
        if (ticketItem.getTicketItemModifiers() != null && ticketItem.getTicketItemModifiers().size() > 0) {
            for (TicketItemModifier ticketItemModifier : ticketItem.getTicketItemModifiers()) {
                hashMap.put(ticketItemModifier.getItemId(), ticketItemModifier);
            }
        }
        for (Component component : componentArray) {
            Comparable<StringBuilder> comparable;
            if (component instanceof JLabel) continue;
            ModifierButton modifierButton = (ModifierButton)component;
            MenuItemModifierPageItem menuItemModifierPageItem = modifierButton.e;
            TicketItemModifier ticketItemModifier = (TicketItemModifier)hashMap.get(menuItemModifierPageItem.getMenuModifierId());
            if (ticketItemModifier != null) {
                comparable = MenuModifierDAO.getInstance().get(menuItemModifierPageItem.getMenuModifierId());
                MenuModifierDAO.getInstance().initialize((MenuModifier)comparable);
                double d = ticketItem.findTicketItemModifierByMenuModifier((MenuModifier)comparable);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("<html><center>");
                stringBuilder.append(menuItemModifierPageItem.getMenuModifierName());
                stringBuilder.append("<br/><span style='color:green;'>(");
                stringBuilder.append(d);
                stringBuilder.append(")</span></center></html>");
                modifierButton.setText(stringBuilder.toString());
            } else {
                comparable = new StringBuilder();
                ((StringBuilder)comparable).append("<html><center>");
                ((StringBuilder)comparable).append(menuItemModifierPageItem.getMenuModifierName());
                ((StringBuilder)comparable).append("</center></html>");
                modifierButton.setText(((StringBuilder)comparable).toString());
            }
            if (ModifierSelectionDialog.isRequiredModifiersAdded(ticketItem, this.c)) {
                this.e.setBackground(Color.green);
                continue;
            }
            this.e.setBackground(UIManager.getColor("Control"));
        }
    }

    @Override
    protected void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        this.setDataModel(this.dataModel);
    }

    @Override
    protected void scrollUp() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        this.setDataModel(this.dataModel);
    }

    private class MultiplierButton
    extends POSToggleButton
    implements ActionListener {
        private Multiplier b;

        public MultiplierButton(Multiplier multiplier) {
            Integer n;
            this.b = multiplier;
            this.setText(multiplier.getTicketPrefix());
            Integer n2 = multiplier.getButtonColor();
            if (n2 != null) {
                this.setBackground(new Color(n2));
            }
            if ((n = multiplier.getTextColor()) != null) {
                this.setForeground(new Color(n));
            }
            this.setBorder(null);
            this.setBorderPainted(false);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ModifierView.this.g = this.b;
        }

        public Multiplier getMultiplier() {
            return this.b;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
        }
    }

    private class ModifierButton
    extends PosButton
    implements ActionListener {
        private int b = 100;
        private MenuItemModifierPageItem e;

        public ModifierButton(MenuItemModifierPageItem menuItemModifierPageItem) {
            MenuModifier menuModifier;
            this.e = menuItemModifierPageItem;
            this.setFocusable(true);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.b = PosUIManager.getSize(100);
            this.setText("<html><center>" + menuItemModifierPageItem.getMenuModifierName() + "</center></html>");
            if (menuItemModifierPageItem.getImage() != null) {
                int n = this.b - PosUIManager.getSize(0);
                int n2 = this.b - PosUIManager.getSize(0);
                if (menuItemModifierPageItem.isShowImageOnly().booleanValue()) {
                    this.setIcon(new ImageIcon(menuItemModifierPageItem.getImage().getImage().getScaledInstance(n, n2, 0)));
                } else {
                    n = PosUIManager.getSize(80);
                    n2 = PosUIManager.getSize(40);
                    this.setIcon(new ImageIcon(menuItemModifierPageItem.getImage().getImage().getScaledInstance(n, n2, 0)));
                    this.setText("<html><body><center>" + menuItemModifierPageItem.getMenuModifierName() + "</center></body></html>");
                }
            } else {
                this.setText("<html><body><center>" + menuItemModifierPageItem.getMenuModifierName() + "</center></body></html>");
            }
            if (menuItemModifierPageItem.getTextColor() != null) {
                this.setForeground(menuItemModifierPageItem.getTextColor());
            }
            if (menuItemModifierPageItem.getButtonColor() != null) {
                this.setBackground(menuItemModifierPageItem.getButtonColor());
            }
            if (!(menuModifier = menuItemModifierPageItem.getMenuModifier()).isEnable().booleanValue()) {
                this.setEnabled(false);
            }
            this.setPreferredSize(new Dimension(this.b, this.b));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = this.e.getMenuModifierId();
                MenuModifier menuModifier = MenuModifierDAO.getInstance().get(string);
                if (menuModifier == null) {
                    throw new PosException(String.format(Messages.getString("ModifierView.4"), new Object[0]));
                }
                MenuModifierDAO.getInstance().initialize(menuModifier);
                menuModifier.setMenuItemModifierSpec(ModifierView.this.c);
                menuModifier.setModifierGroup(ModifierView.this.c.getModifierGroup());
                for (ModifierSelectionListener modifierSelectionListener : ModifierView.this.a) {
                    modifierSelectionListener.modifierSelected(menuModifier, ModifierView.this.g);
                }
                if (ModifierView.this.h != null) {
                    ModifierView.this.h.setSelected(true);
                    ModifierView.this.g = ModifierView.this.h.getMultiplier();
                }
            }
            catch (PosException posException) {
                POSMessageDialog.showError(posException.getMessage());
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
            }
        }
    }
}

