/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.model.Store;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.NumericKeypad;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class GratuityInputDialog
extends OkCancelOptionDialog {
    private DoubleTextField a;
    private Double b;
    private List<PosButton> c;

    public GratuityInputDialog() {
        super(POSUtil.getFocusedWindow());
        this.setCaption(Messages.getString("GratuityInputDialog.0"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("inset 0", "[grow,fill]", "[grow,fill]"));
        this.a = new DoubleTextField();
        this.a.setHorizontalAlignment(11);
        this.a.setFocusCycleRoot(true);
        this.a.setFont(this.a.getFont().deriveFont(1, PosUIManager.getNumberFieldFontSize()));
        this.a.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    GratuityInputDialog.this.doOk();
                }
            }
        });
        jPanel.add((Component)this.a, "cell 0 0,alignx left,height 40px,aligny top");
        NumericKeypad numericKeypad = new NumericKeypad();
        jPanel.add((Component)numericKeypad, "cell 0 1");
        jPanel.add((Component)this.a(), "cell 0 2");
        this.getContentPanel().add(jPanel);
    }

    private JPanel a() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("inset 0", "[grow,fill]", "[grow,fill]"));
        Font font = UIManager.getFont("Button.font").deriveFont((float)PosUIManager.getFontSize(18));
        Store store = DataProvider.get().getStore();
        Map<String, Double> map = store.getGratuityPercentageConfig();
        this.c = new ArrayList<PosButton>();
        this.a(jPanel, font, map);
        SwingUtilities.invokeLater(() -> this.c.forEach(posButton -> posButton.setText(CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumberIfNeeded(this.a(Double.parseDouble(posButton.getText()))))));
        return jPanel;
    }

    private void a(JPanel jPanel, Font font, Map<String, Double> map) {
        PosButton posButton;
        Double d;
        int n;
        for (n = 0; n < map.size(); ++n) {
            d = map.get("gp" + (n + 1));
            posButton = new PosButton(NumberUtil.formatNumberIfNeeded(d) + "%");
            posButton.setFont(font);
            posButton.addActionListener(actionEvent -> this.setGratuity(this.a((double)d, false)));
            if (n == 2 || n == 5) {
                jPanel.add((Component)posButton, "wrap");
                continue;
            }
            jPanel.add(posButton);
        }
        for (n = 0; n < map.size(); ++n) {
            d = map.get("gp" + (n + 1));
            posButton = new PosButton(d + "");
            posButton.setFont(font);
            this.c.add(posButton);
            posButton.addActionListener(actionEvent -> this.setGratuity(this.a(d)));
            if (n == 2 || n == 5) {
                jPanel.add((Component)posButton, "wrap");
                continue;
            }
            jPanel.add(posButton);
        }
    }

    private double a(double d) {
        return this.a(d, true);
    }

    private double a(double d, boolean bl) {
        double d2 = 0.0;
        if (d > 0.0) {
            d2 = this.b * (d / 100.0);
        }
        return bl ? (double)Math.round(d2) : d2;
    }

    @Override
    public void doOk() {
        if (StringUtils.isBlank((String)this.a.getText())) {
            POSMessageDialog.showError(Messages.getString("GratuityInputDialog.1"));
            return;
        }
        double d = this.a.getDoubleOrZero();
        if (d < 0.0) {
            POSMessageDialog.showError(Messages.getString("SettleTicketProcessor.21"));
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    public void setGratuity(double d) {
        this.a.setText(NumberUtil.format(d));
    }

    public double getGratuityAmount() {
        return this.a.getDoubleOrZero();
    }

    public void setSubTotalAmount(Double d) {
        this.b = d;
    }
}

