/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.kitchendisplay.LineDisplayWindow;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.StoreUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URLEncoder;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.sql.rowset.serial.SerialBlob;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jiconfont.IconCode;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import org.apache.commons.lang.StringUtils;

public class POSUtil {
    public static Window getFocusedWindow() {
        Window window = FocusManager.getCurrentManager().getFocusedWindow();
        if (window == null) {
            Window[] windowArray;
            for (Window window2 : windowArray = Window.getWindows()) {
                if (!window2.isShowing()) continue;
                return window2;
            }
        }
        return POSUtil.a(window);
    }

    private static Window a(Window window) {
        if (window == null) {
            return window;
        }
        if (window.isShowing()) {
            return window;
        }
        Container container = window.getParent();
        if (container instanceof Window) {
            return POSUtil.a((Window)container);
        }
        return window;
    }

    public static Image getScaledImage(Image image, int n, int n2) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static BufferedImage convertBlackAndWhiteImage(Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.drawImage(image, 0, 0, Color.WHITE, null);
        graphics2D.dispose();
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                Color color = new Color(bufferedImage.getRGB(j, i));
                int n3 = (int)((double)color.getRed() * 0.299);
                int n4 = (int)((double)color.getGreen() * 0.587);
                int n5 = (int)((double)color.getBlue() * 0.114);
                Color color2 = new Color(n3 + n4 + n5, n3 + n4 + n5, n3 + n4 + n5);
                bufferedImage.setRGB(j, i, color2.getRGB());
            }
        }
        return bufferedImage;
    }

    public static ImageIcon convertToButtonImage(ImageIcon imageIcon) {
        return POSUtil.scaleImage(imageIcon, 80);
    }

    public static ImageIcon convertToBigButtonImage(ImageIcon imageIcon) {
        return POSUtil.scaleImage(imageIcon, 200);
    }

    public static ImageIcon scaleImage(ImageIcon imageIcon, int n) {
        if (imageIcon == null) {
            return null;
        }
        int n2 = imageIcon.getIconHeight();
        int n3 = imageIcon.getIconWidth();
        if (n3 > n2) {
            int n4 = n;
            int n5 = n2 * n4 / n3;
            Image image = imageIcon.getImage().getScaledInstance(PosUIManager.getSize(n4), PosUIManager.getSize(n5), 4);
            return new ImageIcon(image);
        }
        int n6 = n;
        int n7 = n3 * n6 / n2;
        Image image = imageIcon.getImage().getScaledInstance(PosUIManager.getSize(n7), PosUIManager.getSize(n6), 4);
        return new ImageIcon(image);
    }

    public static BackOfficeWindow getBackOfficeWindow() {
        return BackOfficeWindow.getInstance();
    }

    public static LineDisplayWindow getLineDisplayWindow() {
        Window[] windowArray;
        for (Window window : windowArray = Window.getWindows()) {
            if (!(window instanceof LineDisplayWindow)) continue;
            return (LineDisplayWindow)window;
        }
        return null;
    }

    public static boolean isBlankOrNull(String string) {
        if (string == null) {
            return true;
        }
        return string.trim().equals("");
    }

    public static String escapePropertyKey(String string) {
        return string.replaceAll("\\s+", "_");
    }

    public static boolean getBoolean(String string) {
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    public static boolean getBoolean(String string, boolean bl) {
        if (StringUtils.isBlank((String)string)) {
            return bl;
        }
        return Boolean.valueOf(string);
    }

    public static boolean getBoolean(Boolean bl) {
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public static boolean getBoolean(Boolean bl, boolean bl2) {
        if (bl == null) {
            return bl2;
        }
        return bl;
    }

    public static double getDouble(Double d) {
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public static Integer getInteger(Object object) {
        if (object != null && object instanceof Number) {
            return ((Number)object).intValue();
        }
        return 0;
    }

    public static double getDoubleAmount(Object object) {
        if (object != null && object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            return POSUtil.parseDouble((String)object);
        }
        return 0.0;
    }

    @Deprecated
    public static double getRoundedDouble(Object object) {
        if (object != null && object instanceof Number) {
            return NumberUtil.round(((Number)object).doubleValue());
        }
        return 0.0;
    }

    public static int getInteger(Integer n) {
        if (n == null) {
            return 0;
        }
        return n;
    }

    public static int parseInteger(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static int parseInteger(String string, String string2) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            throw new PosException(string2);
        }
    }

    public static double parseDouble(String string) {
        return NumberUtil.parseOrGetZero(string).doubleValue();
    }

    public static double parseDouble(String string, String string2, boolean bl) {
        if (bl && StringUtils.isBlank((String)string)) {
            throw new PosException(Messages.getString("POSUtil.1"));
        }
        try {
            return NumberUtil.parse(string).doubleValue();
        }
        catch (Exception exception) {
            if (bl) {
                throw new PosException(string2);
            }
            return 0.0;
        }
    }

    public static String encodeURLString(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static boolean isValidPassword(char[] cArray) {
        for (char c : cArray) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkDrawerAssignment() {
        Terminal terminal = Application.getInstance().getTerminal();
        User user = Application.getCurrentUser();
        return POSUtil.checkDrawerAssignment(terminal, user);
    }

    public static boolean checkDrawerAssignment(Terminal terminal, User user) {
        if (terminal.isTwoCashDrawersEnable()) {
            return POSUtil.checkDrawerAssignmentV2(terminal, user);
        }
        return POSUtil.checkDrawerAssignmentV1(terminal, user);
    }

    public static boolean checkDrawerAssignmentV1(Terminal terminal, User user) {
        if (TerminalDAO.getInstance().isDrawerAssigned(terminal)) {
            return true;
        }
        if (user != null && user.isStaffBank().booleanValue() && user.isStaffBankStarted().booleanValue()) {
            return true;
        }
        if (!terminal.isHasCashDrawer().booleanValue()) {
            POSUtil.b();
            return false;
        }
        return POSUtil.a(terminal, user);
    }

    public static boolean checkDrawerAssignmentV2(Terminal terminal, User user) {
        if (user != null && user.isStaffBank().booleanValue() && user.isStaffBankStarted().booleanValue()) {
            return true;
        }
        if (!terminal.isHasCashDrawer().booleanValue()) {
            POSUtil.b();
            return false;
        }
        CashDrawer cashDrawer = user.getActiveCashDrawer();
        if (cashDrawer != null) {
            return true;
        }
        return POSUtil.a(terminal, user);
    }

    private static boolean a(Terminal terminal, User user) {
        try {
            CashDrawer cashDrawer;
            if (terminal.isTwoCashDrawersEnable() && (cashDrawer = terminal.getCurrentCashDrawer()) != null && cashDrawer.isLocked()) {
                POSUtil.a();
                return false;
            }
            cashDrawer = new CashDrawer();
            double d = TerminalConfig.getDeafultDrawerAmount();
            cashDrawer.setStartTime(new Date());
            cashDrawer.setAssignedUser(user);
            cashDrawer.setTerminal(terminal);
            cashDrawer.setStoreSession(StoreUtil.getCurrentStoreSession());
            cashDrawer.setDrawerType(DrawerType.DRAWER);
            cashDrawer.setBeginCash(d);
            cashDrawer.setAssignedBy(user);
            cashDrawer.setOutletId(DataProvider.get().getCurrentOutletId());
            terminal.setCurrentCashDrawer(cashDrawer);
            terminal.setAssignedUser(user);
            CashDrawerDAO.getInstance().saveDrawerAssignment(cashDrawer, terminal);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Drawer id: " + cashDrawer.getId());
            stringBuilder.append(",");
            stringBuilder.append("Assign to user: " + user.getId() + "/" + user.getFullName());
            stringBuilder.append(".");
            ActionHistoryDAO.saveHistory("Cash drawer assignment", stringBuilder.toString());
            return true;
        }
        catch (Exception exception) {
            PosLog.error(POSUtil.class, exception.getMessage());
            POSUtil.a();
            return false;
        }
    }

    private static void a() {
        POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SwitchboardView.18"));
    }

    private static void b() {
        POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("POSUtil.3"));
    }

    public static Blob convertImageToBlob(File file, int n) throws Exception {
        int n2;
        int n3;
        int n4;
        int n5;
        if (file == null) {
            return null;
        }
        BufferedImage bufferedImage = ImageIO.read(file);
        int n6 = bufferedImage.getWidth();
        if (n6 > (n5 = bufferedImage.getHeight())) {
            n4 = n;
            n3 = n5 * n4 / n6;
            n2 = bufferedImage.getType() == 0 ? 2 : bufferedImage.getType();
            bufferedImage = POSUtil.resizeImage(bufferedImage, n4, n3, n2);
        } else {
            n4 = n;
            n3 = n6 * n4 / n5;
            n2 = bufferedImage.getType() == 0 ? 2 : bufferedImage.getType();
            bufferedImage = POSUtil.resizeImage(bufferedImage, n3, n4, n2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(50000);
        String string = file.getName();
        n2 = string.lastIndexOf(".");
        String string2 = string.substring(n2 + 1);
        if (string2.equals("jpg")) {
            ImageIO.write((RenderedImage)bufferedImage, "jpg", byteArrayOutputStream);
        } else if (string2.equals("jpeg")) {
            ImageIO.write((RenderedImage)bufferedImage, "jpeg", byteArrayOutputStream);
        } else if (string2.equals("png")) {
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, "gif", byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        if (byArray.length > 0x3200000) {
            throw new RuntimeException(Messages.getString("POSUtil.0"));
        }
        return new SerialBlob(byArray);
    }

    @Deprecated
    public static Blob convertImageToBlob(File file) throws Exception {
        int n;
        if (file == null) {
            return null;
        }
        BufferedImage bufferedImage = ImageIO.read(file);
        if (bufferedImage.getWidth() > 400 || bufferedImage.getHeight() > 400) {
            int n2 = bufferedImage.getType() == 0 ? 2 : bufferedImage.getType();
            bufferedImage = POSUtil.resizeImage(bufferedImage, 400, 400, n2);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(50000);
        String string = file.getName();
        String string2 = string.substring((n = string.lastIndexOf(".")) + 1);
        if (string2.equals("jpg")) {
            ImageIO.write((RenderedImage)bufferedImage, "jpg", byteArrayOutputStream);
        } else if (string2.equals("jpeg")) {
            ImageIO.write((RenderedImage)bufferedImage, "jpeg", byteArrayOutputStream);
        } else if (string2.equals("png")) {
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, "gif", byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (byArray.length > 500000) {
            throw new RuntimeException(Messages.getString("POSUtil.0"));
        }
        return new SerialBlob(byArray);
    }

    public static Blob convertImageToBlob(BufferedImage bufferedImage, String string) throws Exception {
        if (bufferedImage == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(50000);
        if (string.equals("jpg")) {
            ImageIO.write((RenderedImage)bufferedImage, "jpg", byteArrayOutputStream);
        } else if (string.equals("jpeg")) {
            ImageIO.write((RenderedImage)bufferedImage, "jpeg", byteArrayOutputStream);
        } else if (string.equals("png")) {
            ImageIO.write((RenderedImage)bufferedImage, "png", byteArrayOutputStream);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, "gif", byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (byArray.length > 500000) {
            throw new RuntimeException(Messages.getString("POSUtil.0"));
        }
        return new SerialBlob(byArray);
    }

    public static Blob convertScaledImageToBlob(File file) throws Exception {
        int n;
        if (file == null) {
            return null;
        }
        int n2 = 120;
        int n3 = 120;
        BufferedImage bufferedImage = ImageIO.read(file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(50000);
        int n4 = bufferedImage.getType() == 0 ? 2 : bufferedImage.getType();
        BufferedImage bufferedImage2 = POSUtil.resizeImage(bufferedImage, n2, n3, n4);
        String string = file.getName();
        String string2 = string.substring((n = string.lastIndexOf(".")) + 1);
        if (string2.equals("jpg")) {
            ImageIO.write((RenderedImage)bufferedImage2, "jpg", byteArrayOutputStream);
        } else if (string2.equals("jpeg")) {
            ImageIO.write((RenderedImage)bufferedImage2, "jpeg", byteArrayOutputStream);
        } else if (string2.equals("png")) {
            ImageIO.write((RenderedImage)bufferedImage2, "png", byteArrayOutputStream);
        } else {
            ImageIO.write((RenderedImage)bufferedImage2, "gif", byteArrayOutputStream);
        }
        return new SerialBlob(byteArrayOutputStream.toByteArray());
    }

    public static Blob convertImageResourceToBlob(ImageResource imageResource) throws Exception {
        return new SerialBlob(imageResource.getImageBytes());
    }

    public static BufferedImage resizeImage(BufferedImage bufferedImage, int n, int n2, int n3) {
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, n3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static User getUserWithPermission(UserPermission userPermission) {
        String string = PasswordEntryDialog.show(Application.getPosWindow(), userPermission.toString(), Messages.getString("PosAction.0"));
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        User user = UserDAO.getInstance().findUserBySecretKey(string);
        if (user == null) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("PosAction.1"));
            return null;
        }
        if (!user.hasPermission(userPermission)) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("PosAction.2"));
            return null;
        }
        return user;
    }

    public static void storeLongProperty(Map<String, String> map, String string, String string2, int n) {
        block4: {
            String string3;
            String string42;
            Set<String> set = map.keySet();
            HashSet<String> hashSet = new HashSet<String>();
            for (String string42 : set) {
                if (!string42.startsWith(string)) continue;
                hashSet.add(string42);
            }
            for (String string42 : hashSet) {
                map.remove(string42);
            }
            if (string2.length() <= n) {
                map.put(string + "1", string2);
                return;
            }
            int n2 = 1;
            string42 = "";
            do {
                string42 = string2.substring(0, n);
                string2 = string2.substring(n);
                string3 = string + n2++;
                map.put(string3, string42);
            } while (string2.length() >= n);
            if (!StringUtils.isNotEmpty((String)string2)) break block4;
            string3 = string + n2++;
            map.put(string3, string2);
        }
    }

    public static String readLongProperty(Map<String, String> map, String string) {
        String string2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        StringBuilder stringBuilder = new StringBuilder();
        Set<String> set = map.keySet();
        for (String object : set) {
            if (!object.startsWith(string)) continue;
            string2 = object.replaceAll(string, "");
            try {
                arrayList.add(Integer.parseInt(string2));
            }
            catch (Exception exception) {}
        }
        if (arrayList.size() == 0) {
            return null;
        }
        Collections.sort(arrayList);
        for (Integer n : arrayList) {
            string2 = map.get(string + n);
            stringBuilder.append(string2);
        }
        return stringBuilder.toString();
    }

    public static void removeLongProperty(Map<String, String> map, String string) {
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (!entry.getKey().startsWith(string)) continue;
            iterator.remove();
        }
    }

    public static Set copySelectedValues(Set linkedHashSet, Set set) {
        if (linkedHashSet == null) {
            linkedHashSet = new LinkedHashSet();
            linkedHashSet.addAll(set);
            return linkedHashSet;
        }
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (set.contains(e)) continue;
            iterator.remove();
        }
        linkedHashSet.addAll(set);
        return linkedHashSet;
    }

    public static List copySelectedValues(List arrayList, List list) {
        if (arrayList == null) {
            arrayList = new ArrayList();
            arrayList.addAll(list);
            return arrayList;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (list.contains(e)) continue;
            iterator.remove();
        }
        arrayList.addAll(list);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(String string) throws IOException {
        try (ByteArrayOutputStream byteArrayOutputStream = null;){
            byteArrayOutputStream = new ByteArrayOutputStream(string.length());
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(string.getBytes("UTF-8"));
            gZIPOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decompress(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        GZIPInputStream gZIPInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            String string;
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)gZIPInputStream, "UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            while ((string = bufferedReader.readLine()) != null) {
                stringBuilder.append(string);
            }
            String string2 = stringBuilder.toString();
            return string2;
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (gZIPInputStream != null) {
                gZIPInputStream.close();
            }
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
        }
    }

    public static boolean isWindowsOs() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.indexOf("win") >= 0;
    }

    public static void openURLToBrowser(String string) {
        try {
            Desktop desktop;
            Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
            if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                desktop.browse(new URI(string));
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    public static boolean isAllowLocalItem() {
        String string = System.getProperty("allowLocalItem");
        if (StringUtils.isEmpty((String)string)) {
            return true;
        }
        return Boolean.valueOf(string);
    }

    public static String toFormattedString(List<?> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        String string = list.toString();
        return string.substring(1, string.length() - 1);
    }

    public static int getIntegerOrZero(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static boolean validatePhoneNo(String string) {
        if (StringUtils.isBlank((String)string)) {
            return false;
        }
        String string2 = "^[+]?[(]?[0-9]{0,3}[)]?[-\\s.]?[0-9]{0,3}[-\\s.]?[0-9]{3,9}$";
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static List<String> getStringIds(List<? extends Object> list, Class<?> clazz) {
        return POSUtil.getStringIds(list, clazz, "");
    }

    public static List<String> getStringIds(List<? extends Object> list, Class<?> clazz, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list != null) {
            try {
                for (Object object : list) {
                    Object object2;
                    Method method;
                    if (StringUtils.isBlank((String)string)) {
                        string = "getId";
                    }
                    if ((method = clazz.getMethod(string, null)) == null || (object2 = method.invoke(object, (Object[])null)) == null) continue;
                    arrayList.add((String)object2);
                }
            }
            catch (Exception exception) {
                PosLog.error(POSUtil.class, exception);
            }
        }
        return arrayList;
    }

    public static List<Integer> getIntegerIds(List<? extends Object> list, Class<?> clazz) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (list != null) {
            try {
                for (Object object : list) {
                    Object object2;
                    Method method = clazz.getMethod("getId", null);
                    if (method == null || (object2 = method.invoke(object, (Object[])null)) == null) continue;
                    arrayList.add((Integer)object2);
                }
            }
            catch (Exception exception) {
                PosLog.error(POSUtil.class, exception);
            }
        }
        return arrayList;
    }

    public static Date monthOfYear(int n, int n2) {
        return POSUtil.createDate(null, n, n2);
    }

    public static Date createDate(Integer n, int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n3);
        calendar.set(2, n2 - 1);
        if (n != null) {
            calendar.set(5, n);
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return new Date(calendar.getTimeInMillis());
    }

    public static List<Integer> getYearList() {
        return POSUtil.getYearList(2000);
    }

    public static List<Integer> getYearList(int n) {
        Calendar calendar = Calendar.getInstance();
        int n2 = calendar.get(1);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = n2; i >= n; --i) {
            arrayList.add(i);
        }
        return arrayList;
    }

    public static List<Integer> getDayList() {
        return POSUtil.getDayList(0, null);
    }

    public static List<Integer> getDayList(int n, Integer n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, n);
        if (n2 != null) {
            calendar.set(1, n2);
        }
        int n3 = calendar.getActualMaximum(5);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 1; i <= n3; ++i) {
            arrayList.add(i);
        }
        return arrayList;
    }

    public static List<Date> getDaysBetweenDates(Date date, Date date2) {
        ArrayList<Date> arrayList = new ArrayList<Date>();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        while (gregorianCalendar.getTime().before(date2) || gregorianCalendar.getTime().equals(date2)) {
            Date date3 = gregorianCalendar.getTime();
            arrayList.add(date3);
            ((Calendar)gregorianCalendar).add(5, 1);
        }
        return arrayList;
    }

    public static List<Date> getMonthBetweenDates(Date date, Date date2) {
        ArrayList<Date> arrayList = new ArrayList<Date>();
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        gregorianCalendar.set(5, 1);
        while (gregorianCalendar.getTime().before(date2) || gregorianCalendar.getTime().equals(date2)) {
            Date date3 = gregorianCalendar.getTime();
            arrayList.add(date3);
            ((Calendar)gregorianCalendar).add(2, 1);
        }
        return arrayList;
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static void main(String[] stringArray) {
        POSUtil.beep();
    }

    public static String createNameString(List<? extends Object> list, Class<?> clazz) {
        return POSUtil.createStringByField(list, clazz, null);
    }

    public static String createStringByField(List<? extends Object> list, Class<?> clazz, String string) {
        return POSUtil.createStringByField(list, clazz, string, Boolean.FALSE);
    }

    public static String createStringByField(List<? extends Object> list, Class<?> clazz, String string, boolean bl) {
        if (list == null || list.isEmpty()) {
            return POSConstants.ALL;
        }
        String string2 = "";
        try {
            Iterator<? extends Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object object2 = iterator.next();
                Method method = clazz.getMethod(string == null ? "getName" : string, null);
                if (method != null && (object = method.invoke(object2, (Object[])null)) != null) {
                    string2 = bl ? string2 + "'" + (String)object + "'" : string2 + (String)object;
                }
                if (!iterator.hasNext()) continue;
                string2 = string2 + ", ";
            }
        }
        catch (Exception exception) {
            PosLog.error(POSUtil.class, exception);
        }
        return string2;
    }

    public static void clear(Collection collection) {
        if (collection != null) {
            collection.clear();
        }
    }

    public static List copyList(List list) {
        if (list != null) {
            return new ArrayList(list);
        }
        return new ArrayList(1);
    }

    public static Set copySet(Set set) {
        if (set != null) {
            return new HashSet(set);
        }
        return new HashSet(1);
    }

    public static String createOrderTypeIdString(List<OrderType> list) {
        if (list == null) {
            return POSConstants.ALL;
        }
        String string = "";
        Iterator<OrderType> iterator = list.iterator();
        while (iterator.hasNext()) {
            OrderType orderType = iterator.next();
            string = string + orderType.getName();
            if (!iterator.hasNext()) continue;
            string = string + ", ";
        }
        return string;
    }

    public static String formatGiftCardNo(String string) {
        if (StringUtils.isNotEmpty((String)string)) {
            if (string.startsWith("%")) {
                string = string.replaceFirst("%", "");
            }
            if (string.endsWith("?")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public static Object getFromList(Object object, List list) {
        if (list == null) {
            return null;
        }
        for (Object e : list) {
            if (!object.equals(e)) continue;
            return e;
        }
        return null;
    }

    public static JPanel doCreateDemoMessagePanel(String string) {
        JPanel jPanel = new JPanel(new WrapLayout());
        jPanel.setBorder(null);
        Font font = jPanel.getFont().deriveFont(1);
        jPanel.setBackground(Color.RED);
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(font);
        jLabel.setForeground(Color.WHITE);
        JButton jButton = new JButton("shop.orocube.com");
        jButton.setFont(font);
        jButton.setBorder(BorderFactory.createEmptyBorder());
        jButton.setFocusable(false);
        jButton.setHorizontalAlignment(4);
        jButton.setIcon(IconFontSwing.buildIcon((IconCode)GoogleMaterialDesignIcons.OPEN_IN_NEW, (float)16.0f));
        jButton.addActionListener(actionEvent -> POSUtil.openURLToBrowser("https://shop.orocube.com"));
        jButton.setForeground(Color.WHITE);
        jButton.setBackground(Color.RED);
        jButton.setCursor(Cursor.getPredefinedCursor(12));
        JLabel jLabel2 = new JLabel(Messages.getString("StoreConfigurationView.14"));
        jLabel2.setFont(font);
        jLabel2.setForeground(Color.WHITE);
        jPanel.add(jLabel);
        jPanel.add(jButton);
        jPanel.add(jLabel2);
        return jPanel;
    }

    public static boolean endsWithComma(String string) {
        return string != null && string.trim().endsWith(",");
    }
}

