/*
 * Decompiled with CFR 0.152.
 */
package com.jstatcom.component;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JPanel;

public class CardPanel
extends JPanel {
    public CardPanel() {
        super(new Layout());
    }

    protected int getVisibleChildIndex() {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.getComponent(i);
            if (!component.isVisible()) continue;
            return i;
        }
        return -1;
    }

    public void showCard(Component component) {
        int n;
        if (component.getParent() != this) {
            this.add(component);
        }
        if ((n = this.getVisibleChildIndex()) != -1) {
            this.getComponent(n).setVisible(false);
        }
        component.setVisible(true);
        this.revalidate();
        this.repaint();
    }

    public void showCard(String string) {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.getComponent(i);
            if (!component.getName().equals(string)) continue;
            this.showCard(component);
            break;
        }
    }

    public void showFirstCard() {
        if (this.getComponentCount() <= 0) {
            return;
        }
        this.showCard(this.getComponent(0));
    }

    public void showLastCard() {
        if (this.getComponentCount() <= 0) {
            return;
        }
        this.showCard(this.getComponent(this.getComponentCount() - 1));
    }

    public void showNextCard() {
        if (this.getComponentCount() <= 0) {
            return;
        }
        int n = this.getVisibleChildIndex();
        if (n == -1) {
            this.showCard(this.getComponent(0));
        } else if (n == this.getComponentCount() - 1) {
            this.showCard(this.getComponent(0));
        } else {
            this.showCard(this.getComponent(n + 1));
        }
    }

    public void showPreviousCard() {
        if (this.getComponentCount() <= 0) {
            return;
        }
        int n = this.getVisibleChildIndex();
        if (n == -1) {
            this.showCard(this.getComponent(0));
        } else if (n == 0) {
            this.showCard(this.getComponent(this.getComponentCount() - 1));
        } else {
            this.showCard(this.getComponent(n - 1));
        }
    }

    private static class Layout
    implements LayoutManager {
        private Layout() {
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            if (string != null) {
                component.setName(string);
            }
            component.setVisible(component.getParent().getComponentCount() == 1);
        }

        @Override
        public void removeLayoutComponent(Component component) {
            Container container;
            if (component.isVisible() && (container = component.getParent()).getComponentCount() > 0) {
                container.getComponent(0).setVisible(true);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            int n = container.getComponentCount();
            Insets insets = container.getInsets();
            int n2 = insets.left + insets.right;
            int n3 = insets.top + insets.bottom;
            for (int i = 0; i < n; ++i) {
                Dimension dimension = container.getComponent(i).getPreferredSize();
                if (dimension.width > n2) {
                    n2 = dimension.width;
                }
                if (dimension.height <= n3) continue;
                n3 = dimension.height;
            }
            return new Dimension(n2, n3);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            int n = container.getComponentCount();
            Insets insets = container.getInsets();
            int n2 = insets.left + insets.right;
            int n3 = insets.top + insets.bottom;
            for (int i = 0; i < n; ++i) {
                Dimension dimension = container.getComponent(i).getMinimumSize();
                if (dimension.width > n2) {
                    n2 = dimension.width;
                }
                if (dimension.height <= n3) continue;
                n3 = dimension.height;
            }
            return new Dimension(n2, n3);
        }

        @Override
        public void layoutContainer(Container container) {
            int n = container.getComponentCount();
            Insets insets = container.getInsets();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Rectangle rectangle = container.getBounds();
                int n2 = rectangle.width - insets.left + insets.right;
                int n3 = rectangle.height - insets.top + insets.bottom;
                component.setBounds(insets.left, insets.top, n2, n3);
                break;
            }
        }
    }
}

