/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.Writer;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import liquibase.util.file.FilenameUtils;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class CustomerCsvExportAction
extends AbstractAction {
    private static final String a = Messages.getString("CustomerCsvExportAction.0");
    public static final String JSON_PROP_MEMBER_ID = "Member Id";
    public static final String JSON_PROP_SALUTATION = "Salutation";
    public static final String JSON_PROP_FIRST_NAME = "First Name";
    public static final String JSON_PROP_LAST_NAME = "Last Name";
    public static final String JSON_PROP_SECRET_CODE = "Secret Code";
    public static final String JSON_PROP_LOYALTY_NO = "Loyalty No";
    public static final String JSON_PROP_LOYALTY_POINT = "Loyalty Point";
    public static final String JSON_PROP_PHONE = "Phone";
    public static final String JSON_PROP_EMAIL = "Email";
    public static final String JSON_PROP_IS_MEMBER = "Member";
    public static final String JSON_PROP_LIFE_TIME_MEMBER = "Life Time Member";
    public static final String JSON_PROP_MEMBERSHIP_TYPE = "Membership Type";
    public static final String JSON_PROP_MEMBERSHIP_START_DATE = "Membership Start Date";
    public static final String JSON_PROP_MEMBERSHIP_RENEW_DATE = "Membership Renew Date";
    public static final String JSON_PROP_MEMBERSHIP_EXPIRY_DATE = "Membership Expiry Date";
    public static final String JSON_PROP_MEMBERSHIP_ACTIVE = "Membership Active";
    public static final String JSON_PROP_DOB = "DoB";
    public static final String JSON_PROP_SSN = "Ssn";
    public static final String JSON_PROP_ADDRESS = "Address";
    public static final String JSON_PROP_CITY = "City";
    public static final String JSON_PROP_STATE = "State";
    public static final String JSON_PROP_COUNTRY = "Country";
    public static final String JSON_PROP_ZIP = "Zip";
    public static final String JSON_PROP_VIP = "Vip";
    public static final String JSON_PROP_CREDIT_LIMIT = "Credit Limit";
    public static final String JSON_PROP_NOTE = "Note";
    public static final String JSON_PROP_TAX_EXEMPT = "Tax Exempt";
    public static final String JSON_PROP_PIN = "Pin";
    public static final String JSON_PROP_CUSTOMER_GROUP_NAME = "Customer Group Name";
    public static final String JSON_PROP_ACTIVE = "Active";

    public CustomerCsvExportAction() {
        super(a);
    }

    public CustomerCsvExportAction(String string) {
        super(string);
    }

    public CustomerCsvExportAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.a();
        }
        catch (FileNotFoundException fileNotFoundException) {
            POSMessageDialog.showError(fileNotFoundException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() throws Exception {
        CSVPrinter cSVPrinter;
        block14: {
            FileWriter fileWriter;
            JFileChooser jFileChooser;
            List<Customer> list;
            block12: {
                block13: {
                    list = CustomerDAO.getInstance().findAll();
                    if (list == null) {
                        POSMessageDialog.showMessage(Messages.getString("CustomerExplorer.12"));
                        return;
                    }
                    jFileChooser = this.b();
                    Integer n = jFileChooser.showSaveDialog(POSUtil.getBackOfficeWindow());
                    if (n != 0) {
                        return;
                    }
                    File file = jFileChooser.getSelectedFile();
                    String string = file.getPath();
                    String string2 = FilenameUtils.getExtension((String)file.getName());
                    if (StringUtils.isBlank((String)string2)) {
                        jFileChooser.setSelectedFile(new File(string + ".csv"));
                    }
                    cSVPrinter = null;
                    fileWriter = null;
                    if (this.a(jFileChooser)) break block12;
                    if (fileWriter == null) break block13;
                    IOUtils.closeQuietly(fileWriter);
                }
                if (cSVPrinter != null) {
                    cSVPrinter.close();
                }
                return;
            }
            try {
                File file = jFileChooser.getSelectedFile();
                fileWriter = new FileWriter(file);
                CSVFormat cSVFormat = CSVFormat.DEFAULT.withRecordSeparator("\n");
                cSVPrinter = new CSVPrinter((Appendable)fileWriter, cSVFormat);
                Object[] objectArray = new Object[]{JSON_PROP_MEMBER_ID, JSON_PROP_SALUTATION, JSON_PROP_FIRST_NAME, JSON_PROP_LAST_NAME, JSON_PROP_SECRET_CODE, JSON_PROP_LOYALTY_NO, JSON_PROP_LOYALTY_POINT, JSON_PROP_PHONE, JSON_PROP_EMAIL, JSON_PROP_IS_MEMBER, JSON_PROP_LIFE_TIME_MEMBER, JSON_PROP_MEMBERSHIP_TYPE, JSON_PROP_MEMBERSHIP_START_DATE, JSON_PROP_MEMBERSHIP_RENEW_DATE, JSON_PROP_MEMBERSHIP_EXPIRY_DATE, JSON_PROP_MEMBERSHIP_ACTIVE, JSON_PROP_DOB, JSON_PROP_SSN, JSON_PROP_ADDRESS, JSON_PROP_CITY, JSON_PROP_STATE, JSON_PROP_COUNTRY, JSON_PROP_ZIP, JSON_PROP_VIP, JSON_PROP_CREDIT_LIMIT, JSON_PROP_NOTE, JSON_PROP_TAX_EXEMPT, JSON_PROP_PIN, JSON_PROP_CUSTOMER_GROUP_NAME, JSON_PROP_ACTIVE};
                cSVPrinter.printRecord(objectArray);
                for (Customer customer : list) {
                    Object[] objectArray2 = new Object[30];
                    objectArray2[0] = StringUtils.isBlank((String)customer.getMemberId()) ? "" : customer.getMemberId();
                    objectArray2[1] = customer.getSalutation();
                    objectArray2[2] = customer.getFirstName();
                    objectArray2[3] = customer.getLastName();
                    objectArray2[4] = customer.getSecretCode();
                    objectArray2[5] = customer.getLoyaltyNo();
                    objectArray2[6] = customer.getLoyaltyPoint();
                    objectArray2[7] = customer.getMobileNo();
                    objectArray2[8] = StringUtils.isBlank((String)customer.getEmail()) ? "" : customer.getEmail();
                    objectArray2[9] = customer.isMember();
                    objectArray2[10] = customer.isLifeTimeMember();
                    objectArray2[11] = customer.getMembershipTypeDisplayString();
                    objectArray2[12] = customer.getMembershipStartDate() == null ? "" : DateUtil.formatAsGiftCardDateFormat(customer.getMembershipStartDate());
                    objectArray2[13] = customer.getMembershipRenewDate() == null ? "" : DateUtil.formatAsGiftCardDateFormat(customer.getMembershipRenewDate());
                    objectArray2[14] = customer.getMembershipExpiryDate() == null ? "" : DateUtil.formatAsGiftCardDateFormat(customer.getMembershipExpiryDate());
                    objectArray2[15] = customer.isMembershipActive();
                    objectArray2[16] = customer.getDob();
                    objectArray2[17] = customer.getSsn();
                    objectArray2[18] = customer.getAddress();
                    objectArray2[19] = customer.getCity();
                    objectArray2[20] = customer.getState();
                    objectArray2[21] = customer.getCountry();
                    objectArray2[22] = customer.getZipCode();
                    objectArray2[23] = customer.isVip();
                    objectArray2[24] = customer.getCreditLimit();
                    objectArray2[25] = customer.getNote();
                    objectArray2[26] = customer.isTaxExempt();
                    objectArray2[27] = customer.getPin();
                    String string = "";
                    CustomerGroup customerGroup = customer.getCustomerGroup();
                    if (customerGroup != null) {
                        string = customerGroup.getName();
                    }
                    objectArray2[28] = string;
                    objectArray2[29] = customer.isActive();
                    cSVPrinter.printRecord(objectArray2);
                }
                if (fileWriter == null) break block14;
            }
            catch (Throwable throwable) {
                if (fileWriter != null) {
                    IOUtils.closeQuietly(fileWriter);
                }
                if (cSVPrinter != null) {
                    cSVPrinter.close();
                }
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)fileWriter);
        }
        if (cSVPrinter != null) {
            cSVPrinter.close();
        }
    }

    private JFileChooser b() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("*.csv", "csv"));
        jFileChooser.setSelectedFile(new File(Messages.getString("CustomerExplorer.14") + ".csv"));
        return jFileChooser;
    }

    private boolean a(JFileChooser jFileChooser) {
        if (jFileChooser.getSelectedFile().exists() && POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("CustomerExplorer.18"), Messages.getString("CONFIRM")) != 0) {
            Integer n = jFileChooser.showSaveDialog(POSUtil.getBackOfficeWindow());
            if (n != 0) {
                return false;
            }
            return this.a(jFileChooser);
        }
        return true;
    }
}

