/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.DuplicateDataException;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.customer.CustomerExplorer;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.dao.CustomerGroupDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.ui.dialog.CustomerImportCheckingDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class CustomerCsvImportAction
extends AbstractAction {
    private static final String a = Messages.getString("CustomerCsvImportAction.0");
    private CustomerExplorer b;

    public CustomerCsvImportAction() {
        super(a);
    }

    public CustomerCsvImportAction(CustomerExplorer customerExplorer) {
        super(a);
        this.b = customerExplorer;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("*.csv", "csv"));
            int n = jFileChooser.showOpenDialog(POSUtil.getFocusedWindow());
            if (n == 1) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            if (!file.exists()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.3"));
                return;
            }
            CustomerImportCheckingDialog customerImportCheckingDialog = new CustomerImportCheckingDialog(file);
            customerImportCheckingDialog.openFullScreen();
            if (customerImportCheckingDialog.isCanceled()) {
                return;
            }
            List<Customer> list = customerImportCheckingDialog.getCustomers();
            if (list != null) {
                GenericDAO genericDAO = GenericDAO.getInstance();
                Transaction transaction = null;
                try {
                    Session session = genericDAO.createNewSession();
                    transaction = session.beginTransaction();
                    for (Customer customer : list) {
                        String string = customer.getMemberId();
                        if (StringUtils.isNotBlank((String)string)) {
                            try {
                                genericDAO.checkDifferentObjectExists(customer.getId(), string, Customer.class, Customer.PROP_MEMBER_ID, session);
                            }
                            catch (DuplicateDataException duplicateDataException) {
                                throw new PosException(Messages.getString("CustomerExplorer.22"));
                            }
                        }
                        genericDAO.save(customer, session);
                        String string2 = customer.getCustomerGroupId();
                        if (!StringUtils.isNotBlank((String)string2)) continue;
                        CustomerGroupDAO customerGroupDAO = CustomerGroupDAO.getInstance();
                        CustomerGroup customerGroup = customerGroupDAO.get(string2, session);
                        customerGroupDAO.initialize(customerGroup);
                        customerGroup.getCustomers().add(customer);
                        genericDAO.saveOrUpdate(customerGroup, session);
                    }
                    transaction.commit();
                }
                catch (Exception exception) {
                    transaction.rollback();
                    throw exception;
                }
            }
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CustomerExplorer.24"));
            if (this.b != null) {
                this.b.updateCustomer();
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.67"), exception);
        }
    }
}

