/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.base.BaseShopTable;
import com.floreantpos.model.dao.ShopSeatDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.tableselection.TableSelectorDialog;
import com.floreantpos.ui.tableselection.TableSelectorFactory;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.ticket.TicketViewerTableModel;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hibernate.StaleStateException;

public class TableSelectionAction
extends PosAction {
    private Ticket a;

    public TableSelectionAction() {
        this((OrderView)null);
    }

    public TableSelectionAction(OrderView orderView) {
        super(orderView);
    }

    @Override
    public void execute() {
        try {
            if (this.listener == null || !(this.listener instanceof OrderView)) {
                return;
            }
            Object object = this.listener.getSelectedData();
            if (!(object instanceof Ticket)) {
                return;
            }
            this.a = (Ticket)object;
            this.a();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a() {
        if (this.a == null) {
            return;
        }
        OrderView orderView = (OrderView)this.listener;
        TableSelectorDialog tableSelectorDialog = null;
        try {
            Object object;
            int n;
            boolean bl;
            tableSelectorDialog = TableSelectorFactory.createTableSelectorDialog(this.a.getOrderType());
            tableSelectorDialog.setTitle(Messages.getString("TableSelectionAction.0"));
            tableSelectorDialog.getTableSelector().setTicketTransferMode(true);
            tableSelectorDialog.setCreateNewTicket(false);
            tableSelectorDialog.getTableSelector().setHomeViewMode(Boolean.FALSE);
            tableSelectorDialog.updateView(Boolean.TRUE);
            this.a.setShouldUpdateTableStatus(true);
            if (this.a != null) {
                tableSelectorDialog.setTicket(this.a);
            }
            tableSelectorDialog.openUndecoratedFullScreen();
            if (tableSelectorDialog.isCanceled()) {
                return;
            }
            List<ShopTable> list = tableSelectorDialog.getSelectedTables();
            if (list.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TableSelectionAction.1"));
                return;
            }
            boolean bl2 = bl = this.a.getId() == null && TicketDAO.getInstance().isNewTicket(this.a.getId());
            if (!bl && (n = POSMessageDialog.showYesNoQuestionDialog(orderView, (String)(object = Messages.getString("TableSelectionAction.2")), Messages.getString("CONFIRM"))) != 0) {
                return;
            }
            object = new ArrayList();
            for (ShopTable shopTable : list) {
                SalesArea salesArea = shopTable.getSalesArea();
                if (salesArea != null) {
                    this.a.setSalesArea(salesArea);
                    this.a.setSalesAreaId(salesArea.getId());
                }
                object.add(shopTable.getId());
            }
            this.a(list);
            if (!bl) {
                ShopTableDAO.getInstance().transferTickets(this.a, (List<Integer>)object);
            } else {
                this.a.setTableNumbers((List<Integer>)object);
            }
            OroMqttClient.getInstance().publishOnThread("MQTT-COMMAND", "1");
            orderView.updateView();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), orderView);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
        finally {
            if (tableSelectorDialog != null) {
                tableSelectorDialog.setCreateNewTicket(true);
            }
        }
    }

    private void a(List<ShopTable> list) {
        Serializable serializable;
        OrderView orderView = (OrderView)this.listener;
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        HashMap<Integer, ShopTable> hashMap = new HashMap<Integer, ShopTable>();
        for (ShopTable serializable22 : list) {
            serializable = serializable22.getId();
            hashMap.put((Integer)serializable, serializable22);
            arrayList.add((Integer)serializable);
        }
        List<ShopSeat> list2 = ShopSeatDAO.getInstance().getShopSeatsByTableIds(arrayList);
        HashMap<String, ShopSeat> hashMap2 = new HashMap<String, ShopSeat>();
        serializable = orderView.getTicketView().getTicketViewerTable();
        TicketViewerTableModel ticketViewerTableModel = ((TicketViewerTable)serializable).getModel();
        int n = ticketViewerTableModel.getRowCount();
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            Comparable comparable;
            ShopSeat shopSeat;
            TicketItemSeat ticketItemSeat;
            Object object = ticketViewerTableModel.get(i);
            TicketItem ticketItem = null;
            if (object instanceof TicketItem) {
                ticketItem = (TicketItem)object;
            }
            if (ticketItem == null || (ticketItemSeat = ticketItem.getSeat()) == null || (shopSeat = ticketItemSeat.getShopSeat()) == null) continue;
            ShopSeat shopSeat2 = (ShopSeat)hashMap2.get(shopSeat.getId());
            if (shopSeat2 == null) {
                Integer n3;
                comparable = shopSeat.getShopTable();
                if (comparable == null || hashMap.get(n3 = ((BaseShopTable)comparable).getId()) != null) continue;
                Integer n4 = ticketItemSeat.getSeatNumber();
                shopSeat2 = this.a(list2, n4);
                if (shopSeat2 == null) {
                    shopSeat2 = this.a(n2);
                    ++n2;
                }
                if (shopSeat2 != null) {
                    hashMap2.put(shopSeat.getId(), shopSeat2);
                }
            }
            if (shopSeat2 == null) {
                if (ticketItem.isTreatAsSeat().booleanValue()) {
                    ticketItem.setName(Messages.getString("TableSelectionAction.3"));
                }
                ticketItem.setSeat(null);
                continue;
            }
            comparable = shopSeat2.convertTicketItemSeat();
            ((TicketItemSeat)comparable).setMember(ticketItemSeat.getMember());
            if (ticketItem.isTreatAsSeat().booleanValue()) {
                ticketItem.setName(shopSeat2.getSeatNumberWithTableName());
            }
            ticketItem.setSeat((TicketItemSeat)comparable);
        }
        ((TicketViewerTable)serializable).updateView();
    }

    private ShopSeat a(int n) {
        ShopSeat shopSeat = new ShopSeat();
        shopSeat.setId(GlobalIdGenerator.generateGlobalId());
        shopSeat.setSeatNumber(n);
        List<ShopSeat> list = this.a.getExtraSeats();
        if (list == null) {
            list = new ArrayList<ShopSeat>();
        }
        list.add(shopSeat);
        this.a.addExtraSeats(list);
        return shopSeat;
    }

    private ShopSeat a(List<ShopSeat> list, Integer n) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (ShopSeat shopSeat : list) {
            if (shopSeat.getSeatNumber() != n) continue;
            return shopSeat;
        }
        return null;
    }
}

