/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.report.JournalReportView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class JournalReportAction
extends AbstractAction {
    public JournalReportAction() {
        super(POSConstants.JOURNAL_REPORT);
    }

    public JournalReportAction(String string) {
        super(string);
    }

    public JournalReportAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            JournalReportView journalReportView = null;
            int n = jTabbedPane.indexOfTab(POSConstants.JOURNAL_REPORT);
            if (n == -1) {
                journalReportView = new JournalReportView();
                jTabbedPane.addTab(POSConstants.JOURNAL_REPORT, journalReportView);
            } else {
                journalReportView = (JournalReportView)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(journalReportView);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

