/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.report.SessionSummaryReportView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class SessionSummaryReportAction
extends AbstractAction {
    public SessionSummaryReportAction() {
        super(POSConstants.SESSION_SUMMARY_REPORT);
    }

    public SessionSummaryReportAction(String string) {
        super(string);
    }

    public SessionSummaryReportAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            SessionSummaryReportView sessionSummaryReportView = null;
            int n = jTabbedPane.indexOfTab(POSConstants.SESSION_SUMMARY_REPORT);
            if (n == -1) {
                sessionSummaryReportView = new SessionSummaryReportView();
                jTabbedPane.addTab(POSConstants.SESSION_SUMMARY_REPORT, sessionSummaryReportView);
            } else {
                sessionSummaryReportView = (SessionSummaryReportView)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(sessionSummaryReportView);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

