/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.bo.ui.explorer.TicketExplorer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class TicketExplorerAction
extends AbstractAction {
    public TicketExplorerAction() {
        super(POSConstants.CLOSED_TICKETS);
    }

    public TicketExplorerAction(String string) {
        super(string);
    }

    public TicketExplorerAction(String string, Icon icon) {
        super(string, icon);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        BackOfficeWindow backOfficeWindow = POSUtil.getBackOfficeWindow();
        try {
            TicketExplorer ticketExplorer = null;
            JTabbedPane jTabbedPane = backOfficeWindow.getTabbedPane();
            int n = jTabbedPane.indexOfTab(POSConstants.CLOSED_TICKETS);
            if (n == -1) {
                ticketExplorer = new TicketExplorer();
                jTabbedPane.addTab(POSConstants.CLOSED_TICKETS, ticketExplorer);
            } else {
                ticketExplorer = (TicketExplorer)jTabbedPane.getComponentAt(n);
            }
            jTabbedPane.setSelectedComponent(ticketExplorer);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(backOfficeWindow, exception.getMessage(), exception);
        }
    }
}

