/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.BeanTableExplorerView;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.dao.MenuItemSizeDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuItemSizeForm;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JButton;

public class MenuItemSizeExplorer
extends BeanTableExplorerView<MenuItemSize> {
    public MenuItemSizeExplorer() {
        super(MenuItemSize.class);
        JButton jButton = new JButton(Messages.getString("MenuItemSizeExplorer.5"));
        jButton.addActionListener(actionEvent -> this.a());
        TransparentPanel transparentPanel = this.getBottomActionPanel();
        transparentPanel.add(jButton);
        this.add((Component)transparentPanel, "South");
    }

    @Override
    public void initData() {
        this.setRows(MenuItemSizeDAO.getInstance().findAll());
    }

    @Override
    public void initTableModel(BeanTableModel<MenuItemSize> beanTableModel) {
        beanTableModel.addColumn(POSConstants.NAME, "name");
        beanTableModel.addColumn(Messages.getString("MenuItemSizeExplorer.0"), "translatedName");
        beanTableModel.addColumn(Messages.getString("MenuItemSizeExplorer.2"), "description");
        beanTableModel.addColumn(Messages.getString("MenuItemSizeExplorer.4"), "sizeInInch", 11, BeanTableModel.DataType.NUMBER);
        beanTableModel.addColumn(Messages.getString("MenuItemSizeExplorer.6"), "sortOrder", 11, BeanTableModel.DataType.NUMBER);
        beanTableModel.addColumn("Default", MenuItemSize.PROP_DEFAULT_SIZE);
    }

    @Override
    public MenuItemSize createNew() {
        return this.openNewForm(new MenuItemSizeForm());
    }

    @Override
    public MenuItemSize editSelectedRow(MenuItemSize menuItemSize) {
        MenuItemSizeDAO.getInstance().refresh(menuItemSize);
        this.checkDataValidation(menuItemSize.isDeleted(), menuItemSize.getName());
        return this.openEditForm(new MenuItemSizeForm(menuItemSize));
    }

    @Override
    public boolean delete(MenuItemSize menuItemSize) {
        MenuItemSizeDAO.getInstance().refresh(menuItemSize);
        this.checkDataValidation(menuItemSize.isDeleted(), menuItemSize.getName());
        if (menuItemSize.isDefaultSize().booleanValue()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MenuItemSizeExplorer.1"));
            return false;
        }
        MenuItemSizeDAO.getInstance().delete(menuItemSize);
        return true;
    }

    private void a() {
        try {
            MenuItemSize menuItemSize = (MenuItemSize)this.getSelectedRow();
            if (menuItemSize == null) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SetDefault"));
                return;
            }
            MenuItemSizeDAO.getInstance().refresh(menuItemSize);
            ArrayList<MenuItemSize> arrayList = new ArrayList<MenuItemSize>();
            arrayList.add(menuItemSize);
            for (MenuItemSize menuItemSize2 : this.getRows()) {
                if (!menuItemSize2.isDefaultSize().booleanValue()) continue;
                menuItemSize2.setDefaultSize(false);
                arrayList.add(menuItemSize2);
            }
            menuItemSize.setDefaultSize(true);
            MenuItemSizeDAO menuItemSizeDAO = new MenuItemSizeDAO();
            menuItemSizeDAO.saveOrUpdateList(arrayList);
            this.getTable().repaint();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

