/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer.attribute;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.explorer.attribute.QuickGroupLayout;
import com.floreantpos.bo.ui.explorer.attribute.VariantComboCheckUtil;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.DetailsInfoDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.POSUtil;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.ValidationResultModel;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import validation.TextFieldValidationComponant;

public class QuickAttributeLayout
extends TransparentPanel
implements FocusListener {
    private TextFieldValidationComponant a;
    private JTextField b;
    private JButton c;
    private Attribute d;
    private QuickGroupLayout e;
    private QuickAttributeLayout f;

    public QuickAttributeLayout(Attribute attribute, QuickGroupLayout quickGroupLayout) {
        this.e = quickGroupLayout;
        this.d = attribute;
        this.a();
        this.renderAttribute();
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3,ins 0", "[][grow]", ""));
        this.b = new JTextField(30);
        this.b.addActionListener(actionEvent -> this.createNewAttributeLayout(this));
        this.b.addFocusListener(this);
        this.a = new TextFieldValidationComponant(this.b);
        this.c = new JButton(Messages.getString("QuickAttributeLayout.0"));
        this.c.setFont(this.c.getFont().deriveFont(1));
        this.c.setToolTipText(Messages.getString("QuickAttributeLayout.1"));
        this.c.addActionListener(actionEvent -> this.a(this));
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setLayout((LayoutManager)new MigLayout("fillx,hidemode 3,ins 0", "[][grow]", ""));
        transparentPanel.add(this.a);
        transparentPanel.add(this.c);
        this.add(transparentPanel);
    }

    private void a(QuickAttributeLayout quickAttributeLayout) {
        try {
            MenuItem menuItem = this.e.getParentMenuItem();
            if (menuItem != null) {
                VariantComboCheckUtil.checkVariantIsUsedByCombo(menuItem, this.d);
            }
            AttributeGroup attributeGroup = this.e.getAttributeGroup(false);
            Attribute attribute = quickAttributeLayout.getAttribute();
            if (StringUtils.isNotBlank((CharSequence)attribute.getId())) {
                attribute.setDeleted(true);
                this.e.b.add(attribute);
            }
            if (this.e.a.size() == 1) {
                this.b.requestFocus();
                this.a(attributeGroup);
            } else {
                this.e.c.remove(quickAttributeLayout);
                this.e.getQuickAttributeLayoutList().remove(quickAttributeLayout);
            }
            QuickAttributeLayout.renderAttributeUi(this.e.getQuickAttributeLayoutList());
            this.e.revalidateUi();
        }
        catch (PosException posException) {
            DetailsInfoDialog detailsInfoDialog = new DetailsInfoDialog(posException.getMessage(), posException.getDetails());
            detailsInfoDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage());
        }
    }

    private void a(AttributeGroup attributeGroup) {
        this.d = new Attribute();
        this.b.setText("");
    }

    public void renderAttribute() {
        if (this.d == null && StringUtils.isBlank((CharSequence)this.d.getId())) {
            return;
        }
        String string = this.d.getName();
        this.b.setText(StringUtils.isBlank((CharSequence)string) ? "" : string);
    }

    public Attribute getAttribute() {
        this.d.setName(this.b.getText().trim());
        return this.d;
    }

    public void createNewAttributeLayout(QuickAttributeLayout quickAttributeLayout) {
        try {
            this.b(quickAttributeLayout);
            this.f.requestFocus();
            QuickAttributeLayout.renderAttributeUi(this.e.getQuickAttributeLayoutList());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage());
        }
    }

    private void b(QuickAttributeLayout quickAttributeLayout) {
        QuickGroupLayout quickGroupLayout = quickAttributeLayout.e;
        this.f = new QuickAttributeLayout(new Attribute(), quickGroupLayout);
        TransparentPanel transparentPanel = quickGroupLayout.c;
        Component component = transparentPanel.getComponent(transparentPanel.getComponentCount() - 1);
        if (component instanceof JButton) {
            transparentPanel.remove(component);
            transparentPanel.add(this.f);
            transparentPanel.add(component);
        } else {
            transparentPanel.add(this.f);
        }
        quickGroupLayout.getQuickAttributeLayoutList().add(this.f);
        this.e.revalidateUi();
    }

    @Override
    public void requestFocus() {
        this.b.requestFocus();
    }

    public JTextField getTfAttributeName() {
        return this.b;
    }

    public void updateValidation(String string) {
        ValidationResult validationResult = new ValidationResult();
        if (StringUtils.isNotBlank((CharSequence)string)) {
            validationResult.addError(string, (Object)GlobalIdGenerator.generateGlobalId());
        }
        this.a(validationResult);
    }

    private void a(ValidationResult validationResult) {
        ValidationResultModel validationResultModel = this.a.getValidationResultModel();
        validationResultModel.setResult(validationResult);
        this.a.updateValidationResult(validationResult, this.a.getValidationResultModel());
        this.e.revalidateUi();
    }

    protected static void renderAttributeUi(List<QuickAttributeLayout> list) {
        if (list.size() == 1) {
            list.get(0).updateValidation("");
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            QuickAttributeLayout quickAttributeLayout = list.get(i);
            for (int j = 0; j < list.size(); ++j) {
                QuickAttributeLayout quickAttributeLayout2 = list.get(j);
                if (i == j) continue;
                String string = quickAttributeLayout2.getAttribute().getName();
                if (StringUtils.isNotBlank((CharSequence)string) && quickAttributeLayout.getAttribute().getName().equals(string)) {
                    quickAttributeLayout2.updateValidation(string + Messages.getString("QuickAttributeLayout.2"));
                    return;
                }
                quickAttributeLayout2.updateValidation("");
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        QuickAttributeLayout.renderAttributeUi(this.e.getQuickAttributeLayoutList());
        this.e.revalidateUi();
    }
}

