/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.menudesigner;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.menudesigner.MenuPageDesignView;
import com.floreantpos.bo.ui.menudesigner.MenuPageListRenderer;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.base.BaseMenuPage;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuCategoryForm;
import com.floreantpos.ui.model.MenuGroupForm;
import com.floreantpos.ui.model.MenuPageForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import net.miginfocom.swing.MigLayout;
import org.hibernate.HibernateException;
import org.hibernate.StaleStateException;

public class MenuPageDesigner
extends TransparentPanel
implements RefreshableView {
    private JList<MenuCategory> a;
    private JList<MenuGroup> b;
    private MenuPageDesignView c;
    private JList<MenuPage> d;
    private ComboBoxModel e;
    private JButton f;
    private JButton g;
    private JButton h;
    private JButton i;
    private JButton j;
    private JButton k;
    private boolean l = true;

    public MenuPageDesigner() {
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setPreferredSize(PosUIManager.getSize(130, 82));
        this.add((Component)jPanel3, "East");
        this.a = new JList(new ComboBoxModel());
        this.a.addListSelectionListener(listSelectionEvent -> this.c(listSelectionEvent));
        this.b = new JList(new ComboBoxModel());
        this.b.addListSelectionListener(listSelectionEvent -> this.b(listSelectionEvent));
        this.e = new ComboBoxModel();
        this.d = new JList(this.e);
        this.d.setCellRenderer(new MenuPageListRenderer());
        this.d.addListSelectionListener(listSelectionEvent -> this.a(listSelectionEvent));
        this.d.setFocusable(false);
        JPanel jPanel4 = new JPanel(new BorderLayout(10, 10));
        jPanel4.setBorder(new CompoundBorder(new TitledBorder(Messages.getString("MenuPageDesigner.11")), new EmptyBorder(5, 5, 5, 5)));
        JScrollPane jScrollPane = new JScrollPane(this.a);
        jPanel4.add(jScrollPane);
        JButton jButton = new JButton(Messages.getString("MenuPageDesigner.2"));
        jPanel4.add((Component)jButton, "South");
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel(new BorderLayout(10, 10));
        jPanel5.setBorder(new CompoundBorder(new TitledBorder(Messages.getString("MenuPageDesigner.13")), new EmptyBorder(5, 5, 5, 5)));
        JScrollPane jScrollPane2 = new JScrollPane(this.b);
        jPanel5.add(jScrollPane2);
        JButton jButton2 = new JButton(Messages.getString("MenuPageDesigner.12"));
        jPanel5.add((Component)jButton2, "South");
        jPanel.add(jPanel5);
        this.h = new JButton(Messages.getString("MenuPageDesigner.3"));
        this.i = new JButton(Messages.getString("MenuPageDesigner.4"));
        this.g = new JButton(Messages.getString("MenuPageDesigner.5"));
        this.k = new JButton(Messages.getString("MenuPageDesigner.6"));
        this.k.addActionListener(actionEvent -> this.c());
        this.j = new JButton(Messages.getString("MenuPageDesigner.7"));
        this.j.addActionListener(actionEvent -> this.d());
        this.g.addActionListener(actionEvent -> this.l());
        jButton.addActionListener(actionEvent -> this.f());
        jButton2.addActionListener(actionEvent -> this.g());
        this.h.addActionListener(actionEvent -> this.i());
        this.i.addActionListener(actionEvent -> this.k());
        this.f = new JButton(Messages.getString("MenuPageDesigner.10"));
        this.f.addActionListener(actionEvent -> this.h());
        JPanel jPanel6 = new JPanel(new BorderLayout(10, 10));
        jPanel6.setBorder(new TitledBorder(Messages.getString("MenuPageDesigner.15")));
        JScrollPane jScrollPane3 = new JScrollPane(this.d);
        jPanel6.add(jScrollPane3);
        JPanel jPanel7 = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel7.add((Component)this.f, "growx");
        jPanel7.add((Component)this.h, "growx");
        jPanel7.add((Component)this.i, "growx,wrap");
        jPanel7.add((Component)this.g, "growx");
        jPanel7.add((Component)this.k, "growx");
        jPanel7.add((Component)this.j, "growx");
        this.j.setEnabled(false);
        jPanel6.add((Component)jPanel7, "South");
        jPanel.add(jPanel6);
        jPanel2.add(jPanel);
        JPanel jPanel8 = new JPanel(new BorderLayout());
        this.c = new MenuPageDesignView();
        JPanel jPanel9 = new JPanel((LayoutManager)new MigLayout("center"));
        jPanel9.add((Component)new JLabel(POSConstants.ORDER_TYPE), "split 2");
        JPanel jPanel10 = new JPanel(new BorderLayout());
        jPanel10.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        jPanel10.add(this.c);
        jPanel8.add(jPanel10);
        this.add((Component)jPanel2, "West");
        this.add(jPanel8);
        this.a(false);
    }

    private void a(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.b();
            this.e();
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void b() {
        if (!this.l) {
            return;
        }
        if (this.c.isEnabledSaveButton()) {
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.31"), Messages.getString("CONFIRM")) == 0) {
                this.doSaveMenuPage();
            } else {
                this.c.resetPage();
            }
        }
    }

    protected void doSaveMenuPage() {
        try {
            this.c.save();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
        }
    }

    private void c() {
        try {
            this.l = false;
            MenuPage menuPage = this.c.getMenuPage();
            if (menuPage == null) {
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.33"), Messages.getString("CONFIRM")) != 0) {
                return;
            }
            int n = this.d.getSelectedIndex();
            MenuPageDAO.getInstance().delete(menuPage);
            this.e.removeElement(menuPage);
            if (this.e.getSize() > 0) {
                this.d.setSelectedIndex(n - 1);
            } else {
                this.e();
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage());
        }
        finally {
            this.l = true;
        }
    }

    private void d() {
        try {
            this.l = false;
            List list = this.e.getDataList();
            if (list == null || list.isEmpty()) {
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.35") + this.b.getSelectedValue() + Messages.getString("MenuPageDesigner.36"), Messages.getString("CONFIRM")) != 0) {
                return;
            }
            MenuPageDAO.getInstance().deleteAll(list);
            this.e.removeAllElements();
            this.j.setEnabled(false);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage());
        }
        finally {
            this.l = true;
        }
    }

    public void initData() {
        List<MenuCategory> list = MenuCategoryDAO.getInstance().findAll();
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.a.getModel();
        comboBoxModel.setDataList(list);
    }

    private void e() {
        try {
            MenuPage menuPage = null;
            if (this.e.getSize() > 0) {
                menuPage = this.d.getSelectedValue();
                if (menuPage != null) {
                    this.g.setText(menuPage.isVisible() != false ? Messages.getString("MenuPageDesigner.38") : Messages.getString("MenuPageDesigner.39"));
                    this.j.setEnabled(true);
                    this.a(true);
                } else {
                    this.a(false);
                }
            } else {
                this.a(false);
            }
            this.c.setMenuPage(menuPage);
            this.c.setEnabledSaveAndCancel(false);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void a(boolean bl) {
        this.i.setEnabled(bl);
        this.g.setEnabled(bl);
        this.k.setEnabled(bl);
        this.c.getDetachAllButton().setEnabled(bl);
    }

    public void doCreateNewPage() {
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.40"), Messages.getString("CONFIRM")) != 0) {
            return;
        }
        int n = (int)NumberSelectionDialog2.takeIntInput(Messages.getString("MenuPageDesigner.42"));
        if (n < 1) {
            return;
        }
        ArrayList<MenuPage> arrayList = new ArrayList<MenuPage>();
        for (int i = 0; i < n; ++i) {
            MenuPage menuPage = new MenuPage();
            menuPage.setName("Page " + (i + 1));
            arrayList.add(menuPage);
        }
        try {
            MenuPageDAO.getInstance().saveOrUpdatePages(arrayList);
            this.e.setDataList(arrayList);
            this.d.setSelectedIndex(0);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    protected List<MenuItem> getSelectedMenuItems(List<MenuItem> list) {
        MenuItemSelectionDialog menuItemSelectionDialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>());
        menuItemSelectionDialog.setSelectionMode(1);
        menuItemSelectionDialog.setSize(PosUIManager.getSize(750, 515));
        menuItemSelectionDialog.open();
        if (menuItemSelectionDialog.isCanceled()) {
            return null;
        }
        List<MenuItem> list2 = menuItemSelectionDialog.getSelectedItems();
        MenuPage menuPage = this.d.getSelectedValue();
        int n = menuPage.getCols() * menuPage.getRows();
        if (list2 != null && list2.size() > n) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.44") + n);
            return this.getSelectedMenuItems(list2);
        }
        return list2;
    }

    private void f() {
        try {
            MenuCategoryForm menuCategoryForm = new MenuCategoryForm();
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuCategoryForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            MenuCategory menuCategory = (MenuCategory)menuCategoryForm.getBean();
            ComboBoxModel comboBoxModel = (ComboBoxModel)this.a.getModel();
            comboBoxModel.addElement(menuCategory);
            this.a.setSelectedValue(menuCategory, true);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void g() {
        try {
            MenuGroup menuGroup = new MenuGroup();
            MenuCategory menuCategory = this.a.getSelectedValue();
            if (menuCategory != null) {
                menuGroup.setMenuCategoryId(menuCategory.getId());
            } else {
                menuGroup.setMenuCategoryId(null);
            }
            MenuGroupForm menuGroupForm = new MenuGroupForm(menuGroup);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuGroupForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            MenuGroup menuGroup2 = (MenuGroup)menuGroupForm.getBean();
            ComboBoxModel comboBoxModel = (ComboBoxModel)this.b.getModel();
            comboBoxModel.addElement(menuGroup2);
            this.a.setSelectedValue(menuGroup2, true);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void h() {
        MenuGroup menuGroup = this.b.getSelectedValue();
        if (menuGroup == null) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.46"));
            return;
        }
        List<MenuItem> list = MenuItemDAO.getInstance().findByParent(null, menuGroup, true);
        if (list == null || list.isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.47"));
            return;
        }
        MenuPageForm menuPageForm = new MenuPageForm(new MenuPage(), true);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuPageForm);
        beanEditorDialog.open();
        if (beanEditorDialog.isCanceled()) {
            return;
        }
        MenuPage menuPage = (MenuPage)menuPageForm.getBean();
        int n = menuPage.getCols();
        int n2 = menuPage.getRows();
        int n3 = list.size();
        int n4 = (int)Math.ceil((double)n3 / (double)(n * n2));
        int n5 = n4 == 0 ? 1 : n4;
        ArrayList<MenuPageItem> arrayList = new ArrayList<MenuPageItem>();
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            try {
                int n8;
                int n9;
                int n10 = this.e.getSize();
                MenuPage menuPage2 = null;
                if (menuPage2 == null) {
                    menuPage2 = new MenuPage();
                    menuPage2.setMenuGroupId(menuGroup.getId());
                    menuPage2.setName(Messages.getString("MenuPageDesigner.48") + (n10 + 1));
                    menuPage2.setRows(n2);
                    menuPage2.setCols(n);
                    menuPage2.setSortOrder(i);
                    menuPage2.setFlixibleButtonSize(menuPage.isFlixibleButtonSize());
                    menuPage2.setButtonHeight(menuPage.getButtonHeight());
                    menuPage2.setButtonWidth(menuPage.getButtonWidth());
                    MenuPageDAO.getInstance().saveOrUpdate(menuPage2);
                    this.e.addElement(menuPage2);
                }
                if (n3 < (n9 = n * n2)) {
                    while (n6 < list.size()) {
                        MenuPageItem menuPageItem = new MenuPageItem();
                        menuPageItem.setMenuPage(menuPage2);
                        menuPageItem.setMenuItem(list.get(n6));
                        arrayList.add(menuPageItem);
                        menuPage2.addTopageItems(menuPageItem);
                        ++n6;
                    }
                } else {
                    n8 = 0;
                    while (n8 < n9) {
                        MenuPageItem menuPageItem = new MenuPageItem();
                        menuPageItem.setMenuPage(menuPage2);
                        menuPageItem.setMenuItem(list.get(n6));
                        arrayList.add(menuPageItem);
                        menuPage2.addTopageItems(menuPageItem);
                        ++n8;
                        ++n6;
                    }
                }
                n3 -= n9;
                for (n8 = 0; n8 < n2; ++n8) {
                    for (int j = 0; j < n && n7 <= arrayList.size() - 1 && arrayList.get(n7) != null; ++n7, ++j) {
                        ((MenuPageItem)arrayList.get(n7)).setRow(n8);
                        ((MenuPageItem)arrayList.get(n7)).setCol(j);
                    }
                }
                MenuPageDAO.getInstance().saveOrUpdate(menuPage2);
                this.d.setSelectedValue(menuPage2, true);
                continue;
            }
            catch (Exception exception) {
                POSMessageDialog.showError(exception.getMessage());
            }
        }
        this.c.repaint();
        this.c.revalidate();
    }

    private void i() {
        this.b();
        MenuGroup menuGroup = this.b.getSelectedValue();
        if (menuGroup == null) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("MenuPageDesigner.49"));
            return;
        }
        try {
            MenuPage menuPage = new MenuPage();
            menuPage.setMenuGroupId(menuGroup.getId());
            menuPage.setCols(4);
            menuPage.setRows(4);
            int n = this.j();
            menuPage.setName("Page " + n);
            menuPage.setSortOrder(n);
            MenuPageDAO.getInstance().saveOrUpdate(menuPage);
            this.e.addElement(menuPage);
            this.d.setSelectedValue(menuPage, true);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private int j() {
        Serializable serializable;
        String string = "";
        if (this.e.getSize() > 0) {
            serializable = (MenuPage)this.e.getElementAt(this.e.getSize() - 1);
            string = ((BaseMenuPage)serializable).getName();
        }
        serializable = Pattern.compile(".* ([0-9]+)");
        Matcher matcher = ((Pattern)serializable).matcher(string);
        int n = this.e.getSize() + 1;
        if (matcher.find()) {
            try {
                int n2 = Integer.parseInt(matcher.group(1));
                if (n2 + 1 > n) {
                    n = n2 + 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void k() {
        try {
            this.b();
            this.setCursor(Cursor.getPredefinedCursor(3));
            MenuPage menuPage = this.c.getMenuPage();
            if (menuPage == null) {
                return;
            }
            MenuPageForm menuPageForm = new MenuPageForm(menuPage, false);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuPageForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            menuPage = (MenuPage)menuPageForm.getBean();
            MenuPageDAO.getInstance().saveOrUpdate(menuPage);
            MenuPageDAO.getInstance().refresh(this.d.getSelectedValue());
            this.e();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    public void refresh() {
        try {
            this.c.refresh();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void l() throws HibernateException {
        try {
            MenuPage menuPage = this.d.getSelectedValue();
            int n = this.d.getSelectedIndex();
            if (menuPage == null) {
                return;
            }
            menuPage.setVisible((menuPage = MenuPageDAO.getInstance().get(menuPage.getId())).isVisible() == false);
            MenuPageDAO.getInstance().saveOrUpdate(menuPage);
            this.e.getDataList().set(n, menuPage);
            this.g.setText(menuPage.isVisible() != false ? Messages.getString("MenuPageDesigner.8") : Messages.getString("MenuPageDesigner.9"));
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void b(ListSelectionEvent listSelectionEvent) {
        try {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            MenuGroup menuGroup = this.b.getSelectedValue();
            this.e.removeAllElements();
            this.d.clearSelection();
            if (menuGroup == null) {
                this.j.setEnabled(false);
                return;
            }
            List<MenuPage> list = MenuPageDAO.getInstance().findByGroup(menuGroup);
            if (list != null && list.size() > 0) {
                this.e.setDataList(list);
                this.j.setEnabled(true);
            }
            if (this.e.getSize() > 0) {
                this.d.setSelectedIndex(0);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void c(ListSelectionEvent listSelectionEvent) {
        try {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            MenuCategory menuCategory = this.a.getSelectedValue();
            ComboBoxModel comboBoxModel = (ComboBoxModel)this.b.getModel();
            comboBoxModel.removeAllElements();
            if (menuCategory == null) {
                return;
            }
            List<MenuGroup> list = MenuGroupDAO.getInstance().findByParent(menuCategory);
            if (list != null) {
                comboBoxModel.setDataList(list);
                if (list.size() > 0) {
                    this.b.setSelectedValue(list.get(0), true);
                }
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }
}

